/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-09-03 11:27:10 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=13147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=39324 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=39355 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gf_draft_submissions` (
  `uuid` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `form_id` mediumint unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_url` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `submission` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint unsigned NOT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint NOT NULL DEFAULT '0',
  `is_read` tinyint NOT NULL DEFAULT '0',
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_agent` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `currency` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_status` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `transaction_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_fulfilled` tinyint DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `transaction_type` tinyint DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint unsigned NOT NULL DEFAULT '0',
  `entry_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `item_index` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int unsigned NOT NULL,
  `user_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `note_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sub_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint NOT NULL DEFAULT '1',
  `is_trash` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_meta` (
  `form_id` mediumint unsigned NOT NULL,
  `display_meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `entries_grid_meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `confirmations` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `notifications` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint unsigned NOT NULL,
  `display_meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_view` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `count` mediumint unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_rest_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_grp_google_place` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `place_id` varchar(80) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `photo` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `rating` double DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `review_count` int DEFAULT NULL,
  `updated` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `grp_place_id` (`place_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_grp_google_review` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `google_place_id` bigint unsigned NOT NULL,
  `rating` int NOT NULL,
  `text` varchar(10000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time` int NOT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `profile_photo_url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hide` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `grp_google_place_id` (`google_place_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_grp_google_stats` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `google_place_id` bigint unsigned NOT NULL,
  `time` int NOT NULL,
  `rating` double DEFAULT NULL,
  `review_count` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `grp_google_place_id` (`google_place_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_hustle_entries` (
  `entry_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `entry_type` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `module_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`entry_id`),
  KEY `entry_type` (`entry_type`),
  KEY `entry_module_id` (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_hustle_entries_meta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint unsigned NOT NULL,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`),
  KEY `meta_entry_id` (`entry_id`),
  KEY `meta_key_object` (`entry_id`,`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_hustle_modules` (
  `module_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` bigint unsigned NOT NULL DEFAULT '0',
  `module_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `module_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `active` tinyint DEFAULT '1',
  `module_mode` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`module_id`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_hustle_modules_meta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `module_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `module_id` (`module_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_hustle_tracking` (
  `tracking_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `module_id` bigint unsigned NOT NULL,
  `page_id` bigint unsigned NOT NULL,
  `module_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ip` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `counter` mediumint unsigned NOT NULL DEFAULT '1',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tracking_id`),
  KEY `tracking_module_id` (`module_id`),
  KEY `action` (`action`),
  KEY `tracking_module_object` (`action`,`module_id`,`module_type`),
  KEY `tracking_module_object_ip` (`module_id`,`tracking_id`,`ip`),
  KEY `tracking_date_created` (`date_created` DESC)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_kls_consentlog` (
  `id` int NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consent_status` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accepted_categories` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `rejected_categories` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=87897 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2926 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=384 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_redirection_404` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `agent` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referrer` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `http_code` int unsigned NOT NULL DEFAULT '0',
  `request_method` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `request_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_redirection_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tracking` int NOT NULL DEFAULT '1',
  `module_id` int unsigned NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `position` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_redirection_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `match_url` varchar(2000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `match_data` text COLLATE utf8mb4_unicode_520_ci,
  `regex` int unsigned NOT NULL DEFAULT '0',
  `position` int unsigned NOT NULL DEFAULT '0',
  `last_count` int unsigned NOT NULL DEFAULT '0',
  `last_access` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `group_id` int NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_code` int unsigned NOT NULL,
  `action_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `match_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`),
  KEY `match_url` (`match_url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_redirection_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sent_to` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `agent` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `referrer` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `http_code` int unsigned NOT NULL DEFAULT '0',
  `request_method` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `request_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `redirect_by` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `redirection_id` int unsigned DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=602 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=1481 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12413 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=41918 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpmailsmtp_debug_events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `initiator` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmailsmtp_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpr_above_the_fold` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `lcp` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `viewport` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `error_message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpr_rocket_cache` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpr_rucss_used_css` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `css` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `hash` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `error_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error_message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `unprocessedcss` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT '1',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `job_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `queue_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `hash` (`hash`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wsal_metadata` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `occurrence_id` bigint NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `occurrence_name` (`occurrence_id`,`name`),
  KEY `name_value` (`name`,`value`(64))
) ENGINE=InnoDB AUTO_INCREMENT=637 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wsal_occurrences` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `site_id` bigint NOT NULL,
  `alert_id` bigint NOT NULL,
  `created_on` double NOT NULL,
  `client_ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `event_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_roles` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `session_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `site_alert_created` (`site_id`,`alert_id`,`created_on`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB AUTO_INCREMENT=184 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=983 DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("12158", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-04 00:11:06", "2024-08-04 00:11:06", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1722730266;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1722730266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-04 00:15:29", "2024-08-04 01:15:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12164", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-05 00:15:29", "2024-08-05 00:15:29", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1722816929;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1722816929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-05 00:29:04", "2024-08-05 01:29:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12174", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-06 00:29:04", "2024-08-06 00:29:04", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1722904144;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1722904144;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-06 06:24:10", "2024-08-06 07:24:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12182", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-07 06:24:10", "2024-08-07 06:24:10", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723011850;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723011850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-07 09:20:23", "2024-08-07 10:20:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12193", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-08 09:20:23", "2024-08-08 09:20:23", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723108823;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723108823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-08 23:31:41", "2024-08-09 00:31:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12201", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-09 23:31:41", "2024-08-09 23:31:41", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723246301;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723246301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-10 00:10:38", "2024-08-10 01:10:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12209", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-11 00:10:38", "2024-08-11 00:10:38", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723335038;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723335038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-11 00:11:07", "2024-08-11 01:11:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12230", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-12 00:11:07", "2024-08-12 00:11:07", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723421467;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723421467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-12 00:15:29", "2024-08-12 01:15:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12236", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-13 00:15:29", "2024-08-13 00:15:29", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723508129;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723508129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-13 00:16:14", "2024-08-13 01:16:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12244", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-14 00:16:14", "2024-08-14 00:16:14", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723594574;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723594574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-14 02:04:04", "2024-08-14 03:04:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12259", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-15 02:04:04", "2024-08-15 02:04:04", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723687444;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723687444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-16 00:10:25", "2024-08-16 01:10:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12267", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-17 00:10:25", "2024-08-17 00:10:25", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723853425;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723853425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-17 00:10:27", "2024-08-17 01:10:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12275", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-18 00:10:27", "2024-08-18 00:10:27", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723939827;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723939827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-18 00:10:52", "2024-08-18 01:10:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12283", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-19 00:10:52", "2024-08-19 00:10:52", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724026252;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724026252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-19 00:11:01", "2024-08-19 01:11:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12289", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-20 00:11:01", "2024-08-20 00:11:01", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724112661;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724112661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-20 00:15:38", "2024-08-20 01:15:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12298", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-21 00:15:38", "2024-08-21 00:15:38", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724199338;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724199338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-21 00:34:40", "2024-08-21 01:34:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12308", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-22 00:34:40", "2024-08-22 00:34:40", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724286880;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724286880;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-22 16:43:01", "2024-08-22 17:43:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12321", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-23 16:43:01", "2024-08-23 16:43:01", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724431381;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724431381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-23 22:45:33", "2024-08-23 23:45:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12329", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-24 22:45:33", "2024-08-24 22:45:33", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724539533;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724539533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-25 00:10:46", "2024-08-25 01:10:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12337", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-26 00:10:46", "2024-08-26 00:10:46", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724631046;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724631046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-26 00:11:02", "2024-08-26 01:11:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12345", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-27 00:11:02", "2024-08-27 00:11:02", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724717462;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724717462;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-27 00:37:00", "2024-08-27 01:37:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12370", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-28 00:37:00", "2024-08-28 00:37:00", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724805420;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724805420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-28 03:07:42", "2024-08-28 04:07:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12566", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-29 03:07:42", "2024-08-29 03:07:42", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724900862;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724900862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-29 06:29:09", "2024-08-29 07:29:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12765", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-30 06:29:09", "2024-08-30 06:29:09", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1724999349;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1724999349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-30 06:32:19", "2024-08-30 07:32:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12834", "wp_mail_smtp_admin_notifications_update", "complete", "2024-08-31 06:32:19", "2024-08-31 06:32:19", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725085939;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725085939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-08-31 14:17:41", "2024-08-31 15:17:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12921", "wp_mail_smtp_admin_notifications_update", "complete", "2024-09-01 14:17:41", "2024-09-01 14:17:41", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725200261;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725200261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-09-01 14:22:29", "2024-09-01 15:22:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12936", "wp_mail_smtp_admin_notifications_update", "complete", "2024-09-02 14:22:29", "2024-09-02 14:22:29", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725286949;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725286949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-09-02 14:23:11", "2024-09-02 15:23:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("12998", "wp_mail_smtp_admin_notifications_update", "pending", "2024-09-03 14:23:11", "2024-09-03 14:23:11", "[91]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725373391;s:18:\"\0*\0first_timestamp\";i:1693838618;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725373391;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("13111", "action_scheduler/migration_hook", "complete", "2024-09-03 07:55:44", "2024-09-03 07:55:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725350144;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725350144;}", "1", "1", "2024-09-03 07:56:00", "2024-09-03 08:56:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("34798", "2024-01-28 02:28:12");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wp_mail_smtp");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "rocket-atf-warmup");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("36386", "12158", "action created", "2024-08-03 00:11:06", "2024-08-03 00:11:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("36396", "12158", "action started via WP Cron", "2024-08-04 00:15:29", "2024-08-04 00:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("36397", "12158", "action complete via WP Cron", "2024-08-04 00:15:29", "2024-08-04 00:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("36398", "12164", "action created", "2024-08-04 00:15:29", "2024-08-04 00:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("36436", "12164", "action started via WP Cron", "2024-08-05 00:29:03", "2024-08-05 00:29:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("36437", "12164", "action complete via WP Cron", "2024-08-05 00:29:04", "2024-08-05 00:29:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("36438", "12174", "action created", "2024-08-05 00:29:04", "2024-08-05 00:29:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("36456", "12174", "action started via WP Cron", "2024-08-06 06:24:10", "2024-08-06 06:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("36457", "12174", "action complete via WP Cron", "2024-08-06 06:24:10", "2024-08-06 06:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("36458", "12182", "action created", "2024-08-06 06:24:10", "2024-08-06 06:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("36493", "12182", "action started via WP Cron", "2024-08-07 09:20:23", "2024-08-07 09:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("36494", "12182", "action complete via WP Cron", "2024-08-07 09:20:23", "2024-08-07 09:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("36495", "12193", "action created", "2024-08-07 09:20:23", "2024-08-07 09:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("36517", "12193", "action started via WP Cron", "2024-08-08 23:31:41", "2024-08-08 23:31:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("36518", "12193", "action complete via WP Cron", "2024-08-08 23:31:41", "2024-08-08 23:31:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("36519", "12201", "action created", "2024-08-08 23:31:41", "2024-08-08 23:31:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("36541", "12201", "action started via WP Cron", "2024-08-10 00:10:38", "2024-08-10 00:10:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("36542", "12201", "action complete via WP Cron", "2024-08-10 00:10:38", "2024-08-10 00:10:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("36543", "12209", "action created", "2024-08-10 00:10:38", "2024-08-10 00:10:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("36588", "12209", "action started via Async Request", "2024-08-11 00:11:07", "2024-08-11 00:11:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("36589", "12209", "action complete via Async Request", "2024-08-11 00:11:07", "2024-08-11 00:11:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("36590", "12230", "action created", "2024-08-11 00:11:07", "2024-08-11 00:11:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("36622", "12230", "action started via WP Cron", "2024-08-12 00:15:29", "2024-08-12 00:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("36623", "12230", "action complete via WP Cron", "2024-08-12 00:15:29", "2024-08-12 00:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("36624", "12236", "action created", "2024-08-12 00:15:29", "2024-08-12 00:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("36646", "12236", "action started via WP Cron", "2024-08-13 00:16:14", "2024-08-13 00:16:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("36647", "12236", "action complete via WP Cron", "2024-08-13 00:16:14", "2024-08-13 00:16:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("36648", "12244", "action created", "2024-08-13 00:16:14", "2024-08-13 00:16:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("36691", "12244", "action started via WP Cron", "2024-08-14 02:04:04", "2024-08-14 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("36692", "12244", "action complete via WP Cron", "2024-08-14 02:04:04", "2024-08-14 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("36693", "12259", "action created", "2024-08-14 02:04:04", "2024-08-14 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("36715", "12259", "action started via WP Cron", "2024-08-16 00:10:25", "2024-08-16 00:10:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("36716", "12259", "action complete via WP Cron", "2024-08-16 00:10:25", "2024-08-16 00:10:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("36717", "12267", "action created", "2024-08-16 00:10:25", "2024-08-16 00:10:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("36739", "12267", "action started via WP Cron", "2024-08-17 00:10:27", "2024-08-17 00:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("36740", "12267", "action complete via WP Cron", "2024-08-17 00:10:27", "2024-08-17 00:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("36741", "12275", "action created", "2024-08-17 00:10:27", "2024-08-17 00:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("36763", "12275", "action started via WP Cron", "2024-08-18 00:10:52", "2024-08-18 00:10:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("36764", "12275", "action complete via WP Cron", "2024-08-18 00:10:52", "2024-08-18 00:10:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("36765", "12283", "action created", "2024-08-18 00:10:52", "2024-08-18 00:10:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("36781", "12283", "action started via WP Cron", "2024-08-19 00:11:00", "2024-08-19 00:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("36782", "12283", "action complete via WP Cron", "2024-08-19 00:11:01", "2024-08-19 00:11:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("36783", "12289", "action created", "2024-08-19 00:11:01", "2024-08-19 00:11:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("36808", "12289", "action started via WP Cron", "2024-08-20 00:15:38", "2024-08-20 00:15:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("36809", "12289", "action complete via WP Cron", "2024-08-20 00:15:38", "2024-08-20 00:15:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("36810", "12298", "action created", "2024-08-20 00:15:38", "2024-08-20 00:15:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("36838", "12298", "action started via WP Cron", "2024-08-21 00:34:39", "2024-08-21 00:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("36839", "12298", "action complete via WP Cron", "2024-08-21 00:34:40", "2024-08-21 00:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("36840", "12308", "action created", "2024-08-21 00:34:40", "2024-08-21 00:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("36877", "12308", "action started via WP Cron", "2024-08-22 16:43:01", "2024-08-22 16:43:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("36878", "12308", "action complete via WP Cron", "2024-08-22 16:43:01", "2024-08-22 16:43:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("36879", "12321", "action created", "2024-08-22 16:43:01", "2024-08-22 16:43:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("36901", "12321", "action started via WP Cron", "2024-08-23 22:45:33", "2024-08-23 22:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("36902", "12321", "action complete via WP Cron", "2024-08-23 22:45:33", "2024-08-23 22:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("36903", "12329", "action created", "2024-08-23 22:45:33", "2024-08-23 22:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("36925", "12329", "action started via WP Cron", "2024-08-25 00:10:46", "2024-08-25 00:10:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("36926", "12329", "action complete via WP Cron", "2024-08-25 00:10:46", "2024-08-25 00:10:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("36927", "12337", "action created", "2024-08-25 00:10:46", "2024-08-25 00:10:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("36949", "12337", "action started via WP Cron", "2024-08-26 00:11:02", "2024-08-26 00:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("36950", "12337", "action complete via WP Cron", "2024-08-26 00:11:02", "2024-08-26 00:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("36951", "12345", "action created", "2024-08-26 00:11:02", "2024-08-26 00:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("37024", "12345", "action started via WP Cron", "2024-08-27 00:37:00", "2024-08-27 00:37:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("37025", "12345", "action complete via WP Cron", "2024-08-27 00:37:00", "2024-08-27 00:37:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("37026", "12370", "action created", "2024-08-27 00:37:00", "2024-08-27 00:37:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("37612", "12370", "action started via WP Cron", "2024-08-28 03:07:42", "2024-08-28 03:07:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("37613", "12370", "action complete via WP Cron", "2024-08-28 03:07:42", "2024-08-28 03:07:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("37614", "12566", "action created", "2024-08-28 03:07:42", "2024-08-28 03:07:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("38209", "12566", "action started via WP Cron", "2024-08-29 06:29:09", "2024-08-29 06:29:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("38210", "12566", "action complete via WP Cron", "2024-08-29 06:29:09", "2024-08-29 06:29:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("38211", "12765", "action created", "2024-08-29 06:29:09", "2024-08-29 06:29:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("38416", "12765", "action started via WP Cron", "2024-08-30 06:32:19", "2024-08-30 06:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("38417", "12765", "action complete via WP Cron", "2024-08-30 06:32:19", "2024-08-30 06:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("38418", "12834", "action created", "2024-08-30 06:32:19", "2024-08-30 06:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("38677", "12834", "action started via WP Cron", "2024-08-31 14:17:41", "2024-08-31 14:17:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("38678", "12834", "action complete via WP Cron", "2024-08-31 14:17:41", "2024-08-31 14:17:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("38679", "12921", "action created", "2024-08-31 14:17:41", "2024-08-31 14:17:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("38712", "12921", "action started via WP Cron", "2024-09-01 14:22:29", "2024-09-01 14:22:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("38713", "12921", "action complete via WP Cron", "2024-09-01 14:22:29", "2024-09-01 14:22:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("38714", "12936", "action created", "2024-09-01 14:22:29", "2024-09-01 14:22:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("38908", "12936", "action started via WP Cron", "2024-09-02 14:23:11", "2024-09-02 14:23:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("38909", "12936", "action complete via WP Cron", "2024-09-02 14:23:11", "2024-09-02 14:23:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("38910", "12998", "action created", "2024-09-02 14:23:11", "2024-09-02 14:23:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("39245", "13111", "action created", "2024-09-03 07:54:44", "2024-09-03 07:54:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("39267", "13111", "action started via Async Request", "2024-09-03 07:56:00", "2024-09-03 07:56:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("39268", "13111", "action complete via Async Request", "2024-09-03 07:56:00", "2024-09-03 07:56:00");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("18", "opzetopzet_migration_files", "568771be14cd748c1825_20230404110839", "100", "2023-04-04 11:08:45", "Klasse", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-04-04 11:08:39\";s:7:\"Version\";s:7:\"1.5.2.1\";s:9:\"VersionWP\";s:3:\"6.2\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"8.0.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:18;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"568771be14cd748c1825_20230404110839\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_568771be14cd748c1825_20230404110839\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"opzetopzet_migration_files_568771be14cd748c1825_20230404110839_scan.json\";s:10:\"TimerStart\";d:1680606525.9638140201568603515625;s:7:\"Runtime\";s:10:\"14.83 sec.\";s:7:\"ExeSize\";s:6:\"94.7KB\";s:7:\"ZipSize\";s:7:\"87.33MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:6:\"Klasse\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"opzetopzet_migration_files_568771be14cd748c1825_20230404110839_archive.daf\";s:6:\"Format\";s:3:\"DAF\";s:7:\"PackDir\";s:37:\"/home/opzetweb/opzet.opzet-website.nl\";s:4:\"Size\";i:91567292;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1916;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11626;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14275;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/opzetweb/opzet.opzet-website.nl/wp-admin\";i:1;s:49:\"/home/opzetweb/opzet.opzet-website.nl/wp-includes\";i:2;s:58:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/opzetweb/opzet.opzet-website.nl\";i:1;s:37:\"/home/opzetweb/opzet.opzet-website.nl\";i:2;s:48:\"/home/opzetweb/opzet.opzet-website.nl/wp-content\";i:3;s:56:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/uploads\";i:4;s:56:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/plugins\";i:5;s:59:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/mu-plugins\";i:6;s:55:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"opzetopzet_migration_files_568771be14cd748c1825_20230404110839_installer.php.bak\";s:4:\"Size\";i:96968;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:601;s:12:\"numDirsAdded\";i:131;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:121:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_568771b-04110839/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:101:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_568771b-04110839\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:37:\"/home/opzetweb/opzet.opzet-website.nl\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/opzetweb/opzet.opzet-website.nl/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3463:\"<?php\ndefine( \'WP_CACHE\', true ); // Added by WP Rocket\ndefine( \'WP_MEMORY_LIMIT\', \'128M\' );\n\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * MySQL settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** MySQL settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'opzetweb_wp5\' );\n\n/** MySQL database username */\ndefine( \'DB_USER\', \'opzetweb_wp5\' );\n\n/** MySQL database password */\ndefine( \'DB_PASSWORD\', \'Z.pv2kXiJ9eeXFx3hKd46\' );\n\n/** MySQL hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\',         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\');\ndefine(\'SECURE_AUTH_KEY\',  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\');\ndefine(\'LOGGED_IN_KEY\',    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\');\ndefine(\'NONCE_KEY\',        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\');\ndefine(\'AUTH_SALT\',        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\');\ndefine(\'SECURE_AUTH_SALT\', \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\');\ndefine(\'LOGGED_IN_SALT\',   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\');\ndefine(\'NONCE_SALT\',       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\');\n\n/**\n * Other customizations.\n */\ndefine(\'FS_METHOD\',\'direct\');\ndefine(\'FS_CHMOD_DIR\',0755);\ndefine(\'FS_CHMOD_FILE\',0644);\ndefine(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\n\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:22:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:36:\"define( \'WP_MEMORY_LIMIT\', \'128M\' );\";s:5:\"value\";s:6:\"\'128M\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'WP_MEMORY_LIMIT\'\";i:1;s:9:\", \'128M\' \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:36:\"define( \'DB_NAME\', \'opzetweb_wp5\' );\";s:5:\"value\";s:14:\"\'opzetweb_wp5\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:17:\", \'opzetweb_wp5\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:36:\"define( \'DB_USER\', \'opzetweb_wp5\' );\";s:5:\"value\";s:14:\"\'opzetweb_wp5\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:17:\", \'opzetweb_wp5\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:49:\"define( \'DB_PASSWORD\', \'Z.pv2kXiJ9eeXFx3hKd46\' );\";s:5:\"value\";s:23:\"\'Z.pv2kXiJ9eeXFx3hKd46\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:26:\", \'Z.pv2kXiJ9eeXFx3hKd46\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_KEY\',         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\');\";s:5:\"value\";s:66:\"\'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:76:\",         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_KEY\',  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\');\";s:5:\"value\";s:66:\"\'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:69:\",  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_KEY\',    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\');\";s:5:\"value\";s:66:\"\'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:71:\",    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_KEY\',        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\');\";s:5:\"value\";s:66:\"\'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:75:\",        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_SALT\',        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\');\";s:5:\"value\";s:66:\"\'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:75:\",        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\');\";s:5:\"value\";s:66:\"\'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_SALT\',   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\');\";s:5:\"value\";s:66:\"\'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:70:\",   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_SALT\',       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\');\";s:5:\"value\";s:66:\"\'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:74:\",       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\'\";i:2;s:2:\");\";}}s:9:\"FS_METHOD\";a:3:{s:3:\"src\";s:29:\"define(\'FS_METHOD\',\'direct\');\";s:5:\"value\";s:8:\"\'direct\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'FS_METHOD\'\";i:1;s:9:\",\'direct\'\";i:2;s:2:\");\";}}s:12:\"FS_CHMOD_DIR\";a:3:{s:3:\"src\";s:28:\"define(\'FS_CHMOD_DIR\',0755);\";s:5:\"value\";s:4:\"0755\";s:5:\"parts\";a:3:{i:0;s:21:\"define(\'FS_CHMOD_DIR\'\";i:1;s:5:\",0755\";i:2;s:2:\");\";}}s:13:\"FS_CHMOD_FILE\";a:3:{s:3:\"src\";s:29:\"define(\'FS_CHMOD_FILE\',0644);\";s:5:\"value\";s:4:\"0644\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'FS_CHMOD_FILE\'\";i:1;s:5:\",0644\";i:2;s:2:\");\";}}s:11:\"WP_TEMP_DIR\";a:3:{s:3:\"src\";s:62:\"define(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\";s:5:\"value\";s:39:\"dirname(__FILE__).\'/wp-content/uploads\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'WP_TEMP_DIR\'\";i:1;s:40:\",dirname(__FILE__).\'/wp-content/uploads\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10052254;s:4:\"File\";s:75:\"opzetopzet_migration_files_568771be14cd748c1825_20230404110839_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:7:\"utf8mb4\";i:1;s:6:\"latin1\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:4:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:18:\"utf8mb4_general_ci\";i:3;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:12:\"opzetweb_wp5\";s:15:\"tablesBaseCount\";i:63;s:16:\"tablesFinalCount\";i:63;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:30116;s:16:\"tablesSizeOnDisk\";i:9294283;s:10:\"tablesList\";a:63:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:29064;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:3086;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:9312;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:15;s:12:\"insertedRows\";i:15;s:4:\"size\";i:20536;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:47956;}s:18:\"wp_frmt_form_entry\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:23:\"wp_frmt_form_entry_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:18:\"wp_frmt_form_views\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:17:\"wp_kls_consentlog\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:4;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_nf3_action_meta\";a:3:{s:14:\"inaccurateRows\";i:440;s:12:\"insertedRows\";i:440;s:4:\"size\";i:49752;}s:14:\"wp_nf3_actions\";a:3:{s:14:\"inaccurateRows\";i:22;s:12:\"insertedRows\";i:22;s:4:\"size\";i:3272;}s:13:\"wp_nf3_chunks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:17:\"wp_nf3_field_meta\";a:3:{s:14:\"inaccurateRows\";i:1094;s:12:\"insertedRows\";i:1094;s:4:\"size\";i:84528;}s:13:\"wp_nf3_fields\";a:3:{s:14:\"inaccurateRows\";i:22;s:12:\"insertedRows\";i:22;s:4:\"size\";i:5268;}s:16:\"wp_nf3_form_meta\";a:3:{s:14:\"inaccurateRows\";i:460;s:12:\"insertedRows\";i:460;s:4:\"size\";i:40552;}s:12:\"wp_nf3_forms\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:2312;}s:18:\"wp_nf3_object_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:14:\"wp_nf3_objects\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"wp_nf3_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:15:\"wp_nf3_upgrades\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:85356;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:499;s:12:\"insertedRows\";i:505;s:4:\"size\";i:453752;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:168;s:12:\"insertedRows\";i:168;s:4:\"size\";i:50940;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:38;s:12:\"insertedRows\";i:38;s:4:\"size\";i:62816;}s:11:\"wp_snippets\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5752;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:3177;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:4232;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:13460;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:61;s:12:\"insertedRows\";i:61;s:4:\"size\";i:48448;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8468;}s:17:\"wp_wfblockediplog\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2084;}s:12:\"wp_wfblocks7\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:11:\"wp_wfconfig\";a:3:{s:14:\"inaccurateRows\";i:265;s:12:\"insertedRows\";i:265;s:4:\"size\";i:1599288;}s:13:\"wp_wfcrawlers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:16:\"wp_wffilechanges\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:13:\"wp_wffilemods\";a:3:{s:14:\"inaccurateRows\";i:11599;s:12:\"insertedRows\";i:11599;s:4:\"size\";i:3553508;}s:9:\"wp_wfhits\";a:3:{s:14:\"inaccurateRows\";i:78;s:12:\"insertedRows\";i:78;s:4:\"size\";i:34612;}s:11:\"wp_wfhoover\";a:3:{s:14:\"inaccurateRows\";i:2308;s:12:\"insertedRows\";i:2308;s:4:\"size\";i:355704;}s:11:\"wp_wfissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_wfknownfilelist\";a:3:{s:14:\"inaccurateRows\";i:11599;s:12:\"insertedRows\";i:11599;s:4:\"size\";i:2358064;}s:21:\"wp_wflivetraffichuman\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:9:\"wp_wflocs\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2116;}s:11:\"wp_wflogins\";a:3:{s:14:\"inaccurateRows\";i:29;s:12:\"insertedRows\";i:29;s:4:\"size\";i:9532;}s:19:\"wp_wfls_2fa_secrets\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:16:\"wp_wfls_settings\";a:3:{s:14:\"inaccurateRows\";i:21;s:12:\"insertedRows\";i:21;s:4:\"size\";i:16384;}s:18:\"wp_wfnotifications\";a:3:{s:14:\"inaccurateRows\";i:70;s:12:\"insertedRows\";i:70;s:4:\"size\";i:14380;}s:18:\"wp_wfpendingissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:17:\"wp_wfreversecache\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2096;}s:14:\"wp_wfsnipcache\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:5196;}s:11:\"wp_wfstatus\";a:3:{s:14:\"inaccurateRows\";i:1196;s:12:\"insertedRows\";i:1196;s:4:\"size\";i:151684;}s:17:\"wp_wftrafficrates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"wp_wpmailsmtp_debug_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:24:\"wp_wpmailsmtp_tasks_meta\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2176;}s:19:\"wp_wpr_rocket_cache\";a:3:{s:14:\"inaccurateRows\";i:14;s:12:\"insertedRows\";i:14;s:4:\"size\";i:12708;}s:21:\"wp_wpr_rucss_used_css\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:18:\"wp_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:20;s:12:\"insertedRows\";i:20;s:4:\"size\";i:17552;}s:28:\"wp_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:16;s:4:\"size\";i:5456;}s:19:\"wp_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:9768;}s:21:\"wp_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:16;s:4:\"size\";i:5488;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.32\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:145:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/opzetopzet_migration_files_568771be14cd748c1825_20230404110839_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";i:1680606540;s:11:\"initialized\";b:1;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:1;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:1;s:21:\"database_script_built\";b:1;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-04-04 11:08:39\";s:7:\"Version\";s:7:\"1.5.2.1\";s:9:\"VersionWP\";s:3:\"6.2\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"8.0.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"568771be14cd748c1825_20230404110839\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_568771be14cd748c1825_20230404110839\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:269;s:13:\"BuildProgress\";r:569;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("19", "opzetopzet_migration_files", "1676c907902e421d2742_20230601080034", "100", "2023-06-01 08:01:02", "Klasse", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-06-01 08:00:34\";s:7:\"Version\";s:5:\"1.5.4\";s:9:\"VersionWP\";s:5:\"6.2.2\";s:9:\"VersionDB\";s:6:\"8.0.33\";s:10:\"VersionPHP\";s:6:\"8.0.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:19;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"1676c907902e421d2742_20230601080034\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_1676c907902e421d2742_20230601080034\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"opzetopzet_migration_files_1676c907902e421d2742_20230601080034_scan.json\";s:10:\"TimerStart\";d:1685606462.88597011566162109375;s:7:\"Runtime\";s:10:\"16.39 sec.\";s:7:\"ExeSize\";s:7:\"94.69KB\";s:7:\"ZipSize\";s:7:\"87.86MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:6:\"Klasse\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"opzetopzet_migration_files_1676c907902e421d2742_20230601080034_archive.daf\";s:6:\"Format\";s:3:\"DAF\";s:7:\"PackDir\";s:37:\"/home/opzetweb/opzet.opzet-website.nl\";s:4:\"Size\";i:92131313;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1919;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11727;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14385;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/opzetweb/opzet.opzet-website.nl/wp-admin\";i:1;s:49:\"/home/opzetweb/opzet.opzet-website.nl/wp-includes\";i:2;s:58:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/opzetweb/opzet.opzet-website.nl\";i:1;s:37:\"/home/opzetweb/opzet.opzet-website.nl\";i:2;s:48:\"/home/opzetweb/opzet.opzet-website.nl/wp-content\";i:3;s:56:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/uploads\";i:4;s:56:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/plugins\";i:5;s:59:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/mu-plugins\";i:6;s:55:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"opzetopzet_migration_files_1676c907902e421d2742_20230601080034_installer.php.bak\";s:4:\"Size\";i:96966;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:606;s:12:\"numDirsAdded\";i:132;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:121:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_1676c90-01080034/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:101:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_1676c90-01080034\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:37:\"/home/opzetweb/opzet.opzet-website.nl\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/opzetweb/opzet.opzet-website.nl/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3463:\"<?php\ndefine( \'WP_CACHE\', true ); // Added by WP Rocket\ndefine( \'WP_MEMORY_LIMIT\', \'128M\' );\n\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * MySQL settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** MySQL settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'opzetweb_wp5\' );\n\n/** MySQL database username */\ndefine( \'DB_USER\', \'opzetweb_wp5\' );\n\n/** MySQL database password */\ndefine( \'DB_PASSWORD\', \'Z.pv2kXiJ9eeXFx3hKd46\' );\n\n/** MySQL hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\',         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\');\ndefine(\'SECURE_AUTH_KEY\',  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\');\ndefine(\'LOGGED_IN_KEY\',    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\');\ndefine(\'NONCE_KEY\',        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\');\ndefine(\'AUTH_SALT\',        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\');\ndefine(\'SECURE_AUTH_SALT\', \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\');\ndefine(\'LOGGED_IN_SALT\',   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\');\ndefine(\'NONCE_SALT\',       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\');\n\n/**\n * Other customizations.\n */\ndefine(\'FS_METHOD\',\'direct\');\ndefine(\'FS_CHMOD_DIR\',0755);\ndefine(\'FS_CHMOD_FILE\',0644);\ndefine(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\n\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:22:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:36:\"define( \'WP_MEMORY_LIMIT\', \'128M\' );\";s:5:\"value\";s:6:\"\'128M\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'WP_MEMORY_LIMIT\'\";i:1;s:9:\", \'128M\' \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:36:\"define( \'DB_NAME\', \'opzetweb_wp5\' );\";s:5:\"value\";s:14:\"\'opzetweb_wp5\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:17:\", \'opzetweb_wp5\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:36:\"define( \'DB_USER\', \'opzetweb_wp5\' );\";s:5:\"value\";s:14:\"\'opzetweb_wp5\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:17:\", \'opzetweb_wp5\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:49:\"define( \'DB_PASSWORD\', \'Z.pv2kXiJ9eeXFx3hKd46\' );\";s:5:\"value\";s:23:\"\'Z.pv2kXiJ9eeXFx3hKd46\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:26:\", \'Z.pv2kXiJ9eeXFx3hKd46\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_KEY\',         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\');\";s:5:\"value\";s:66:\"\'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:76:\",         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_KEY\',  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\');\";s:5:\"value\";s:66:\"\'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:69:\",  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_KEY\',    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\');\";s:5:\"value\";s:66:\"\'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:71:\",    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_KEY\',        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\');\";s:5:\"value\";s:66:\"\'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:75:\",        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_SALT\',        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\');\";s:5:\"value\";s:66:\"\'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:75:\",        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\');\";s:5:\"value\";s:66:\"\'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_SALT\',   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\');\";s:5:\"value\";s:66:\"\'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:70:\",   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_SALT\',       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\');\";s:5:\"value\";s:66:\"\'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:74:\",       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\'\";i:2;s:2:\");\";}}s:9:\"FS_METHOD\";a:3:{s:3:\"src\";s:29:\"define(\'FS_METHOD\',\'direct\');\";s:5:\"value\";s:8:\"\'direct\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'FS_METHOD\'\";i:1;s:9:\",\'direct\'\";i:2;s:2:\");\";}}s:12:\"FS_CHMOD_DIR\";a:3:{s:3:\"src\";s:28:\"define(\'FS_CHMOD_DIR\',0755);\";s:5:\"value\";s:4:\"0755\";s:5:\"parts\";a:3:{i:0;s:21:\"define(\'FS_CHMOD_DIR\'\";i:1;s:5:\",0755\";i:2;s:2:\");\";}}s:13:\"FS_CHMOD_FILE\";a:3:{s:3:\"src\";s:29:\"define(\'FS_CHMOD_FILE\',0644);\";s:5:\"value\";s:4:\"0644\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'FS_CHMOD_FILE\'\";i:1;s:5:\",0644\";i:2;s:2:\");\";}}s:11:\"WP_TEMP_DIR\";a:3:{s:3:\"src\";s:62:\"define(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\";s:5:\"value\";s:39:\"dirname(__FILE__).\'/wp-content/uploads\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'WP_TEMP_DIR\'\";i:1;s:40:\",dirname(__FILE__).\'/wp-content/uploads\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10147807;s:4:\"File\";s:75:\"opzetopzet_migration_files_1676c907902e421d2742_20230601080034_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:7:\"utf8mb4\";i:1;s:6:\"latin1\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:4:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:18:\"utf8mb4_general_ci\";i:3;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:12:\"opzetweb_wp5\";s:15:\"tablesBaseCount\";i:63;s:16:\"tablesFinalCount\";i:63;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:30129;s:16:\"tablesSizeOnDisk\";i:9330372;s:10:\"tablesList\";a:63:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:14;s:4:\"size\";i:30324;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:3086;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:9312;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:42;s:4:\"size\";i:20536;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:2;s:4:\"size\";i:47956;}s:18:\"wp_frmt_form_entry\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:23:\"wp_frmt_form_entry_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:18:\"wp_frmt_form_views\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:17:\"wp_kls_consentlog\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:4;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_nf3_action_meta\";a:3:{s:14:\"inaccurateRows\";i:440;s:12:\"insertedRows\";i:440;s:4:\"size\";i:49752;}s:14:\"wp_nf3_actions\";a:3:{s:14:\"inaccurateRows\";i:22;s:12:\"insertedRows\";i:22;s:4:\"size\";i:3272;}s:13:\"wp_nf3_chunks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:17:\"wp_nf3_field_meta\";a:3:{s:14:\"inaccurateRows\";i:1094;s:12:\"insertedRows\";i:1094;s:4:\"size\";i:84528;}s:13:\"wp_nf3_fields\";a:3:{s:14:\"inaccurateRows\";i:22;s:12:\"insertedRows\";i:22;s:4:\"size\";i:5268;}s:16:\"wp_nf3_form_meta\";a:3:{s:14:\"inaccurateRows\";i:460;s:12:\"insertedRows\";i:460;s:4:\"size\";i:40552;}s:12:\"wp_nf3_forms\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:2312;}s:18:\"wp_nf3_object_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:14:\"wp_nf3_objects\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"wp_nf3_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:15:\"wp_nf3_upgrades\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:85356;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:518;s:12:\"insertedRows\";i:515;s:4:\"size\";i:487904;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:177;s:12:\"insertedRows\";i:177;s:4:\"size\";i:51964;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:37;s:12:\"insertedRows\";i:37;s:4:\"size\";i:62816;}s:11:\"wp_snippets\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5752;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:3198;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:4232;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:13460;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:64;s:12:\"insertedRows\";i:64;s:4:\"size\";i:48448;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8468;}s:17:\"wp_wfblockediplog\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2084;}s:12:\"wp_wfblocks7\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:11:\"wp_wfconfig\";a:3:{s:14:\"inaccurateRows\";i:265;s:12:\"insertedRows\";i:265;s:4:\"size\";i:1599288;}s:13:\"wp_wfcrawlers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:16:\"wp_wffilechanges\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:13:\"wp_wffilemods\";a:3:{s:14:\"inaccurateRows\";i:11599;s:12:\"insertedRows\";i:11599;s:4:\"size\";i:3553508;}s:9:\"wp_wfhits\";a:3:{s:14:\"inaccurateRows\";i:78;s:12:\"insertedRows\";i:78;s:4:\"size\";i:34612;}s:11:\"wp_wfhoover\";a:3:{s:14:\"inaccurateRows\";i:2308;s:12:\"insertedRows\";i:2308;s:4:\"size\";i:355704;}s:11:\"wp_wfissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_wfknownfilelist\";a:3:{s:14:\"inaccurateRows\";i:11599;s:12:\"insertedRows\";i:11599;s:4:\"size\";i:2358064;}s:21:\"wp_wflivetraffichuman\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:9:\"wp_wflocs\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2116;}s:11:\"wp_wflogins\";a:3:{s:14:\"inaccurateRows\";i:29;s:12:\"insertedRows\";i:29;s:4:\"size\";i:9532;}s:19:\"wp_wfls_2fa_secrets\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:16:\"wp_wfls_settings\";a:3:{s:14:\"inaccurateRows\";i:21;s:12:\"insertedRows\";i:21;s:4:\"size\";i:16384;}s:18:\"wp_wfnotifications\";a:3:{s:14:\"inaccurateRows\";i:70;s:12:\"insertedRows\";i:70;s:4:\"size\";i:14380;}s:18:\"wp_wfpendingissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:17:\"wp_wfreversecache\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2096;}s:14:\"wp_wfsnipcache\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:5196;}s:11:\"wp_wfstatus\";a:3:{s:14:\"inaccurateRows\";i:1196;s:12:\"insertedRows\";i:1196;s:4:\"size\";i:151684;}s:17:\"wp_wftrafficrates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"wp_wpmailsmtp_debug_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:24:\"wp_wpmailsmtp_tasks_meta\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2176;}s:19:\"wp_wpr_rocket_cache\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:12736;}s:21:\"wp_wpr_rucss_used_css\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:18:\"wp_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:19;s:12:\"insertedRows\";i:19;s:4:\"size\";i:17132;}s:28:\"wp_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:16;s:4:\"size\";i:5456;}s:19:\"wp_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:9792;}s:21:\"wp_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:16;s:4:\"size\";i:5488;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.33\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:145:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/opzetopzet_migration_files_1676c907902e421d2742_20230601080034_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";i:1685606478;s:11:\"initialized\";b:1;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:1;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:1;s:21:\"database_script_built\";b:1;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-06-01 08:00:34\";s:7:\"Version\";s:5:\"1.5.4\";s:9:\"VersionWP\";s:5:\"6.2.2\";s:9:\"VersionDB\";s:6:\"8.0.33\";s:10:\"VersionPHP\";s:6:\"8.0.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"1676c907902e421d2742_20230601080034\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_1676c907902e421d2742_20230601080034\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:269;s:13:\"BuildProgress\";r:569;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("20", "opzetopzet_migration_files", "1b6498b23632ce621716_20231003114433", "100", "2023-10-03 11:44:39", "Klasse", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-10-03 11:44:33\";s:7:\"Version\";s:5:\"1.5.6\";s:9:\"VersionWP\";s:5:\"6.3.1\";s:9:\"VersionDB\";s:6:\"8.0.34\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:20;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"1b6498b23632ce621716_20231003114433\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_1b6498b23632ce621716_20231003114433\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"opzetopzet_migration_files_1b6498b23632ce621716_20231003114433_scan.json\";s:10:\"TimerStart\";d:1696333479.895061969757080078125;s:7:\"Runtime\";s:10:\"25.35 sec.\";s:7:\"ExeSize\";s:7:\"94.82KB\";s:7:\"ZipSize\";s:7:\"89.51MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:6:\"Klasse\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"opzetopzet_migration_files_1b6498b23632ce621716_20231003114433_archive.daf\";s:6:\"Format\";s:3:\"DAF\";s:7:\"PackDir\";s:37:\"/home/opzetweb/opzet.opzet-website.nl\";s:4:\"Size\";i:93858610;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1981;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11542;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14262;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/opzetweb/opzet.opzet-website.nl/wp-admin\";i:1;s:49:\"/home/opzetweb/opzet.opzet-website.nl/wp-includes\";i:2;s:58:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/opzetweb/opzet.opzet-website.nl\";i:1;s:37:\"/home/opzetweb/opzet.opzet-website.nl\";i:2;s:48:\"/home/opzetweb/opzet.opzet-website.nl/wp-content\";i:3;s:56:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/uploads\";i:4;s:56:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/plugins\";i:5;s:59:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/mu-plugins\";i:6;s:55:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"opzetopzet_migration_files_1b6498b23632ce621716_20231003114433_installer.php.bak\";s:4:\"Size\";i:97094;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:606;s:12:\"numDirsAdded\";i:132;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:121:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_1b6498b-03114433/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:101:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_1b6498b-03114433\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:37:\"/home/opzetweb/opzet.opzet-website.nl\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/opzetweb/opzet.opzet-website.nl/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3463:\"<?php\ndefine( \'WP_CACHE\', true ); // Added by WP Rocket\ndefine( \'WP_MEMORY_LIMIT\', \'128M\' );\n\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * MySQL settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** MySQL settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'opzetweb_wp5\' );\n\n/** MySQL database username */\ndefine( \'DB_USER\', \'opzetweb_wp5\' );\n\n/** MySQL database password */\ndefine( \'DB_PASSWORD\', \'Z.pv2kXiJ9eeXFx3hKd46\' );\n\n/** MySQL hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\',         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\');\ndefine(\'SECURE_AUTH_KEY\',  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\');\ndefine(\'LOGGED_IN_KEY\',    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\');\ndefine(\'NONCE_KEY\',        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\');\ndefine(\'AUTH_SALT\',        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\');\ndefine(\'SECURE_AUTH_SALT\', \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\');\ndefine(\'LOGGED_IN_SALT\',   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\');\ndefine(\'NONCE_SALT\',       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\');\n\n/**\n * Other customizations.\n */\ndefine(\'FS_METHOD\',\'direct\');\ndefine(\'FS_CHMOD_DIR\',0755);\ndefine(\'FS_CHMOD_FILE\',0644);\ndefine(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\n\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:22:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:36:\"define( \'WP_MEMORY_LIMIT\', \'128M\' );\";s:5:\"value\";s:6:\"\'128M\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'WP_MEMORY_LIMIT\'\";i:1;s:9:\", \'128M\' \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:36:\"define( \'DB_NAME\', \'opzetweb_wp5\' );\";s:5:\"value\";s:14:\"\'opzetweb_wp5\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:17:\", \'opzetweb_wp5\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:36:\"define( \'DB_USER\', \'opzetweb_wp5\' );\";s:5:\"value\";s:14:\"\'opzetweb_wp5\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:17:\", \'opzetweb_wp5\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:49:\"define( \'DB_PASSWORD\', \'Z.pv2kXiJ9eeXFx3hKd46\' );\";s:5:\"value\";s:23:\"\'Z.pv2kXiJ9eeXFx3hKd46\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:26:\", \'Z.pv2kXiJ9eeXFx3hKd46\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_KEY\',         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\');\";s:5:\"value\";s:66:\"\'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:76:\",         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_KEY\',  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\');\";s:5:\"value\";s:66:\"\'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:69:\",  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_KEY\',    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\');\";s:5:\"value\";s:66:\"\'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:71:\",    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_KEY\',        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\');\";s:5:\"value\";s:66:\"\'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:75:\",        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_SALT\',        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\');\";s:5:\"value\";s:66:\"\'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:75:\",        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\');\";s:5:\"value\";s:66:\"\'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_SALT\',   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\');\";s:5:\"value\";s:66:\"\'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:70:\",   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_SALT\',       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\');\";s:5:\"value\";s:66:\"\'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:74:\",       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\'\";i:2;s:2:\");\";}}s:9:\"FS_METHOD\";a:3:{s:3:\"src\";s:29:\"define(\'FS_METHOD\',\'direct\');\";s:5:\"value\";s:8:\"\'direct\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'FS_METHOD\'\";i:1;s:9:\",\'direct\'\";i:2;s:2:\");\";}}s:12:\"FS_CHMOD_DIR\";a:3:{s:3:\"src\";s:28:\"define(\'FS_CHMOD_DIR\',0755);\";s:5:\"value\";s:4:\"0755\";s:5:\"parts\";a:3:{i:0;s:21:\"define(\'FS_CHMOD_DIR\'\";i:1;s:5:\",0755\";i:2;s:2:\");\";}}s:13:\"FS_CHMOD_FILE\";a:3:{s:3:\"src\";s:29:\"define(\'FS_CHMOD_FILE\',0644);\";s:5:\"value\";s:4:\"0644\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'FS_CHMOD_FILE\'\";i:1;s:5:\",0644\";i:2;s:2:\");\";}}s:11:\"WP_TEMP_DIR\";a:3:{s:3:\"src\";s:62:\"define(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\";s:5:\"value\";s:39:\"dirname(__FILE__).\'/wp-content/uploads\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'WP_TEMP_DIR\'\";i:1;s:40:\",dirname(__FILE__).\'/wp-content/uploads\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10384357;s:4:\"File\";s:75:\"opzetopzet_migration_files_1b6498b23632ce621716_20231003114433_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:7:\"utf8mb4\";i:1;s:6:\"latin1\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:4:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:18:\"utf8mb4_general_ci\";i:3;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:12:\"opzetweb_wp5\";s:15:\"tablesBaseCount\";i:63;s:16:\"tablesFinalCount\";i:63;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:30263;s:16:\"tablesSizeOnDisk\";i:9577652;s:10:\"tablesList\";a:63:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:29;s:12:\"insertedRows\";i:29;s:4:\"size\";i:37092;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:3086;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:9312;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:85;s:12:\"insertedRows\";i:85;s:4:\"size\";i:24432;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:3;s:4:\"size\";i:47976;}s:18:\"wp_frmt_form_entry\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:23:\"wp_frmt_form_entry_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:18:\"wp_frmt_form_views\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:17:\"wp_kls_consentlog\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:5;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_nf3_action_meta\";a:3:{s:14:\"inaccurateRows\";i:440;s:12:\"insertedRows\";i:440;s:4:\"size\";i:49752;}s:14:\"wp_nf3_actions\";a:3:{s:14:\"inaccurateRows\";i:22;s:12:\"insertedRows\";i:22;s:4:\"size\";i:3272;}s:13:\"wp_nf3_chunks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:17:\"wp_nf3_field_meta\";a:3:{s:14:\"inaccurateRows\";i:1094;s:12:\"insertedRows\";i:1094;s:4:\"size\";i:84528;}s:13:\"wp_nf3_fields\";a:3:{s:14:\"inaccurateRows\";i:22;s:12:\"insertedRows\";i:22;s:4:\"size\";i:5268;}s:16:\"wp_nf3_form_meta\";a:3:{s:14:\"inaccurateRows\";i:460;s:12:\"insertedRows\";i:460;s:4:\"size\";i:40552;}s:12:\"wp_nf3_forms\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:2312;}s:18:\"wp_nf3_object_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:14:\"wp_nf3_objects\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"wp_nf3_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:15:\"wp_nf3_upgrades\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:85356;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:528;s:12:\"insertedRows\";i:528;s:4:\"size\";i:724460;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:198;s:12:\"insertedRows\";i:198;s:4:\"size\";i:51964;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:40;s:12:\"insertedRows\";i:40;s:4:\"size\";i:62816;}s:11:\"wp_snippets\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5752;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:3198;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:4232;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:13460;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:64;s:12:\"insertedRows\";i:64;s:4:\"size\";i:48448;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8468;}s:17:\"wp_wfblockediplog\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2084;}s:12:\"wp_wfblocks7\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:11:\"wp_wfconfig\";a:3:{s:14:\"inaccurateRows\";i:265;s:12:\"insertedRows\";i:265;s:4:\"size\";i:1599288;}s:13:\"wp_wfcrawlers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:16:\"wp_wffilechanges\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:13:\"wp_wffilemods\";a:3:{s:14:\"inaccurateRows\";i:11599;s:12:\"insertedRows\";i:11599;s:4:\"size\";i:3553508;}s:9:\"wp_wfhits\";a:3:{s:14:\"inaccurateRows\";i:78;s:12:\"insertedRows\";i:78;s:4:\"size\";i:34612;}s:11:\"wp_wfhoover\";a:3:{s:14:\"inaccurateRows\";i:2308;s:12:\"insertedRows\";i:2308;s:4:\"size\";i:355704;}s:11:\"wp_wfissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_wfknownfilelist\";a:3:{s:14:\"inaccurateRows\";i:11599;s:12:\"insertedRows\";i:11599;s:4:\"size\";i:2358064;}s:21:\"wp_wflivetraffichuman\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:9:\"wp_wflocs\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2116;}s:11:\"wp_wflogins\";a:3:{s:14:\"inaccurateRows\";i:29;s:12:\"insertedRows\";i:29;s:4:\"size\";i:9532;}s:19:\"wp_wfls_2fa_secrets\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:16:\"wp_wfls_settings\";a:3:{s:14:\"inaccurateRows\";i:21;s:12:\"insertedRows\";i:21;s:4:\"size\";i:16384;}s:18:\"wp_wfnotifications\";a:3:{s:14:\"inaccurateRows\";i:70;s:12:\"insertedRows\";i:70;s:4:\"size\";i:14380;}s:18:\"wp_wfpendingissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:17:\"wp_wfreversecache\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2096;}s:14:\"wp_wfsnipcache\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:5196;}s:11:\"wp_wfstatus\";a:3:{s:14:\"inaccurateRows\";i:1196;s:12:\"insertedRows\";i:1196;s:4:\"size\";i:151684;}s:17:\"wp_wftrafficrates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"wp_wpmailsmtp_debug_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:24:\"wp_wpmailsmtp_tasks_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2176;}s:19:\"wp_wpr_rocket_cache\";a:3:{s:14:\"inaccurateRows\";i:12;s:12:\"insertedRows\";i:12;s:4:\"size\";i:12776;}s:21:\"wp_wpr_rucss_used_css\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:18:\"wp_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:19;s:12:\"insertedRows\";i:19;s:4:\"size\";i:17132;}s:28:\"wp_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:16;s:4:\"size\";i:5456;}s:19:\"wp_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:9792;}s:21:\"wp_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5488;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.34\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:145:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/opzetopzet_migration_files_1b6498b23632ce621716_20231003114433_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";i:1696333504;s:11:\"initialized\";b:1;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:1;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:1;s:21:\"database_script_built\";b:1;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-10-03 11:44:33\";s:7:\"Version\";s:5:\"1.5.6\";s:9:\"VersionWP\";s:5:\"6.3.1\";s:9:\"VersionDB\";s:6:\"8.0.34\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"1b6498b23632ce621716_20231003114433\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_1b6498b23632ce621716_20231003114433\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:269;s:13:\"BuildProgress\";r:569;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("21", "opzetopzet_migration_files", "99ab987f9402e8d69893_20240223103811", "100", "2024-02-23 10:40:25", "Klasse", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-02-23 10:38:11\";s:7:\"Version\";s:5:\"1.5.8\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.1.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:21;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"99ab987f9402e8d69893_20240223103811\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_99ab987f9402e8d69893_20240223103811\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"opzetopzet_migration_files_99ab987f9402e8d69893_20240223103811_scan.json\";s:10:\"TimerStart\";d:1708684825.428594112396240234375;s:7:\"Runtime\";s:10:\"25.30 sec.\";s:7:\"ExeSize\";s:7:\"94.82KB\";s:7:\"ZipSize\";s:7:\"84.99MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:6:\"Klasse\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"opzetopzet_migration_files_99ab987f9402e8d69893_20240223103811_archive.daf\";s:6:\"Format\";s:3:\"DAF\";s:7:\"PackDir\";s:37:\"/home/opzetweb/opzet.opzet-website.nl\";s:4:\"Size\";i:89113835;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2143;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11779;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14662;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/opzetweb/opzet.opzet-website.nl/wp-admin\";i:1;s:49:\"/home/opzetweb/opzet.opzet-website.nl/wp-includes\";i:2;s:58:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/opzetweb/opzet.opzet-website.nl\";i:1;s:37:\"/home/opzetweb/opzet.opzet-website.nl\";i:2;s:48:\"/home/opzetweb/opzet.opzet-website.nl/wp-content\";i:3;s:56:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/uploads\";i:4;s:56:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/plugins\";i:5;s:59:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/mu-plugins\";i:6;s:55:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"opzetopzet_migration_files_99ab987f9402e8d69893_20240223103811_installer.php.bak\";s:4:\"Size\";i:97095;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:607;s:12:\"numDirsAdded\";i:132;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:121:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_99ab987-23103811/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:101:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_99ab987-23103811\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:37:\"/home/opzetweb/opzet.opzet-website.nl\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/opzetweb/opzet.opzet-website.nl/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3445:\"<?php\ndefine( \'WP_CACHE\', true ); // Added by WP Rocket\n\ndefine( \'WP_MEMORY_LIMIT\', \'128M\' );\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * MySQL settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n// ** MySQL settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'opzetweb_wp5\' );\n/** MySQL database username */\ndefine( \'DB_USER\', \'opzetweb_wp5\' );\n/** MySQL database password */\ndefine( \'DB_PASSWORD\', \'Z.pv2kXiJ9eeXFx3hKd46\' );\n/** MySQL hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\',         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\');\ndefine(\'SECURE_AUTH_KEY\',  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\');\ndefine(\'LOGGED_IN_KEY\',    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\');\ndefine(\'NONCE_KEY\',        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\');\ndefine(\'AUTH_SALT\',        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\');\ndefine(\'SECURE_AUTH_SALT\', \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\');\ndefine(\'LOGGED_IN_SALT\',   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\');\ndefine(\'NONCE_SALT\',       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\');\n/**\n * Other customizations.\n */\ndefine(\'FS_METHOD\',\'direct\');\ndefine(\'FS_CHMOD_DIR\',0755);\ndefine(\'FS_CHMOD_FILE\',0644);\ndefine(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\n/**#@-*/\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n/* Add any custom values between this line and the \"stop editing\" line. */\n/* That\'s all, stop editing! Happy publishing. */\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:22:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:36:\"define( \'WP_MEMORY_LIMIT\', \'128M\' );\";s:5:\"value\";s:6:\"\'128M\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'WP_MEMORY_LIMIT\'\";i:1;s:9:\", \'128M\' \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:36:\"define( \'DB_NAME\', \'opzetweb_wp5\' );\";s:5:\"value\";s:14:\"\'opzetweb_wp5\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:17:\", \'opzetweb_wp5\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:36:\"define( \'DB_USER\', \'opzetweb_wp5\' );\";s:5:\"value\";s:14:\"\'opzetweb_wp5\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:17:\", \'opzetweb_wp5\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:49:\"define( \'DB_PASSWORD\', \'Z.pv2kXiJ9eeXFx3hKd46\' );\";s:5:\"value\";s:23:\"\'Z.pv2kXiJ9eeXFx3hKd46\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:26:\", \'Z.pv2kXiJ9eeXFx3hKd46\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_KEY\',         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\');\";s:5:\"value\";s:66:\"\'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:76:\",         \'ISmei3KPQvlnIX0yCdNpq9mwOXyjOeOLForjsb6csxELVp66v9iN8RWlniLHgA03\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_KEY\',  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\');\";s:5:\"value\";s:66:\"\'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:69:\",  \'MIV1BSenxy9YKA357U7euarfY4y9zGT1LFeu3eI7GYQv3HNsykT2zR0QelBOV7uE\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_KEY\',    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\');\";s:5:\"value\";s:66:\"\'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:71:\",    \'ZCJxU1PENwuuW3bxWU5OBvKnPIv4yrXAzeapFKWXTeP2gdtVDRMtDWC9bNzsWo9i\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_KEY\',        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\');\";s:5:\"value\";s:66:\"\'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:75:\",        \'dusLfatBINE5Irdz6fM9NdoLcvPlmTq69TZHksFhyKkJoRlMysLR1am4I3mAGyju\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_SALT\',        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\');\";s:5:\"value\";s:66:\"\'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:75:\",        \'QJOuJabIR5CA2JLIM923U1RCbdE7Z7jN0VCS9KwnrKwOxvulhofrTC7ZdgYcW7FE\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\');\";s:5:\"value\";s:66:\"\'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'UIeGqWlgOAyp1eW54jfsf1IYuhJG3M70yYRm3U7K2j4BPsJFgUKetuETentzkpuU\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_SALT\',   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\');\";s:5:\"value\";s:66:\"\'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:70:\",   \'zGgHrHqhKPCYFlvHpdr1Db7P5RPKcyYuFh3LCFswUzL3ctuvvd6IUk8IYjWLzRxo\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_SALT\',       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\');\";s:5:\"value\";s:66:\"\'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:74:\",       \'W31f3uJ5Q0YGNX0tSeG4f22ywY0MVmRBzgCK9gawcQrQQAXuzatJI9cJUvjHwPg2\'\";i:2;s:2:\");\";}}s:9:\"FS_METHOD\";a:3:{s:3:\"src\";s:29:\"define(\'FS_METHOD\',\'direct\');\";s:5:\"value\";s:8:\"\'direct\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'FS_METHOD\'\";i:1;s:9:\",\'direct\'\";i:2;s:2:\");\";}}s:12:\"FS_CHMOD_DIR\";a:3:{s:3:\"src\";s:28:\"define(\'FS_CHMOD_DIR\',0755);\";s:5:\"value\";s:4:\"0755\";s:5:\"parts\";a:3:{i:0;s:21:\"define(\'FS_CHMOD_DIR\'\";i:1;s:5:\",0755\";i:2;s:2:\");\";}}s:13:\"FS_CHMOD_FILE\";a:3:{s:3:\"src\";s:29:\"define(\'FS_CHMOD_FILE\',0644);\";s:5:\"value\";s:4:\"0644\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'FS_CHMOD_FILE\'\";i:1;s:5:\",0644\";i:2;s:2:\");\";}}s:11:\"WP_TEMP_DIR\";a:3:{s:3:\"src\";s:62:\"define(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\";s:5:\"value\";s:39:\"dirname(__FILE__).\'/wp-content/uploads\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'WP_TEMP_DIR\'\";i:1;s:40:\",dirname(__FILE__).\'/wp-content/uploads\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:9360779;s:4:\"File\";s:75:\"opzetopzet_migration_files_99ab987f9402e8d69893_20240223103811_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:7:\"utf8mb4\";i:1;s:6:\"latin1\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:3:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"InnoDB\";i:1;s:6:\"MEMORY\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:12:\"opzetweb_wp5\";s:15:\"tablesBaseCount\";i:62;s:16:\"tablesFinalCount\";i:62;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:29191;s:16:\"tablesSizeOnDisk\";i:17973248;s:10:\"tablesList\";a:62:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:31;s:12:\"insertedRows\";i:27;s:4:\"size\";i:147456;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:32768;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:81;s:12:\"insertedRows\";i:79;s:4:\"size\";i:49152;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:4;s:4:\"size\";i:131072;}s:23:\"wp_gf_draft_submissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:11:\"wp_gf_entry\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:16:\"wp_gf_entry_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:17:\"wp_gf_entry_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:10:\"wp_gf_form\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:16384;}s:15:\"wp_gf_form_meta\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:20:\"wp_gf_form_revisions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:15:\"wp_gf_form_view\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"wp_gf_rest_api_keys\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:17:\"wp_kls_consentlog\";a:3:{s:14:\"inaccurateRows\";i:6;s:12:\"insertedRows\";i:6;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:534;s:12:\"insertedRows\";i:568;s:4:\"size\";i:2621440;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:153;s:12:\"insertedRows\";i:153;s:4:\"size\";i:81920;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:18;s:12:\"insertedRows\";i:18;s:4:\"size\";i:81920;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:66;s:12:\"insertedRows\";i:65;s:4:\"size\";i:81920;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:65536;}s:17:\"wp_wfblockediplog\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:12:\"wp_wfblocks7\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:11:\"wp_wfconfig\";a:3:{s:14:\"inaccurateRows\";i:274;s:12:\"insertedRows\";i:276;s:4:\"size\";i:2588672;}s:13:\"wp_wfcrawlers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_wffilechanges\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:13:\"wp_wffilemods\";a:3:{s:14:\"inaccurateRows\";i:13324;s:12:\"insertedRows\";i:12287;s:4:\"size\";i:6832128;}s:9:\"wp_wfhits\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:6;s:4:\"size\";i:65536;}s:11:\"wp_wfhoover\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:11:\"wp_wfissues\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:9;s:4:\"size\";i:81920;}s:18:\"wp_wfknownfilelist\";a:3:{s:14:\"inaccurateRows\";i:12192;s:12:\"insertedRows\";i:12287;s:4:\"size\";i:2637824;}s:21:\"wp_wflivetraffichuman\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:9:\"wp_wflocs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:11:\"wp_wflogins\";a:3:{s:14:\"inaccurateRows\";i:197;s:12:\"insertedRows\";i:198;s:4:\"size\";i:98304;}s:19:\"wp_wfls_2fa_secrets\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:19:\"wp_wfls_role_counts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:0;}s:16:\"wp_wfls_settings\";a:3:{s:14:\"inaccurateRows\";i:30;s:12:\"insertedRows\";i:30;s:4:\"size\";i:16384;}s:18:\"wp_wfnotifications\";a:3:{s:14:\"inaccurateRows\";i:80;s:12:\"insertedRows\";i:92;s:4:\"size\";i:16384;}s:18:\"wp_wfpendingissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:17:\"wp_wfreversecache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:19:\"wp_wfsecurityevents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:14:\"wp_wfsnipcache\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:65536;}s:11:\"wp_wfstatus\";a:3:{s:14:\"inaccurateRows\";i:1492;s:12:\"insertedRows\";i:1492;s:4:\"size\";i:344064;}s:17:\"wp_wftrafficrates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_wfwaffailures\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:26:\"wp_wpmailsmtp_debug_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:24:\"wp_wpmailsmtp_tasks_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:16384;}s:19:\"wp_wpr_rocket_cache\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:65536;}s:21:\"wp_wpr_rucss_used_css\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:114688;}s:16:\"wp_wsal_metadata\";a:3:{s:14:\"inaccurateRows\";i:468;s:12:\"insertedRows\";i:515;s:4:\"size\";i:131072;}s:19:\"wp_wsal_occurrences\";a:3:{s:14:\"inaccurateRows\";i:130;s:12:\"insertedRows\";i:149;s:4:\"size\";i:81920;}s:18:\"wp_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:16;s:4:\"size\";i:114688;}s:28:\"wp_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:65536;}s:19:\"wp_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:32768;}s:21:\"wp_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:49152;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:145:\"/home/opzetweb/opzet.opzet-website.nl/wp-content/backups-dup-lite/tmp/opzetopzet_migration_files_99ab987f9402e8d69893_20240223103811_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";i:1708684850;s:11:\"initialized\";b:1;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:1;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:1;s:21:\"database_script_built\";b:1;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-02-23 10:38:11\";s:7:\"Version\";s:5:\"1.5.8\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.1.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"99ab987f9402e8d69893_20240223103811\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_99ab987f9402e8d69893_20240223103811\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:269;s:13:\"BuildProgress\";r:564;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("22", "opzetopzet_migration_files", "766f68c7175af55b7263_20240903093452", "100", "2024-09-03 09:35:13", "Klasse", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-03 09:34:52\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.1.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:22;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"766f68c7175af55b7263_20240903093452\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_766f68c7175af55b7263_20240903093452\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"opzetopzet_migration_files_766f68c7175af55b7263_20240903093452_scan.json\";s:10:\"TimerStart\";d:1725356113.5856831073760986328125;s:7:\"Runtime\";s:10:\"19.08 sec.\";s:7:\"ExeSize\";s:7:\"94.82KB\";s:7:\"ZipSize\";s:8:\"138.37MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:6:\"Klasse\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"opzetopzet_migration_files_766f68c7175af55b7263_20240903093452_archive.daf\";s:6:\"Format\";s:3:\"DAF\";s:7:\"PackDir\";s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";s:4:\"Size\";i:145086301;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2633;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14529;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:17902;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:51:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-admin\";i:1;s:54:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-includes\";i:2;s:63:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";i:1;s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";i:2;s:53:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content\";i:3;s:61:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/uploads\";i:4;s:61:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/plugins\";i:5;s:64:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/mu-plugins\";i:6;s:60:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:74:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"opzetopzet_migration_files_766f68c7175af55b7263_20240903093452_installer.php.bak\";s:4:\"Size\";i:97099;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:607;s:12:\"numDirsAdded\";i:132;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:126:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_766f68c-03093452/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:106:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp/original_files_766f68c-03093452\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:56:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3478:\"<?php\ndefine( \'WP_CACHE\', true ); // Added by WP Rocket\n\ndefine( \'WP_MEMORY_LIMIT\', \'128M\' );\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * MySQL settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n// ** MySQL settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine(\'DB_NAME\', \'opzetweb_wp_ued3f\');\n/** MySQL database username */\ndefine(\'DB_USER\', \'opzetweb_wp_roenj\');\n/** MySQL database password */\ndefine(\'DB_PASSWORD\', \'6M^6Fk9onA$jJJL9\');\n/** MySQL hostname */\ndefine(\'DB_HOST\', \'localhost:3306\');\n/** Database charset to use in creating database tables. */\ndefine(\'DB_CHARSET\', \'utf8\');\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\', \'SM%wc3hmv1a6zS6|-+~4Qw3HIh|ZO~0j8o;4p%)NQ303DJMC~tRfU1-NJ:+x1u#u\');\ndefine(\'SECURE_AUTH_KEY\', \'t06#FAVV0+(PFD8-f)g(ZF&8:[C]D|oOBVQ99fsCC[+41Ub161ZDM0OjGxY(+1i[\');\ndefine(\'LOGGED_IN_KEY\', \'ghU1*[q88)2*z+m*Z9ukW*@01lZUG6;2ij7_h!N:3OV81v7dk3)I95d(ciX7S[S+\');\ndefine(\'NONCE_KEY\', \'~45+o~:ds~-23)(sa1gl~4Hp62s;24i~bSD~n5X3B*2WyJF+|A]9Gt/V09(PJF3C\');\ndefine(\'AUTH_SALT\', \')823wVe-4JeIfnj!GJeXj*Q~e12I70#58mIh33418389At8h4m:9Y#88wmW8#S6-\');\ndefine(\'SECURE_AUTH_SALT\', \'51)I&%|75Zf37vIlImc#kb#2%9w//t:hP%76]Eb2KZr~-5-Y%W536Y;O4zA0;F!3\');\ndefine(\'LOGGED_IN_SALT\', \'TG82TdM5fD:%)krKPO6u75/K_Z0zaBE;]!l1*jGye4I@LO565p2#48Z!72c5OX1G\');\ndefine(\'NONCE_SALT\', \'9v##9CX1k_Nd!Y8wbg1HP8X]i5:@6ak;;*6DG1K3/Wd7/%v:C%GrO81R(Sq3uE[V\');\n/**\n * Other customizations.\n */\ndefine(\'FS_METHOD\',\'direct\');\ndefine(\'FS_CHMOD_DIR\',0755);\ndefine(\'FS_CHMOD_FILE\',0644);\ndefine(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\n/**#@-*/\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n/* Add any custom values between this line and the \"stop editing\" line. */\ndefine( \'WP_CACHE_KEY_SALT\', \'4a558abfd6e15a6e6c9078b3f0214e05\' );\n/* That\'s all, stop editing! Happy publishing. */\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:23:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:36:\"define( \'WP_MEMORY_LIMIT\', \'128M\' );\";s:5:\"value\";s:6:\"\'128M\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'WP_MEMORY_LIMIT\'\";i:1;s:9:\", \'128M\' \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:39:\"define(\'DB_NAME\', \'opzetweb_wp_ued3f\');\";s:5:\"value\";s:19:\"\'opzetweb_wp_ued3f\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:21:\", \'opzetweb_wp_ued3f\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:39:\"define(\'DB_USER\', \'opzetweb_wp_roenj\');\";s:5:\"value\";s:19:\"\'opzetweb_wp_roenj\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:21:\", \'opzetweb_wp_roenj\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:42:\"define(\'DB_PASSWORD\', \'6M^6Fk9onA$jJJL9\');\";s:5:\"value\";s:18:\"\'6M^6Fk9onA$jJJL9\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:20:\", \'6M^6Fk9onA$jJJL9\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:36:\"define(\'DB_HOST\', \'localhost:3306\');\";s:5:\"value\";s:16:\"\'localhost:3306\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:18:\", \'localhost:3306\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:87:\"define(\'AUTH_KEY\', \'SM%wc3hmv1a6zS6|-+~4Qw3HIh|ZO~0j8o;4p%)NQ303DJMC~tRfU1-NJ:+x1u#u\');\";s:5:\"value\";s:66:\"\'SM%wc3hmv1a6zS6|-+~4Qw3HIh|ZO~0j8o;4p%)NQ303DJMC~tRfU1-NJ:+x1u#u\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:68:\", \'SM%wc3hmv1a6zS6|-+~4Qw3HIh|ZO~0j8o;4p%)NQ303DJMC~tRfU1-NJ:+x1u#u\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:94:\"define(\'SECURE_AUTH_KEY\', \'t06#FAVV0+(PFD8-f)g(ZF&8:[C]D|oOBVQ99fsCC[+41Ub161ZDM0OjGxY(+1i[\');\";s:5:\"value\";s:66:\"\'t06#FAVV0+(PFD8-f)g(ZF&8:[C]D|oOBVQ99fsCC[+41Ub161ZDM0OjGxY(+1i[\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:68:\", \'t06#FAVV0+(PFD8-f)g(ZF&8:[C]D|oOBVQ99fsCC[+41Ub161ZDM0OjGxY(+1i[\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:92:\"define(\'LOGGED_IN_KEY\', \'ghU1*[q88)2*z+m*Z9ukW*@01lZUG6;2ij7_h!N:3OV81v7dk3)I95d(ciX7S[S+\');\";s:5:\"value\";s:66:\"\'ghU1*[q88)2*z+m*Z9ukW*@01lZUG6;2ij7_h!N:3OV81v7dk3)I95d(ciX7S[S+\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:68:\", \'ghU1*[q88)2*z+m*Z9ukW*@01lZUG6;2ij7_h!N:3OV81v7dk3)I95d(ciX7S[S+\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:88:\"define(\'NONCE_KEY\', \'~45+o~:ds~-23)(sa1gl~4Hp62s;24i~bSD~n5X3B*2WyJF+|A]9Gt/V09(PJF3C\');\";s:5:\"value\";s:66:\"\'~45+o~:ds~-23)(sa1gl~4Hp62s;24i~bSD~n5X3B*2WyJF+|A]9Gt/V09(PJF3C\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:68:\", \'~45+o~:ds~-23)(sa1gl~4Hp62s;24i~bSD~n5X3B*2WyJF+|A]9Gt/V09(PJF3C\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:88:\"define(\'AUTH_SALT\', \')823wVe-4JeIfnj!GJeXj*Q~e12I70#58mIh33418389At8h4m:9Y#88wmW8#S6-\');\";s:5:\"value\";s:66:\"\')823wVe-4JeIfnj!GJeXj*Q~e12I70#58mIh33418389At8h4m:9Y#88wmW8#S6-\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:68:\", \')823wVe-4JeIfnj!GJeXj*Q~e12I70#58mIh33418389At8h4m:9Y#88wmW8#S6-\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'51)I&%|75Zf37vIlImc#kb#2%9w//t:hP%76]Eb2KZr~-5-Y%W536Y;O4zA0;F!3\');\";s:5:\"value\";s:66:\"\'51)I&%|75Zf37vIlImc#kb#2%9w//t:hP%76]Eb2KZr~-5-Y%W536Y;O4zA0;F!3\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'51)I&%|75Zf37vIlImc#kb#2%9w//t:hP%76]Eb2KZr~-5-Y%W536Y;O4zA0;F!3\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:93:\"define(\'LOGGED_IN_SALT\', \'TG82TdM5fD:%)krKPO6u75/K_Z0zaBE;]!l1*jGye4I@LO565p2#48Z!72c5OX1G\');\";s:5:\"value\";s:66:\"\'TG82TdM5fD:%)krKPO6u75/K_Z0zaBE;]!l1*jGye4I@LO565p2#48Z!72c5OX1G\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:68:\", \'TG82TdM5fD:%)krKPO6u75/K_Z0zaBE;]!l1*jGye4I@LO565p2#48Z!72c5OX1G\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:89:\"define(\'NONCE_SALT\', \'9v##9CX1k_Nd!Y8wbg1HP8X]i5:@6ak;;*6DG1K3/Wd7/%v:C%GrO81R(Sq3uE[V\');\";s:5:\"value\";s:66:\"\'9v##9CX1k_Nd!Y8wbg1HP8X]i5:@6ak;;*6DG1K3/Wd7/%v:C%GrO81R(Sq3uE[V\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:68:\", \'9v##9CX1k_Nd!Y8wbg1HP8X]i5:@6ak;;*6DG1K3/Wd7/%v:C%GrO81R(Sq3uE[V\'\";i:2;s:2:\");\";}}s:9:\"FS_METHOD\";a:3:{s:3:\"src\";s:29:\"define(\'FS_METHOD\',\'direct\');\";s:5:\"value\";s:8:\"\'direct\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'FS_METHOD\'\";i:1;s:9:\",\'direct\'\";i:2;s:2:\");\";}}s:12:\"FS_CHMOD_DIR\";a:3:{s:3:\"src\";s:28:\"define(\'FS_CHMOD_DIR\',0755);\";s:5:\"value\";s:4:\"0755\";s:5:\"parts\";a:3:{i:0;s:21:\"define(\'FS_CHMOD_DIR\'\";i:1;s:5:\",0755\";i:2;s:2:\");\";}}s:13:\"FS_CHMOD_FILE\";a:3:{s:3:\"src\";s:29:\"define(\'FS_CHMOD_FILE\',0644);\";s:5:\"value\";s:4:\"0644\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'FS_CHMOD_FILE\'\";i:1;s:5:\",0644\";i:2;s:2:\");\";}}s:11:\"WP_TEMP_DIR\";a:3:{s:3:\"src\";s:62:\"define(\'WP_TEMP_DIR\',dirname(__FILE__).\'/wp-content/uploads\');\";s:5:\"value\";s:39:\"dirname(__FILE__).\'/wp-content/uploads\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'WP_TEMP_DIR\'\";i:1;s:40:\",dirname(__FILE__).\'/wp-content/uploads\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:17:\"WP_CACHE_KEY_SALT\";a:3:{s:3:\"src\";s:66:\"define( \'WP_CACHE_KEY_SALT\', \'4a558abfd6e15a6e6c9078b3f0214e05\' );\";s:5:\"value\";s:34:\"\'4a558abfd6e15a6e6c9078b3f0214e05\'\";s:5:\"parts\";a:3:{i:0;s:27:\"define( \'WP_CACHE_KEY_SALT\'\";i:1;s:37:\", \'4a558abfd6e15a6e6c9078b3f0214e05\' \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:12029162;s:4:\"File\";s:75:\"opzetopzet_migration_files_766f68c7175af55b7263_20240903093452_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:7:\"utf8mb4\";i:1;s:6:\"latin1\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:3:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"InnoDB\";i:1;s:6:\"MEMORY\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:17:\"opzetweb_wp_ued3f\";s:15:\"tablesBaseCount\";i:75;s:16:\"tablesFinalCount\";i:75;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:29144;s:16:\"tablesSizeOnDisk\";i:17645568;s:10:\"tablesList\";a:75:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:29;s:12:\"insertedRows\";i:35;s:4:\"size\";i:147456;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:32768;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:83;s:12:\"insertedRows\";i:97;s:4:\"size\";i:49152;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:5;s:4:\"size\";i:163840;}s:23:\"wp_gf_draft_submissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:11:\"wp_gf_entry\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:16:\"wp_gf_entry_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:17:\"wp_gf_entry_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:10:\"wp_gf_form\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:16384;}s:15:\"wp_gf_form_meta\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:81920;}s:20:\"wp_gf_form_revisions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:15:\"wp_gf_form_view\";a:3:{s:14:\"inaccurateRows\";i:12;s:12:\"insertedRows\";i:14;s:4:\"size\";i:49152;}s:19:\"wp_gf_rest_api_keys\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"wp_grp_google_place\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:20:\"wp_grp_google_review\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:32768;}s:19:\"wp_grp_google_stats\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:17:\"wp_hustle_entries\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:22:\"wp_hustle_entries_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:17:\"wp_hustle_modules\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:22:\"wp_hustle_modules_meta\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:131072;}s:18:\"wp_hustle_tracking\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:17:\"wp_kls_consentlog\";a:3:{s:14:\"inaccurateRows\";i:18;s:12:\"insertedRows\";i:18;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:627;s:12:\"insertedRows\";i:707;s:4:\"size\";i:2686976;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:524;s:12:\"insertedRows\";i:664;s:4:\"size\";i:262144;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:191;s:12:\"insertedRows\";i:251;s:4:\"size\";i:1605632;}s:18:\"wp_redirection_404\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:21:\"wp_redirection_groups\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:49152;}s:20:\"wp_redirection_items\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:114688;}s:19:\"wp_redirection_logs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:25;s:12:\"insertedRows\";i:31;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:6;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:6;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:58;s:12:\"insertedRows\";i:59;s:4:\"size\";i:81920;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:65536;}s:17:\"wp_wfblockediplog\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:16384;}s:12:\"wp_wfblocks7\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:11:\"wp_wfconfig\";a:3:{s:14:\"inaccurateRows\";i:273;s:12:\"insertedRows\";i:276;s:4:\"size\";i:524288;}s:13:\"wp_wfcrawlers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_wffilechanges\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:13:\"wp_wffilemods\";a:3:{s:14:\"inaccurateRows\";i:12173;s:12:\"insertedRows\";i:12412;s:4:\"size\";i:4734976;}s:9:\"wp_wfhits\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:65536;}s:11:\"wp_wfhoover\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:11:\"wp_wfissues\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:81920;}s:18:\"wp_wfknownfilelist\";a:3:{s:14:\"inaccurateRows\";i:12271;s:12:\"insertedRows\";i:12412;s:4:\"size\";i:3686400;}s:21:\"wp_wflivetraffichuman\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:9:\"wp_wflocs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:11:\"wp_wflogins\";a:3:{s:14:\"inaccurateRows\";i:198;s:12:\"insertedRows\";i:198;s:4:\"size\";i:98304;}s:19:\"wp_wfls_2fa_secrets\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:19:\"wp_wfls_role_counts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:0;}s:16:\"wp_wfls_settings\";a:3:{s:14:\"inaccurateRows\";i:27;s:12:\"insertedRows\";i:27;s:4:\"size\";i:16384;}s:18:\"wp_wfnotifications\";a:3:{s:14:\"inaccurateRows\";i:95;s:12:\"insertedRows\";i:95;s:4:\"size\";i:49152;}s:18:\"wp_wfpendingissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:17:\"wp_wfreversecache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:19:\"wp_wfsecurityevents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:14:\"wp_wfsnipcache\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:65536;}s:11:\"wp_wfstatus\";a:3:{s:14:\"inaccurateRows\";i:1526;s:12:\"insertedRows\";i:1526;s:4:\"size\";i:327680;}s:17:\"wp_wftrafficrates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_wfwaffailures\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:26:\"wp_wpmailsmtp_debug_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:24:\"wp_wpmailsmtp_tasks_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:16384;}s:21:\"wp_wpr_above_the_fold\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:19:\"wp_wpr_rocket_cache\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:11;s:4:\"size\";i:65536;}s:21:\"wp_wpr_rucss_used_css\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:114688;}s:16:\"wp_wsal_metadata\";a:3:{s:14:\"inaccurateRows\";i:636;s:12:\"insertedRows\";i:636;s:4:\"size\";i:180224;}s:19:\"wp_wsal_occurrences\";a:3:{s:14:\"inaccurateRows\";i:183;s:12:\"insertedRows\";i:183;s:4:\"size\";i:114688;}s:18:\"wp_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:25;s:4:\"size\";i:114688;}s:28:\"wp_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:15;s:12:\"insertedRows\";i:16;s:4:\"size\";i:65536;}s:19:\"wp_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:32768;}s:21:\"wp_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:46;s:12:\"insertedRows\";i:70;s:4:\"size\";i:49152;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.39\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:150:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp/opzetopzet_migration_files_766f68c7175af55b7263_20240903093452_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";i:1725356132;s:11:\"initialized\";b:1;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:1;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:1;s:21:\"database_script_built\";b:1;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-03 09:34:52\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.1.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"opzetopzet_migration_files\";s:4:\"Hash\";s:35:\"766f68c7175af55b7263_20240903093452\";s:8:\"NameHash\";s:62:\"opzetopzet_migration_files_766f68c7175af55b7263_20240903093452\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:276;s:13:\"BuildProgress\";r:623;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("23", "opzetopzet_migration_files2", "f8f9c1cacc7704fc8669_20240903112704", "21", "2024-09-03 11:27:10", "Klasse", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-03 11:27:04\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.1.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:23;s:4:\"Name\";s:27:\"opzetopzet_migration_files2\";s:4:\"Hash\";s:35:\"f8f9c1cacc7704fc8669_20240903112704\";s:8:\"NameHash\";s:63:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:73:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.8\";s:6:\"WPUser\";s:6:\"Klasse\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:75:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2634;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14532;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-03 11:27:04\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.1.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:27:\"opzetopzet_migration_files2\";s:4:\"Hash\";s:35:\"f8f9c1cacc7704fc8669_20240903112704\";s:8:\"NameHash\";s:63:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:81:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:56:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:76:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:151:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp/opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:51:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-admin\";i:1;s:54:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-includes\";i:2;s:63:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";i:1;s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";i:2;s:53:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content\";i:3;s:61:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/uploads\";i:4;s:61:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/plugins\";i:5;s:64:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/mu-plugins\";i:6;s:60:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:74:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_gf_form */
INSERT INTO `wp_gf_form` VALUES("1", "Contact", "2024-01-11 14:44:47", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("2", "Lead formulier", "2024-01-11 14:49:13", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("3", "Test formulier", "2024-01-11 14:52:15", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("4", "Plans", "2024-09-02 09:38:56", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("5", "abonnementen", "2024-09-02 09:43:02", NULL, "1", "0");

/* INSERT TABLE DATA: wp_gf_form_meta */
INSERT INTO `wp_gf_form_meta` VALUES("1", "{\"fields\":[{\"type\":\"text\",\"id\":1,\"formId\":1,\"label\":\"Voor- en achternaam\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"1701be79\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"email\",\"id\":3,\"formId\":1,\"label\":\"E-mailadres\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"d67ad6b1\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"phone\",\"id\":4,\"formId\":1,\"label\":\"Telefoonnummer\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"international\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"f1763e50\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"type\":\"textarea\",\"id\":5,\"formId\":1,\"label\":\"Bericht\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"form_id\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"651a5335\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"}],\"button\":{\"type\":\"text\",\"text\":\"Verzenden\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12,\"id\":\"submit\"},\"title\":\"Contact\",\"description\":\"\",\"version\":\"2.8.0\",\"id\":1,\"markupVersion\":2,\"nextFieldId\":6,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"notifications\":{\"659ffedfe8c03\":{\"id\":\"659ffedfe8c03\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"Beheerdersmelding\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"Nieuwe inzending van {form_title}\",\"message\":\"{all_fields}\"}},\"confirmations\":{\"659ffedfe9751\":{\"id\":\"659ffedfe9751\",\"name\":\"Standaardbevestiging\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Bedankt voor je bericht! We zullen binnenkort contact met je opnemen.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}},\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(Vereist)\",\"cssClass\":\"\",\"saveButtonText\":\"Opslaan & doorgaan\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"enableHoneypot\":true,\"honeypotAction\":\"abort\",\"validationSummary\":false,\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Opslaan & doorgaan\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}", NULL, "{\"659ffedfe9751\":{\"id\":\"659ffedfe9751\",\"name\":\"Standaardbevestiging\",\"isDefault\":true,\"type\":\"page\",\"message\":\"Bedankt voor je bericht! We zullen binnenkort contact met je opnemen.\",\"url\":\"\",\"pageId\":\"13\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"13\",\"conditionalLogic\":[]}}", "{\"659ffedfe8c03\":{\"id\":\"659ffedfe8c03\",\"isActive\":true,\"to\":\"{klant:emailadres}\",\"name\":\"Email naar de klant\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"Nieuwe LEAD! | {klant:bedrijfsnaam}\",\"message\":\"Tromgeroffel...\\r\\n\\r\\nEr is een nieuwe lead binnengekomen! Hieronder de gegevens.\\r\\n\\r\\n{all_fields}\\r\\n\\r\\nOnderwerp: {form_title}\\r\\n\\r\\nMet vriendelijke groet,\\r\\n\\r\\nTeam {admin:name}\",\"service\":\"wordpress\",\"toEmail\":\"{klant:emailadres}\",\"toField\":\"\",\"routing\":null,\"fromName\":\"\",\"from\":\"{klant:emailadres}\",\"replyTo\":\"{E-mailadres:3}\",\"cc\":\"{klant:cc_emailadres}\",\"bcc\":\"{klant:bcc_emailadres}\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"enableAttachments\":false},\"65a00068e6589\":{\"id\":\"65a00068e6589\",\"name\":\"Email bezoeker\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"toType\":\"field\",\"toEmail\":\"{E-mailadres:3}\",\"toField\":\"3\",\"routing\":null,\"fromName\":\"\",\"from\":\"{klant:emailadres}\",\"replyTo\":\"\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"Bedankt voor je bericht - {klant:bedrijfsnaam}\",\"message\":\"Bedankt voor het invullen van het formulier. Wij nemen zo snel mogelijk contact met jou op.\\r\\nWil je gelijk antwoord op jou vraag? Gebruik dan de onderstaande contactgegevens\\r\\n\\r\\n{klant:telefoonnummer}\\r\\n{klant:emailadres}\\r\\n{klant:adres}\\r\\n\\r\\nMet vriendelijke groet,\\r\\n{klant:bedrijfsnaam}\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"to\":\"3\",\"enableAttachments\":false,\"isActive\":false}}");
INSERT INTO `wp_gf_form_meta` VALUES("2", "{\"fields\":[{\"type\":\"text\",\"id\":1,\"formId\":2,\"label\":\"Voor- en achternaam\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"1701be79\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"email\",\"id\":3,\"formId\":2,\"label\":\"E-mailadres\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"d67ad6b1\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"phone\",\"id\":4,\"formId\":2,\"label\":\"Telefoonnummer\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"international\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"f1763e50\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"}],\"button\":{\"type\":\"text\",\"text\":\"Verzenden\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12,\"id\":\"submit\"},\"title\":\"Lead formulier\",\"description\":\"\",\"version\":\"2.8.0\",\"id\":2,\"markupVersion\":2,\"nextFieldId\":6,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(Vereist)\",\"cssClass\":\"\",\"saveButtonText\":\"Opslaan & doorgaan\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"enableHoneypot\":true,\"honeypotAction\":\"abort\",\"validationSummary\":false,\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Opslaan & doorgaan\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}", NULL, "{\"659ffedfe9751\":{\"id\":\"659ffedfe9751\",\"name\":\"Standaardbevestiging\",\"isDefault\":true,\"type\":\"page\",\"message\":\"Bedankt voor je bericht! We zullen binnenkort contact met je opnemen.\",\"url\":\"\",\"pageId\":\"13\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"13\",\"conditionalLogic\":[]}}", "{\"659ffedfe8c03\":{\"id\":\"659ffedfe8c03\",\"isActive\":true,\"to\":\"{klant:emailadres}\",\"name\":\"Email naar de klant\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"Nieuwe LEAD! | {klant:bedrijfsnaam}\",\"message\":\"Tromgeroffel...\\r\\n\\r\\nEr is een nieuwe lead binnengekomen! Hieronder de gegevens.\\r\\n\\r\\n{all_fields}\\r\\n\\r\\nOnderwerp: {form_title}\\r\\n\\r\\nMet vriendelijke groet,\\r\\n\\r\\nTeam {admin:name}\",\"service\":\"wordpress\",\"toEmail\":\"{klant:emailadres}\",\"toField\":\"\",\"routing\":null,\"fromName\":\"\",\"from\":\"{klant:emailadres}\",\"replyTo\":\"{E-mailadres:3}\",\"cc\":\"{klant:cc_emailadres}\",\"bcc\":\"{klant:bcc_emailadres}\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"enableAttachments\":false},\"65a00086f2a83\":{\"id\":\"65a00086f2a83\",\"name\":\"Email bezoeker\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"toType\":\"field\",\"toEmail\":\"{E-mailadres:3}\",\"toField\":\"3\",\"routing\":null,\"fromName\":\"\",\"from\":\"{klant:emailadres}\",\"replyTo\":\"\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"Bedankt voor je bericht - {klant:bedrijfsnaam}\",\"message\":\"Bedankt voor het invullen van het formulier. Wij nemen zo snel mogelijk contact met jou op.\\r\\nWil je gelijk antwoord op jou vraag? Gebruik dan de onderstaande contactgegevens\\r\\n\\r\\n{klant:telefoonnummer}\\r\\n{klant:emailadres}\\r\\n{klant:adres}\\r\\n\\r\\nMet vriendelijke groet,\\r\\n{klant:bedrijfsnaam}\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"to\":\"3\",\"enableAttachments\":false,\"isActive\":false}}");
INSERT INTO `wp_gf_form_meta` VALUES("3", "{\"fields\":[{\"type\":\"text\",\"id\":1,\"formId\":3,\"label\":\"Voor- en achternaam\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"1701be79\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"email\",\"id\":3,\"formId\":3,\"label\":\"E-mailadres\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"d67ad6b1\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"phone\",\"id\":4,\"formId\":3,\"label\":\"Telefoonnummer\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"international\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"f1763e50\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"}],\"button\":{\"type\":\"text\",\"text\":\"Verzenden\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12,\"id\":\"submit\"},\"title\":\"Test formulier\",\"description\":\"\",\"version\":\"2.8.0\",\"id\":3,\"markupVersion\":2,\"nextFieldId\":5,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(Vereist)\",\"cssClass\":\"\",\"saveButtonText\":\"Opslaan & doorgaan\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"enableHoneypot\":true,\"honeypotAction\":\"abort\",\"validationSummary\":false,\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Opslaan & doorgaan\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"notifications\":{\"659ffedfe8c03\":{\"id\":\"659ffedfe8c03\",\"isActive\":true,\"to\":\"{klant:emailadres}\",\"name\":\"Email naar de klant\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"Nieuwe LEAD! | {klant:bedrijfsnaam}\",\"message\":\"Tromgeroffel...\\r\\n\\r\\nEr is een nieuwe lead binnengekomen! Hieronder de gegevens.\\r\\n\\r\\n{all_fields}\\r\\n\\r\\nOnderwerp: {form_title}\\r\\n\\r\\nMet vriendelijke groet,\\r\\n\\r\\nTeam {admin:name}\",\"service\":\"wordpress\",\"toEmail\":\"{klant:emailadres}\",\"toField\":\"\",\"routing\":null,\"fromName\":\"\",\"from\":\"{klant:emailadres}\",\"replyTo\":\"{E-mailadres:3}\",\"cc\":\"{klant:cc_emailadres}\",\"bcc\":\"{klant:bcc_emailadres}\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"enableAttachments\":false},\"65a00086f2a83\":{\"id\":\"65a00086f2a83\",\"name\":\"Email bezoeker\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"toType\":\"email\",\"toEmail\":\"{E-mailadres:3}\",\"toField\":\"\",\"routing\":null,\"fromName\":\"\",\"from\":\"{klant:emailadres}\",\"replyTo\":\"\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"Bedankt voor je bericht - {klant:bedrijfsnaam}\",\"message\":\"Bedankt voor het invullen van het formulier. Wij nemen zo snel mogelijk contact met jou op.\\r\\nWil je gelijk antwoord op jou vraag? Gebruik dan de onderstaande contactgegevens\\r\\n\\r\\n{klant:telefoonnummer}\\r\\n{klant:emailadres}\\r\\n{klant:adres}\\r\\n\\r\\nMet vriendelijke groet,\\r\\n{klant:bedrijfsnaam}\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"to\":\"{E-mailadres:3}\",\"enableAttachments\":false,\"isActive\":false}},\"confirmations\":{\"659ffedfe9751\":{\"id\":\"659ffedfe9751\",\"name\":\"Standaardbevestiging\",\"isDefault\":true,\"type\":\"page\",\"message\":\"Bedankt voor je bericht! We zullen binnenkort contact met je opnemen.\",\"url\":\"\",\"pageId\":\"13\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"13\",\"conditionalLogic\":[]}}}", NULL, "{\"659ffedfe9751\":{\"id\":\"659ffedfe9751\",\"name\":\"Standaardbevestiging\",\"isDefault\":true,\"type\":\"page\",\"message\":\"Bedankt voor je bericht! We zullen binnenkort contact met je opnemen.\",\"url\":\"\",\"pageId\":\"13\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"13\",\"conditionalLogic\":[]}}", "{\"659ffedfe8c03\":{\"id\":\"659ffedfe8c03\",\"isActive\":true,\"to\":\"server@klassebv.nl\",\"name\":\"Email naar de klant tester\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"Nieuwe LEAD! | {klant:bedrijfsnaam}\",\"message\":\"{all_fields}\\r\\n\\r\\nOnderwerp: {form_title}\",\"service\":\"wordpress\",\"toEmail\":\"server@klassebv.nl\",\"toField\":\"\",\"routing\":null,\"fromName\":\"\",\"from\":\"{klant:emailadres}\",\"replyTo\":\"{E-mailadres:3}\",\"cc\":\"\",\"bcc\":\"\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"enableAttachments\":false}}");
INSERT INTO `wp_gf_form_meta` VALUES("4", "{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"postAuthor\":\"1\",\"postCategory\":\"1\",\"postStatus\":\"draft\",\"title\":\"Plans\",\"description\":\"Form with different plans\",\"maxEntriesAllowed\":\"0\",\"button\":{\"type\":\"text\",\"text\":\"Versturen\",\"imageUrl\":\"\",\"conditionalLogic\":null,\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"fields\":[{\"type\":\"section\",\"id\":7,\"size\":\"medium\",\"displayOnly\":\"1\",\"description\":\"\",\"label\":\"Over jou\",\"inputType\":\"section\",\"choices\":\"\",\"inputs\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"productField\":\"\",\"isRequired\":false,\"labelPlacement\":\"\",\"defaultValue\":\"\",\"fields\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMaskIsCustom\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"autocompleteAttribute\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"layoutGroupId\":\"c66e1637\",\"adminLabel\":\"\",\"maxLength\":\"\",\"errorMessage\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":false,\"pageNumber\":1,\"formId\":4},{\"type\":\"name\",\"id\":1,\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"We need to know your name. What if we wanted to send you a birthday cake?\",\"label\":\"Je naam\",\"inputs\":[{\"id\":\"1.2\",\"label\":\"Voorvoegsel\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-prefix\",\"choices\":[{\"text\":\"Dhr.\",\"value\":\"Mr.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Mw.\",\"value\":\"Mrs.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Miss\",\"value\":\"Miss\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Ms.\",\"value\":\"Ms.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Dr.\",\"value\":\"Dr.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Prof.\",\"value\":\"Prof.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Rev.\",\"value\":\"Rev.\",\"isSelected\":false,\"price\":\"\"}],\"isHidden\":true,\"inputType\":\"radio\"},{\"id\":\"1.3\",\"label\":\"Voornaam\",\"name\":\"\",\"placeholder\":\"\",\"autocompleteAttribute\":\"given-name\"},{\"id\":\"1.4\",\"label\":\"Tussenvoegsel\",\"name\":\"\",\"autocompleteAttribute\":\"additional-name\",\"isHidden\":true},{\"id\":\"1.6\",\"label\":\"Achternaam\",\"name\":\"\",\"placeholder\":\"\",\"autocompleteAttribute\":\"family-name\"},{\"id\":\"1.8\",\"label\":\"Achtervoegsel\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-suffix\",\"isHidden\":true}],\"inputType\":\"name\",\"displayOnly\":\"\",\"nameFormat\":\"advanced\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"defaultValue\":\"\",\"description\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"productField\":\"\",\"fields\":\"\",\"layoutGroupId\":\"c1236779\",\"inputMaskIsCustom\":false,\"checkboxLabel\":\"\",\"adminLabel\":\"\",\"maxLength\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":true,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"formId\":4},{\"type\":\"address\",\"id\":4,\"size\":\"medium\",\"addressType\":\"us\",\"label\":\"Je adres\",\"defaultCountry\":\"United States\",\"defaultState\":\"Virginia\",\"inputs\":[{\"id\":\"4.1\",\"label\":\"Straat + huisnummer\",\"placeholder\":\"\",\"autocompleteAttribute\":\"address-line1\"},{\"id\":\"4.2\",\"label\":\"Adresregel 2\",\"placeholder\":\"\",\"autocompleteAttribute\":\"address-line2\"},{\"id\":\"4.3\",\"label\":\"Stad\",\"placeholder\":\"\",\"autocompleteAttribute\":\"address-level2\"},{\"id\":\"4.4\",\"label\":\"Staat \\/ provincie\",\"isHidden\":true,\"placeholder\":\"\",\"autocompleteAttribute\":\"address-level1\"},{\"id\":\"4.5\",\"label\":\"Postcode\",\"placeholder\":\"\",\"autocompleteAttribute\":\"postal-code\"},{\"id\":\"4.6\",\"label\":\"Land\",\"placeholder\":\"\",\"autocompleteAttribute\":\"country-name\"}],\"inputType\":\"address\",\"displayOnly\":\"\",\"isRequired\":false,\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"defaultProvince\":\"\",\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"productField\":\"\",\"description\":\"\",\"hideState\":\"\",\"hideAddress2\":\"\",\"enableCopyValuesOption\":\"\",\"copyValuesOptionDefault\":\"\",\"copyValuesOptionLabel\":\"\",\"fields\":\"\",\"layoutGroupId\":\"aaa2ed03\",\"adminLabel\":\"\",\"inputMaskIsCustom\":\"\",\"maxLength\":\"\",\"errorMessage\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":true,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"formId\":4},{\"type\":\"section\",\"id\":10,\"size\":\"medium\",\"displayOnly\":\"1\",\"description\":\"We gaan graag met je in gesprek. Hoe kunnen we in contact komen?\",\"label\":\"Hoe kunnen wij je bereiken?\",\"inputType\":\"section\",\"choices\":\"\",\"inputs\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"productField\":\"\",\"isRequired\":false,\"labelPlacement\":\"\",\"defaultValue\":\"\",\"fields\":\"\",\"adminLabel\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"errorMessage\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"layoutGroupId\":\"2d3b3f3c\",\"pageNumber\":1,\"formId\":4},{\"type\":\"select\",\"id\":11,\"size\":\"medium\",\"enableChoiceValue\":\"1\",\"label\":\"Gewenste manier van contact\",\"choices\":[{\"text\":\"E-mailadres\",\"value\":\"Email\"},{\"text\":\"Telefoon\",\"value\":\"Phone\"}],\"inputType\":\"select\",\"displayOnly\":\"\",\"isRequired\":false,\"inputs\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"productField\":\"\",\"labelPlacement\":\"\",\"description\":\"\",\"descriptionPlacement\":\"\",\"defaultValue\":\"\",\"enablePrice\":\"\",\"fields\":\"\",\"layoutGroupId\":\"34920583\",\"adminLabel\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":\"\",\"maxLength\":\"\",\"errorMessage\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"formId\":4},{\"type\":\"email\",\"id\":2,\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"Oops. Please supply a valid email address\",\"label\":\"Je e-mailadres\",\"emailConfirmEnabled\":\"1\",\"inputType\":\"email\",\"displayOnly\":\"\",\"inputs\":[{\"id\":\"2\",\"label\":\"E-mailadres invoeren\",\"name\":\"\",\"placeholder\":\"\",\"customLabel\":\"Email Address\",\"autocompleteAttribute\":\"email\"},{\"id\":\"2.2\",\"label\":\"E-mailadres bevestigen\",\"name\":\"\",\"placeholder\":\"\",\"customLabel\":\"Confirm Email Address\",\"autocompleteAttribute\":\"email\"}],\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"visibility\":\"visible\",\"productField\":\"\",\"description\":\"\",\"fields\":\"\",\"layoutGroupId\":\"92a6673b\",\"adminLabel\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":true,\"autocompleteAttribute\":\"\",\"checkboxLabel\":\"\",\"pageNumber\":1,\"formId\":4},{\"type\":\"phone\",\"id\":5,\"isRequired\":true,\"size\":\"medium\",\"phoneFormat\":\"standard\",\"errorMessage\":\"Please enter your phone number.\",\"label\":\"Je telefoon\",\"conditionalLogic\":{\"actionType\":\"show\",\"logicType\":\"all\",\"rules\":[{\"fieldId\":\"11\",\"operator\":\"is\",\"value\":\"Phone\"}]},\"inputType\":\"phone\",\"displayOnly\":\"\",\"inputs\":\"\",\"choices\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"visibility\":\"visible\",\"productField\":\"\",\"description\":\"\",\"defaultValue\":\"\",\"fields\":\"\",\"layoutGroupId\":\"a5b7fe20\",\"adminLabel\":\"\",\"inputMaskIsCustom\":\"\",\"maxLength\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":true,\"autocompleteAttribute\":\"tel\",\"pageNumber\":1,\"formId\":4},{\"type\":\"select\",\"id\":12,\"isRequired\":true,\"size\":\"medium\",\"enableChoiceValue\":\"1\",\"label\":\"Beste tijd om je te bellen\",\"choices\":[{\"isSelected\":true,\"text\":\"Selecteer een tijd\",\"value\":\"\"},{\"text\":\"12:00 uur\",\"value\":\"12:00 am\"},{\"text\":\"12:30 uur\",\"value\":\"12:30 am\"},{\"text\":\"1:00 uur\",\"value\":\"1:00 am\"},{\"text\":\"1:30 uur\",\"value\":\"1:30 am\"},{\"text\":\"2:00 uur\",\"value\":\"2:00 am\"},{\"text\":\"2:30 uur\",\"value\":\"2:30 am\"},{\"text\":\"3:00 uur\",\"value\":\"3:00 am\"},{\"text\":\"3:30 uur\",\"value\":\"3:30 am\"},{\"text\":\"4:00 uur\",\"value\":\"4:00 am\"},{\"text\":\"4:30 uur\",\"value\":\"4:30 am\"},{\"text\":\"5:00 uur\",\"value\":\"5:00 am\"},{\"text\":\"5:30 uur\",\"value\":\"5:30 am\"},{\"text\":\"6:00 uur\",\"value\":\"6:00 am\"},{\"text\":\"6:30 uur\",\"value\":\"6:30 am\"},{\"text\":\"7:00 uur\",\"value\":\"7:00 am\"},{\"text\":\"7:30 uur\",\"value\":\"7:30 am\"},{\"text\":\"8:00 uur\",\"value\":\"8:00 am\"},{\"text\":\"8:30 uur\",\"value\":\"8:30 am\"},{\"text\":\"9:00 uur\",\"value\":\"9:00 am\"},{\"text\":\"9:30 uur\",\"value\":\"9:30 am\"},{\"text\":\"10:00 uur\",\"value\":\"10:00 am\"},{\"text\":\"10:30 uur\",\"value\":\"10:30 am\"},{\"text\":\"11:00 uur\",\"value\":\"11:00 am\"},{\"text\":\"11:30 uur\",\"value\":\"11:30 am\"},{\"text\":\"12:00 uur\",\"value\":\"12:00 pm\"},{\"text\":\"12:30 uur\",\"value\":\"12:30 pm\"},{\"text\":\"13:00 uur\",\"value\":\"1:00 pm\"},{\"text\":\"13:30 uur\",\"value\":\"1:30 pm\"},{\"text\":\"14 :00 uur\",\"value\":\"2:00 pm\"},{\"text\":\"14 :30 uur\",\"value\":\"2:30 pm\"},{\"text\":\"15 :00 uur\",\"value\":\"3:00 pm\"},{\"text\":\"15 .30 uur\",\"value\":\"3:30 pm\"},{\"text\":\"16 :00 uur\",\"value\":\"4:00 pm\"},{\"text\":\"16 .30 uur\",\"value\":\"4:30 pm\"},{\"text\":\"17 :00 uur\",\"value\":\"5:00 pm\"},{\"text\":\"17 .30 uur\",\"value\":\"5:30 pm\"},{\"text\":\"18 .00 uur\",\"value\":\"6:00 pm\"},{\"text\":\"18 .30 uur\",\"value\":\"6:30 pm\"},{\"text\":\"19 :00 uur\",\"value\":\"7:00 pm\"},{\"text\":\"19 .30 uur\",\"value\":\"7:30 pm\"},{\"text\":\"20:00 uur\",\"value\":\"8:00 pm\"},{\"text\":\"20:30 uur\",\"value\":\"8:30 pm\"},{\"text\":\"21:00 uur\",\"value\":\"9:00 pm\"},{\"text\":\"21:30 uur\",\"value\":\"9:30 pm\"},{\"text\":\"22:00 uur\",\"value\":\"10:00 pm\"},{\"text\":\"22.30 uur\",\"value\":\"10:30 pm\"},{\"text\":\"23:00 uur\",\"value\":\"11:00 pm\"},{\"text\":\"23.30 uur\",\"value\":\"11:30 pm\"}],\"conditionalLogic\":{\"actionType\":\"show\",\"logicType\":\"all\",\"rules\":[{\"fieldId\":\"11\",\"operator\":\"is\",\"value\":\"Phone\"}]},\"inputType\":\"select\",\"displayOnly\":\"\",\"inputs\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"visibility\":\"visible\",\"productField\":\"\",\"description\":\"\",\"defaultValue\":\"\",\"enablePrice\":\"\",\"fields\":\"\",\"layoutGroupId\":\"5d733fd7\",\"adminLabel\":\"\",\"inputMaskIsCustom\":\"\",\"maxLength\":\"\",\"errorMessage\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"formId\":4},{\"type\":\"section\",\"id\":8,\"size\":\"medium\",\"displayOnly\":\"1\",\"description\":\"Laat ons weten wat je bezighoudt. Heb je een vraag voor ons? Stel hem gerust.\",\"label\":\"Waar denk je aan?\",\"inputType\":\"section\",\"choices\":\"\",\"inputs\":\"\",\"conditionalLogic\":\"\",\"visibility\":\"visible\",\"productField\":\"\",\"isRequired\":false,\"labelPlacement\":\"\",\"defaultValue\":\"\",\"fields\":\"\",\"layoutGroupId\":\"73cb7ce0\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMaskIsCustom\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"autocompleteAttribute\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"adminLabel\":\"\",\"maxLength\":\"\",\"errorMessage\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":false,\"pageNumber\":1,\"formId\":4},{\"type\":\"textarea\",\"id\":3,\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"Please enter your message.\",\"label\":\"Je reacties\\/vragen\",\"inputType\":\"textarea\",\"displayOnly\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"visibility\":\"visible\",\"productField\":\"\",\"description\":\"\",\"defaultValue\":\"\",\"form_id\":\"\",\"fields\":\"\",\"inputMaskIsCustom\":false,\"layoutGroupId\":\"20d48602\",\"adminLabel\":\"\",\"maxLength\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"formId\":4},{\"type\":\"page\",\"id\":16,\"formId\":4,\"label\":\"\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"nextButton\":{\"type\":\"text\",\"text\":\"Volgende\",\"imageUrl\":\"\"},\"previousButton\":{\"type\":\"text\",\"text\":\"Vorige\",\"imageUrl\":\"\"},\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":\"\",\"maxLength\":\"\",\"inputType\":\"page\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"31a2b441\",\"pageNumber\":2,\"fields\":\"\"},{\"type\":\"select\",\"id\":27,\"formId\":4,\"label\":\"Kies een abonnement\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Basis plan\",\"value\":\"Basis plan\",\"isSelected\":true,\"price\":\"\"},{\"text\":\"Geadvanceerd plan\",\"value\":\"Geadvanceerd plan\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Premium plan\",\"value\":\"Premium plan\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"Zie informatie op site.\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"e1f1a192\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"enableChoiceValue\":false,\"checkboxLabel\":\"\",\"pageNumber\":2,\"fields\":\"\"}],\"descriptionPlacement\":\"below\",\"gpollDisplayResults\":\"1\",\"gpollShowResultsLink\":\"1\",\"gpollShowPercentages\":\"1\",\"gpollShowCounts\":\"1\",\"gpollStyle\":\"green\",\"gpollCookie\":\"1 month\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":{\"type\":\"text\",\"text\":\"Vorige\",\"imageUrl\":\"\"},\"pagination\":{\"type\":\"percentage\",\"pages\":[\"\"],\"style\":\"blue\",\"backgroundColor\":null,\"color\":null,\"display_progressbar_on_confirmation\":false,\"progressbar_completion_text\":null},\"firstPageCssClass\":\"\",\"is_active\":\"1\",\"date_created\":\"2016-07-12 20:22:20\",\"is_trash\":\"0\",\"nextFieldId\":28,\"feeds\":{\"gravityformsadvancedpostcreation\":[]},\"version\":\"2.8.17\",\"subLabelPlacement\":\"above\",\"validationSummary\":\"1\",\"requiredIndicator\":\"text\",\"customRequiredIndicator\":\"\",\"cssClass\":\"\",\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Opslaan en later doorgaan\"}},\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"enableHoneypot\":false,\"enableAnimation\":false,\"markupVersion\":2,\"template_id\":\"advanced_contact\",\"id\":4,\"autoResponder\":{\"from\":\"{admin_email}\",\"subject\":\"We hebben je aanvraag ontvangen\",\"message\":\"<p>Hallo, {Name (First):1.3},<\\/p><p>Bedankt dat je contact hebt opgenomen. We hebben je aanvraag ontvangen en zullen binnen een werkdag contact met je opnemen.<\\/p>\",\"toField\":\"2\"}}", NULL, "{\"51794abf1ee7a\":{\"type\":\"message\",\"id\":\"51794abf1ee7a\",\"isDefault\":true,\"url\":\"\",\"queryString\":\"\",\"name\":\"Default Confirmation\",\"message\":\"Dank je voor het contact met ons! We zullen binnenkort contact met je opnemen.\",\"disableAutoformat\":false,\"pageId\":0,\"conditionalLogic\":[]}}", "{\"51794abf1f0d1\":{\"id\":\"51794abf1f0d1\",\"from\":\"{admin_email}\",\"subject\":\"We hebben je aanvraag ontvangen\",\"message\":\"<p>Hallo, {Name (First):1.3},<\\/p><p>Bedankt dat je contact hebt opgenomen. We hebben je aanvraag ontvangen en zullen binnen een werkdag contact met je opnemen.<\\/p>\",\"toType\":\"field\",\"toField\":\"2\",\"to\":\"2\",\"event\":\"form_submission\",\"name\":\"User Notification\",\"type\":\"user\"},\"51794abf1f0d2\":{\"id\":\"51794abf1f0d2\",\"from\":\"{admin_email}\",\"subject\":\"Nieuwe inzending van {form_title}\",\"message\":\"{all_fields}\",\"toType\":\"email\",\"to\":\"{admin_email}\",\"event\":\"form_submission\",\"name\":\"Admin Notification\"}}");
INSERT INTO `wp_gf_form_meta` VALUES("5", "{\"fields\":[],\"button\":{\"type\":\"text\",\"text\":\"\",\"imageUrl\":\"\"},\"title\":\"abonnementen\",\"description\":\"een lijst van abonnementen\",\"version\":\"2.8.17\",\"id\":5,\"markupVersion\":2}", NULL, "{\"66d588a6b9119\":{\"id\":\"66d588a6b9119\",\"name\":\"Standaardbevestiging\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Bedankt voor je bericht! We zullen binnenkort contact met je opnemen.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"66d588a6b8379\":{\"id\":\"66d588a6b8379\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"Beheerdersmelding\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"Nieuwe inzending van {form_title}\",\"message\":\"{all_fields}\"}}");

/* INSERT TABLE DATA: wp_gf_form_view */
INSERT INTO `wp_gf_form_view` VALUES("1", "1", "2024-08-26 15:06:40", "", "66");
INSERT INTO `wp_gf_form_view` VALUES("2", "1", "2024-08-27 16:36:42", "", "156");
INSERT INTO `wp_gf_form_view` VALUES("3", "2", "2024-08-28 10:51:20", "", "63");
INSERT INTO `wp_gf_form_view` VALUES("4", "1", "2024-08-29 02:19:23", "", "116");
INSERT INTO `wp_gf_form_view` VALUES("5", "2", "2024-08-29 11:38:51", "", "66");
INSERT INTO `wp_gf_form_view` VALUES("6", "1", "2024-08-30 02:24:51", "", "64");
INSERT INTO `wp_gf_form_view` VALUES("7", "2", "2024-08-30 11:44:56", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("8", "1", "2024-08-31 02:35:12", "", "14");
INSERT INTO `wp_gf_form_view` VALUES("9", "1", "2024-09-01 02:38:41", "", "18");
INSERT INTO `wp_gf_form_view` VALUES("10", "2", "2024-09-01 02:38:41", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("11", "1", "2024-09-02 02:46:42", "", "58");
INSERT INTO `wp_gf_form_view` VALUES("12", "2", "2024-09-02 06:50:43", "", "48");
INSERT INTO `wp_gf_form_view` VALUES("13", "1", "2024-09-03 02:54:46", "", "158");
INSERT INTO `wp_gf_form_view` VALUES("14", "2", "2024-09-03 06:50:56", "", "50");

/* INSERT TABLE DATA: wp_grp_google_place */
INSERT INTO `wp_grp_google_place` VALUES("1", "ChIJdbYM9cZNxEcR7-2do_w5AmM", "Totstraksonline", "https://lh3.googleusercontent.com/places/ANXAkqHZIbD1y2K3DKvxxVdx4LZqFJ_a5XmSFckH17pV1tQ1PhjsnlRtymVeQE3_urSz3vsiJz8nNd9qxoYWrwnbW4xGOen83jtX8i8=s1600-w300-h300", "https://maps.gstatic.com/mapfiles/place_api/icons/v1/png_71/generic_business-71.png", "Kerkenbos 1039, 6546 BB Nijmegen, Netherlands", "5", "https://maps.google.com/?cid=7134328516947865071", "https://totstraksonline.nl/", "38", "1725350468168");

/* INSERT TABLE DATA: wp_grp_google_review */
INSERT INTO `wp_grp_google_review` VALUES("1", "1", "5", "I recently had the pleasure of working with Totstraksonline to create a website for my business, and I couldn\'t be more satisfied with the results! From the very start, their team demonstrated exceptional professionalism, creativity, and attention to detail. They took the time to understand my vision and translated it into a stunning, user-friendly website that perfectly represents my brand.\n\nThe entire process was smooth and efficient. They provided regular updates, sought feedback, and made sure every aspect of the website met my expectations. Their expertise in design and functionality is truly impressive. The final product not only looks fantastic but also performs flawlessly across all devices.\n\nWhat sets Totstraksonline apart is their commitment to customer satisfaction. They went above and beyond to ensure I was happy with every detail. Their dedication, combined with their technical skills, makes them the best choice for anyone looking to create a professional, high-quality website.\n\nI highly recommend Totstraksonline to anyone in need of top-notch website creation services. They exceeded my expectations in every way and delivered a product that I am incredibly proud to showcase. Thank you, Totstraksonline, for your outstanding work!", "1719485860", "en", "Sean Lim", "https://www.google.com/maps/contrib/110088299018929985925/reviews", "https://lh3.googleusercontent.com/a-/ALV-UjWygvLZ3Qnowd1kS9EklTsWZyJraaxJuBTInjegddzLg5fffc6vhg=s128-c0x00000000-cc-rp-mo-ba3", "");
INSERT INTO `wp_grp_google_review` VALUES("2", "1", "5", "Great group of people, All my issues/concerns were talked about and sorted quickly and professionally. Want to say thank you to Totstraksonline you\'ve been amazing.", "1719493478", "en", "zx zx", "https://www.google.com/maps/contrib/105364201862152996413/reviews", "https://lh3.googleusercontent.com/a-/ALV-UjXYDo-gOToYSn1-k6pqZQqI-mkEx8BDfZ_OTjcTmbqyf3gG897h=s128-c0x00000000-cc-rp-mo", "");
INSERT INTO `wp_grp_google_review` VALUES("3", "1", "5", "Excellent! Would do business again with these wonderful people! Very professional and they went above and beyond! I highly recommend them for any of your business needs!!", "1719486291", "en", "Michaelangelo Balmonte", "https://www.google.com/maps/contrib/102511811107511503722/reviews", "https://lh3.googleusercontent.com/a-/ALV-UjUnZvHFr9MigEtPbOfFnZ_241GCDDvmk_Mx1Mg8nIUw2xyfZvd8=s128-c0x00000000-cc-rp-mo", "");
INSERT INTO `wp_grp_google_review` VALUES("4", "1", "5", "From start to finish, Totstraksonline delivered top-notch service and results!", "1719483803", "en", "Toxic. Healer", "https://www.google.com/maps/contrib/114269619774757901289/reviews", "https://lh3.googleusercontent.com/a-/ALV-UjXuVjVymz6MwnwdaDX941XfdaECGGRlYi8I1fGxbzodXKlBFi8=s128-c0x00000000-cc-rp-mo", "");
INSERT INTO `wp_grp_google_review` VALUES("5", "1", "5", "Very innovative company. We love the the flexibility and the fantastic service.", "1719571758", "en", "Mario Döhring", "https://www.google.com/maps/contrib/117839912032409688991/reviews", "https://lh3.googleusercontent.com/a/ACg8ocIu5KsKA8TwzR-LYxSgHZkbWtDzrnYNhK6S8HNZcWSvEFNhkA=s128-c0x00000000-cc-rp-mo", "");
INSERT INTO `wp_grp_google_review` VALUES("6", "1", "5", "Customer-oriented and extremely competent party. Have all services in-house.", "1721904291", "en", "NG Privé Spa", "https://www.google.com/maps/contrib/107368272572110486721/reviews", "https://lh3.googleusercontent.com/a/ACg8ocJwgg9YWKVLwBi9nuSDgZj8stmaLvkESJIJkcbALStK9eactQ=s128-c0x00000000-cc-rp-mo", "");
INSERT INTO `wp_grp_google_review` VALUES("7", "1", "5", "Always available, fast service and, not unimportantly, helpful!", "1721903940", "en", "Pejman Kazemi", "https://www.google.com/maps/contrib/110652973731959135441/reviews", "https://lh3.googleusercontent.com/a/ACg8ocJynJlBda4zG5VqsOOn1iYLmUZh6p1HBY1xRa5b2Uh33bSdmg=s128-c0x00000000-cc-rp-mo", "");
INSERT INTO `wp_grp_google_review` VALUES("8", "1", "5", "Good service, reliable and nice contact!", "1721824811", "en", "E M", "https://www.google.com/maps/contrib/100520577819083000682/reviews", "https://lh3.googleusercontent.com/a-/ALV-UjWTNWxAxstoaGvsA9qkGU5egG0UHtmxa_kRe6hovoUHnrbjRA8=s128-c0x00000000-cc-rp-mo", "");
INSERT INTO `wp_grp_google_review` VALUES("9", "1", "5", "Our go-to supplier for developing and maintaining activation websites for customers such as PUMA. Always flexible, great service (and advice) and a fair price. Very nice and fast switching with Joey and Joeri, among others, who think carefully about what is needed.", "1721817018", "en", "Daniëlle Groenewald", "https://www.google.com/maps/contrib/104280786658598209065/reviews", "https://lh3.googleusercontent.com/a/ACg8ocI96HAqDGNZ0xFisq3UW7Ga6QQ9apWpZKe5ubvdtCjqR4vm1w=s128-c0x00000000-cc-rp-mo", "");
INSERT INTO `wp_grp_google_review` VALUES("10", "1", "5", "", "1719824345", NULL, "Chris Cornelissen", "https://www.google.com/maps/contrib/110458836038918479930/reviews", "https://lh3.googleusercontent.com/a/ACg8ocIp8Wljln4FQhjAY1xuYoSFT6VVDuasBuYMbjLJHNRHI3HrUQ=s128-c0x00000000-cc-rp-mo", "");

/* INSERT TABLE DATA: wp_grp_google_stats */
INSERT INTO `wp_grp_google_stats` VALUES("1", "1", "1725350468", "5", "38");

/* INSERT TABLE DATA: wp_hustle_modules */
INSERT INTO `wp_hustle_modules` VALUES("1", "0", "klasse", "popup", "1", "informational");

/* INSERT TABLE DATA: wp_hustle_modules_meta */
INSERT INTO `wp_hustle_modules_meta` VALUES("1", "1", "content", "{\"module_name\":\"\",\"title\":\"klasse\",\"sub_title\":\"Boxing company\",\"main_content\":\"<p>Welcome to the boxing company<\\/p>\",\"feature_image\":\"https:\\/\\/opzetstan2.opzet-website.nl\\/wp-content\\/uploads\\/mikey.jpeg\",\"background_image\":\"\",\"show_never_see_link\":\"1\",\"never_see_link_text\":\"Close\",\"show_cta\":\"1\",\"cta_label\":\"Discover now\",\"cta_url\":\"#\",\"cta_target\":\"self\",\"cta_two_label\":\"Close\",\"cta_two_url\":\"\",\"cta_two_target\":\"close\",\"cta_helper_show\":\"0\",\"cta_helper_text\":\"\",\"feature_image_alt\":\"\"}");
INSERT INTO `wp_hustle_modules_meta` VALUES("2", "1", "emails", "{\"form_elements\":{\"first_name\":{\"required\":\"false\",\"label\":\"First Name\",\"name\":\"first_name\",\"type\":\"name\",\"placeholder\":\"John\",\"can_delete\":true},\"last_name\":{\"required\":\"false\",\"label\":\"Last Name\",\"name\":\"last_name\",\"type\":\"name\",\"placeholder\":\"Smith\",\"can_delete\":true},\"email\":{\"required\":\"true\",\"label\":\"Your email\",\"name\":\"email\",\"type\":\"email\",\"placeholder\":\"johnsmith@example.com\",\"validate\":\"true\",\"can_delete\":false},\"submit\":{\"required\":\"true\",\"label\":\"Submit\",\"error_message\":\"Something went wrong, please try again.\",\"name\":\"submit\",\"type\":\"submit\",\"placeholder\":\"Subscribe\",\"can_delete\":false}},\"after_successful_submission\":\"show_success\",\"success_message\":\"\",\"auto_close_success_message\":\"0\",\"auto_close_time\":5,\"auto_close_unit\":\"seconds\",\"redirect_url\":\"\",\"automated_email\":\"0\",\"email_time\":\"instant\",\"recipient\":\"{email}\",\"day\":\"\",\"time\":\"\",\"auto_email_time\":\"5\",\"schedule_auto_email_time\":\"5\",\"auto_email_unit\":\"seconds\",\"schedule_auto_email_unit\":\"seconds\",\"email_subject\":\"\",\"email_body\":\"\",\"automated_file\":\"0\",\"auto_download_file\":\"\",\"redirect_tab\":\"\"}");
INSERT INTO `wp_hustle_modules_meta` VALUES("3", "1", "integrations_settings", "{\"allow_subscribed_users\":\"1\",\"disallow_submission_message\":\"This email address is already subscribed.\",\"active_integrations\":\"local_list\",\"active_integrations_count\":\"1\"}");
INSERT INTO `wp_hustle_modules_meta` VALUES("4", "1", "design", "{\"enable_mobile_settings\":\"1\",\"form_layout\":\"two\",\"style\":\"simple\",\"feature_image_position\":\"right\",\"feature_image_width\":50,\"feature_image_width_unit\":\"%\",\"feature_image_height\":150,\"feature_image_height_unit\":\"px\",\"feature_image_height_mobile\":18,\"feature_image_height_unit_mobile\":\"rem\",\"feature_image_fit\":\"cover\",\"feature_image_fit_mobile\":\"cover\",\"feature_image_horizontal_position\":\"center\",\"feature_image_horizontal_position_mobile\":\"center\",\"feature_image_horizontal_value\":-100,\"feature_image_horizontal_value_mobile\":\"\",\"feature_image_horizontal_unit\":\"px\",\"feature_image_horizontal_unit_mobile\":\"px\",\"feature_image_vertical_position\":\"center\",\"feature_image_vertical_position_mobile\":\"custom\",\"feature_image_vertical_value_mobile\":-40,\"feature_image_vertical_value\":-100,\"feature_image_vertical_unit\":\"px\",\"feature_image_vertical_unit_mobile\":\"px\",\"background_image_width\":\"\",\"background_image_width_mobile\":\"\",\"background_image_width_unit\":\"px\",\"background_image_width_unit_mobile\":\"px\",\"background_image_height\":150,\"background_image_height_mobile\":150,\"background_image_height_unit\":\"px\",\"background_image_height_unit_mobile\":\"px\",\"background_image_fit\":\"contain\",\"background_image_fit_mobile\":\"contain\",\"background_image_horizontal_position\":\"center\",\"background_image_horizontal_position_mobile\":\"center\",\"background_image_horizontal_value\":-100,\"background_image_horizontal_value_mobile\":-100,\"background_image_horizontal_unit\":\"px\",\"background_image_horizontal_unit_mobile\":\"px\",\"background_image_vertical_position\":\"center\",\"background_image_vertical_position_mobile\":\"center\",\"background_image_vertical_value\":-100,\"background_image_vertical_value_mobile\":-100,\"background_image_vertical_unit\":\"px\",\"background_image_vertical_unit_mobile\":\"px\",\"background_image_repeat\":\"repeat\",\"background_image_repeat_mobile\":\"repeat\",\"cta_buttons_layout_type\":\"stacked\",\"cta_buttons_layout_type_mobile\":\"stacked\",\"cta_buttons_layout_gap_value\":\"20\",\"cta_buttons_layout_gap_value_mobile\":\"20\",\"cta_buttons_layout_gap_unit\":\"px\",\"cta_buttons_layout_gap_unit_mobile\":\"px\",\"cta_buttons_alignment\":\"full\",\"cta_buttons_alignment_mobile\":\"full\",\"optin_form_layout\":\"stacked\",\"optin_form_layout_mobile\":\"stacked\",\"form_fields_icon\":\"none\",\"customize_form_fields_proximity\":\"0\",\"customize_form_fields_proximity_mobile\":\"1\",\"form_fields_proximity_unit\":\"px\",\"form_fields_proximity_unit_mobile\":\"px\",\"form_fields_proximity_value\":5,\"form_fields_proximity_value_mobile\":10,\"close_icon_position\":\"outside\",\"close_icon_position_mobile\":\"outside\",\"close_icon_alignment_x\":\"right\",\"close_icon_alignment_x_mobile\":\"right\",\"close_icon_alignment_y\":\"top\",\"close_icon_alignment_y_mobile\":\"top\",\"close_icon_style\":\"flat\",\"close_icon_style_mobile\":\"flat\",\"close_button_static_background\":\"#403159\",\"close_icon_size\":\"12\",\"close_icon_size_mobile\":\"12\",\"customize_typography\":\"1\",\"customize_typography_mobile\":\"1\",\"global_font_family\":\"Roboto\",\"global_custom_font_family\":\"inherit\",\"customize_border_shadow_spacing\":\"1\",\"customize_border_shadow_spacing_mobile\":\"1\",\"use_vanilla\":\"0\",\"feature_image_hide_on_mobile\":\"0\",\"color_palette\":\"ectoplasm\",\"customize_colors\":\"1\",\"customize_size\":\"0\",\"customize_size_mobile\":\"0\",\"custom_width\":600,\"custom_width_unit\":\"px\",\"custom_width_mobile\":600,\"custom_width_unit_mobile\":\"px\",\"custom_height\":300,\"custom_height_unit\":\"px\",\"custom_height_mobile\":300,\"custom_height_unit_mobile\":\"px\",\"customize_css\":\"0\",\"custom_css\":\"\",\"main_bg_color\":\"#403159\",\"image_container_bg\":\"#3D2F54\",\"form_area_bg\":\"#ffffff\",\"title_color\":\"#000000\",\"title_color_alt\":\"#ADB5B7\",\"subtitle_color\":\"#000000\",\"subtitle_color_alt\":\"#ADB5B7\",\"content_color\":\"#ADB5B7\",\"ol_counter\":\"#ADB5B7\",\"ul_bullets\":\"#ADB5B7\",\"blockquote_border\":\"#B9CE33\",\"link_static_color\":\"#B9CE33\",\"link_hover_color\":\"#92A41E\",\"link_active_color\":\"#92A41E\",\"cta_button_static_bo\":\"#A3B723\",\"cta_button_static_bg\":\"#B9CE33\",\"cta_button_static_color\":\"#FFFFFF\",\"cta_button_hover_bo\":\"#9EAF31\",\"cta_button_hover_bg\":\"#92A41E\",\"cta_button_hover_color\":\"#FFFFFF\",\"cta_button_active_bo\":\"#9EAF31\",\"cta_button_active_bg\":\"#92A41E\",\"cta_button_active_color\":\"#FFFFFF\",\"optin_input_icon\":\"#888888\",\"optin_input_static_bo\":\"#070707\",\"optin_input_static_bg\":\"#FFFFFF\",\"optin_form_field_text_static_color\":\"#000000\",\"optin_placeholder_color\":\"#888888\",\"optin_input_icon_hover\":\"#888888\",\"optin_input_hover_bo\":\"#070707\",\"optin_input_hover_bg\":\"#FFFFFF\",\"optin_input_icon_focus\":\"#888888\",\"optin_input_active_bo\":\"#070707\",\"optin_input_active_bg\":\"#FFFFFF\",\"optin_input_icon_error\":\"#e12e2e\",\"optin_input_error_border\":\"#e12e2e\",\"optin_input_error_background\":\"#FFFFFF\",\"optin_check_radio_bo\":\"#B0BEC6\",\"optin_check_radio_bg\":\"#FFFFFF\",\"optin_mailchimp_labels_color\":\"#FFFFFF\",\"optin_check_radio_bo_checked\":\"#4F5F6B\",\"optin_check_radio_bg_checked\":\"#FFFFFF\",\"optin_check_radio_tick_color\":\"#38C5B5\",\"gdpr_chechbox_border_static\":\"#B0BEC6\",\"gdpr_chechbox_background_static\":\"#FFFFFF\",\"gdpr_content\":\"#FFFFFF\",\"gdpr_content_link\":\"#FFFFFF\",\"gdpr_chechbox_border_active\":\"#4F5F6B\",\"gdpr_checkbox_background_active\":\"#FFFFFF\",\"gdpr_checkbox_icon\":\"#38C5B5\",\"gdpr_checkbox_border_error\":\"#D43858\",\"gdpr_checkbox_background_error\":\"#FFFFFF\",\"optin_select_border\":\"#B0BEC6\",\"optin_select_icon\":\"#38C5B5\",\"optin_select_background\":\"#FFFFFF\",\"optin_select_placeholder\":\"#AAAAAA\",\"optin_select_label\":\"#5D7380\",\"optin_select_border_hover\":\"#4F5F6B\",\"optin_select_icon_hover\":\"#49E2D1\",\"optin_select_background_hover\":\"#FFFFFF\",\"optin_select_border_open\":\"#4F5F6B\",\"optin_select_icon_open\":\"#49E2D1\",\"optin_select_background_open\":\"#FFFFFF\",\"optin_select_border_error\":\"#D43858\",\"optin_select_icon_error\":\"#D43858\",\"optin_select_background_error\":\"#FFFFFF\",\"optin_dropdown_background\":\"#FFFFFF\",\"optin_dropdown_option_color\":\"#5D7380\",\"optin_dropdown_option_color_hover\":\"#FFFFFF\",\"optin_dropdown_option_bg_hover\":\"#ADB5B7\",\"optin_dropdown_option_color_active\":\"#FFFFFF\",\"optin_dropdown_option_bg_active\":\"#38C5B5\",\"optin_calendar_background\":\"#FFFFFF\",\"optin_calendar_title\":\"#35414A\",\"optin_calendar_arrows\":\"#5D7380\",\"optin_calendar_thead\":\"#35414A\",\"optin_calendar_cell_background\":\"#FFFFFF\",\"optin_calendar_cell_color\":\"#5D7380\",\"optin_calendar_arrows_hover\":\"#5D7380\",\"optin_calendar_cell_bg_hover\":\"#38C5B5\",\"optin_calendar_cell_color_hover\":\"#FFFFFF\",\"optin_calendar_arrows_active\":\"#5D7380\",\"optin_calendar_cell_bg_active\":\"#38C5B5\",\"optin_calendar_cell_color_active\":\"#FFFFFF\",\"optin_submit_button_static_bo\":\"#f2af29\",\"optin_submit_button_static_bg\":\"#f2af29\",\"optin_submit_button_static_color\":\"#000000\",\"optin_submit_button_hover_bo\":\"#fec44f\",\"optin_submit_button_hover_bg\":\"#fec44f\",\"optin_submit_button_hover_color\":\"#000000\",\"optin_submit_button_active_bo\":\"#4D99F7\",\"optin_submit_button_active_bg\":\"#f2af29\",\"optin_submit_button_active_color\":\"#000000\",\"optin_mailchimp_title_color\":\"#FFFFFF\",\"custom_section_bg\":\"#35414A\",\"optin_error_text_bg\":\"#fcebe5\",\"optin_error_text_border\":\"#e12e2e\",\"optin_error_text_color\":\"#e12e2e\",\"optin_success_background\":\"#ffffff\",\"optin_success_tick_color\":\"#f2af29\",\"optin_success_content_color\":\"#666666\",\"overlay_bg\":\"rgba(51,51,51,0.9)\",\"close_button_static_color\":\"#B9CE33\",\"never_see_link_static\":\"#B9CE33\",\"recaptcha_copy_text\":\"#FFFFFF\",\"recaptcha_copy_link_default\":\"#FFFFFF\",\"close_button_hover_color\":\"#92A41E\",\"never_see_link_hover\":\"#92A41E\",\"recaptcha_copy_link_hover\":\"#FFFFFF\",\"close_button_active_color\":\"#92A41E\",\"never_see_link_active\":\"#92A41E\",\"recaptcha_copy_link_focus\":\"#FFFFFF\",\"module_cont_drop_shadow\":\"rgba(0,0,0,0)\",\"module_cont_border\":\"#DADADA\",\"layout_header_border\":\"rgba(0,0,0,0.16)\",\"layout_header_bg\":\"rgba(0,0,0,0)\",\"layout_header_drop_shadow\":\"rgba(0,0,0,0)\",\"layout_content_border\":\"rgba(0,0,0,0)\",\"layout_content_bg\":\"#513E70\",\"layout_content_drop_shadow\":\"rgba(0,0,0,0)\",\"layout_footer_border\":\"rgba(0,0,0,0)\",\"layout_footer_bg\":\"rgba(0,0,0,0.16)\",\"layout_footer_drop_shadow\":\"rgba(0,0,0,0)\",\"form_cont_border\":\"rgba(0,0,0,0)\",\"form_cont_drop_shadow\":\"rgba(0,0,0,0.4)\",\"title_drop_shadow\":\"rgba(0,0,0,0)\",\"title_border\":\"rgba(0,0,0,0)\",\"title_bg\":\"rgba(0,0,0,0)\",\"subtitle_drop_shadow\":\"rgba(0,0,0,0)\",\"subtitle_border\":\"rgba(0,0,0,0)\",\"subtitle_bg\":\"rgba(0,0,0,0)\",\"content_wrap_border\":\"rgba(0,0,0,0)\",\"content_wrap_bg\":\"rgba(0,0,0,0)\",\"content_wrap_drop_shadow\":\"rgba(0,0,0,0)\",\"cta_button_static_drop_shadow\":\"rgba(0,0,0,0)\",\"cta_button_hover_drop_shadow\":\"rgba(0,0,0,0)\",\"cta_button_active_drop_shadow\":\"rgba(0,0,0,0)\",\"form_extras_border\":\"rgba(0,0,0,0)\",\"form_extras_drop_shadow\":\"rgba(0,0,0,0.4)\",\"optin_input_drop_shadow\":\"rgba(0,0,0,0.4)\",\"optin_dropdown_border\":\"#FFFFFF\",\"optin_dropdown_drop_shadow\":\"rgba(0,0,0,0.4)\",\"optin_success_border\":\"rgba(0,0,0,0)\",\"optin_success_drop_shadow\":\"rgba(0,0,0,0)\",\"submit_button_static_drop_shadow\":\"rgba(0,0,0,0.4)\",\"recaptcha_copy_border\":\"rgba(0,0,0,0)\",\"recaptcha_copy_drop_shadow\":\"rgba(0,0,0,0.4)\",\"content_border\":\"rgba(0,0,0,0)\",\"cta_cont_border\":\"rgba(0,0,0,0)\",\"form_cont_margin_are_sides_linked\":\"1\",\"form_cont_margin_unit\":\"px\",\"form_cont_margin_top\":0,\"form_cont_margin_right\":0,\"form_cont_margin_bottom\":0,\"form_cont_margin_left\":0,\"form_cont_padding_are_sides_linked\":\"0\",\"form_cont_padding_unit\":\"px\",\"form_cont_padding_top\":30,\"form_cont_padding_right\":40,\"form_cont_padding_bottom\":30,\"form_cont_padding_left\":50,\"form_cont_border_type\":\"solid\",\"form_cont_border_are_sides_linked\":\"1\",\"form_cont_border_unit\":\"px\",\"form_cont_border_top\":0,\"form_cont_border_right\":0,\"form_cont_border_bottom\":0,\"form_cont_border_left\":0,\"form_cont_radius_are_sides_linked\":\"1\",\"form_cont_radius_unit\":\"px\",\"form_cont_radius_top_left\":0,\"form_cont_radius_top_right\":0,\"form_cont_radius_bottom_left\":0,\"form_cont_radius_bottom_right\":0,\"form_extras_margin_are_sides_linked\":\"0\",\"form_extras_margin_unit\":\"px\",\"form_extras_margin_top\":20,\"form_extras_margin_right\":0,\"form_extras_margin_bottom\":0,\"form_extras_margin_left\":0,\"form_extras_padding_are_sides_linked\":\"1\",\"form_extras_padding_unit\":\"px\",\"form_extras_padding_top\":20,\"form_extras_padding_right\":20,\"form_extras_padding_bottom\":20,\"form_extras_padding_left\":20,\"form_extras_border_type\":\"solid\",\"form_extras_border_are_sides_linked\":\"1\",\"form_extras_border_unit\":\"px\",\"form_extras_border_top\":0,\"form_extras_border_right\":0,\"form_extras_border_bottom\":0,\"form_extras_border_left\":0,\"form_extras_radius_are_sides_linked\":\"1\",\"form_extras_radius_unit\":\"px\",\"form_extras_radius_top_left\":0,\"form_extras_radius_top_right\":0,\"form_extras_radius_bottom_left\":0,\"form_extras_radius_bottom_right\":0,\"form_extras_drop_shadow_unit\":\"px\",\"form_extras_drop_shadow_x\":0,\"form_extras_drop_shadow_y\":0,\"form_extras_drop_shadow_blur\":0,\"form_extras_drop_shadow_spread\":0,\"input_padding_are_sides_linked\":\"0\",\"input_padding_unit\":\"px\",\"input_padding_top\":8,\"input_padding_right\":19,\"input_padding_bottom\":8,\"input_padding_left\":19,\"input_border_type\":\"solid\",\"input_border_are_sides_linked\":\"1\",\"input_border_unit\":\"px\",\"input_border_top\":1,\"input_border_right\":1,\"input_border_bottom\":1,\"input_border_left\":1,\"input_radius_are_sides_linked\":\"1\",\"input_radius_unit\":\"px\",\"input_radius_top_left\":0,\"input_radius_top_right\":0,\"input_radius_bottom_left\":0,\"input_radius_bottom_right\":0,\"input_drop_shadow_unit\":\"px\",\"input_drop_shadow_x\":0,\"input_drop_shadow_y\":0,\"input_drop_shadow_blur\":0,\"input_drop_shadow_spread\":0,\"checkbox_border_type\":\"solid\",\"checkbox_border_are_sides_linked\":\"1\",\"checkbox_border_unit\":\"px\",\"checkbox_border_top\":0,\"checkbox_border_right\":0,\"checkbox_border_bottom\":0,\"checkbox_border_left\":0,\"checkbox_radius_are_sides_linked\":\"1\",\"checkbox_radius_unit\":\"px\",\"checkbox_radius_top_left\":0,\"checkbox_radius_top_right\":0,\"checkbox_radius_bottom_left\":0,\"checkbox_radius_bottom_right\":0,\"dropdown_margin_are_sides_linked\":\"1\",\"dropdown_margin_unit\":\"px\",\"dropdown_margin_top\":0,\"dropdown_margin_right\":0,\"dropdown_margin_bottom\":0,\"dropdown_margin_left\":0,\"dropdown_padding_are_sides_linked\":\"1\",\"dropdown_padding_unit\":\"px\",\"dropdown_padding_top\":0,\"dropdown_padding_right\":0,\"dropdown_padding_bottom\":0,\"dropdown_padding_left\":0,\"dropdown_border_type\":\"solid\",\"dropdown_border_are_sides_linked\":\"1\",\"dropdown_border_unit\":\"px\",\"dropdown_border_top\":0,\"dropdown_border_right\":0,\"dropdown_border_bottom\":0,\"dropdown_border_left\":0,\"dropdown_radius_are_sides_linked\":\"1\",\"dropdown_radius_unit\":\"px\",\"dropdown_radius_top_left\":0,\"dropdown_radius_top_right\":0,\"dropdown_radius_bottom_left\":0,\"dropdown_radius_bottom_right\":0,\"dropdown_drop_shadow_unit\":\"px\",\"dropdown_drop_shadow_x\":0,\"dropdown_drop_shadow_y\":0,\"dropdown_drop_shadow_blur\":0,\"dropdown_drop_shadow_spread\":0,\"submit_button_margin_are_sides_linked\":\"1\",\"submit_button_padding_are_sides_linked\":\"0\",\"submit_button_padding_unit\":\"px\",\"submit_button_padding_top\":9,\"submit_button_padding_right\":10,\"submit_button_padding_bottom\":9,\"submit_button_padding_left\":10,\"submit_button_border_type\":\"solid\",\"submit_button_border_are_sides_linked\":\"1\",\"submit_button_border_unit\":\"px\",\"submit_button_border_top\":2,\"submit_button_border_right\":2,\"submit_button_border_bottom\":2,\"submit_button_border_left\":2,\"submit_button_radius_are_sides_linked\":\"1\",\"submit_button_radius_unit\":\"px\",\"submit_button_radius_top_left\":0,\"submit_button_radius_top_right\":0,\"submit_button_radius_bottom_left\":0,\"submit_button_radius_bottom_right\":0,\"submit_button_drop_shadow_unit\":\"px\",\"submit_button_drop_shadow_x\":0,\"submit_button_drop_shadow_y\":0,\"submit_button_drop_shadow_blur\":0,\"submit_button_drop_shadow_spread\":0,\"error_message_margin_are_sides_linked\":\"0\",\"error_message_margin_unit\":\"px\",\"error_message_margin_top\":20,\"error_message_margin_right\":0,\"error_message_margin_bottom\":0,\"error_message_margin_left\":0,\"success_message_padding_are_sides_linked\":\"1\",\"success_message_padding_unit\":\"px\",\"success_message_padding_top\":0,\"success_message_padding_right\":0,\"success_message_padding_bottom\":0,\"success_message_padding_left\":0,\"success_message_border_type\":\"solid\",\"success_message_border_are_sides_linked\":\"1\",\"success_message_border_unit\":\"px\",\"success_message_border_top\":0,\"success_message_border_right\":0,\"success_message_border_bottom\":0,\"success_message_border_left\":0,\"success_message_radius_are_sides_linked\":\"1\",\"success_message_radius_unit\":\"px\",\"success_message_radius_top_left\":0,\"success_message_radius_top_right\":0,\"success_message_radius_bottom_left\":0,\"success_message_radius_bottom_right\":0,\"success_message_drop_shadow_unit\":\"px\",\"success_message_drop_shadow_x\":0,\"success_message_drop_shadow_y\":0,\"success_message_drop_shadow_blur\":0,\"success_message_drop_shadow_spread\":0,\"gdpr_margin_are_sides_linked\":\"0\",\"gdpr_margin_unit\":\"px\",\"gdpr_margin_top\":20,\"gdpr_margin_right\":0,\"gdpr_margin_bottom\":0,\"gdpr_margin_left\":0,\"gdpr_border_type\":\"solid\",\"gdpr_border_are_sides_linked\":\"1\",\"gdpr_border_unit\":\"px\",\"gdpr_border_top\":0,\"gdpr_border_right\":0,\"gdpr_border_bottom\":0,\"gdpr_border_left\":0,\"gdpr_radius_are_sides_linked\":\"1\",\"gdpr_radius_unit\":\"px\",\"gdpr_radius_top_left\":0,\"gdpr_radius_top_right\":0,\"gdpr_radius_bottom_left\":0,\"gdpr_radius_bottom_right\":0,\"recaptcha_margin_are_sides_linked\":\"1\",\"recaptcha_margin_unit\":\"px\",\"recaptcha_margin_top\":0,\"recaptcha_margin_right\":0,\"recaptcha_margin_bottom\":0,\"recaptcha_margin_left\":0,\"recaptcha_padding_are_sides_linked\":\"1\",\"recaptcha_padding_unit\":\"px\",\"recaptcha_padding_top\":0,\"recaptcha_padding_right\":0,\"recaptcha_padding_bottom\":0,\"recaptcha_padding_left\":0,\"recaptcha_border_type\":\"solid\",\"recaptcha_border_are_sides_linked\":\"1\",\"recaptcha_border_unit\":\"px\",\"recaptcha_border_top\":0,\"recaptcha_border_right\":0,\"recaptcha_border_bottom\":0,\"recaptcha_border_left\":0,\"recaptcha_radius_are_sides_linked\":\"1\",\"recaptcha_radius_unit\":\"px\",\"recaptcha_radius_top_left\":0,\"recaptcha_radius_top_right\":0,\"recaptcha_radius_bottom_left\":0,\"recaptcha_radius_bottom_right\":0,\"recaptcha_drop_shadow_unit\":\"px\",\"recaptcha_drop_shadow_x\":0,\"recaptcha_drop_shadow_y\":0,\"recaptcha_drop_shadow_blur\":0,\"recaptcha_drop_shadow_spread\":0,\"module_cont_margin_are_sides_linked\":\"1\",\"popup_cont_padding_are_sides_linked\":\"0\",\"popup_cont_padding_unit\":\"px\",\"popup_cont_padding_top\":0,\"popup_cont_padding_right\":15,\"popup_cont_padding_bottom\":0,\"popup_cont_padding_left\":15,\"embed_cont_margin_are_sides_linked\":\"1\",\"embed_cont_margin_unit\":\"px\",\"embed_cont_margin_top\":0,\"embed_cont_margin_right\":0,\"embed_cont_margin_bottom\":0,\"embed_cont_margin_left\":0,\"module_cont_margin_unit\":\"px\",\"module_cont_margin_top\":0,\"module_cont_margin_right\":0,\"module_cont_margin_bottom\":0,\"module_cont_margin_left\":0,\"module_cont_padding_are_sides_linked\":\"1\",\"module_cont_padding_unit\":\"px\",\"module_cont_padding_top\":10,\"module_cont_padding_right\":10,\"module_cont_padding_bottom\":10,\"module_cont_padding_left\":10,\"module_cont_border_type\":\"solid\",\"module_cont_border_are_sides_linked\":\"1\",\"module_cont_border_unit\":\"px\",\"module_cont_border_top\":0,\"module_cont_border_right\":0,\"module_cont_border_bottom\":0,\"module_cont_border_left\":0,\"module_cont_radius_are_sides_linked\":\"1\",\"module_cont_radius_unit\":\"px\",\"module_cont_radius_top_left\":0,\"module_cont_radius_top_right\":0,\"module_cont_radius_bottom_left\":0,\"module_cont_radius_bottom_right\":0,\"module_cont_drop_shadow_unit\":\"px\",\"module_cont_drop_shadow_x\":0,\"module_cont_drop_shadow_y\":0,\"module_cont_drop_shadow_blur\":0,\"module_cont_drop_shadow_spread\":0,\"layout_header_padding_are_sides_linked\":\"1\",\"layout_header_padding_unit\":\"px\",\"layout_header_padding_top\":20,\"layout_header_padding_right\":20,\"layout_header_padding_bottom\":20,\"layout_header_padding_left\":20,\"layout_header_border_type\":\"solid\",\"layout_header_border_are_sides_linked\":\"0\",\"layout_header_border_unit\":\"px\",\"layout_header_border_top\":0,\"layout_header_border_right\":0,\"layout_header_border_bottom\":1,\"layout_header_border_left\":0,\"layout_header_radius_are_sides_linked\":\"1\",\"layout_header_radius_unit\":\"px\",\"layout_header_radius_top_left\":0,\"layout_header_radius_top_right\":0,\"layout_header_radius_bottom_left\":0,\"layout_header_radius_bottom_right\":0,\"layout_header_drop_shadow_unit\":\"px\",\"layout_header_drop_shadow_x\":0,\"layout_header_drop_shadow_y\":0,\"layout_header_drop_shadow_blur\":0,\"layout_header_drop_shadow_spread\":0,\"layout_content_padding_are_sides_linked\":\"1\",\"layout_content_padding_unit\":\"px\",\"layout_content_padding_top\":0,\"layout_content_padding_right\":0,\"layout_content_padding_bottom\":0,\"layout_content_padding_left\":0,\"layout_content_border_type\":\"solid\",\"layout_content_border_are_sides_linked\":\"1\",\"layout_content_border_unit\":\"px\",\"layout_content_border_top\":0,\"layout_content_border_right\":0,\"layout_content_border_bottom\":0,\"layout_content_border_left\":0,\"layout_content_radius_are_sides_linked\":\"1\",\"layout_content_radius_unit\":\"px\",\"layout_content_radius_top_left\":0,\"layout_content_radius_top_right\":0,\"layout_content_radius_bottom_left\":0,\"layout_content_radius_bottom_right\":0,\"layout_content_drop_shadow_unit\":\"px\",\"layout_content_drop_shadow_x\":0,\"layout_content_drop_shadow_y\":0,\"layout_content_drop_shadow_blur\":0,\"layout_content_drop_shadow_spread\":0,\"layout_footer_padding_are_sides_linked\":\"0\",\"layout_footer_padding_unit\":\"px\",\"layout_footer_padding_top\":1,\"layout_footer_padding_right\":20,\"layout_footer_padding_bottom\":20,\"layout_footer_padding_left\":20,\"layout_footer_border_type\":\"solid\",\"layout_footer_border_are_sides_linked\":\"1\",\"layout_footer_border_unit\":\"px\",\"layout_footer_border_top\":0,\"layout_footer_border_right\":0,\"layout_footer_border_bottom\":0,\"layout_footer_border_left\":0,\"layout_footer_radius_are_sides_linked\":\"1\",\"layout_footer_radius_unit\":\"px\",\"layout_footer_radius_top_left\":0,\"layout_footer_radius_top_right\":0,\"layout_footer_radius_bottom_left\":0,\"layout_footer_radius_bottom_right\":0,\"layout_footer_drop_shadow_unit\":\"px\",\"layout_footer_drop_shadow_x\":0,\"layout_footer_drop_shadow_y\":0,\"layout_footer_drop_shadow_blur\":0,\"layout_footer_drop_shadow_spread\":0,\"content_wrap_margin_are_sides_linked\":\"1\",\"content_wrap_margin_unit\":\"px\",\"content_wrap_margin_top\":0,\"content_wrap_margin_right\":0,\"content_wrap_margin_bottom\":0,\"content_wrap_margin_left\":0,\"content_wrap_padding_are_sides_linked\":\"0\",\"content_wrap_padding_unit\":\"px\",\"content_wrap_padding_top\":33,\"content_wrap_padding_right\":40,\"content_wrap_padding_bottom\":40,\"content_wrap_padding_left\":50,\"content_wrap_border_type\":\"solid\",\"content_wrap_border_are_sides_linked\":\"1\",\"content_wrap_border_unit\":\"px\",\"content_wrap_border_top\":0,\"content_wrap_border_right\":0,\"content_wrap_border_bottom\":0,\"content_wrap_border_left\":0,\"content_wrap_radius_are_sides_linked\":\"1\",\"content_wrap_radius_unit\":\"px\",\"content_wrap_radius_top_left\":0,\"content_wrap_radius_top_right\":0,\"content_wrap_radius_bottom_left\":0,\"content_wrap_radius_bottom_right\":0,\"content_wrap_drop_shadow_unit\":\"px\",\"content_wrap_drop_shadow_x\":0,\"content_wrap_drop_shadow_y\":0,\"content_wrap_drop_shadow_blur\":0,\"content_wrap_drop_shadow_spread\":0,\"title_margin_are_sides_linked\":\"0\",\"title_margin_unit\":\"px\",\"title_margin_top\":0,\"title_margin_right\":0,\"title_margin_bottom\":143,\"title_margin_left\":0,\"title_padding_are_sides_linked\":\"1\",\"title_padding_unit\":\"px\",\"title_padding_top\":0,\"title_padding_right\":0,\"title_padding_bottom\":0,\"title_padding_left\":0,\"title_border_type\":\"solid\",\"title_border_are_sides_linked\":\"1\",\"title_border_unit\":\"px\",\"title_border_top\":0,\"title_border_right\":0,\"title_border_bottom\":0,\"title_border_left\":0,\"title_radius_are_sides_linked\":\"1\",\"title_radius_unit\":\"px\",\"title_radius_top_left\":0,\"title_radius_top_right\":0,\"title_radius_bottom_left\":0,\"title_radius_bottom_right\":0,\"title_drop_shadow_unit\":\"px\",\"title_drop_shadow_x\":0,\"title_drop_shadow_y\":0,\"title_drop_shadow_blur\":0,\"title_drop_shadow_spread\":0,\"subtitle_margin_are_sides_linked\":\"1\",\"subtitle_margin_unit\":\"px\",\"subtitle_margin_top\":0,\"subtitle_margin_right\":0,\"subtitle_margin_bottom\":0,\"subtitle_margin_left\":0,\"subtitle_padding_are_sides_linked\":\"0\",\"subtitle_padding_unit\":\"px\",\"subtitle_padding_top\":0,\"subtitle_padding_right\":0,\"subtitle_padding_bottom\":0,\"subtitle_padding_left\":0,\"subtitle_border_type\":\"solid\",\"subtitle_border_are_sides_linked\":\"0\",\"subtitle_border_unit\":\"px\",\"subtitle_border_top\":0,\"subtitle_border_right\":0,\"subtitle_border_bottom\":0,\"subtitle_border_left\":0,\"subtitle_radius_are_sides_linked\":\"1\",\"subtitle_radius_unit\":\"px\",\"subtitle_radius_top_left\":0,\"subtitle_radius_top_right\":0,\"subtitle_radius_bottom_left\":0,\"subtitle_radius_bottom_right\":0,\"subtitle_drop_shadow_unit\":\"px\",\"subtitle_drop_shadow_x\":0,\"subtitle_drop_shadow_y\":0,\"subtitle_drop_shadow_blur\":0,\"subtitle_drop_shadow_spread\":0,\"main_content_margin_are_sides_linked\":\"0\",\"main_content_margin_unit\":\"px\",\"main_content_margin_top\":15,\"main_content_margin_right\":0,\"main_content_margin_bottom\":0,\"main_content_margin_left\":0,\"main_content_padding_are_sides_linked\":\"1\",\"main_content_padding_unit\":\"px\",\"main_content_padding_top\":0,\"main_content_padding_right\":0,\"main_content_padding_bottom\":0,\"main_content_padding_left\":0,\"main_content_border_type\":\"solid\",\"main_content_border_are_sides_linked\":\"1\",\"main_content_border_unit\":\"px\",\"main_content_border_top\":0,\"main_content_border_right\":0,\"main_content_border_bottom\":0,\"main_content_border_left\":0,\"cta_cont_margin_are_sides_linked\":\"0\",\"cta_cont_margin_unit\":\"px\",\"cta_cont_margin_top\":20,\"cta_cont_margin_right\":0,\"cta_cont_margin_bottom\":0,\"cta_cont_margin_left\":0,\"cta_cont_padding_are_sides_linked\":\"1\",\"cta_cont_padding_unit\":\"px\",\"cta_cont_padding_top\":0,\"cta_cont_padding_right\":0,\"cta_cont_padding_bottom\":0,\"cta_cont_padding_left\":0,\"cta_cont_border_type\":\"solid\",\"cta_cont_border_are_sides_linked\":\"1\",\"cta_cont_border_unit\":\"px\",\"cta_cont_border_top\":0,\"cta_cont_border_right\":0,\"cta_cont_border_bottom\":0,\"cta_cont_border_left\":0,\"cta_padding_are_sides_linked\":\"0\",\"cta_padding_unit\":\"%\",\"cta_padding_top\":3,\"cta_padding_right\":17,\"cta_padding_bottom\":3,\"cta_padding_left\":17,\"cta_border_type\":\"solid\",\"cta_border_are_sides_linked\":\"1\",\"cta_border_unit\":\"px\",\"cta_border_top\":2,\"cta_border_right\":2,\"cta_border_bottom\":2,\"cta_border_left\":2,\"cta_radius_are_sides_linked\":\"1\",\"cta_radius_unit\":\"px\",\"cta_radius_top_left\":0,\"cta_radius_top_right\":0,\"cta_radius_bottom_left\":0,\"cta_radius_bottom_right\":0,\"cta_drop_shadow_unit\":\"px\",\"cta_drop_shadow_x\":0,\"cta_drop_shadow_y\":0,\"cta_drop_shadow_blur\":0,\"cta_drop_shadow_spread\":0,\"nsa_link_margin_are_sides_linked\":\"0\",\"nsa_link_margin_unit\":\"px\",\"nsa_link_margin_top\":15,\"nsa_link_margin_right\":0,\"nsa_link_margin_bottom\":0,\"nsa_link_margin_left\":0,\"form_cont_margin_are_sides_linked_mobile\":\"1\",\"form_cont_margin_unit_mobile\":\"px\",\"form_cont_margin_top_mobile\":\"\",\"form_cont_margin_right_mobile\":\"\",\"form_cont_margin_bottom_mobile\":\"\",\"form_cont_margin_left_mobile\":\"\",\"form_cont_padding_are_sides_linked_mobile\":\"0\",\"form_cont_padding_unit_mobile\":\"px\",\"form_cont_padding_top_mobile\":30,\"form_cont_padding_right_mobile\":0,\"form_cont_padding_bottom_mobile\":30,\"form_cont_padding_left_mobile\":0,\"form_cont_border_type_mobile\":\"solid\",\"form_cont_border_are_sides_linked_mobile\":\"1\",\"form_cont_border_unit_mobile\":\"px\",\"form_cont_border_top_mobile\":\"\",\"form_cont_border_right_mobile\":\"\",\"form_cont_border_bottom_mobile\":\"\",\"form_cont_border_left_mobile\":\"\",\"form_cont_radius_are_sides_linked_mobile\":\"1\",\"form_cont_radius_unit_mobile\":\"px\",\"form_cont_radius_top_left_mobile\":\"\",\"form_cont_radius_top_right_mobile\":\"\",\"form_cont_radius_bottom_left_mobile\":\"\",\"form_cont_radius_bottom_right_mobile\":\"\",\"form_extras_margin_are_sides_linked_mobile\":\"0\",\"form_extras_margin_unit_mobile\":\"px\",\"form_extras_margin_top_mobile\":10,\"form_extras_margin_right_mobile\":\"\",\"form_extras_margin_bottom_mobile\":\"\",\"form_extras_margin_left_mobile\":\"\",\"form_extras_padding_are_sides_linked_mobile\":\"1\",\"form_extras_padding_unit_mobile\":\"px\",\"form_extras_padding_top_mobile\":10,\"form_extras_padding_right_mobile\":10,\"form_extras_padding_bottom_mobile\":10,\"form_extras_padding_left_mobile\":10,\"form_extras_border_type_mobile\":\"solid\",\"form_extras_border_are_sides_linked_mobile\":\"1\",\"form_extras_border_unit_mobile\":\"px\",\"form_extras_border_top_mobile\":\"\",\"form_extras_border_right_mobile\":\"\",\"form_extras_border_bottom_mobile\":\"\",\"form_extras_border_left_mobile\":\"\",\"form_extras_radius_are_sides_linked_mobile\":\"1\",\"form_extras_radius_unit_mobile\":\"px\",\"form_extras_radius_top_left_mobile\":\"\",\"form_extras_radius_top_right_mobile\":\"\",\"form_extras_radius_bottom_left_mobile\":\"\",\"form_extras_radius_bottom_right_mobile\":\"\",\"form_extras_drop_shadow_unit_mobile\":\"px\",\"form_extras_drop_shadow_x_mobile\":\"\",\"form_extras_drop_shadow_y_mobile\":\"\",\"form_extras_drop_shadow_blur_mobile\":\"\",\"form_extras_drop_shadow_spread_mobile\":\"\",\"input_padding_are_sides_linked_mobile\":\"1\",\"input_padding_unit_mobile\":\"px\",\"input_padding_top_mobile\":\"\",\"input_padding_right_mobile\":\"\",\"input_padding_bottom_mobile\":\"\",\"input_padding_left_mobile\":\"\",\"input_border_type_mobile\":\"solid\",\"input_border_are_sides_linked_mobile\":\"1\",\"input_border_unit_mobile\":\"px\",\"input_border_top_mobile\":\"\",\"input_border_right_mobile\":\"\",\"input_border_bottom_mobile\":\"\",\"input_border_left_mobile\":\"\",\"input_radius_are_sides_linked_mobile\":\"1\",\"input_radius_unit_mobile\":\"px\",\"input_radius_top_left_mobile\":\"\",\"input_radius_top_right_mobile\":\"\",\"input_radius_bottom_left_mobile\":\"\",\"input_radius_bottom_right_mobile\":\"\",\"input_drop_shadow_unit_mobile\":\"px\",\"input_drop_shadow_x_mobile\":\"\",\"input_drop_shadow_y_mobile\":\"\",\"input_drop_shadow_blur_mobile\":\"\",\"input_drop_shadow_spread_mobile\":\"\",\"checkbox_border_type_mobile\":\"solid\",\"checkbox_border_are_sides_linked_mobile\":\"1\",\"checkbox_border_unit_mobile\":\"px\",\"checkbox_border_top_mobile\":\"\",\"checkbox_border_right_mobile\":\"\",\"checkbox_border_bottom_mobile\":\"\",\"checkbox_border_left_mobile\":\"\",\"checkbox_radius_are_sides_linked_mobile\":\"1\",\"checkbox_radius_unit_mobile\":\"px\",\"checkbox_radius_top_left_mobile\":\"\",\"checkbox_radius_top_right_mobile\":\"\",\"checkbox_radius_bottom_left_mobile\":\"\",\"checkbox_radius_bottom_right_mobile\":\"\",\"dropdown_margin_are_sides_linked_mobile\":\"1\",\"dropdown_margin_unit_mobile\":\"px\",\"dropdown_margin_top_mobile\":\"\",\"dropdown_margin_right_mobile\":\"\",\"dropdown_margin_bottom_mobile\":\"\",\"dropdown_margin_left_mobile\":\"\",\"dropdown_padding_are_sides_linked_mobile\":\"1\",\"dropdown_padding_unit_mobile\":\"px\",\"dropdown_padding_top_mobile\":\"\",\"dropdown_padding_right_mobile\":\"\",\"dropdown_padding_bottom_mobile\":\"\",\"dropdown_padding_left_mobile\":\"\",\"dropdown_border_type_mobile\":\"solid\",\"dropdown_border_are_sides_linked_mobile\":\"1\",\"dropdown_border_unit_mobile\":\"px\",\"dropdown_border_top_mobile\":\"\",\"dropdown_border_right_mobile\":\"\",\"dropdown_border_bottom_mobile\":\"\",\"dropdown_border_left_mobile\":\"\",\"dropdown_radius_are_sides_linked_mobile\":\"1\",\"dropdown_radius_unit_mobile\":\"px\",\"dropdown_radius_top_left_mobile\":\"\",\"dropdown_radius_top_right_mobile\":\"\",\"dropdown_radius_bottom_left_mobile\":\"\",\"dropdown_radius_bottom_right_mobile\":\"\",\"dropdown_drop_shadow_unit_mobile\":\"px\",\"dropdown_drop_shadow_x_mobile\":\"\",\"dropdown_drop_shadow_y_mobile\":\"\",\"dropdown_drop_shadow_blur_mobile\":\"\",\"dropdown_drop_shadow_spread_mobile\":\"\",\"submit_button_margin_are_sides_linked_mobile\":\"1\",\"submit_button_margin_unit_mobile\":\"px\",\"submit_button_margin_top_mobile\":\"\",\"submit_button_margin_right_mobile\":\"\",\"submit_button_margin_bottom_mobile\":\"\",\"submit_button_margin_left_mobile\":\"\",\"submit_button_padding_are_sides_linked_mobile\":\"1\",\"submit_button_padding_unit_mobile\":\"px\",\"submit_button_padding_top_mobile\":\"\",\"submit_button_padding_right_mobile\":\"\",\"submit_button_padding_bottom_mobile\":\"\",\"submit_button_padding_left_mobile\":\"\",\"submit_button_border_type_mobile\":\"solid\",\"submit_button_border_are_sides_linked_mobile\":\"1\",\"submit_button_border_unit_mobile\":\"px\",\"submit_button_border_top_mobile\":\"\",\"submit_button_border_right_mobile\":\"\",\"submit_button_border_bottom_mobile\":\"\",\"submit_button_border_left_mobile\":\"\",\"submit_button_radius_are_sides_linked_mobile\":\"1\",\"submit_button_radius_unit_mobile\":\"px\",\"submit_button_radius_top_left_mobile\":\"\",\"submit_button_radius_top_right_mobile\":\"\",\"submit_button_radius_bottom_left_mobile\":\"\",\"submit_button_radius_bottom_right_mobile\":\"\",\"submit_button_drop_shadow_unit_mobile\":\"px\",\"submit_button_drop_shadow_x_mobile\":\"\",\"submit_button_drop_shadow_y_mobile\":\"\",\"submit_button_drop_shadow_blur_mobile\":\"\",\"submit_button_drop_shadow_spread_mobile\":\"\",\"error_message_margin_are_sides_linked_mobile\":\"1\",\"error_message_margin_unit_mobile\":\"px\",\"error_message_margin_top_mobile\":\"\",\"error_message_margin_right_mobile\":\"\",\"error_message_margin_bottom_mobile\":\"\",\"error_message_margin_left_mobile\":\"\",\"success_message_padding_are_sides_linked_mobile\":\"1\",\"success_message_padding_unit_mobile\":\"px\",\"success_message_padding_top_mobile\":\"\",\"success_message_padding_right_mobile\":\"\",\"success_message_padding_bottom_mobile\":\"\",\"success_message_padding_left_mobile\":\"\",\"success_message_border_type_mobile\":\"solid\",\"success_message_border_are_sides_linked_mobile\":\"1\",\"success_message_border_unit_mobile\":\"px\",\"success_message_border_top_mobile\":\"\",\"success_message_border_right_mobile\":\"\",\"success_message_border_bottom_mobile\":\"\",\"success_message_border_left_mobile\":\"\",\"success_message_radius_are_sides_linked_mobile\":\"1\",\"success_message_radius_unit_mobile\":\"px\",\"success_message_radius_top_left_mobile\":\"\",\"success_message_radius_top_right_mobile\":\"\",\"success_message_radius_bottom_left_mobile\":\"\",\"success_message_radius_bottom_right_mobile\":\"\",\"success_message_drop_shadow_unit_mobile\":\"px\",\"success_message_drop_shadow_x_mobile\":\"\",\"success_message_drop_shadow_y_mobile\":\"\",\"success_message_drop_shadow_blur_mobile\":\"\",\"success_message_drop_shadow_spread_mobile\":\"\",\"gdpr_margin_are_sides_linked_mobile\":\"0\",\"gdpr_margin_unit_mobile\":\"px\",\"gdpr_margin_top_mobile\":20,\"gdpr_margin_right_mobile\":0,\"gdpr_margin_bottom_mobile\":0,\"gdpr_margin_left_mobile\":0,\"gdpr_border_type_mobile\":\"solid\",\"gdpr_border_are_sides_linked_mobile\":\"1\",\"gdpr_border_unit_mobile\":\"px\",\"gdpr_border_top_mobile\":0,\"gdpr_border_right_mobile\":0,\"gdpr_border_bottom_mobile\":0,\"gdpr_border_left_mobile\":0,\"gdpr_radius_are_sides_linked_mobile\":\"1\",\"gdpr_radius_unit_mobile\":\"px\",\"gdpr_radius_top_left_mobile\":0,\"gdpr_radius_top_right_mobile\":0,\"gdpr_radius_bottom_left_mobile\":0,\"gdpr_radius_bottom_right_mobile\":0,\"recaptcha_margin_are_sides_linked_mobile\":\"1\",\"recaptcha_margin_unit_mobile\":\"px\",\"recaptcha_margin_top_mobile\":0,\"recaptcha_margin_right_mobile\":0,\"recaptcha_margin_bottom_mobile\":0,\"recaptcha_margin_left_mobile\":0,\"recaptcha_padding_are_sides_linked_mobile\":\"1\",\"recaptcha_padding_unit_mobile\":\"px\",\"recaptcha_padding_top_mobile\":0,\"recaptcha_padding_right_mobile\":0,\"recaptcha_padding_bottom_mobile\":0,\"recaptcha_padding_left_mobile\":0,\"recaptcha_border_type_mobile\":\"solid\",\"recaptcha_border_are_sides_linked_mobile\":\"1\",\"recaptcha_border_unit_mobile\":\"px\",\"recaptcha_border_top_mobile\":0,\"recaptcha_border_right_mobile\":0,\"recaptcha_border_bottom_mobile\":0,\"recaptcha_border_left_mobile\":0,\"recaptcha_radius_are_sides_linked_mobile\":\"1\",\"recaptcha_radius_unit_mobile\":\"px\",\"recaptcha_radius_top_left_mobile\":0,\"recaptcha_radius_top_right_mobile\":0,\"recaptcha_radius_bottom_left_mobile\":0,\"recaptcha_radius_bottom_right_mobile\":0,\"recaptcha_drop_shadow_unit_mobile\":\"px\",\"recaptcha_drop_shadow_x_mobile\":0,\"recaptcha_drop_shadow_y_mobile\":0,\"recaptcha_drop_shadow_blur_mobile\":0,\"recaptcha_drop_shadow_spread_mobile\":0,\"popup_cont_padding_are_sides_linked_mobile\":\"1\",\"popup_cont_padding_unit_mobile\":\"px\",\"popup_cont_padding_top_mobile\":\"\",\"popup_cont_padding_right_mobile\":\"\",\"popup_cont_padding_bottom_mobile\":\"\",\"popup_cont_padding_left_mobile\":\"\",\"embed_cont_margin_are_sides_linked_mobile\":\"1\",\"embed_cont_margin_unit_mobile\":\"px\",\"embed_cont_margin_top_mobile\":\"\",\"embed_cont_margin_right_mobile\":\"\",\"embed_cont_margin_bottom_mobile\":\"\",\"embed_cont_margin_left_mobile\":\"\",\"module_cont_margin_are_sides_linked_mobile\":\"1\",\"module_cont_margin_unit_mobile\":\"px\",\"module_cont_margin_top_mobile\":\"\",\"module_cont_margin_right_mobile\":\"\",\"module_cont_margin_bottom_mobile\":\"\",\"module_cont_margin_left_mobile\":\"\",\"module_cont_padding_are_sides_linked_mobile\":\"1\",\"module_cont_padding_unit_mobile\":\"px\",\"module_cont_padding_top_mobile\":30,\"module_cont_padding_right_mobile\":30,\"module_cont_padding_bottom_mobile\":30,\"module_cont_padding_left_mobile\":30,\"module_cont_border_type_mobile\":\"solid\",\"module_cont_border_are_sides_linked_mobile\":\"1\",\"module_cont_border_unit_mobile\":\"px\",\"module_cont_border_top_mobile\":0,\"module_cont_border_right_mobile\":0,\"module_cont_border_bottom_mobile\":0,\"module_cont_border_left_mobile\":0,\"module_cont_radius_are_sides_linked_mobile\":\"1\",\"module_cont_radius_unit_mobile\":\"px\",\"module_cont_radius_top_left_mobile\":\"\",\"module_cont_radius_top_right_mobile\":\"\",\"module_cont_radius_bottom_left_mobile\":\"\",\"module_cont_radius_bottom_right_mobile\":\"\",\"module_cont_drop_shadow_unit_mobile\":\"px\",\"module_cont_drop_shadow_x_mobile\":\"\",\"module_cont_drop_shadow_y_mobile\":\"\",\"module_cont_drop_shadow_blur_mobile\":\"\",\"module_cont_drop_shadow_spread_mobile\":\"\",\"layout_header_padding_are_sides_linked_mobile\":\"1\",\"layout_header_padding_unit_mobile\":\"px\",\"layout_header_padding_top_mobile\":\"\",\"layout_header_padding_right_mobile\":\"\",\"layout_header_padding_bottom_mobile\":\"\",\"layout_header_padding_left_mobile\":\"\",\"layout_header_border_type_mobile\":\"solid\",\"layout_header_border_are_sides_linked_mobile\":\"1\",\"layout_header_border_unit_mobile\":\"px\",\"layout_header_border_top_mobile\":\"\",\"layout_header_border_right_mobile\":\"\",\"layout_header_border_bottom_mobile\":\"\",\"layout_header_border_left_mobile\":\"\",\"layout_header_radius_are_sides_linked_mobile\":\"1\",\"layout_header_radius_unit_mobile\":\"px\",\"layout_header_radius_top_left_mobile\":\"\",\"layout_header_radius_top_right_mobile\":\"\",\"layout_header_radius_bottom_left_mobile\":\"\",\"layout_header_radius_bottom_right_mobile\":\"\",\"layout_header_drop_shadow_unit_mobile\":\"px\",\"layout_header_drop_shadow_x_mobile\":\"\",\"layout_header_drop_shadow_y_mobile\":\"\",\"layout_header_drop_shadow_blur_mobile\":\"\",\"layout_header_drop_shadow_spread_mobile\":\"\",\"layout_content_padding_are_sides_linked_mobile\":\"1\",\"layout_content_padding_unit_mobile\":\"px\",\"layout_content_padding_top_mobile\":\"\",\"layout_content_padding_right_mobile\":\"\",\"layout_content_padding_bottom_mobile\":\"\",\"layout_content_padding_left_mobile\":\"\",\"layout_content_border_type_mobile\":\"solid\",\"layout_content_border_are_sides_linked_mobile\":\"1\",\"layout_content_border_unit_mobile\":\"px\",\"layout_content_border_top_mobile\":\"\",\"layout_content_border_right_mobile\":\"\",\"layout_content_border_bottom_mobile\":\"\",\"layout_content_border_left_mobile\":\"\",\"layout_content_radius_are_sides_linked_mobile\":\"1\",\"layout_content_radius_unit_mobile\":\"px\",\"layout_content_radius_top_left_mobile\":\"\",\"layout_content_radius_top_right_mobile\":\"\",\"layout_content_radius_bottom_left_mobile\":\"\",\"layout_content_radius_bottom_right_mobile\":\"\",\"layout_content_drop_shadow_unit_mobile\":\"px\",\"layout_content_drop_shadow_x_mobile\":\"\",\"layout_content_drop_shadow_y_mobile\":\"\",\"layout_content_drop_shadow_blur_mobile\":\"\",\"layout_content_drop_shadow_spread_mobile\":\"\",\"layout_footer_padding_are_sides_linked_mobile\":\"1\",\"layout_footer_padding_unit_mobile\":\"px\",\"layout_footer_padding_top_mobile\":\"\",\"layout_footer_padding_right_mobile\":\"\",\"layout_footer_padding_bottom_mobile\":\"\",\"layout_footer_padding_left_mobile\":\"\",\"layout_footer_border_type_mobile\":\"solid\",\"layout_footer_border_are_sides_linked_mobile\":\"1\",\"layout_footer_border_unit_mobile\":\"px\",\"layout_footer_border_top_mobile\":\"\",\"layout_footer_border_right_mobile\":\"\",\"layout_footer_border_bottom_mobile\":\"\",\"layout_footer_border_left_mobile\":\"\",\"layout_footer_radius_are_sides_linked_mobile\":\"1\",\"layout_footer_radius_unit_mobile\":\"px\",\"layout_footer_radius_top_left_mobile\":\"\",\"layout_footer_radius_top_right_mobile\":\"\",\"layout_footer_radius_bottom_left_mobile\":\"\",\"layout_footer_radius_bottom_right_mobile\":\"\",\"layout_footer_drop_shadow_unit_mobile\":\"px\",\"layout_footer_drop_shadow_x_mobile\":\"\",\"layout_footer_drop_shadow_y_mobile\":\"\",\"layout_footer_drop_shadow_blur_mobile\":\"\",\"layout_footer_drop_shadow_spread_mobile\":\"\",\"content_wrap_margin_are_sides_linked_mobile\":\"1\",\"content_wrap_margin_unit_mobile\":\"px\",\"content_wrap_margin_top_mobile\":\"\",\"content_wrap_margin_right_mobile\":\"\",\"content_wrap_margin_bottom_mobile\":\"\",\"content_wrap_margin_left_mobile\":\"\",\"content_wrap_padding_are_sides_linked_mobile\":\"0\",\"content_wrap_padding_unit_mobile\":\"px\",\"content_wrap_padding_top_mobile\":0,\"content_wrap_padding_right_mobile\":0,\"content_wrap_padding_bottom_mobile\":30,\"content_wrap_padding_left_mobile\":0,\"content_wrap_border_type_mobile\":\"solid\",\"content_wrap_border_are_sides_linked_mobile\":\"1\",\"content_wrap_border_unit_mobile\":\"px\",\"content_wrap_border_top_mobile\":\"\",\"content_wrap_border_right_mobile\":\"\",\"content_wrap_border_bottom_mobile\":\"\",\"content_wrap_border_left_mobile\":\"\",\"content_wrap_radius_are_sides_linked_mobile\":\"1\",\"content_wrap_radius_unit_mobile\":\"px\",\"content_wrap_radius_top_left_mobile\":\"\",\"content_wrap_radius_top_right_mobile\":\"\",\"content_wrap_radius_bottom_left_mobile\":\"\",\"content_wrap_radius_bottom_right_mobile\":\"\",\"content_wrap_drop_shadow_unit_mobile\":\"px\",\"content_wrap_drop_shadow_x_mobile\":\"\",\"content_wrap_drop_shadow_y_mobile\":\"\",\"content_wrap_drop_shadow_blur_mobile\":\"\",\"content_wrap_drop_shadow_spread_mobile\":\"\",\"title_margin_are_sides_linked_mobile\":\"0\",\"title_margin_unit_mobile\":\"px\",\"title_margin_top_mobile\":0,\"title_margin_right_mobile\":0,\"title_margin_bottom_mobile\":30,\"title_margin_left_mobile\":0,\"title_padding_are_sides_linked_mobile\":\"1\",\"title_padding_unit_mobile\":\"px\",\"title_padding_top_mobile\":\"\",\"title_padding_right_mobile\":\"\",\"title_padding_bottom_mobile\":\"\",\"title_padding_left_mobile\":\"\",\"title_border_type_mobile\":\"solid\",\"title_border_are_sides_linked_mobile\":\"1\",\"title_border_unit_mobile\":\"px\",\"title_border_top_mobile\":\"\",\"title_border_right_mobile\":\"\",\"title_border_bottom_mobile\":\"\",\"title_border_left_mobile\":\"\",\"title_radius_are_sides_linked_mobile\":\"1\",\"title_radius_unit_mobile\":\"px\",\"title_radius_top_left_mobile\":\"\",\"title_radius_top_right_mobile\":\"\",\"title_radius_bottom_left_mobile\":\"\",\"title_radius_bottom_right_mobile\":\"\",\"title_drop_shadow_unit_mobile\":\"px\",\"title_drop_shadow_x_mobile\":\"\",\"title_drop_shadow_y_mobile\":\"\",\"title_drop_shadow_blur_mobile\":\"\",\"title_drop_shadow_spread_mobile\":\"\",\"subtitle_margin_are_sides_linked_mobile\":\"1\",\"subtitle_margin_unit_mobile\":\"px\",\"subtitle_margin_top_mobile\":\"\",\"subtitle_margin_right_mobile\":\"\",\"subtitle_margin_bottom_mobile\":\"\",\"subtitle_margin_left_mobile\":\"\",\"subtitle_padding_are_sides_linked_mobile\":\"1\",\"subtitle_padding_unit_mobile\":\"px\",\"subtitle_padding_top_mobile\":\"\",\"subtitle_padding_right_mobile\":\"\",\"subtitle_padding_bottom_mobile\":\"\",\"subtitle_padding_left_mobile\":\"\",\"subtitle_border_type_mobile\":\"solid\",\"subtitle_border_are_sides_linked_mobile\":\"1\",\"subtitle_border_unit_mobile\":\"px\",\"subtitle_border_top_mobile\":\"\",\"subtitle_border_right_mobile\":\"\",\"subtitle_border_bottom_mobile\":\"\",\"subtitle_border_left_mobile\":\"\",\"subtitle_radius_are_sides_linked_mobile\":\"1\",\"subtitle_radius_unit_mobile\":\"px\",\"subtitle_radius_top_left_mobile\":\"\",\"subtitle_radius_top_right_mobile\":\"\",\"subtitle_radius_bottom_left_mobile\":\"\",\"subtitle_radius_bottom_right_mobile\":\"\",\"subtitle_drop_shadow_unit_mobile\":\"px\",\"subtitle_drop_shadow_x_mobile\":\"\",\"subtitle_drop_shadow_y_mobile\":\"\",\"subtitle_drop_shadow_blur_mobile\":\"\",\"subtitle_drop_shadow_spread_mobile\":\"\",\"main_content_margin_are_sides_linked_mobile\":\"1\",\"main_content_margin_unit_mobile\":\"px\",\"main_content_margin_top_mobile\":\"\",\"main_content_margin_right_mobile\":\"\",\"main_content_margin_bottom_mobile\":\"\",\"main_content_margin_left_mobile\":\"\",\"main_content_padding_are_sides_linked_mobile\":\"1\",\"main_content_padding_unit_mobile\":\"px\",\"main_content_padding_top_mobile\":\"\",\"main_content_padding_right_mobile\":\"\",\"main_content_padding_bottom_mobile\":\"\",\"main_content_padding_left_mobile\":\"\",\"main_content_border_type_mobile\":\"solid\",\"main_content_border_are_sides_linked_mobile\":\"1\",\"main_content_border_unit_mobile\":\"px\",\"main_content_border_top_mobile\":\"\",\"main_content_border_right_mobile\":\"\",\"main_content_border_bottom_mobile\":\"\",\"main_content_border_left_mobile\":\"\",\"main_content_radius_are_sides_linked_mobile\":\"1\",\"main_content_radius_unit_mobile\":\"px\",\"main_content_radius_top_left_mobile\":\"\",\"main_content_radius_top_right_mobile\":\"\",\"main_content_radius_bottom_left_mobile\":\"\",\"main_content_radius_bottom_right_mobile\":\"\",\"cta_cont_margin_are_sides_linked_mobile\":\"1\",\"cta_cont_margin_unit_mobile\":\"px\",\"cta_cont_margin_top_mobile\":\"\",\"cta_cont_margin_right_mobile\":\"\",\"cta_cont_margin_bottom_mobile\":\"\",\"cta_cont_margin_left_mobile\":\"\",\"cta_cont_padding_are_sides_linked_mobile\":\"1\",\"cta_cont_padding_unit_mobile\":\"px\",\"cta_cont_padding_top_mobile\":\"\",\"cta_cont_padding_right_mobile\":\"\",\"cta_cont_padding_bottom_mobile\":\"\",\"cta_cont_padding_left_mobile\":\"\",\"cta_cont_border_type_mobile\":\"solid\",\"cta_cont_border_are_sides_linked_mobile\":\"1\",\"cta_cont_border_unit_mobile\":\"px\",\"cta_cont_border_top_mobile\":\"\",\"cta_cont_border_right_mobile\":\"\",\"cta_cont_border_bottom_mobile\":\"\",\"cta_cont_border_left_mobile\":\"\",\"cta_padding_are_sides_linked_mobile\":\"1\",\"cta_padding_unit_mobile\":\"px\",\"cta_padding_top_mobile\":\"\",\"cta_padding_right_mobile\":\"\",\"cta_padding_bottom_mobile\":\"\",\"cta_padding_left_mobile\":\"\",\"cta_border_type_mobile\":\"solid\",\"cta_border_are_sides_linked_mobile\":\"1\",\"cta_border_unit_mobile\":\"px\",\"cta_border_top_mobile\":\"\",\"cta_border_right_mobile\":\"\",\"cta_border_bottom_mobile\":\"\",\"cta_border_left_mobile\":\"\",\"cta_radius_are_sides_linked_mobile\":\"1\",\"cta_radius_unit_mobile\":\"px\",\"cta_radius_top_left_mobile\":\"\",\"cta_radius_top_right_mobile\":\"\",\"cta_radius_bottom_left_mobile\":\"\",\"cta_radius_bottom_right_mobile\":\"\",\"cta_drop_shadow_unit_mobile\":\"px\",\"cta_drop_shadow_x_mobile\":\"\",\"cta_drop_shadow_y_mobile\":\"\",\"cta_drop_shadow_blur_mobile\":\"\",\"cta_drop_shadow_spread_mobile\":\"\",\"nsa_link_margin_are_sides_linked_mobile\":\"0\",\"nsa_link_margin_unit_mobile\":\"px\",\"nsa_link_margin_top_mobile\":10,\"nsa_link_margin_right_mobile\":\"\",\"nsa_link_margin_bottom_mobile\":\"\",\"nsa_link_margin_left_mobile\":\"\",\"title_font_family\":\"Roboto\",\"title_custom_font_family\":\"inherit\",\"title_font_size\":14,\"title_font_size_unit\":\"px\",\"title_font_weight\":\"regular\",\"title_alignment\":\"left\",\"title_line_height\":16,\"title_line_height_unit\":\"px\",\"title_letter_spacing\":2,\"title_letter_spacing_unit\":\"px\",\"title_text_transform\":\"none\",\"title_text_decoration\":\"none\",\"subtitle_font_family\":\"Crimson Text\",\"subtitle_custom_font_family\":\"inherit\",\"subtitle_font_size\":38,\"subtitle_font_size_unit\":\"px\",\"subtitle_font_weight\":600,\"subtitle_alignment\":\"left\",\"subtitle_line_height\":46,\"subtitle_line_height_unit\":\"px\",\"subtitle_letter_spacing\":\"-0.75\",\"subtitle_letter_spacing_unit\":\"px\",\"subtitle_text_transform\":\"none\",\"subtitle_text_decoration\":\"none\",\"main_content_paragraph_font_family\":\"Roboto\",\"main_content_paragraph_custom_font_family\":\"inherit\",\"main_content_paragraph_font_size\":16,\"main_content_paragraph_font_size_unit\":\"px\",\"main_content_paragraph_font_weight\":\"regular\",\"main_content_paragraph_alignment\":\"left\",\"main_content_paragraph_line_height\":26,\"main_content_paragraph_line_height_unit\":\"px\",\"main_content_paragraph_letter_spacing\":\"-0.25\",\"main_content_paragraph_letter_spacing_unit\":\"px\",\"main_content_paragraph_text_transform\":\"none\",\"main_content_paragraph_text_decoration\":\"none\",\"main_content_heading_one_font_family\":\"Open Sans\",\"main_content_heading_one_custom_font_family\":\"inherit\",\"main_content_heading_one_font_size\":28,\"main_content_heading_one_font_size_unit\":\"px\",\"main_content_heading_one_font_weight\":700,\"main_content_heading_one_alignment\":\"left\",\"main_content_heading_one_line_height\":\"1.4\",\"main_content_heading_one_line_height_unit\":\"em\",\"main_content_heading_one_letter_spacing\":0,\"main_content_heading_one_letter_spacing_unit\":\"px\",\"main_content_heading_one_text_transform\":\"none\",\"main_content_heading_one_text_decoration\":\"none\",\"main_content_heading_two_font_family\":\"custom\",\"main_content_heading_two_custom_font_family\":\"inherit\",\"main_content_heading_two_font_size\":22,\"main_content_heading_two_font_size_unit\":\"px\",\"main_content_heading_two_font_weight\":700,\"main_content_heading_two_alignment\":\"left\",\"main_content_heading_two_line_height\":\"1.4\",\"main_content_heading_two_line_height_unit\":\"em\",\"main_content_heading_two_letter_spacing\":0,\"main_content_heading_two_letter_spacing_unit\":\"px\",\"main_content_heading_two_text_transform\":\"none\",\"main_content_heading_two_text_decoration\":\"none\",\"main_content_heading_three_font_family\":\"Open Sans\",\"main_content_heading_three_custom_font_family\":\"inherit\",\"main_content_heading_three_font_size\":18,\"main_content_heading_three_font_size_unit\":\"px\",\"main_content_heading_three_font_weight\":700,\"main_content_heading_three_alignment\":\"left\",\"main_content_heading_three_line_height\":\"1.4\",\"main_content_heading_three_line_height_unit\":\"em\",\"main_content_heading_three_letter_spacing\":0,\"main_content_heading_three_letter_spacing_unit\":\"px\",\"main_content_heading_three_text_transform\":\"none\",\"main_content_heading_three_text_decoration\":\"none\",\"main_content_heading_four_font_family\":\"Open Sans\",\"main_content_heading_four_custom_font_family\":\"inherit\",\"main_content_heading_four_font_size\":16,\"main_content_heading_four_font_size_unit\":\"px\",\"main_content_heading_four_font_weight\":700,\"main_content_heading_four_alignment\":\"left\",\"main_content_heading_four_line_height\":\"1.4\",\"main_content_heading_four_line_height_unit\":\"em\",\"main_content_heading_four_letter_spacing\":0,\"main_content_heading_four_letter_spacing_unit\":\"px\",\"main_content_heading_four_text_transform\":\"none\",\"main_content_heading_four_text_decoration\":\"none\",\"main_content_heading_five_font_family\":\"Open Sans\",\"main_content_heading_five_custom_font_family\":\"inherit\",\"main_content_heading_five_font_size\":14,\"main_content_heading_five_font_size_unit\":\"px\",\"main_content_heading_five_font_weight\":700,\"main_content_heading_five_alignment\":\"left\",\"main_content_heading_five_line_height\":\"1.4\",\"main_content_heading_five_line_height_unit\":\"em\",\"main_content_heading_five_letter_spacing\":0,\"main_content_heading_five_letter_spacing_unit\":\"px\",\"main_content_heading_five_text_transform\":\"none\",\"main_content_heading_five_text_decoration\":\"none\",\"main_content_heading_six_font_family\":\"Open Sans\",\"main_content_heading_six_custom_font_family\":\"inherit\",\"main_content_heading_six_font_size\":12,\"main_content_heading_six_font_size_unit\":\"px\",\"main_content_heading_six_font_weight\":700,\"main_content_heading_six_alignment\":\"left\",\"main_content_heading_six_line_height\":\"1.4\",\"main_content_heading_six_line_height_unit\":\"em\",\"main_content_heading_six_letter_spacing\":0,\"main_content_heading_six_letter_spacing_unit\":\"px\",\"main_content_heading_six_text_transform\":\"uppercase\",\"main_content_heading_six_text_decoration\":\"none\",\"main_content_lists_font_family\":\"Open Sans\",\"main_content_lists_custom_font_family\":\"inherit\",\"main_content_lists_font_size\":14,\"main_content_lists_font_size_unit\":\"px\",\"main_content_lists_font_weight\":400,\"main_content_lists_alignment\":\"left\",\"main_content_lists_line_height\":\"1.45\",\"main_content_lists_line_height_unit\":\"em\",\"main_content_lists_letter_spacing\":0,\"main_content_lists_letter_spacing_unit\":\"px\",\"main_content_lists_text_transform\":\"none\",\"main_content_lists_text_decoration\":\"none\",\"cta_font_family\":\"Roboto\",\"cta_custom_font_family\":\"inherit\",\"cta_font_size\":14,\"cta_font_size_unit\":\"px\",\"cta_font_weight\":500,\"cta_alignment\":\"center\",\"cta_line_height\":22,\"cta_line_height_unit\":\"px\",\"cta_letter_spacing\":0,\"cta_letter_spacing_unit\":\"px\",\"cta_text_transform\":\"uppercase\",\"cta_text_decoration\":\"none\",\"cta_help_font_family\":\"custom\",\"cta_help_custom_font_family\":\"inherit\",\"cta_help_font_size\":15,\"cta_help_font_size_unit\":\"px\",\"cta_help_font_weight\":\"regular\",\"cta_help_alignment\":\"left\",\"cta_help_line_height\":26,\"cta_help_line_height_unit\":\"px\",\"cta_help_letter_spacing\":-0.25,\"cta_help_letter_spacing_unit\":\"px\",\"cta_help_text_transform\":\"none\",\"cta_help_text_decoration\":\"none\",\"never_see_link_font_family\":\"Roboto\",\"never_see_link_custom_font_family\":\"inherit\",\"never_see_link_font_size\":14,\"never_see_link_font_size_unit\":\"px\",\"never_see_link_font_weight\":\"regular\",\"never_see_link_alignment\":\"center\",\"never_see_link_line_height\":22,\"never_see_link_line_height_unit\":\"px\",\"never_see_link_letter_spacing\":\"-0.22\",\"never_see_link_letter_spacing_unit\":\"px\",\"never_see_link_text_transform\":\"none\",\"never_see_link_text_decoration\":\"none\",\"form_extras_font_family\":\"Open Sans\",\"form_extras_custom_font_family\":\"inherit\",\"form_extras_font_size\":13,\"form_extras_font_size_unit\":\"px\",\"form_extras_font_weight\":700,\"form_extras_alignment\":\"left\",\"form_extras_line_height\":22,\"form_extras_line_height_unit\":\"px\",\"form_extras_letter_spacing\":0,\"form_extras_letter_spacing_unit\":\"px\",\"form_extras_text_transform\":\"none\",\"form_extras_text_decoration\":\"none\",\"input_font_family\":\"Roboto\",\"input_custom_font_family\":\"inherit\",\"input_font_size\":16,\"input_font_size_unit\":\"px\",\"input_font_weight\":\"regular\",\"input_alignment\":\"left\",\"input_line_height\":26,\"input_line_height_unit\":\"px\",\"input_letter_spacing\":\"-0.25\",\"input_letter_spacing_unit\":\"px\",\"input_text_transform\":\"none\",\"input_text_decoration\":\"none\",\"select_font_family\":\"Open Sans\",\"select_custom_font_family\":\"inherit\",\"select_font_size\":13,\"select_font_size_unit\":\"px\",\"select_font_weight\":400,\"select_alignment\":\"left\",\"select_line_height\":18,\"select_line_height_unit\":\"px\",\"select_letter_spacing\":0,\"select_letter_spacing_unit\":\"px\",\"select_text_transform\":\"none\",\"select_text_decoration\":\"\",\"checkbox_font_family\":\"Open Sans\",\"checkbox_custom_font_family\":\"inherit\",\"checkbox_font_size\":12,\"checkbox_font_size_unit\":\"px\",\"checkbox_font_weight\":\"regular\",\"checkbox_alignment\":\"left\",\"checkbox_line_height\":20,\"checkbox_line_height_unit\":\"px\",\"checkbox_letter_spacing\":0,\"checkbox_letter_spacing_unit\":\"px\",\"checkbox_text_transform\":\"none\",\"checkbox_text_decoration\":\"none\",\"dropdown_font_family\":\"Open Sans\",\"dropdown_custom_font_family\":\"inherit\",\"dropdown_font_size\":13,\"dropdown_font_size_unit\":\"px\",\"dropdown_font_weight\":400,\"dropdown_alignment\":\"left\",\"dropdown_line_height\":18,\"dropdown_line_height_unit\":\"px\",\"dropdown_letter_spacing\":0,\"dropdown_letter_spacing_unit\":\"px\",\"dropdown_text_transform\":\"none\",\"dropdown_text_decoration\":\"none\",\"gdpr_font_family\":\"Open Sans\",\"gdpr_custom_font_family\":\"inherit\",\"gdpr_font_size\":12,\"gdpr_font_size_unit\":\"px\",\"gdpr_font_weight\":400,\"gdpr_alignment\":\"left\",\"gdpr_line_height\":\"1.7\",\"gdpr_line_height_unit\":\"em\",\"gdpr_letter_spacing\":0,\"gdpr_letter_spacing_unit\":\"px\",\"gdpr_text_transform\":\"none\",\"gdpr_text_decoration\":\"none\",\"recaptcha_font_family\":\"custom\",\"recaptcha_custom_font_family\":\"inherit\",\"recaptcha_font_size\":15,\"recaptcha_font_size_unit\":\"px\",\"recaptcha_font_weight\":400,\"recaptcha_alignment\":\"left\",\"recaptcha_line_height\":\"1.75\",\"recaptcha_line_height_unit\":\"em\",\"recaptcha_letter_spacing\":\"-0.25\",\"recaptcha_letter_spacing_unit\":\"px\",\"recaptcha_text_transform\":\"none\",\"recaptcha_text_decoration\":\"none\",\"submit_button_font_family\":\"Roboto\",\"submit_button_custom_font_family\":\"inherit\",\"submit_button_font_size\":14,\"submit_button_font_size_unit\":\"px\",\"submit_button_font_weight\":500,\"submit_button_line_height\":22,\"submit_button_line_height_unit\":\"px\",\"submit_button_letter_spacing\":0,\"submit_button_letter_spacing_unit\":\"px\",\"submit_button_text_transform\":\"uppercase\",\"submit_button_text_decoration\":\"none\",\"success_message_paragraph_font_family\":\"Open Sans\",\"success_message_paragraph_custom_font_family\":\"inherit\",\"success_message_paragraph_font_size\":14,\"success_message_paragraph_font_size_unit\":\"px\",\"success_message_paragraph_font_weight\":400,\"success_message_paragraph_alignment\":\"left\",\"success_message_paragraph_line_height\":\"1.45\",\"success_message_paragraph_line_height_unit\":\"em\",\"success_message_paragraph_letter_spacing\":0,\"success_message_paragraph_letter_spacing_unit\":\"px\",\"success_message_paragraph_text_transform\":\"none\",\"success_message_paragraph_text_decoration\":\"none\",\"success_message_heading_one_font_family\":\"Open Sans\",\"success_message_heading_one_custom_font_family\":\"inherit\",\"success_message_heading_one_font_size\":28,\"success_message_heading_one_font_size_unit\":\"px\",\"success_message_heading_one_font_weight\":700,\"success_message_heading_one_alignment\":\"left\",\"success_message_heading_one_line_height\":\"1.4\",\"success_message_heading_one_line_height_unit\":\"em\",\"success_message_heading_one_letter_spacing\":0,\"success_message_heading_one_letter_spacing_unit\":\"px\",\"success_message_heading_one_text_transform\":\"none\",\"success_message_heading_one_text_decoration\":\"none\",\"success_message_heading_two_font_family\":\"Open Sans\",\"success_message_heading_two_custom_font_family\":\"inherit\",\"success_message_heading_two_font_size\":22,\"success_message_heading_two_font_size_unit\":\"px\",\"success_message_heading_two_font_weight\":700,\"success_message_heading_two_alignment\":\"left\",\"success_message_heading_two_line_height\":\"1.4\",\"success_message_heading_two_line_height_unit\":\"em\",\"success_message_heading_two_letter_spacing\":0,\"success_message_heading_two_letter_spacing_unit\":\"px\",\"success_message_heading_two_text_transform\":\"none\",\"success_message_heading_two_text_decoration\":\"none\",\"success_message_heading_three_font_family\":\"Open Sans\",\"success_message_heading_three_custom_font_family\":\"inherit\",\"success_message_heading_three_font_size\":18,\"success_message_heading_three_font_size_unit\":\"px\",\"success_message_heading_three_font_weight\":700,\"success_message_heading_three_alignment\":\"left\",\"success_message_heading_three_line_height\":\"1.4\",\"success_message_heading_three_line_height_unit\":\"em\",\"success_message_heading_three_letter_spacing\":0,\"success_message_heading_three_letter_spacing_unit\":\"px\",\"success_message_heading_three_text_transform\":\"none\",\"success_message_heading_three_text_decoration\":\"none\",\"success_message_heading_four_font_family\":\"Open Sans\",\"success_message_heading_four_custom_font_family\":\"inherit\",\"success_message_heading_four_font_size\":16,\"success_message_heading_four_font_size_unit\":\"px\",\"success_message_heading_four_font_weight\":700,\"success_message_heading_four_alignment\":\"left\",\"success_message_heading_four_line_height\":\"1.4\",\"success_message_heading_four_line_height_unit\":\"em\",\"success_message_heading_four_letter_spacing\":0,\"success_message_heading_four_letter_spacing_unit\":\"px\",\"success_message_heading_four_text_transform\":\"none\",\"success_message_heading_four_text_decoration\":\"none\",\"success_message_heading_five_font_family\":\"Open Sans\",\"success_message_heading_five_custom_font_family\":\"inherit\",\"success_message_heading_five_font_size\":14,\"success_message_heading_five_font_size_unit\":\"px\",\"success_message_heading_five_font_weight\":700,\"success_message_heading_five_alignment\":\"left\",\"success_message_heading_five_line_height\":\"1.4\",\"success_message_heading_five_line_height_unit\":\"em\",\"success_message_heading_five_letter_spacing\":0,\"success_message_heading_five_letter_spacing_unit\":\"px\",\"success_message_heading_five_text_transform\":\"none\",\"success_message_heading_five_text_decoration\":\"none\",\"success_message_heading_six_font_family\":\"Open Sans\",\"success_message_heading_six_custom_font_family\":\"inherit\",\"success_message_heading_six_font_size\":12,\"success_message_heading_six_font_size_unit\":\"px\",\"success_message_heading_six_font_weight\":700,\"success_message_heading_six_alignment\":\"left\",\"success_message_heading_six_line_height\":\"1.4\",\"success_message_heading_six_line_height_unit\":\"em\",\"success_message_heading_six_letter_spacing\":0,\"success_message_heading_six_letter_spacing_unit\":\"px\",\"success_message_heading_six_text_transform\":\"uppercase\",\"success_message_heading_six_text_decoration\":\"none\",\"success_message_lists_font_family\":\"Open Sans\",\"success_message_lists_custom_font_family\":\"inherit\",\"success_message_lists_font_size\":14,\"success_message_lists_font_size_unit\":\"px\",\"success_message_lists_font_weight\":400,\"success_message_lists_alignment\":\"left\",\"success_message_lists_line_height\":\"1.45\",\"success_message_lists_line_height_unit\":\"em\",\"success_message_lists_letter_spacing\":0,\"success_message_lists_letter_spacing_unit\":\"px\",\"success_message_lists_text_transform\":\"none\",\"success_message_lists_text_decoration\":\"none\",\"error_message_font_family\":\"Open Sans\",\"error_message_custom_font_family\":\"inherit\",\"error_message_font_size\":12,\"error_message_font_size_unit\":\"px\",\"error_message_font_weight\":400,\"error_message_alignment\":\"left\",\"error_message_line_height\":20,\"error_message_line_height_unit\":\"px\",\"error_message_letter_spacing\":0,\"error_message_letter_spacing_unit\":\"px\",\"error_message_text_transform\":\"none\",\"error_message_text_decoration\":\"none\",\"title_font_size_mobile\":\"\",\"title_font_size_unit_mobile\":\"px\",\"title_font_weight_mobile\":\"regular\",\"title_alignment_mobile\":\"left\",\"title_line_height_mobile\":\"\",\"title_line_height_unit_mobile\":\"px\",\"title_letter_spacing_mobile\":\"\",\"title_letter_spacing_unit_mobile\":\"px\",\"title_text_transform_mobile\":\"none\",\"title_text_decoration_mobile\":\"none\",\"subtitle_font_size_mobile\":\"\",\"subtitle_font_size_unit_mobile\":\"px\",\"subtitle_font_weight_mobile\":600,\"subtitle_alignment_mobile\":\"left\",\"subtitle_line_height_mobile\":\"\",\"subtitle_line_height_unit_mobile\":\"px\",\"subtitle_letter_spacing_mobile\":\"\",\"subtitle_letter_spacing_unit_mobile\":\"px\",\"subtitle_text_transform_mobile\":\"none\",\"subtitle_text_decoration_mobile\":\"none\",\"main_content_paragraph_font_size_mobile\":\"\",\"main_content_paragraph_font_size_unit_mobile\":\"px\",\"main_content_paragraph_font_weight_mobile\":400,\"main_content_paragraph_alignment_mobile\":\"left\",\"main_content_paragraph_line_height_mobile\":\"\",\"main_content_paragraph_line_height_unit_mobile\":\"em\",\"main_content_paragraph_letter_spacing_mobile\":\"\",\"main_content_paragraph_letter_spacing_unit_mobile\":\"px\",\"main_content_paragraph_text_transform_mobile\":\"none\",\"main_content_paragraph_text_decoration_mobile\":\"none\",\"main_content_heading_one_font_size_mobile\":28,\"main_content_heading_one_font_size_unit_mobile\":\"px\",\"main_content_heading_one_font_weight_mobile\":700,\"main_content_heading_one_alignment_mobile\":\"left\",\"main_content_heading_one_line_height_mobile\":\"1.4\",\"main_content_heading_one_line_height_unit_mobile\":\"em\",\"main_content_heading_one_letter_spacing_mobile\":0,\"main_content_heading_one_letter_spacing_unit_mobile\":\"px\",\"main_content_heading_one_text_transform_mobile\":\"none\",\"main_content_heading_one_text_decoration_mobile\":\"none\",\"main_content_heading_two_font_size_mobile\":22,\"main_content_heading_two_font_size_unit_mobile\":\"px\",\"main_content_heading_two_font_weight_mobile\":700,\"main_content_heading_two_alignment_mobile\":\"left\",\"main_content_heading_two_line_height_mobile\":\"1.4\",\"main_content_heading_two_line_height_unit_mobile\":\"em\",\"main_content_heading_two_letter_spacing_mobile\":0,\"main_content_heading_two_letter_spacing_unit_mobile\":\"px\",\"main_content_heading_two_text_transform_mobile\":\"none\",\"main_content_heading_two_text_decoration_mobile\":\"none\",\"main_content_heading_three_font_size_mobile\":18,\"main_content_heading_three_font_size_unit_mobile\":\"px\",\"main_content_heading_three_font_weight_mobile\":700,\"main_content_heading_three_alignment_mobile\":\"left\",\"main_content_heading_three_line_height_mobile\":\"1.4\",\"main_content_heading_three_line_height_unit_mobile\":\"em\",\"main_content_heading_three_letter_spacing_mobile\":0,\"main_content_heading_three_letter_spacing_unit_mobile\":\"px\",\"main_content_heading_three_text_transform_mobile\":\"none\",\"main_content_heading_three_text_decoration_mobile\":\"none\",\"main_content_heading_four_font_size_mobile\":16,\"main_content_heading_four_font_size_unit_mobile\":\"px\",\"main_content_heading_four_font_weight_mobile\":700,\"main_content_heading_four_alignment_mobile\":\"left\",\"main_content_heading_four_line_height_mobile\":\"1.4\",\"main_content_heading_four_line_height_unit_mobile\":\"em\",\"main_content_heading_four_letter_spacing_mobile\":0,\"main_content_heading_four_letter_spacing_unit_mobile\":\"px\",\"main_content_heading_four_text_transform_mobile\":\"none\",\"main_content_heading_four_text_decoration_mobile\":\"none\",\"main_content_heading_five_font_size_mobile\":14,\"main_content_heading_five_font_size_unit_mobile\":\"px\",\"main_content_heading_five_font_weight_mobile\":700,\"main_content_heading_five_alignment_mobile\":\"left\",\"main_content_heading_five_line_height_mobile\":\"1.4\",\"main_content_heading_five_line_height_unit_mobile\":\"em\",\"main_content_heading_five_letter_spacing_mobile\":0,\"main_content_heading_five_letter_spacing_unit_mobile\":\"px\",\"main_content_heading_five_text_transform_mobile\":\"none\",\"main_content_heading_five_text_decoration_mobile\":\"none\",\"main_content_heading_six_font_size_mobile\":12,\"main_content_heading_six_font_size_unit_mobile\":\"px\",\"main_content_heading_six_font_weight_mobile\":700,\"main_content_heading_six_alignment_mobile\":\"left\",\"main_content_heading_six_line_height_mobile\":\"1.4\",\"main_content_heading_six_line_height_unit_mobile\":\"em\",\"main_content_heading_six_letter_spacing_mobile\":0,\"main_content_heading_six_letter_spacing_unit_mobile\":\"px\",\"main_content_heading_six_text_transform_mobile\":\"uppercase\",\"main_content_heading_six_text_decoration_mobile\":\"none\",\"main_content_lists_font_size_mobile\":14,\"main_content_lists_font_size_unit_mobile\":\"px\",\"main_content_lists_font_weight_mobile\":400,\"main_content_lists_alignment_mobile\":\"left\",\"main_content_lists_line_height_mobile\":\"1.45\",\"main_content_lists_line_height_unit_mobile\":\"em\",\"main_content_lists_letter_spacing_mobile\":0,\"main_content_lists_letter_spacing_unit_mobile\":\"px\",\"main_content_lists_text_transform_mobile\":\"none\",\"main_content_lists_text_decoration_mobile\":\"none\",\"cta_font_size_mobile\":\"\",\"cta_font_size_unit_mobile\":\"px\",\"cta_font_weight_mobile\":\"bold\",\"cta_alignment_mobile\":\"center\",\"cta_line_height_mobile\":\"\",\"cta_line_height_unit_mobile\":\"px\",\"cta_letter_spacing_mobile\":\"\",\"cta_letter_spacing_unit_mobile\":\"px\",\"cta_text_transform_mobile\":\"none\",\"cta_text_decoration_mobile\":\"none\",\"cta_help_font_size_mobile\":\"\",\"cta_help_font_size_unit_mobile\":\"px\",\"cta_help_font_weight_mobile\":\"regular\",\"cta_help_alignment_mobile\":\"left\",\"cta_help_line_height_mobile\":\"\",\"cta_help_line_height_unit_mobile\":\"em\",\"cta_help_letter_spacing_mobile\":\"\",\"cta_help_letter_spacing_unit_mobile\":\"px\",\"cta_help_text_transform_mobile\":\"none\",\"cta_help_text_decoration_mobile\":\"none\",\"never_see_link_font_size_mobile\":\"\",\"never_see_link_font_size_unit_mobile\":\"px\",\"never_see_link_font_weight_mobile\":400,\"never_see_link_alignment_mobile\":\"center\",\"never_see_link_line_height_mobile\":\"\",\"never_see_link_line_height_unit_mobile\":\"px\",\"never_see_link_letter_spacing_mobile\":\"\",\"never_see_link_letter_spacing_unit_mobile\":\"px\",\"never_see_link_text_transform_mobile\":\"none\",\"never_see_link_text_decoration_mobile\":\"none\",\"form_extras_font_size_mobile\":\"\",\"form_extras_font_size_unit_mobile\":\"px\",\"form_extras_font_weight_mobile\":\"bold\",\"form_extras_alignment_mobile\":\"left\",\"form_extras_line_height_mobile\":\"\",\"form_extras_line_height_unit_mobile\":\"px\",\"form_extras_letter_spacing_mobile\":\"\",\"form_extras_letter_spacing_unit_mobile\":\"px\",\"form_extras_text_transform_mobile\":\"none\",\"form_extras_text_decoration_mobile\":\"none\",\"input_font_size_mobile\":\"\",\"input_font_size_unit_mobile\":\"px\",\"input_font_weight_mobile\":400,\"input_alignment_mobile\":\"left\",\"input_line_height_mobile\":\"\",\"input_line_height_unit_mobile\":\"px\",\"input_letter_spacing_mobile\":\"\",\"input_letter_spacing_unit_mobile\":\"px\",\"input_text_transform_mobile\":\"none\",\"input_text_decoration_mobile\":\"none\",\"select_font_size_mobile\":13,\"select_font_size_unit_mobile\":\"px\",\"select_font_weight_mobile\":400,\"select_alignment_mobile\":\"left\",\"select_line_height_mobile\":18,\"select_line_height_unit_mobile\":\"px\",\"select_letter_spacing_mobile\":0,\"select_letter_spacing_unit_mobile\":\"px\",\"select_text_transform_mobile\":\"none\",\"select_text_decoration_mobile\":\"\",\"checkbox_font_size_mobile\":\"\",\"checkbox_font_size_unit_mobile\":\"px\",\"checkbox_font_weight_mobile\":400,\"checkbox_alignment_mobile\":\"left\",\"checkbox_line_height_mobile\":\"\",\"checkbox_line_height_unit_mobile\":\"px\",\"checkbox_letter_spacing_mobile\":\"\",\"checkbox_letter_spacing_unit_mobile\":\"px\",\"checkbox_text_transform_mobile\":\"none\",\"checkbox_text_decoration_mobile\":\"none\",\"dropdown_font_size_mobile\":\"\",\"dropdown_font_size_unit_mobile\":\"px\",\"dropdown_font_weight_mobile\":400,\"dropdown_alignment_mobile\":\"left\",\"dropdown_line_height_mobile\":\"\",\"dropdown_line_height_unit_mobile\":\"px\",\"dropdown_letter_spacing_mobile\":\"\",\"dropdown_letter_spacing_unit_mobile\":\"px\",\"dropdown_text_transform_mobile\":\"none\",\"dropdown_text_decoration_mobile\":\"none\",\"gdpr_font_size_mobile\":\"\",\"gdpr_font_size_unit_mobile\":\"px\",\"gdpr_font_weight_mobile\":400,\"gdpr_alignment_mobile\":\"left\",\"gdpr_line_height_mobile\":\"\",\"gdpr_line_height_unit_mobile\":\"em\",\"gdpr_letter_spacing_mobile\":\"\",\"gdpr_letter_spacing_unit_mobile\":\"px\",\"gdpr_text_transform_mobile\":\"none\",\"gdpr_text_decoration_mobile\":\"none\",\"recaptcha_font_size_mobile\":15,\"recaptcha_font_size_unit_mobile\":\"px\",\"recaptcha_font_weight_mobile\":400,\"recaptcha_alignment_mobile\":\"left\",\"recaptcha_line_height_mobile\":\"1.75\",\"recaptcha_line_height_unit_mobile\":\"em\",\"recaptcha_letter_spacing_mobile\":\"-0.25\",\"recaptcha_letter_spacing_unit_mobile\":\"px\",\"recaptcha_text_transform_mobile\":\"none\",\"recaptcha_text_decoration_mobile\":\"none\",\"submit_button_font_size_mobile\":\"\",\"submit_button_font_size_unit_mobile\":\"px\",\"submit_button_font_weight_mobile\":\"bold\",\"submit_button_line_height_mobile\":\"\",\"submit_button_line_height_unit_mobile\":\"px\",\"submit_button_letter_spacing_mobile\":\"\",\"submit_button_letter_spacing_unit_mobile\":\"px\",\"submit_button_text_transform_mobile\":\"none\",\"submit_button_text_decoration_mobile\":\"none\",\"success_message_paragraph_font_size_mobile\":\"\",\"success_message_paragraph_font_size_unit_mobile\":\"px\",\"success_message_paragraph_font_weight_mobile\":400,\"success_message_paragraph_alignment_mobile\":\"left\",\"success_message_paragraph_line_height_mobile\":\"\",\"success_message_paragraph_line_height_unit_mobile\":\"em\",\"success_message_paragraph_letter_spacing_mobile\":\"\",\"success_message_paragraph_letter_spacing_unit_mobile\":\"px\",\"success_message_paragraph_text_transform_mobile\":\"none\",\"success_message_paragraph_text_decoration_mobile\":\"none\",\"success_message_heading_one_font_size_mobile\":28,\"success_message_heading_one_font_size_unit_mobile\":\"px\",\"success_message_heading_one_font_weight_mobile\":700,\"success_message_heading_one_alignment_mobile\":\"left\",\"success_message_heading_one_line_height_mobile\":\"1.4\",\"success_message_heading_one_line_height_unit_mobile\":\"em\",\"success_message_heading_one_letter_spacing_mobile\":0,\"success_message_heading_one_letter_spacing_unit_mobile\":\"px\",\"success_message_heading_one_text_transform_mobile\":\"none\",\"success_message_heading_one_text_decoration_mobile\":\"none\",\"success_message_heading_two_font_size_mobile\":22,\"success_message_heading_two_font_size_unit_mobile\":\"px\",\"success_message_heading_two_font_weight_mobile\":700,\"success_message_heading_two_alignment_mobile\":\"left\",\"success_message_heading_two_line_height_mobile\":\"1.4\",\"success_message_heading_two_line_height_unit_mobile\":\"em\",\"success_message_heading_two_letter_spacing_mobile\":0,\"success_message_heading_two_letter_spacing_unit_mobile\":\"px\",\"success_message_heading_two_text_transform_mobile\":\"none\",\"success_message_heading_two_text_decoration_mobile\":\"none\",\"success_message_heading_three_font_size_mobile\":18,\"success_message_heading_three_font_size_unit_mobile\":\"px\",\"success_message_heading_three_font_weight_mobile\":700,\"success_message_heading_three_alignment_mobile\":\"left\",\"success_message_heading_three_line_height_mobile\":\"1.4\",\"success_message_heading_three_line_height_unit_mobile\":\"em\",\"success_message_heading_three_letter_spacing_mobile\":0,\"success_message_heading_three_letter_spacing_unit_mobile\":\"px\",\"success_message_heading_three_text_transform_mobile\":\"none\",\"success_message_heading_three_text_decoration_mobile\":\"none\",\"success_message_heading_four_font_size_mobile\":16,\"success_message_heading_four_font_size_unit_mobile\":\"px\",\"success_message_heading_four_font_weight_mobile\":700,\"success_message_heading_four_alignment_mobile\":\"left\",\"success_message_heading_four_line_height_mobile\":\"1.4\",\"success_message_heading_four_line_height_unit_mobile\":\"em\",\"success_message_heading_four_letter_spacing_mobile\":0,\"success_message_heading_four_letter_spacing_unit_mobile\":\"px\",\"success_message_heading_four_text_transform_mobile\":\"none\",\"success_message_heading_four_text_decoration_mobile\":\"none\",\"success_message_heading_five_font_size_mobile\":14,\"success_message_heading_five_font_size_unit_mobile\":\"px\",\"success_message_heading_five_font_weight_mobile\":700,\"success_message_heading_five_alignment_mobile\":\"left\",\"success_message_heading_five_line_height_mobile\":\"1.4\",\"success_message_heading_five_line_height_unit_mobile\":\"em\",\"success_message_heading_five_letter_spacing_mobile\":0,\"success_message_heading_five_letter_spacing_unit_mobile\":\"px\",\"success_message_heading_five_text_transform_mobile\":\"none\",\"success_message_heading_five_text_decoration_mobile\":\"none\",\"success_message_heading_six_font_size_mobile\":12,\"success_message_heading_six_font_size_unit_mobile\":\"px\",\"success_message_heading_six_font_weight_mobile\":700,\"success_message_heading_six_alignment_mobile\":\"left\",\"success_message_heading_six_line_height_mobile\":\"1.4\",\"success_message_heading_six_line_height_unit_mobile\":\"em\",\"success_message_heading_six_letter_spacing_mobile\":0,\"success_message_heading_six_letter_spacing_unit_mobile\":\"px\",\"success_message_heading_six_text_transform_mobile\":\"uppercase\",\"success_message_heading_six_text_decoration_mobile\":\"none\",\"success_message_lists_font_size_mobile\":14,\"success_message_lists_font_size_unit_mobile\":\"px\",\"success_message_lists_font_weight_mobile\":400,\"success_message_lists_alignment_mobile\":\"left\",\"success_message_lists_line_height_mobile\":\"1.45\",\"success_message_lists_line_height_unit_mobile\":\"em\",\"success_message_lists_letter_spacing_mobile\":0,\"success_message_lists_letter_spacing_unit_mobile\":\"px\",\"success_message_lists_text_transform_mobile\":\"none\",\"success_message_lists_text_decoration_mobile\":\"none\",\"error_message_font_size_mobile\":\"\",\"error_message_font_size_unit_mobile\":\"px\",\"error_message_font_weight_mobile\":400,\"error_message_alignment_mobile\":\"left\",\"error_message_line_height_mobile\":\"\",\"error_message_line_height_unit_mobile\":\"px\",\"error_message_letter_spacing_mobile\":\"\",\"error_message_letter_spacing_unit_mobile\":\"px\",\"error_message_text_transform_mobile\":\"none\",\"error_message_text_decoration_mobile\":\"none\",\"base_template\":\"minimalist\"}");
INSERT INTO `wp_hustle_modules_meta` VALUES("5", "1", "settings", "{\"auto_close_success_message\":\"0\",\"triggers\":{\"trigger\":[\"time\"],\"on_time_delay\":\"3\",\"on_time_unit\":\"seconds\",\"on_scroll\":\"scrolled\",\"on_scroll_page_percent\":20,\"on_scroll_css_selector\":\"\",\"enable_on_click_element\":\"1\",\"on_click_element\":\"\",\"enable_on_click_shortcode\":\"1\",\"on_exit_intent_per_session\":\"1\",\"on_exit_intent_delayed_time\":\"0\",\"on_exit_intent_delayed_unit\":\"seconds\",\"on_adblock_delay\":\"0\",\"on_adblock_delay_unit\":\"seconds\"},\"animation_in\":\"no_animation\",\"animation_out\":\"fadeOut\",\"after_close\":\"keep_show\",\"expiration\":365,\"expiration_unit\":\"days\",\"after_optin_expiration\":365,\"after_optin_expiration_unit\":\"days\",\"after_cta_expiration\":365,\"after_cta2_expiration\":365,\"after_cta_expiration_unit\":\"days\",\"after_cta2_expiration_unit\":\"days\",\"on_submit\":\"nothing\",\"on_submit_delay\":\"5\",\"on_submit_delay_unit\":\"seconds\",\"close_cta\":\"0\",\"close_cta_time\":\"0\",\"close_cta_unit\":\"seconds\",\"hide_after_cta\":\"keep_show\",\"hide_after_cta2\":\"keep_show\",\"hide_after_subscription\":\"keep_show\",\"is_schedule\":\"0\",\"schedule\":{\"not_schedule_start\":\"1\",\"start_date\":\"09\\/04\\/2024\",\"start_hour\":\"12\",\"start_minute\":\"00\",\"start_meridiem_offset\":\"am\",\"not_schedule_end\":\"1\",\"end_date\":\"09\\/10\\/2024\",\"end_hour\":\"11\",\"end_minute\":\"59\",\"end_meridiem_offset\":\"pm\",\"active_days\":\"all\",\"week_days\":[],\"is_active_all_day\":\"1\",\"day_start_hour\":\"00\",\"day_start_minute\":\"00\",\"day_start_meridiem_offset\":\"am\",\"day_end_hour\":\"11\",\"day_end_minute\":\"59\",\"day_end_meridiem_offset\":\"pm\",\"time_to_use\":\"server\",\"custom_timezone\":\"UTC\"},\"allow_scroll_page\":\"0\",\"close_on_background_click\":\"1\",\"auto_hide\":\"0\",\"auto_hide_unit\":\"seconds\",\"auto_hide_time\":\"5\",\"after_close_trigger\":[\"click_close_icon\"]}");
INSERT INTO `wp_hustle_modules_meta` VALUES("6", "1", "visibility", "{\"conditions\":{\"191b6e20875\":{\"group_id\":\"191b6e20875\",\"show_or_hide_conditions\":\"show\",\"filter_type\":\"all\",\"pages\":{\"filter_type\":\"except\"}}}}");
INSERT INTO `wp_hustle_modules_meta` VALUES("7", "1", "track_types", "{\"popup\":true}");
INSERT INTO `wp_hustle_modules_meta` VALUES("8", "1", "schedule_flags", "{\"is_currently_scheduled\":\"1\",\"check_schedule_at\":\"0\"}");

/* INSERT TABLE DATA: wp_hustle_tracking */
INSERT INTO `wp_hustle_tracking` VALUES("1", "1", "224", "popup", "view", "62.194.143.145", "8", "2024-09-03 08:58:57", "2024-09-03 09:25:17");

/* INSERT TABLE DATA: wp_kls_consentlog */
INSERT INTO `wp_kls_consentlog` VALUES("2", "2023-02-15 15:06:09", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("3", "2023-02-15 16:26:07", "109.37.143.48", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("4", "2023-02-21 08:03:05", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("5", "2023-02-28 16:22:08", "84.85.12.78", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("6", "2023-08-29 11:10:08", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("7", "2024-01-02 12:05:06", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("8", "2024-03-13 08:33:40", "198.16.74.203", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("9", "2024-03-13 08:33:42", "198.16.74.203", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("10", "2024-05-13 09:50:56", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("11", "2024-05-15 07:29:32", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("12", "2024-05-15 08:13:18", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("13", "2024-08-26 10:38:02", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("14", "2024-08-27 10:26:54", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("15", "2024-08-27 17:36:45", "77.175.206.202", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("16", "2024-08-28 07:44:08", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("17", "2024-08-30 09:37:25", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("18", "2024-08-30 09:39:31", "62.194.143.145", "accepted", "[\"necessary\"]", "");
INSERT INTO `wp_kls_consentlog` VALUES("19", "2024-08-30 09:40:17", "62.194.143.145", "accepted", "[\"necessary\"]", "");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://opzetstan2.opzet-website.nl", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://opzetstan2.opzet-website.nl", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Opzet", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Dit wordt jouw website", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "server@klassebv.nl", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "d/m/Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:15:{i:0;s:15:\"worker/init.php\";i:1;s:29:\"gravityforms/gravityforms.php\";i:2;s:47:\"better-search-replace/better-search-replace.php\";i:3;s:48:\"capability-manager-enhanced/capsman-enhanced.php\";i:4;s:44:\"click-to-chat-for-whatsapp/click-to-chat.php\";i:5;s:29:\"divi-builder/divi-builder.php\";i:6;s:25:\"duplicator/duplicator.php\";i:7;s:31:\"klasse-plugin/klasse-plugin.php\";i:8;s:27:\"redirection/redirection.php\";i:9;s:53:\"supreme-modules-for-divi/supreme-modules-for-divi.php\";i:10;s:29:\"widget-google-reviews/grw.php\";i:11;s:27:\"wordpress-popup/popover.php\";i:12;s:24:\"wordpress-seo/wp-seo.php\";i:13;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:14;s:23:\"wp-rocket/wp-rocket.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "1", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:89:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/plugins/ninja-forms/ninja-forms.php\";i:1;s:109:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/plugins/better-search-replace/better-search-replace.php\";i:2;s:93:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/plugins/klasse-plugin/klasse-plugin.php\";i:3;s:87:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/themes/klasse-theme/functions.php\";i:4;s:83:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/themes/klasse-theme/style.css\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "klasse-theme", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "klasse-theme", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/uploads", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:9:{s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:47:\"wp-security-audit-log/wp-security-audit-log.php\";a:2:{i:0;s:30:\"\\WSAL\\Helpers\\Uninstall_Helper\";i:1;s:9:\"uninstall\";}s:27:\"ninja-forms/ninja-forms.php\";s:21:\"ninja_forms_uninstall\";s:27:\"wp-optimize/wp-optimize.php\";a:2:{i:0;s:13:\"WPO_Uninstall\";i:1;s:7:\"actions\";}s:61:\"wp-security-audit-log/classes/class-wp-security-audit-log.php\";a:2:{i:0;s:30:\"\\WSAL\\Helpers\\Uninstall_Helper\";i:1;s:9:\"uninstall\";}s:44:\"click-to-chat-for-whatsapp/click-to-chat.php\";a:2:{i:0;s:15:\"HT_CTC_Register\";i:1;s:9:\"uninstall\";}s:27:\"redirection/redirection.php\";a:2:{i:0;s:17:\"Redirection_Admin\";i:1;s:16:\"plugin_uninstall\";}s:27:\"popup-maker/popup-maker.php\";a:2:{i:0;s:11:\"PUM_Install\";i:1;s:16:\"uninstall_plugin\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "15", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "85", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1735554024", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:107:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;s:37:\"manage_capabilities_frontend_features\";b:1;s:11:\"hustle_menu\";b:1;s:18:\"hustle_edit_module\";b:1;s:13:\"hustle_create\";b:1;s:24:\"hustle_edit_integrations\";b:1;s:20:\"hustle_access_emails\";b:1;s:20:\"hustle_edit_settings\";b:1;s:16:\"hustle_analytics\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:46:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:37:\"manage_capabilities_frontend_features\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:20:\"edit_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:58:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;s:18:\"edit_theme_options\";b:1;s:25:\"gravityforms_view_entries\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "sidebars_widgets", "a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:8:\"footer-1\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:19:\"woocommerce-sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:35:{i:1725362848;a:1:{s:22:\"forminator_send_export\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1725362869;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1725362876;a:1:{s:30:\"rocket_preload_process_pending\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"rocket_preload_process_pending\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1725363338;a:1:{s:23:\"rocket_purge_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:34:\"rocket_expired_cache_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1725364475;a:1:{s:38:\"hustle_general_data_protection_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1725365025;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1725366297;a:1:{s:12:\"wsal_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1725374335;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725380097;a:1:{s:18:\"wsal_delete_logins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725389045;a:1:{s:41:\"puc_cron_check_updates_theme-klasse-theme\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725389809;a:1:{s:36:\"puc_cron_check_updates-klasse-plugin\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725393825;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725393910;a:1:{s:37:\"rocket_preload_revert_old_failed_rows\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:29:\"rocket_revert_old_failed_rows\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725403433;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725408000;a:1:{s:18:\"send_url_to_portal\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725408941;a:1:{s:32:\"rocket_performance_hints_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725416132;a:1:{s:18:\"rocket_atf_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725430853;a:1:{s:19:\"grw_revupd_schedule\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725432191;a:1:{s:26:\"dm_admin_cron_notice_check\";a:1:{s:32:\"dd4d6eb78a154fb59dc300ada4733b5a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:2:{i:0;s:3:\"pfd\";i:1;s:2:\"dm\";}s:8:\"interval\";i:86400;}}}i:1725437025;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725438133;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725438135;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725438253;a:1:{s:26:\"pum_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725438919;a:1:{s:22:\"mwp_update_public_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725438938;a:3:{s:27:\"rocket_cache_dir_size_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725483231;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1725496326;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725523425;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1725547233;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1725673676;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1725886800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1725932449;a:1:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1725956653;a:1:{s:27:\"pum_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1727512527;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("119", "theme_mods_twentytwentyone", "a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1643361187;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";}", "no");
INSERT INTO `wp_options` VALUES("120", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("128", "_transient_update_plugins", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("129", "_transient_update_themes", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("132", "limit_login_activation_timestamp", "1641974628", "no");
INSERT INTO `wp_options` VALUES("133", "limit_login_notice_enable_notify_timestamp", "1639209828", "no");
INSERT INTO `wp_options` VALUES("156", "kls_speed_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("157", "kls_dequeue_styles", "wp-block-library, dashicons", "yes");
INSERT INTO `wp_options` VALUES("158", "kls_updates_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("159", "kls_wordpress_standard_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("160", "kls_dashboard_clean_up_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("161", "kls_admin_select", "Klasse B.V.", "yes");
INSERT INTO `wp_options` VALUES("162", "kls_cookie_title", "Over onze cookies", "yes");
INSERT INTO `wp_options` VALUES("163", "kls_cookie_text", "Wij gebruiken cookies om de website zo soepel mogelijk te laten werken. Als je doorgaat met het gebruiken van de website, gaan we ervan uit dat je hiermee instemt.", "yes");
INSERT INTO `wp_options` VALUES("164", "kls_cookie_button_text", "Ga verder!", "yes");
INSERT INTO `wp_options` VALUES("165", "kls_cookie_button_color", "", "yes");
INSERT INTO `wp_options` VALUES("166", "kls_cookie_button_background_color", "", "yes");
INSERT INTO `wp_options` VALUES("167", "kls_cookie_link_text", "Lees meer...", "yes");
INSERT INTO `wp_options` VALUES("168", "kls_cookie_link", "11", "yes");
INSERT INTO `wp_options` VALUES("169", "kls_maintenance_title", "Website is momenteel in onderhoud.", "yes");
INSERT INTO `wp_options` VALUES("170", "kls_maintenance_text", "", "yes");
INSERT INTO `wp_options` VALUES("171", "recently_activated", "a:2:{s:26:\"popups-for-divi/plugin.php\";i:1725350089;s:27:\"popup-maker/popup-maker.php\";i:1725350084;}", "yes");
INSERT INTO `wp_options` VALUES("172", "kls_admin_name", "Klasse Software & Development B.V.", "yes");
INSERT INTO `wp_options` VALUES("173", "kls_admin_email", "info@klassebv.nl", "yes");
INSERT INTO `wp_options` VALUES("174", "kls_admin_phone", "-", "yes");
INSERT INTO `wp_options` VALUES("175", "kls_admin_website", "https://klassebv.nl", "yes");
INSERT INTO `wp_options` VALUES("176", "kls_admin_street", "Kerkenbos 1039 2e etage", "yes");
INSERT INTO `wp_options` VALUES("177", "kls_admin_postal_code", "6546BB", "yes");
INSERT INTO `wp_options` VALUES("178", "kls_admin_city", "Nijmegen", "yes");
INSERT INTO `wp_options` VALUES("179", "kls_admin_country", "Nederland", "yes");
INSERT INTO `wp_options` VALUES("180", "kls_admin_logo", "logo_klasse.png", "yes");
INSERT INTO `wp_options` VALUES("181", "kls_admin_favicon", "favicon_klasse.png", "yes");
INSERT INTO `wp_options` VALUES("183", "external_updates-klasse-plugin", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1725350073;s:14:\"checkedVersion\";s:6:\"0.1.20\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:13:\"klasse-plugin\";s:7:\"version\";s:6:\"0.1.25\";s:12:\"download_url\";s:94:\"https://api.github.com/repos/Klasse-Software-Development-B-V/klasse-plugin/zipball/development\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:48:\"https://github.com/joerivanderstek/klasse-plugin\";s:6:\"tested\";s:5:\"5.9.1\";s:12:\"requires_php\";s:3:\"7.4\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:31:\"klasse-plugin/klasse-plugin.php\";}s:11:\"updateClass\";s:50:\"YahnisElsts\\PluginUpdateChecker\\v5p4\\Plugin\\Update\";s:15:\"updateBaseClass\";s:13:\"Plugin\\Update\";}", "off");
INSERT INTO `wp_options` VALUES("186", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("191", "kls_beta_updates_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("192", "kls_deinstallation_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("198", "current_theme", "Klasse Theme", "yes");
INSERT INTO `wp_options` VALUES("199", "theme_mods_klasse-theme", "a:175:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:4;}s:17:\"content_max_width\";s:6:\"1305px\";s:21:\"navigation_breakpoint\";s:5:\"768px\";s:21:\"navigation_item_color\";s:7:\"#212121\";s:28:\"navigation_item_active_color\";s:7:\"#222222\";s:27:\"navigation_item_hover_color\";s:7:\"#ffffff\";s:25:\"navigation_sub_item_color\";s:7:\"#888888\";s:32:\"navigation_sub_item_active_color\";s:7:\"#222222\";s:31:\"navigation_sub_item_hover_color\";s:7:\"#222222\";s:36:\"navigation_sub_item_background_color\";s:7:\"#ffffff\";s:32:\"navigation_sub_item_border_color\";s:7:\"#eeeeee\";s:22:\"main_navigation_toggle\";i:1;s:23:\"main_navigation_version\";s:10:\"default-v1\";s:32:\"main_navigation_background_color\";s:7:\"#ffffff\";s:39:\"main_navigation_scroll_background_color\";s:7:\"#ffffff\";s:25:\"main_navigation_font_size\";s:4:\"18px\";s:30:\"main_navigation_icon_font_size\";s:4:\"20px\";s:22:\"top_navigation_version\";s:10:\"default-v1\";s:31:\"top_navigation_background_color\";s:7:\"#324988\";s:37:\"top_navigation_fixed_background_color\";s:7:\"#324988\";s:25:\"top_navigation_item_color\";s:7:\"#dddddd\";s:32:\"top_navigation_item_active_color\";s:7:\"#ffffff\";s:31:\"top_navigation_item_hover_color\";s:7:\"#ffffff\";s:24:\"top_navigation_font_size\";s:4:\"15px\";s:25:\"mobile_navigation_version\";s:10:\"default-v1\";s:27:\"mobile_navigation_font_size\";s:4:\"14px\";s:35:\"mobile_navigation_menu_toggle_color\";s:7:\"#888888\";s:37:\"mobile_navigation_contact_title_color\";s:7:\"#222222\";s:36:\"mobile_navigation_contact_link_color\";s:7:\"#888888\";s:41:\"mobile_navigation_contact_title_font_size\";s:4:\"24px\";s:34:\"mobile_navigation_background_color\";s:7:\"#ffffff\";s:53:\"mobile_bottom_bar_logo_above_content_background_color\";s:7:\"#ffffff\";s:29:\"mobile_bottom_bar_logo_toggle\";i:1;s:43:\"mobile_bottom_bar_logo_above_content_toggle\";i:0;s:32:\"mobile_bottom_bar_icon_font_size\";s:4:\"18px\";s:29:\"mobile_bottom_bar_icons_color\";s:7:\"#888888\";s:36:\"mobile_bottom_bar_icons_active_color\";s:7:\"#222222\";s:33:\"mobile_bottom_bar_v2_contact_link\";s:9:\"/contact/\";s:21:\"general_theme_version\";s:2:\"v1\";s:51:\"general_disable_standard_woocommerce_styling_toggle\";i:1;s:24:\"general_menu_cart_toggle\";i:1;s:28:\"general_menu_wishlist_toggle\";i:1;s:24:\"general_hot_label_toggle\";i:1;s:26:\"general_sales_label_toggle\";i:1;s:37:\"general_sales_label_percentage_toggle\";i:1;s:32:\"general_image_zoom_effect_toggle\";i:1;s:36:\"cart_recently_viewed_products_toggle\";i:1;s:36:\"cart_recently_viewed_products_amount\";s:1:\"3\";s:19:\"cart_upsells_toggle\";i:1;s:20:\"checkout_menu_toggle\";i:1;s:22:\"checkout_footer_toggle\";i:1;s:27:\"checkout_field_order_toggle\";i:1;s:22:\"archive_sidebar_toggle\";i:1;s:26:\"archive_ajax_filter_toggle\";i:1;s:31:\"archive_products_per_page_count\";s:2:\"12\";s:20:\"archive_price_toggle\";i:1;s:23:\"archive_wishlist_toggle\";i:1;s:24:\"archive_quickview_toggle\";i:1;s:31:\"archive_filter_read_more_toggle\";i:0;s:31:\"archive_filter_read_more_amount\";s:1:\"6\";s:29:\"archive_add_divi_shortcode_id\";s:4:\"none\";s:18:\"product_sku_toggle\";i:0;s:25:\"product_categories_toggle\";i:0;s:19:\"product_tags_toggle\";i:0;s:39:\"product_variation_selection_mode_select\";s:5:\"label\";s:31:\"product_related_products_toggle\";i:1;s:30:\"product_related_products_count\";s:1:\"4\";s:37:\"product_related_products_column_count\";s:1:\"4\";s:23:\"product_up_sells_toggle\";i:1;s:22:\"product_up_sells_count\";s:1:\"4\";s:29:\"product_up_sells_column_count\";s:1:\"4\";s:29:\"product_add_divi_shortcode_id\";s:4:\"none\";s:34:\"product_variation_read_more_toggle\";i:0;s:34:\"product_variation_read_more_amount\";s:1:\"6\";s:40:\"wishlist_recently_viewed_products_toggle\";i:1;s:40:\"wishlist_recently_viewed_products_amount\";s:1:\"3\";s:28:\"wishlist_stock_status_toggle\";i:1;s:27:\"my_account_downloads_toggle\";i:1;s:13:\"footer_toggle\";i:0;s:14:\"footer_version\";s:10:\"default-v1\";s:20:\"footer_creation_type\";s:7:\"default\";s:21:\"main_footer_font_size\";s:4:\"15px\";s:29:\"main_footer_heading_font_size\";s:4:\"27px\";s:28:\"main_footer_background_color\";s:7:\"#324988\";s:22:\"main_footer_text_color\";s:7:\"#ffffff\";s:30:\"main_footer_heading_text_color\";s:7:\"#ffffff\";s:22:\"main_footer_link_color\";s:7:\"#ffffff\";s:28:\"main_footer_link_hover_color\";s:7:\"#ffffff\";s:20:\"bottom_footer_toggle\";i:1;s:23:\"bottom_footer_font_size\";s:4:\"15px\";s:30:\"bottom_footer_background_color\";s:7:\"#324988\";s:24:\"bottom_footer_text_color\";s:7:\"#ffffff\";s:24:\"bottom_footer_link_color\";s:7:\"#ffffff\";s:30:\"bottom_footer_link_hover_color\";s:7:\"#ffffff\";s:17:\"theme_404_version\";s:10:\"default-v1\";s:19:\"google_fonts_toggle\";i:0;s:17:\"kls_headings_font\";s:9:\"Open Sans\";s:13:\"kls_body_font\";s:9:\"Open Sans\";s:13:\"primary_color\";s:7:\"#324988\";s:15:\"secundary_color\";s:7:\"#324988\";s:18:\"heading_text_color\";s:7:\"#ffffff\";s:15:\"body_text_color\";s:7:\"#e5e5e5\";s:17:\"button_link_color\";s:7:\"#222222\";s:23:\"button_link_hover_color\";s:7:\"#222222\";s:20:\"button_primary_color\";s:7:\"#57c181\";s:31:\"button_primary_background_color\";s:7:\"#ffffff\";s:27:\"button_primary_border_color\";s:7:\"#57c181\";s:26:\"button_primary_hover_color\";s:7:\"#ffffff\";s:37:\"button_primary_hover_background_color\";s:7:\"#ffffff\";s:33:\"button_primary_hover_border_color\";s:7:\"#57c181\";s:22:\"button_secundary_color\";s:7:\"#222222\";s:33:\"button_secundary_background_color\";s:7:\"#eeeeee\";s:29:\"button_secundary_border_color\";s:7:\"#eeeeee\";s:28:\"button_secundary_hover_color\";s:7:\"#eeeeee\";s:39:\"button_secundary_hover_background_color\";s:7:\"#222222\";s:35:\"button_secundary_hover_border_color\";s:7:\"#222222\";s:18:\"custom_css_post_id\";i:-1;s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:17:\"navigation_toggle\";i:1;s:23:\"fixed_navigation_toggle\";i:1;s:21:\"top_navigation_toggle\";i:1;s:22:\"bottom_footer_link_one\";i:85;s:22:\"bottom_footer_link_two\";i:86;s:24:\"bottom_footer_link_three\";i:87;s:23:\"bottom_footer_link_four\";s:0:\"\";s:18:\"main_footer_toggle\";i:1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1643361147;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:8:\"footer-1\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:19:\"woocommerce-sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}s:36:\"kls_featured_button_mobile_menu_text\";s:21:\"Volg ons op instagram\";s:36:\"kls_featured_button_mobile_menu_link\";b:0;s:33:\"mobile_bottom_bar_v2_contact_text\";s:7:\"Contact\";s:33:\"mobile_bottom_bar_v2_contact_icon\";s:15:\"fas fa-envelope\";s:29:\"archive_filter_read_more_text\";s:9:\"Lees meer\";s:32:\"product_variation_read_more_text\";s:9:\"Lees meer\";s:26:\"mobile_navigation_position\";s:3:\"top\";s:19:\"mobile_menu_version\";s:10:\"default-v1\";s:37:\"mobile_navigation_toggle_contact_info\";i:1;s:20:\"mobile_menu_position\";s:5:\"right\";s:34:\"top_navigation_toggle_contact_info\";i:0;s:39:\"top_navigation_toggle_contact_info_text\";i:0;s:26:\"top_navigation_toggle_menu\";i:1;s:29:\"top_navigation_toggle_socials\";i:1;s:34:\"top_navigation_toggle_socials_text\";i:1;s:26:\"top_navigation_toggle_usps\";i:1;s:37:\"top_navigation_toggle_usp_icon_images\";i:0;s:25:\"top_navigation_usp_amount\";s:1:\"3\";s:17:\"404_search_toggle\";i:0;s:19:\"custom_fonts_toggle\";i:1;s:24:\"theme_404_button_styling\";s:7:\"primary\";s:25:\"kls_checkout_flow_version\";s:2:\"v3\";s:21:\"kls_mini_cart_version\";s:2:\"v1\";s:21:\"checkout_notes_toggle\";i:1;s:35:\"kls_checkout_default_payment_toggle\";i:1;s:27:\"kls_checkout_button_styling\";s:7:\"primary\";s:36:\"kls_woocommerce_product_page_version\";s:2:\"v1\";s:21:\"kls_product_tabs_mode\";s:9:\"accordion\";s:29:\"product_first_tab_open_toggle\";i:1;s:27:\"product_image_arrows_toggle\";i:1;s:25:\"product_image_dots_toggle\";i:1;s:19:\"product_usps_toggle\";i:1;s:39:\"product_recently_viewed_products_toggle\";i:1;s:24:\"kls_custom_fonts_heading\";s:1454:\"https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Italic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ExtraLightItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ExtraLight.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ExtraBoldItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ExtraBold.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-BoldItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Bold.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-BlackItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Black.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ThinItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Thin.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-SemiBoldItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-SemiBold.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Regular.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-MediumItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Medium.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-LightItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Light.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins.zip,\";s:21:\"kls_custom_fonts_body\";s:1387:\"https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Italic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ExtraLightItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ExtraLight.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ExtraBoldItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ExtraBold.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-BoldItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Bold.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-BlackItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Black.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-ThinItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Thin.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-SemiBoldItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-SemiBold.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Regular.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-MediumItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Medium.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-LightItalic.ttf,https://opzetstan2.opzet-website.nl/wp-content/uploads/Poppins-Light.ttf,\";s:14:\"tertiary_color\";s:7:\"#324988\";s:22:\"background_light_color\";s:7:\"#ededed\";s:26:\"button_primary_border_size\";s:3:\"2px\";s:26:\"button_primary_font_weight\";s:6:\"normal\";s:24:\"button_primary_font_size\";s:4:\"18px\";s:26:\"button_primary_line_height\";s:4:\"27px\";s:24:\"button_primary_icon_code\";s:4:\"f061\";s:31:\"button_primary_icon_font_weight\";s:4:\"bold\";s:28:\"button_primary_icon_position\";s:10:\"right-full\";s:27:\"main_navigation_font_weight\";s:6:\"normal\";s:24:\"form_submit_button_style\";s:7:\"primary\";s:27:\"form_submit_button_location\";s:5:\"Right\";}", "yes");
INSERT INTO `wp_options` VALUES("200", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("201", "kls_file_minification", "", "yes");
INSERT INTO `wp_options` VALUES("202", "kls_theme_settings_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("203", "kls_theme_header_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("204", "kls_theme_footer_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("206", "puc_external_updates_theme-klasse-theme", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1725345051;s:14:\"checkedVersion\";s:6:\"0.1.83\";s:6:\"update\";O:8:\"stdClass\":5:{s:4:\"slug\";s:12:\"klasse-theme\";s:7:\"version\";s:6:\"0.1.85\";s:12:\"download_url\";s:93:\"https://api.github.com/repos/Klasse-Software-Development-B-V/klasse-theme/zipball/development\";s:12:\"translations\";a:0:{}s:11:\"details_url\";s:20:\"https://klassebv.nl/\";}s:11:\"updateClass\";s:49:\"YahnisElsts\\PluginUpdateChecker\\v5p4\\Theme\\Update\";s:15:\"updateBaseClass\";s:12:\"Theme\\Update\";}", "off");
INSERT INTO `wp_options` VALUES("210", "new_admin_email", "server@klassebv.nl", "yes");
INSERT INTO `wp_options` VALUES("223", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("224", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":5,\"critical\":1}", "yes");
INSERT INTO `wp_options` VALUES("238", "worker_migration_version", "2", "yes");
INSERT INTO `wp_options` VALUES("239", "_worker_nossl_key", "", "yes");
INSERT INTO `wp_options` VALUES("240", "_worker_public_key", "LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUF6YnVCWEU4M1gzRTFUb0lhL1M2NQpicnpwYUxpaWo3NnJyREVPT0NUdENtVW9BRnN4RUNzenJrclhBZXF6KzNHZDdlcWpTK1dDVmh0MnVjM1REZzViCkJSUnhibTBqYStOSDhSV1oxM2dXVWFkV25xZXdaTnJ0YU9BamVyRWJtZCtwU3NnSjNxSk1rM1NPaUxOUDhiZksKNzJSTVpvSWpONkFVZTN5ekVHM3B1T2RkTXpBUytFQjlsRlpTWXNocTYvY1c2Tm54amdnQjJRcjBtbzFKdW55YgpXSjhtWW9sb2ZwV1Q1N0RKOGJhYnVXdGlYOGFKNlpGZk5RR0NqOHpSVEpSMStNSmMraWFSdldkd1ZvTy91RWhoCktSa2RDWVVJNDFNUHEvL2VaYkFBNTNhb3Rzc2duQVBZY2NobVVWdUJFallZcmx1RFRpZXNMbU5mOFI4U2psMkcKOVFJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg==", "yes");
INSERT INTO `wp_options` VALUES("242", "ninja_forms_oauth_client_secret", "5orMkJy4xnjdCN3eIHbkhwGouhRs9HoF7BryMjuf", "yes");
INSERT INTO `wp_options` VALUES("243", "ninja_forms_version", "3.7.0", "yes");
INSERT INTO `wp_options` VALUES("244", "ninja_forms_db_version", "1.4", "no");
INSERT INTO `wp_options` VALUES("245", "ninja_forms_required_updates", "a:6:{s:19:\"CacheCollateActions\";s:19:\"2022-01-12 08:35:19\";s:17:\"CacheCollateForms\";s:19:\"2022-01-12 08:35:19\";s:18:\"CacheCollateFields\";s:19:\"2022-01-12 08:35:19\";s:19:\"CacheCollateObjects\";s:19:\"2022-01-12 08:35:19\";s:19:\"CacheCollateCleanup\";s:19:\"2022-01-12 08:35:19\";s:25:\"CacheFieldReconcilliation\";s:19:\"2022-01-12 08:35:19\";}", "yes");
INSERT INTO `wp_options` VALUES("246", "ninja_forms_settings", "a:14:{s:11:\"date_format\";s:5:\"m/d/Y\";s:8:\"currency\";s:3:\"USD\";s:18:\"recaptcha_site_key\";s:0:\"\";s:20:\"recaptcha_secret_key\";s:0:\"\";s:20:\"recaptcha_site_key_3\";s:0:\"\";s:22:\"recaptcha_secret_key_3\";s:0:\"\";s:14:\"recaptcha_lang\";s:0:\"\";s:19:\"delete_on_uninstall\";i:0;s:21:\"disable_admin_notices\";s:1:\"0\";s:16:\"builder_dev_mode\";s:1:\"1\";s:18:\"opinionated_styles\";s:5:\"light\";s:15:\"recaptcha_theme\";s:5:\"light\";s:23:\"load_legacy_submissions\";s:1:\"0\";s:15:\"currency_symbol\";s:5:\"&#36;\";}", "yes");
INSERT INTO `wp_options` VALUES("247", "ninja_forms_zuul", "8", "no");
INSERT INTO `wp_options` VALUES("253", "et_core_version", "4.27.1", "yes");
INSERT INTO `wp_options` VALUES("255", "et_divi_builder_plugin", "a:66:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:29:\"custom_defaults_migrated_flag\";b:1;s:27:\"et_pb_post_type_integration\";a:3:{s:4:\"post\";s:2:\"on\";s:4:\"page\";s:2:\"on\";s:7:\"project\";s:2:\"on\";}s:13:\"et_enable_bfb\";s:2:\"on\";s:24:\"et_enable_classic_editor\";s:2:\"on\";s:21:\"et_pb_static_css_file\";s:2:\"on\";s:25:\"et_pb_product_tour_global\";s:3:\"off\";s:30:\"et_flush_rewrite_rules_library\";s:0:\"\";s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:46:\"et_fb_pref_builder_enable_visual_theme_builder\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:0:\"\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:0:\"\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:400;s:33:\"et_fb_pref_modal_dimension_height\";i:400;s:27:\"et_fb_pref_modal_position_x\";i:1242;s:27:\"et_fb_pref_modal_position_y\";i:209;s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:444;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:300;s:30:\"et_fb_pref_lv_modal_position_x\";i:1307;s:30:\"et_fb_pref_lv_modal_position_y\";i:166;s:34:\"et_fb_pref_responsive_tablet_width\";i:768;s:35:\"et_fb_pref_responsive_tablet_height\";i:0;s:33:\"et_fb_pref_responsive_phone_width\";i:400;s:34:\"et_fb_pref_responsive_phone_height\";i:0;s:35:\"et_fb_pref_responsive_minimum_width\";i:320;s:35:\"et_fb_pref_responsive_maximum_width\";i:980;s:16:\"et_global_colors\";a:2:{s:41:\"gcid-9e31517f-92ac-4a3a-b185-23b18f505757\";a:2:{s:5:\"color\";s:7:\"#fc0841\";s:6:\"active\";s:3:\"yes\";}s:41:\"gcid-b85fe595-102d-4121-ab75-76ef4bb49ab7\";a:2:{s:5:\"color\";s:7:\"#7cda24\";s:6:\"active\";s:3:\"yes\";}}s:29:\"presets_storage_migrated_flag\";b:1;s:39:\"builder_global_presets_history_migrated\";b:1;s:28:\"et_fb_pref_limited_view_mode\";s:9:\"wireframe\";s:35:\"et_fb_pref_limited_modal_preference\";s:7:\"default\";s:32:\"et_fb_pref_limited_toolbar_click\";s:5:\"false\";s:34:\"et_fb_pref_limited_toolbar_desktop\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_grid\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_hover\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_phone\";s:4:\"true\";s:33:\"et_fb_pref_limited_toolbar_tablet\";s:4:\"true\";s:36:\"et_fb_pref_limited_toolbar_wireframe\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_zoom\";s:4:\"true\";s:18:\"divi_color_palette\";s:63:\"#407af7|#FFFFFF|#E02B20|#E09900|#EDF000|#7CDA24|#0C71C3|#8300E9\";}", "yes");
INSERT INTO `wp_options` VALUES("256", "et_bfb_settings", "a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("258", "et_safe_mode_plugins_allowlist", "a:9:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:23:\"divi-dash/divi-dash.php\";i:5;s:27:\"ari-adminer/ari-adminer.php\";i:6;s:31:\"query-monitor/query-monitor.php\";i:7;s:27:\"woocommerce/woocommerce.php\";i:8;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}", "yes");
INSERT INTO `wp_options` VALUES("259", "et_support_center_installed", "true", "yes");
INSERT INTO `wp_options` VALUES("263", "et_support_center_setup_done", "processed", "yes");
INSERT INTO `wp_options` VALUES("264", "ninja_forms_addons_feed", "[{\"title\":\"Multi Step Forms\",\"image\":\"assets\\/img\\/add-ons\\/multi-step-forms.png\",\"content\":\"Give submissions a boost on any longer form by making it a multi-page form. Drag and drop fields between pages, add breadcrumb navigation, a progress bar, and loads more!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/multi-step-forms\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Multi+Step+Forms\",\"plugin\":\"ninja-forms-multi-part\\/multi-part.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/multi-step-forms\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Multi+Step+Forms+Docs\",\"version\":\"3.0.26\",\"categories\":[{\"name\":\"Look &amp; Feel\",\"slug\":\"look-feel\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Basic 2022\",\"slug\":\"basic-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Front-End Posting\",\"image\":\"assets\\/img\\/add-ons\\/front-end-posting.png\",\"content\":\"Let users publish content just by submitting a form! Completely configurable including post type, title, even categories and tags. Set post status, author, and much more!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/post-creation\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Front-End+Posting\",\"plugin\":\"ninja-forms-post-creation\\/ninja-forms-post-creation.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/post-creation\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Front-End+Posting+Docs\",\"version\":\"3.0.10\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Mailchimp\",\"image\":\"assets\\/img\\/add-ons\\/mailchimp.png\",\"content\":\"Bring new life to your lists with upgraded Mailchimp signup forms for WordPress! Easy to build and customize with no code required. Link to lists and interest groups!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/mailchimp\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Mailchimp\",\"plugin\":\"ninja-forms-mail-chimp\\/ninja-forms-mail-chimp.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/mailchimp\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Mailchimp+Docs\",\"version\":\"3.3.6\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Campaign Monitor\",\"image\":\"assets\\/img\\/add-ons\\/campaign-monitor.png\",\"content\":\"Make any form a custom crafted WordPress signup form for Campaign Monitor. Connect to any list, link form fields to list fields, and watch your lists grow!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/campaign-monitor\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Campaign+Monitor\",\"plugin\":\"ninja-forms-campaign-monitor\\/ninja-forms-campaign-monitor.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/campaign-monitor\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Campaign+Monitor+Docs\",\"version\":\"3.0.6\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"User Analytics\",\"image\":\"assets\\/img\\/add-ons\\/user-analytics.png\",\"content\":\"Get better data on where your form traffic is coming from with every submission. Add 10 analytics fields including UTM source, medium, campaign, content, and more!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/user-analytics\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=User+Analytics\",\"plugin\":\"ninja-forms-user-analytics\\/ninja-forms-user-analytics.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/user-analytics\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=User+Analytics+Docs\",\"version\":\"3.0.3\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Constant Contact\",\"image\":\"assets\\/img\\/add-ons\\/constant-contact.png\",\"content\":\"Connect WordPress to Constant Contact with forms that you can build and design just the way you want, no tech skills required! Subscribe users to any list or interest group.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/constant-contact\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Constant+Contact\",\"plugin\":\"ninja-forms-constant-contact\\/ninja-forms-constant-contact.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/constant-contact\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Constant+Contact+Docs\",\"version\":\"3.1.1\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"AWeber\",\"image\":\"assets\\/img\\/add-ons\\/aweber.png\",\"content\":\"Build your lists faster with easy to design, professional quality WordPress signup forms. No technical skills required. Connect WordPress to AWeber with style!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/aweber\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=AWeber\",\"plugin\":\"ninja-forms-aweber\\/ninja-forms-aweber.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/aweber\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=AWeber+Docs\",\"version\":\"3.2.1\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"PayPal Express\",\"image\":\"assets\\/img\\/add-ons\\/paypal-express.png\",\"content\":\"Set up any form to accept PayPal payments with PayPal Express for WordPress! Base totals on a fixed amount, user entered amount, or a calculated total.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/paypal-express\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PayPal+Express\",\"plugin\":\"ninja-forms-paypal-express\\/ninja-forms-paypal-express.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/paypal-express\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PayPal+Express+Docs\",\"version\":\"3.1.3\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"MailPoet\",\"image\":\"assets\\/img\\/add-ons\\/mailpoet.png\",\"content\":\"Say hello better! Customize your MailPoet signup forms to draw more subscribers than ever before. Connect WordPress to any MailPoet list in minutes!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/mailpoet\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=MailPoet\",\"plugin\":\"ninja-forms-mailpoet\\/nf-mailpoet.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/mailpoet\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=MailPoet+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Zoho CRM\",\"image\":\"assets\\/img\\/add-ons\\/zoho-crm.png\",\"content\":\"Customize your forms to get the most out of your connection between WordPress and Zoho. Link form fields directly to Zoho fields, custom fields included, from almost any module.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/zoho-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Zoho+CRM\",\"plugin\":\"ninja-forms-zoho-crm\\/ninja-forms-zoho-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/zoho-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Zoho+CRM+Docs\",\"version\":\"3.5.0\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"CRMs\",\"slug\":\"crms\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Capsule CRM\",\"image\":\"assets\\/img\\/add-ons\\/capsule-crm.png\",\"content\":\"Boost conversions from WordPress to Capsule with forms tailor made to your audience. Link form fields to Capsule fields from a wide range of modules. Custom fields too!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/capsule-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Capsule+CRM\",\"plugin\":\"ninja-forms-capsule-crm\\/ninja-forms-capsule-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/capsule-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Capsule+CRM+Docs\",\"version\":\"3.4.4\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"CRMs\",\"slug\":\"crms\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Insightly CRM\",\"image\":\"assets\\/img\\/add-ons\\/insightly-crm.png\",\"content\":\"Your customer\'s journey begins with your WordPress forms. Send Contacts, Leads, Opportunities, Custom fields and more seamlessly from WordPress to Insightly!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/insightly-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Insightly+CRM\",\"plugin\":\"ninja-forms-insightly-crm\\/ninja-forms-insightly-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/insightly-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Insightly+CRM+Docs\",\"version\":\"3.2.1\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"CRMs\",\"slug\":\"crms\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Trello\",\"image\":\"assets\\/img\\/add-ons\\/trello.png\",\"content\":\"Create a new Trello card with data from any WordPress form submission. Map fields to card details, assign members and labels, upload images, embed links.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/trello\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Trello\",\"plugin\":\"ninja-forms-trello\\/ninja-forms-trello.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/trello\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Trello+Docs\",\"version\":\"3.0.4\",\"categories\":[{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"},{\"name\":\"Automation and Integration\",\"slug\":\"automation-and-integration\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Elavon\",\"image\":\"assets\\/img\\/add-ons\\/elavon.png\",\"content\":\"Accept credit card payments from any of your WordPress forms. Pass customer and invoice info from any field securely into Elavon with each payment.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/elavon\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elavon\",\"plugin\":\"ninja-forms-elavon-payment-gateway\\/ninja-forms-elavon-payment-gateway.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/elavon\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elavon+Docs\",\"version\":\"3.1.2\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Accept Payments\",\"slug\":\"accept-payments\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Zapier\",\"image\":\"assets\\/img\\/add-ons\\/zapier.png\",\"content\":\"Don\'t see an add-on integration for a service you love? Don\'t worry! Connect WordPress to more than 4,000 different services through Zapier, no code required!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/zapier\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Zapier\",\"plugin\":\"ninja-forms-zapier\\/ninja-forms-zapier.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/zapier\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Zapier+Docs\",\"version\":\"3.0.9\",\"categories\":[{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Custom Integrations\",\"slug\":\"custom-integrations\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"},{\"name\":\"Automation and Integration\",\"slug\":\"automation-and-integration\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Salesforce CRM\",\"image\":\"assets\\/img\\/add-ons\\/salesforce-crm.png\",\"content\":\"Easily map any form field to any Salesforce Object or Field. A better connection to your customers begins with a better WordPress form builder!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/salesforce-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Salesforce+CRM\",\"plugin\":\"ninja-forms-salesforce-crm\\/ninja-forms-salesforce-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/salesforce-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Salesforce+CRM+Docs\",\"version\":\"3.3.2\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"CRMs\",\"slug\":\"crms\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Slack\",\"image\":\"assets\\/img\\/add-ons\\/slack.png\",\"content\":\"Get realtime Slack notifications in the workspace and channel of your choice with any new WordPress form submission. @Mention any team member!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/slack\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Slack\",\"plugin\":\"ninja-forms-slack\\/ninja-forms-slack.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/slack\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Slack+Docs\",\"version\":\"3.0.3\",\"categories\":[{\"name\":\"Notifications\",\"slug\":\"notifications\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"},{\"name\":\"Automation and Integration\",\"slug\":\"automation-and-integration\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"CleverReach\",\"image\":\"assets\\/img\\/add-ons\\/cleverreach.png\",\"content\":\"Grow the reach of your email marketing with better CleverReach signup forms. Tailor your forms to your audience with this easy to set up integration!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/cleverreach\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=CleverReach\",\"plugin\":\"ninja-forms-cleverreach\\/ninja-forms-cleverreach.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/cleverreach\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=CleverReach+Docs\",\"version\":\"3.1.6\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Webhooks\",\"image\":\"assets\\/img\\/add-ons\\/webhooks.png\",\"content\":\"Can\'t find a WordPress integration for the service you love? Send WordPress forms data to any external URL using a simple GET or POST request!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/webhooks\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Webhooks\",\"plugin\":\"ninja-forms-webhooks\\/ninja-forms-webhooks.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/webhooks\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Webhooks+Docs\",\"version\":\"3.0.6\",\"categories\":[{\"name\":\"Notifications\",\"slug\":\"notifications\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Custom Integrations\",\"slug\":\"custom-integrations\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Automation and Integration\",\"slug\":\"automation-and-integration\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Excel Export\",\"image\":\"assets\\/img\\/add-ons\\/excel-export.png\",\"content\":\"Export any form\'s submissions as a Microsoft Excel spreadsheet. Choose a date range, the fields you want to include, and export to Excel! \",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/excel-export\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Excel+Export\",\"plugin\":\"ninja-forms-excel-export\\/ninja-forms-excel-export.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/excel-export\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Excel+Export+Docs\",\"version\":\"3.3.5\",\"categories\":[{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Help Scout\",\"image\":\"assets\\/img\\/add-ons\\/help-scout.png\",\"content\":\"Offering great support is hard. Tailor your WordPress forms to match your customers\' needs with this Help Scout integration for WordPress.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/help-scout\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Help+Scout\",\"plugin\":null,\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/help-scout\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Help+Scout+Docs\",\"version\":\"3.1.3\",\"categories\":[{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Automation and Integration\",\"slug\":\"automation-and-integration\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Emma\",\"image\":\"assets\\/img\\/add-ons\\/emma.png\",\"content\":\"Take your email marketing further with handcrafted, easy to build signup forms that connect directly into your Emma account! \",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/emma\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Emma\",\"plugin\":\"ninja-forms-emma\\/ninja-forms-emma.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/emma\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Emma+Docs\",\"version\":\"3.0.4\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"ClickSend SMS\",\"image\":\"assets\\/img\\/add-ons\\/clicksend-sms.png\",\"content\":\"Get instant SMS notifications with every new WordPress form submission. Respond to leads faster and make more personal connections!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/clicksend-sms\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ClickSend+SMS\",\"plugin\":\"ninja-forms-clicksend\\/ninja-forms-clicksend.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/clicksend-sms\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ClickSend+SMS+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"SMS Notifications\",\"slug\":\"sms-notifications\"},{\"name\":\"Automation and Integration\",\"slug\":\"automation-and-integration\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Twilio SMS\",\"image\":\"assets\\/img\\/add-ons\\/twilio-sms.png\",\"content\":\"Get instant SMS notifications with every new WordPress form submission. Respond to leads faster and make more personal connections!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/twilio\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Twilio+SMS\",\"plugin\":\"ninja-forms-twilio\\/ninja-forms-twilio.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/twilio\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Twilio+SMS+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"SMS Notifications\",\"slug\":\"sms-notifications\"},{\"name\":\"Automation and Integration\",\"slug\":\"automation-and-integration\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Recurly\",\"image\":\"assets\\/img\\/add-ons\\/recurly.png\",\"content\":\"Subscription plans a part of your business model? Let your users subscribe from any WordPress form & make management easier with Recurly!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/recurly\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Recurly\",\"plugin\":\"ninja-forms-recurly\\/ninja-forms-recurly.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/recurly\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Recurly+Docs\",\"version\":\"3.0.5\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Accept Payments\",\"slug\":\"accept-payments\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Save Progress\",\"image\":\"assets\\/img\\/add-ons\\/save-progress.png\",\"content\":\"Let your users save their work and reload it all when they have time to return. Don\'t lose out on valuable submissions for longer forms!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/save-progress\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Save+Progress\",\"plugin\":\"ninja-forms-save-progress\\/ninja-forms-save-progress.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/save-progress\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Save+Progress+Docs\",\"version\":\"3.0.28\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"EmailOctopus\",\"image\":\"assets\\/img\\/add-ons\\/emailoctopus.png\",\"content\":\"Pair WordPress\' best drag and drop form builder with your EmailOctopus account for incredibly effective signup forms. Easy, complete integration.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/emailoctopus\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=EmailOctopus\",\"plugin\":\"ninja-forms-emailoctopus\\/ninja-forms-emailoctopus.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/emailoctopus\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=EmailOctopus+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Pipeline CRM\",\"image\":\"assets\\/img\\/add-ons\\/pipelinedeals-crm.png\",\"content\":\"Complete, effortless integration with Pipeline CRM. Increase the flow of leads into your sales pipeline with upgraded lead generation forms!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/pipelinedeals-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pipeline+CRM\",\"plugin\":\"ninja-forms-zoho-crm\\/zoho-integration.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/pipelinedeals-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pipeline+CRM+Docs\",\"version\":\"3.0.2\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"CRMs\",\"slug\":\"crms\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"ConvertKit\",\"image\":\"assets\\/img\\/add-ons\\/convertkit.png\",\"content\":\"Connect WordPress to your ConvertKit account with completely customizable opt-in forms. Watch your audience & sales grow like never before!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/convertkit\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ConvertKit\",\"plugin\":\"ninja-forms-convertkit\\/ninja-forms-convertkit.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/convertkit\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ConvertKit+Docs\",\"version\":\"3.1.1\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"OnePageCRM\",\"image\":\"assets\\/img\\/add-ons\\/onepage-crm.png\",\"content\":\"Integrate WordPress with OnePage CRM seamlessly through highly customizable WordPress forms. Make better conversions <em>your<\\/em> Next Action!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/onepage-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=OnePageCRM\",\"plugin\":\"ninja-forms-onepage-crm\\/ninja-forms-onepage-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/onepage-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=OnePageCRM+Docs\",\"version\":\"3.0.4\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"CRMs\",\"slug\":\"crms\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"ActiveCampaign\",\"image\":\"assets\\/img\\/add-ons\\/active-campaign.png\",\"content\":\"Design custom forms that link perfectly to your ActiveCampaign account for the ultimate in marketing automation. Better leads begin here!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/activecampaign\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ActiveCampaign\",\"plugin\":\"ninja-forms-active-campaign\\/ninja-forms-active-campaign.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/activecampaign\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ActiveCampaign+Docs\",\"version\":\"3.1.2\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Agency Membership\",\"image\":\"assets\\/img\\/add-ons\\/ninja-forms-membership-bundle-2.png\",\"content\":\"Get every single Ninja Forms add-ons, at an amazingly discounted price.\",\"link\":\"https:\\/\\/ninjaforms.com\\/documentation\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Agency+Membership\",\"plugin\":null,\"docs\":\"https:\\/\\/ninjaforms.com\\/documentation\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Agency+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Deprecated\",\"slug\":\"deprecated\"},{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"}]},{\"title\":\"Personal Membership\",\"image\":\"assets\\/img\\/add-ons\\/individual-membership-2.png\",\"content\":\"Get our most popular add-ons at an amazingly discounted price. Perfect for the single site owner.\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Personal+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Personal+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Deprecated\",\"slug\":\"deprecated\"},{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"}]},{\"title\":\"Professional Membership\",\"image\":\"assets\\/img\\/add-ons\\/professional-membership-2.png\",\"content\":\"Get our 4 most popular add-ons at an amazingly discounted price. Perfect for your Do It Yourself business owner.\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Professional+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Professional+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Deprecated\",\"slug\":\"deprecated\"},{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"}]},{\"title\":\"HubSpot\",\"image\":\"assets\\/img\\/add-ons\\/hubspot-crm.png\",\"content\":\"Looking for an easier way to connect HubSpot with WordPress? Need more flexibility and features for your HubSpot forms? This is your answer.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/hubspot\\/ \\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=HubSpot\",\"plugin\":\"ninja-forms-hubspot\\/ninja-forms-hubspot.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/hubspot\\/ \\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=HubSpot+Docs\",\"version\":\"3.0.8\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"CRMs\",\"slug\":\"crms\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Advanced Datepicker\",\"image\":\"assets\\/img\\/add-ons\\/advanced-datepicker.png\",\"content\":\"Let your users book dates and times for appointments and more directly from any WordPress form!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/advanced-datepicker\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Advanced+Datepicker\",\"plugin\":\"ninja-forms-advanced-datepicker\\/ninja-forms-advanced-datepicker-3.2.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/advanced-datepicker\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Advanced+Datepicker+Docs\",\"version\":\"3.3.1\",\"categories\":[{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Authorize.net\",\"image\":\"assets\\/img\\/add-ons\\/authorize-net.png\",\"content\":\"Looking for a fast, simple way to connect WordPress to Authorize.net? The Authorize.net add-on is your ticket!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/authorize-net\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Authorize.net\",\"plugin\":\"ninja-forms-authorize-net\\/ninja-forms-authorize-net.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/authorize-net\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Authorize.net+Docs\",\"version\":\"3.1.1\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Accept Payments\",\"slug\":\"accept-payments\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Basic Membership 2022\",\"image\":\"assets\\/img\\/add-ons\\/basic-membership.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Basic+Membership+2022\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Basic+Membership+2022+Docs\",\"version\":null,\"categories\":[{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"}]},{\"title\":\"Plus Membership 2022\",\"image\":\"assets\\/img\\/add-ons\\/plus-membership.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Plus+Membership+2022\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Plus+Membership+2022+Docs\",\"version\":null,\"categories\":[{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"}]},{\"title\":\"Pro Membership 2022\",\"image\":\"assets\\/img\\/add-ons\\/pro-membership.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pro+Membership+2022\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pro+Membership+2022+Docs\",\"version\":null,\"categories\":[{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"}]},{\"title\":\"Elite Membership 2022\",\"image\":\"assets\\/img\\/add-ons\\/elite-membership.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elite+Membership+2022\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elite+Membership+2022+Docs\",\"version\":null,\"categories\":[{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"}]},{\"title\":\"Scheduled Submissions Export\",\"image\":\"assets\\/img\\/add-ons\\/scheduled-submissions-export.png\",\"content\":\"Use Scheduled Submissions Export to set hourly, daily, or weekly exports of any WordPress form submissions to any email address(es)!\",\"link\":\" https:\\/\\/ninjaforms.com\\/extensions\\/scheduled-submissions-export\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Scheduled+Submissions+Export\",\"plugin\":\"ninja-forms-scheduled-exports\\/ninja-forms-scheduled-exports.php\",\"docs\":\" https:\\/\\/ninjaforms.com\\/docs\\/scheduled-submissions-export\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Scheduled+Submissions+Export+Docs\",\"version\":\"3.0.3\",\"categories\":[{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"CiviCRM\",\"image\":\"assets\\/img\\/add-ons\\/civicrm.png\",\"content\":\"Connect & update your CiviCRM account from any WordPress form with the Ninja Forms CiviCRM add-on. Easily add or update Contacts & Activities!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/civicrm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=CiviCRM\",\"plugin\":\"ninja-forms-civicrm\\/ninja-forms-civicrm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/civicrm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=CiviCRM+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"CRMs\",\"slug\":\"crms\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"File Uploads\",\"image\":\"assets\\/img\\/add-ons\\/file-uploads.png\",\"content\":\"Add file upload fields to any WordPress form. Set allowed file types, sizes, upload directories and save to WordPress, Google Drive and more.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/file-uploads\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=File+Uploads\",\"plugin\":\"ninja-forms-uploads\\/file-uploads.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/file-uploads\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=File+Uploads+Docs\",\"version\":\"3.3.16\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Basic 2022\",\"slug\":\"basic-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"User Management\",\"image\":\"assets\\/img\\/add-ons\\/user-management.png\",\"content\":\"Let users register, login, & manage profiles with customizable form templates. Allow user roles to view or edit form submissions. \",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/user-management\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=User+Management\",\"plugin\":\"ninja-forms-user-management\\/ninja-forms-user-management.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/user-management\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=User+Management+Docs\",\"version\":\"3.2.1\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Layout and Styles\",\"image\":\"assets\\/img\\/add-ons\\/layout-styles.png\",\"content\":\"Edit form styles. Create two column forms. Multi column forms. Easily adjust form layout. You don\'t need a designer, just Layout and Styles!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/layouts-and-styles\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Layout+and+Styles\",\"plugin\":\"ninja-forms-style\\/ninja-forms-style.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/layouts-and-styles\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Layout+and+Styles+Docs\",\"version\":\"3.0.29\",\"categories\":[{\"name\":\"Look &amp; Feel\",\"slug\":\"look-feel\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Basic 2022\",\"slug\":\"basic-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Stripe\",\"image\":\"assets\\/img\\/add-ons\\/stripe.png\",\"content\":\"Use Stripe Checkout forms to sell products or subscriptions. Accept credit cards, Google Pay, Apple Pay, & much more!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/stripe\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Stripe\",\"plugin\":\"ninja-forms-stripe\\/ninja-forms-stripe.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/stripe\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Stripe+Docs\",\"version\":\"3.2.6\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Accept Payments\",\"slug\":\"accept-payments\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Conditional Logic\",\"image\":\"assets\\/img\\/add-ons\\/conditional-logic.png\",\"content\":\"Create forms that change as they\'re filled out. Show and hide fields, modify lists, send email to different recipients conditionally and much more.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/conditional-logic\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Conditional+Logic\",\"plugin\":\"ninja-forms-conditionals\\/conditionals.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/conditional-logic\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Conditional+Logic+Docs\",\"version\":\"3.1\",\"categories\":[{\"name\":\"Look &amp; Feel\",\"slug\":\"look-feel\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Basic 2022\",\"slug\":\"basic-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"PDF Form Submission\",\"image\":\"assets\\/img\\/add-ons\\/pdf-form-submission.png\",\"content\":\"Use PDF Form Submission to generate a PDF from any WordPress form submission. Create a fully customizable, fillable PDF from top to bottom!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/pdf\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PDF+Form+Submission\",\"plugin\":\"ninja-forms-pdf-submissions\\/nf-pdf-submissions.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/pdf\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PDF+Form+Submission+Docs\",\"version\":\"3.2.2\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"},{\"name\":\"Advanced Functionality\",\"slug\":\"advanced-functionality\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]},{\"title\":\"Elite Membership\",\"image\":\"assets\\/img\\/add-ons\\/elite-membership-2.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elite+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elite+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"}]},{\"title\":\"Pro Membership\",\"image\":\"assets\\/img\\/add-ons\\/pro-membership-2.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pro+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pro+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"}]},{\"title\":\"Plus Membership\",\"image\":\"assets\\/img\\/add-ons\\/plus-membership-2.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Plus+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Plus+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Member Bundle\",\"slug\":\"member-bundle\"}]},{\"title\":\"PayPal\",\"image\":\"assets\\/img\\/add-ons\\/paypal-checkout.png\",\"content\":\"Use PayPal Checkout to accept standard PayPal payments, PayPal credit, Pay Later, Venmo, & bank debit in WordPress!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/paypal-checkout\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PayPal\",\"plugin\":\"ninja-forms-paypal\\/ninja-forms-paypal.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/paypal-checkout\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PayPal+Docs\",\"version\":\"3.0.2\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Accept Payments\",\"slug\":\"accept-payments\"},{\"name\":\"Memberships 2023\",\"slug\":\"memberships-2023\"},{\"name\":\"Plus 2023\",\"slug\":\"plus-2023\"},{\"name\":\"Pro 2023\",\"slug\":\"pro-2023\"},{\"name\":\"Elite 2023\",\"slug\":\"elite-2023\"}]}]", "no");
INSERT INTO `wp_options` VALUES("266", "wfls_last_role_change", "1704984259", "no");
INSERT INTO `wp_options` VALUES("267", "wordfence_version", "7.11.1", "yes");
INSERT INTO `wp_options` VALUES("268", "wordfence_case", "1", "yes");
INSERT INTO `wp_options` VALUES("269", "wordfence_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("270", "widget_ninja_forms_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("271", "ninja-forms-views-secret", "TDbTAifGtQI1GnxMdjn0pe9C6PA7U64DHfYYzcCE", "yes");
INSERT INTO `wp_options` VALUES("275", "user_hit_count", "a:59:{s:10:\"2024-07-06\";i:14;s:10:\"2024-07-07\";i:14;s:10:\"2024-07-08\";i:15;s:10:\"2024-07-09\";i:14;s:10:\"2024-07-10\";i:22;s:10:\"2024-07-11\";i:14;s:10:\"2024-07-12\";i:15;s:10:\"2024-07-13\";i:12;s:10:\"2024-07-14\";i:20;s:10:\"2024-07-15\";i:14;s:10:\"2024-07-16\";i:25;s:10:\"2024-07-17\";i:15;s:10:\"2024-07-18\";i:12;s:10:\"2024-07-19\";i:14;s:10:\"2024-07-20\";i:12;s:10:\"2024-07-21\";i:14;s:10:\"2024-07-22\";i:14;s:10:\"2024-07-23\";i:35;s:10:\"2024-07-24\";i:22;s:10:\"2024-07-25\";i:14;s:10:\"2024-07-26\";i:25;s:10:\"2024-07-28\";i:15;s:10:\"2024-07-29\";i:15;s:10:\"2024-07-30\";i:14;s:10:\"2024-07-31\";i:15;s:10:\"2024-08-01\";i:14;s:10:\"2024-08-02\";i:13;s:10:\"2024-08-03\";i:13;s:10:\"2024-08-04\";i:17;s:10:\"2024-08-05\";i:13;s:10:\"2024-08-06\";i:25;s:10:\"2024-08-07\";i:5;s:10:\"2024-08-08\";i:16;s:10:\"2024-08-09\";i:13;s:10:\"2024-08-10\";i:15;s:10:\"2024-08-11\";i:15;s:10:\"2024-08-12\";i:19;s:10:\"2024-08-13\";i:10;s:10:\"2024-08-14\";i:22;s:10:\"2024-08-15\";i:16;s:10:\"2024-08-16\";i:13;s:10:\"2024-08-17\";i:9;s:10:\"2024-08-18\";i:6;s:10:\"2024-08-19\";i:14;s:10:\"2024-08-20\";i:24;s:10:\"2024-08-21\";i:15;s:10:\"2024-08-22\";i:18;s:10:\"2024-08-23\";i:13;s:10:\"2024-08-24\";i:15;s:10:\"2024-08-25\";i:18;s:10:\"2024-08-26\";i:102;s:10:\"2024-08-27\";i:419;s:10:\"2024-08-28\";i:536;s:10:\"2024-08-29\";i:243;s:10:\"2024-08-30\";i:225;s:10:\"2024-08-31\";i:26;s:10:\"2024-09-01\";i:34;s:10:\"2024-09-02\";i:173;s:10:\"2024-09-03\";i:365;}", "on");
INSERT INTO `wp_options` VALUES("276", "wordfenceActivated", "0", "yes");
INSERT INTO `wp_options` VALUES("278", "et_pb_builder_options", "a:22:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;s:29:\"updates_main_updates_username\";s:8:\"sjowiexo\";s:28:\"updates_main_updates_api_key\";s:40:\"91d9f16331f197aea0660776c9a10bbc7197bd7d\";s:23:\"api_main_google_api_key\";s:0:\"\";s:35:\"api_main_enqueue_google_maps_script\";s:0:\"\";s:25:\"api_main_use_google_fonts\";s:0:\"\";s:54:\"post_type_integration_main_et_pb_post_type_integration\";a:3:{s:4:\"post\";s:2:\"on\";s:4:\"page\";s:2:\"on\";s:7:\"project\";s:2:\"on\";}s:36:\"advanced_main_minify_combine_scripts\";s:2:\"on\";s:35:\"advanced_main_minify_combine_styles\";s:2:\"on\";s:38:\"advanced_main_et_enable_classic_editor\";s:2:\"on\";s:35:\"advanced_main_et_pb_static_css_file\";s:2:\"on\";s:39:\"advanced_main_et_pb_product_tour_global\";s:3:\"off\";s:41:\"performance_main_dynamic_module_framework\";s:2:\"on\";s:28:\"performance_main_dynamic_css\";s:2:\"on\";s:29:\"performance_main_critical_css\";s:3:\"off\";s:42:\"performance_main_critical_threshold_height\";s:6:\"medium\";s:34:\"performance_main_inline_stylesheet\";s:2:\"on\";s:37:\"performance_main_dynamic_js_libraries\";s:2:\"on\";s:30:\"performance_main_dynamic_icons\";s:2:\"on\";s:36:\"performance_main_google_fonts_inline\";s:3:\"off\";s:63:\"performance_main_limit_google_fonts_support_for_legacy_browsers\";s:3:\"off\";}", "yes");
INSERT INTO `wp_options` VALUES("279", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"23.3\";}", "yes");
INSERT INTO `wp_options` VALUES("280", "wpseo", "a:108:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";s:5:\"false\";s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:1;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:20:\"taxonomy_made_public\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"23.3\";s:16:\"previous_version\";s:4:\"23.2\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:0;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";s:10:\"1641976526\";s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:35:\"https://opzetstan2.opzet-website.nl\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:10:{s:15:\"layout_category\";s:15:\"layout_category\";s:10:\"layout_tag\";s:10:\"layout_tag\";s:11:\"layout_pack\";s:11:\"layout_pack\";s:11:\"layout_type\";s:11:\"layout_type\";s:12:\"module_width\";s:12:\"module_width\";s:5:\"scope\";s:5:\"scope\";s:15:\"et_tb_item_type\";s:15:\"et_tb_item_type\";s:16:\"project_category\";s:16:\"project_category\";s:11:\"project_tag\";s:11:\"project_tag\";s:20:\"et_code_snippet_type\";s:20:\"et_code_snippet_type\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:3:{s:13:\"finishedSteps\";a:0:{}s:16:\"indexablesByStep\";a:0:{}s:8:\"priority\";i:1;}}s:28:\"configuration_finished_steps\";a:3:{i:0;s:18:\"siteRepresentation\";i:1;s:14:\"socialProfiles\";i:2;s:19:\"personalPreferences\";}s:36:\"dismiss_configuration_workout_notice\";b:1;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";s:10:\"1652258756\";s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"project\";}s:28:\"last_known_public_taxonomies\";a:9:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:15:\"layout_category\";i:4;s:10:\"layout_tag\";i:5;s:15:\"et_tb_item_type\";i:6;s:16:\"project_category\";i:7;s:11:\"project_tag\";i:8;s:20:\"et_code_snippet_type\";}s:23:\"last_known_no_unindexed\";a:6:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1725346248;s:35:\"wpseo_total_unindexed_general_items\";i:1725346248;s:31:\"wpseo_unindexed_post_link_count\";i:1725346248;s:31:\"wpseo_unindexed_term_link_count\";i:1725346248;s:27:\"wpseo_total_unindexed_posts\";i:1725270979;s:27:\"wpseo_total_unindexed_terms\";i:1725350664;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("281", "wpseo_titles", "a:238:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:61:\"Je zocht naar: %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:45:\"404 Pagina niet gevonden %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:1;s:12:\"disable-date\";b:1;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:14:\"Boxing company\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:9:\"Boxing HQ\";s:12:\"company_logo\";s:80:\"https://opzetstan2.opzet-website.nl/wp-content/uploads/Boxing-Company-logo-1.png\";s:12:\"company_name\";s:14:\"Boxing company\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";i:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:112:\"Welkom bij de Boxing Company, breidt je boxing skills uit totdat jij op gelijke hoogte kan staan met Mike Tyson!\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:112:\"Welkom bij de Boxing Company, breidt je boxing skills uit totdat jij op gelijke hoogte kan staan met Mike Tyson!\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:13:\"title-project\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-project\";s:112:\"Welkom bij de Boxing Company, breidt je boxing skills uit totdat jij op gelijke hoogte kan staan met Mike Tyson!\";s:15:\"noindex-project\";b:0;s:26:\"display-metabox-pt-project\";b:1;s:26:\"post_types-project-maintax\";i:0;s:24:\"schema-page-type-project\";s:7:\"WebPage\";s:27:\"schema-article-type-project\";s:4:\"None\";s:20:\"social-title-project\";s:9:\"%%title%%\";s:26:\"social-description-project\";s:0:\"\";s:24:\"social-image-url-project\";s:0:\"\";s:23:\"social-image-id-project\";i:0;s:23:\"title-ptarchive-project\";s:51:\"Archief %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-project\";s:0:\"\";s:25:\"bctitle-ptarchive-project\";s:0:\"\";s:25:\"noindex-ptarchive-project\";b:0;s:30:\"social-title-ptarchive-project\";s:21:\"Archief %%pt_plural%%\";s:36:\"social-description-ptarchive-project\";s:0:\"\";s:34:\"social-image-url-ptarchive-project\";s:0:\"\";s:33:\"social-image-id-ptarchive-project\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:25:\"title-tax-layout_category\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-layout_category\";s:0:\"\";s:35:\"display-metabox-tax-layout_category\";b:1;s:27:\"noindex-tax-layout_category\";b:0;s:32:\"social-title-tax-layout_category\";s:24:\"%%term_title%% Archieven\";s:38:\"social-description-tax-layout_category\";s:0:\"\";s:36:\"social-image-url-tax-layout_category\";s:0:\"\";s:35:\"social-image-id-tax-layout_category\";i:0;s:33:\"taxonomy-layout_category-ptparent\";i:0;s:20:\"title-tax-layout_tag\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-layout_tag\";s:0:\"\";s:30:\"display-metabox-tax-layout_tag\";b:1;s:22:\"noindex-tax-layout_tag\";b:0;s:27:\"social-title-tax-layout_tag\";s:24:\"%%term_title%% Archieven\";s:33:\"social-description-tax-layout_tag\";s:0:\"\";s:31:\"social-image-url-tax-layout_tag\";s:0:\"\";s:30:\"social-image-id-tax-layout_tag\";i:0;s:28:\"taxonomy-layout_tag-ptparent\";i:0;s:21:\"title-tax-layout_pack\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-layout_pack\";s:0:\"\";s:31:\"display-metabox-tax-layout_pack\";b:1;s:23:\"noindex-tax-layout_pack\";b:0;s:28:\"social-title-tax-layout_pack\";s:24:\"%%term_title%% Archieven\";s:34:\"social-description-tax-layout_pack\";s:0:\"\";s:32:\"social-image-url-tax-layout_pack\";s:0:\"\";s:31:\"social-image-id-tax-layout_pack\";i:0;s:29:\"taxonomy-layout_pack-ptparent\";i:0;s:21:\"title-tax-layout_type\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-layout_type\";s:0:\"\";s:31:\"display-metabox-tax-layout_type\";b:1;s:23:\"noindex-tax-layout_type\";b:0;s:28:\"social-title-tax-layout_type\";s:24:\"%%term_title%% Archieven\";s:34:\"social-description-tax-layout_type\";s:0:\"\";s:32:\"social-image-url-tax-layout_type\";s:0:\"\";s:31:\"social-image-id-tax-layout_type\";i:0;s:29:\"taxonomy-layout_type-ptparent\";i:0;s:22:\"title-tax-module_width\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-module_width\";s:0:\"\";s:32:\"display-metabox-tax-module_width\";b:1;s:24:\"noindex-tax-module_width\";b:0;s:29:\"social-title-tax-module_width\";s:24:\"%%term_title%% Archieven\";s:35:\"social-description-tax-module_width\";s:0:\"\";s:33:\"social-image-url-tax-module_width\";s:0:\"\";s:32:\"social-image-id-tax-module_width\";i:0;s:30:\"taxonomy-module_width-ptparent\";i:0;s:15:\"title-tax-scope\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-scope\";s:0:\"\";s:25:\"display-metabox-tax-scope\";b:1;s:17:\"noindex-tax-scope\";b:0;s:22:\"social-title-tax-scope\";s:24:\"%%term_title%% Archieven\";s:28:\"social-description-tax-scope\";s:0:\"\";s:26:\"social-image-url-tax-scope\";s:0:\"\";s:25:\"social-image-id-tax-scope\";i:0;s:23:\"taxonomy-scope-ptparent\";i:0;s:25:\"title-tax-et_tb_item_type\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-et_tb_item_type\";s:0:\"\";s:35:\"display-metabox-tax-et_tb_item_type\";b:1;s:27:\"noindex-tax-et_tb_item_type\";b:0;s:32:\"social-title-tax-et_tb_item_type\";s:24:\"%%term_title%% Archieven\";s:38:\"social-description-tax-et_tb_item_type\";s:0:\"\";s:36:\"social-image-url-tax-et_tb_item_type\";s:0:\"\";s:35:\"social-image-id-tax-et_tb_item_type\";i:0;s:33:\"taxonomy-et_tb_item_type-ptparent\";i:0;s:26:\"title-tax-project_category\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-project_category\";s:0:\"\";s:36:\"display-metabox-tax-project_category\";b:1;s:28:\"noindex-tax-project_category\";b:0;s:33:\"social-title-tax-project_category\";s:24:\"%%term_title%% Archieven\";s:39:\"social-description-tax-project_category\";s:0:\"\";s:37:\"social-image-url-tax-project_category\";s:0:\"\";s:36:\"social-image-id-tax-project_category\";i:0;s:34:\"taxonomy-project_category-ptparent\";i:0;s:21:\"title-tax-project_tag\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-project_tag\";s:0:\"\";s:31:\"display-metabox-tax-project_tag\";b:1;s:23:\"noindex-tax-project_tag\";b:0;s:28:\"social-title-tax-project_tag\";s:24:\"%%term_title%% Archieven\";s:34:\"social-description-tax-project_tag\";s:0:\"\";s:32:\"social-image-url-tax-project_tag\";s:0:\"\";s:31:\"social-image-id-tax-project_tag\";i:0;s:29:\"taxonomy-project_tag-ptparent\";i:0;s:30:\"title-tax-et_code_snippet_type\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:33:\"metadesc-tax-et_code_snippet_type\";s:0:\"\";s:40:\"display-metabox-tax-et_code_snippet_type\";b:1;s:32:\"noindex-tax-et_code_snippet_type\";b:0;s:37:\"social-title-tax-et_code_snippet_type\";s:24:\"%%term_title%% Archieven\";s:43:\"social-description-tax-et_code_snippet_type\";s:0:\"\";s:41:\"social-image-url-tax-et_code_snippet_type\";s:0:\"\";s:40:\"social-image-id-tax-et_code_snippet_type\";i:0;s:38:\"taxonomy-et_code_snippet_type-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:178;s:17:\"company_logo_meta\";a:10:{s:5:\"width\";i:222;s:6:\"height\";i:149;s:8:\"filesize\";i:2916;s:3:\"url\";s:80:\"https://opzetstan2.opzet-website.nl/wp-content/uploads/Boxing-Company-logo-1.png\";s:4:\"path\";s:87:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/uploads/Boxing-Company-logo-1.png\";s:4:\"size\";s:4:\"full\";s:2:\"id\";i:178;s:3:\"alt\";s:0:\"\";s:6:\"pixels\";i:33078;s:4:\"type\";s:9:\"image/png\";}s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("282", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:40:\"https://www.facebook.com/boxingcompanyHQ\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:80:\"https://opzetstan2.opzet-website.nl/wp-content/uploads/Boxing-Company-logo-1.png\";s:19:\"og_default_image_id\";i:178;s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("290", "ninja_forms_needs_updates", "0", "yes");
INSERT INTO `wp_options` VALUES("292", "wpr_rucss_used_css_version", "20231031", "yes");
INSERT INTO `wp_options` VALUES("294", "wp_rocket_settings", "a:74:{s:10:\"minify_css\";i:1;s:11:\"exclude_css\";a:0:{}s:26:\"remove_unused_css_safelist\";a:0:{}s:12:\"critical_css\";s:0:\"\";s:9:\"minify_js\";i:1;s:21:\"minify_concatenate_js\";i:1;s:17:\"exclude_inline_js\";a:0:{}s:10:\"exclude_js\";a:0:{}s:16:\"exclude_defer_js\";a:0:{}s:19:\"delay_js_exclusions\";a:0:{}s:8:\"lazyload\";i:1;s:16:\"lazyload_iframes\";i:1;s:16:\"lazyload_youtube\";i:1;s:16:\"exclude_lazyload\";a:1:{i:0;s:8:\"logo-img\";}s:16:\"image_dimensions\";i:1;s:14:\"manual_preload\";i:1;s:20:\"preload_excluded_uri\";a:0:{}s:13:\"preload_links\";s:1:\"1\";s:12:\"dns_prefetch\";a:0:{}s:13:\"preload_fonts\";a:3:{i:0;s:93:\"/wp-content/plugins/klasse-plugin/includes/add-ons/font-awesome/webfonts/fa-regular-400.woff2\";i:1;s:91:\"/wp-content/plugins/klasse-plugin/includes/add-ons/font-awesome/webfonts/fa-solid-900.woff2\";i:2;s:89:\"/wp-content/plugins/klasse-plugin/includes/add-ons/font-awesome/webfonts/fa-solid-900.ttf\";}s:19:\"purge_cron_interval\";i:10;s:15:\"purge_cron_unit\";s:15:\"HOUR_IN_SECONDS\";s:16:\"cache_reject_uri\";a:0:{}s:20:\"cache_reject_cookies\";a:0:{}s:15:\"cache_reject_ua\";a:0:{}s:17:\"cache_purge_pages\";a:0:{}s:19:\"cache_query_strings\";a:0:{}s:27:\"automatic_cleanup_frequency\";s:0:\"\";s:10:\"cdn_cnames\";a:0:{}s:8:\"cdn_zone\";a:0:{}s:16:\"cdn_reject_files\";a:0:{}s:17:\"control_heartbeat\";i:1;s:24:\"heartbeat_admin_behavior\";s:18:\"reduce_periodicity\";s:25:\"heartbeat_editor_behavior\";s:18:\"reduce_periodicity\";s:23:\"heartbeat_site_behavior\";s:18:\"reduce_periodicity\";s:16:\"cloudflare_email\";s:0:\"\";s:18:\"sucury_waf_api_key\";s:0:\"\";s:12:\"consumer_key\";s:8:\"acb3f605\";s:14:\"consumer_email\";s:21:\"info@websitexperts.nl\";s:10:\"secret_key\";s:8:\"f5d34d18\";s:7:\"license\";s:10:\"1641976542\";s:16:\"secret_cache_key\";s:22:\"61de92da3644f989840371\";s:14:\"minify_css_key\";s:22:\"64149dc564693839208714\";s:13:\"minify_js_key\";s:22:\"64149dc564698435125347\";s:7:\"version\";s:6:\"3.16.4\";s:16:\"previous_version\";s:6:\"3.16.3\";s:23:\"cloudflare_old_settings\";s:0:\"\";s:9:\"cache_ssl\";i:1;s:19:\"minify_google_fonts\";i:1;s:5:\"emoji\";i:1;s:17:\"remove_unused_css\";i:0;s:9:\"async_css\";i:0;s:12:\"cache_mobile\";i:1;s:23:\"do_caching_mobile_files\";i:1;s:22:\"minify_concatenate_css\";s:1:\"1\";s:18:\"cloudflare_api_key\";s:0:\"\";s:18:\"cloudflare_zone_id\";s:0:\"\";s:16:\"async_css_mobile\";s:1:\"1\";s:17:\"cache_logged_user\";i:0;s:12:\"defer_all_js\";i:0;s:18:\"database_revisions\";i:0;s:20:\"database_auto_drafts\";i:0;s:22:\"database_trashed_posts\";i:0;s:22:\"database_spam_comments\";i:0;s:25:\"database_trashed_comments\";i:0;s:23:\"database_all_transients\";i:0;s:24:\"database_optimize_tables\";i:0;s:26:\"schedule_automatic_cleanup\";i:0;s:21:\"sucury_waf_cache_sync\";i:0;s:3:\"cdn\";i:0;s:18:\"varnish_auto_purge\";i:0;s:8:\"delay_js\";i:0;s:28:\"delay_js_exclusions_selected\";a:0:{}s:39:\"delay_js_exclusions_selected_exclusions\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("311", "et_account_status", "active", "no");
INSERT INTO `wp_options` VALUES("316", "nf_admin_notice", "a:1:{s:16:\"one_week_support\";a:3:{s:5:\"start\";s:9:\"1/19/2022\";s:3:\"int\";i:7;s:9:\"dismissed\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("317", "_transient_et_updated_plugins_data", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1725350432;}", "yes");
INSERT INTO `wp_options` VALUES("333", "kls_api_key", "XlidNb7b3ys4smyjVG3LTnnhlpzJJFlIihnjdL5H7LZ8NGbLrleSE1pjJmPod3ZJ", "yes");
INSERT INTO `wp_options` VALUES("339", "et_automatic_updates_options", "a:2:{s:8:\"username\";s:8:\"sjowiexo\";s:7:\"api_key\";s:40:\"91d9f16331f197aea0660776c9a10bbc7197bd7d\";}", "yes");
INSERT INTO `wp_options` VALUES("340", "et_support_site_id", "xCLY3P=zI$RdU#aBNJr!", "yes");
INSERT INTO `wp_options` VALUES("341", "et_google_api_settings", "a:3:{s:7:\"api_key\";s:0:\"\";s:26:\"enqueue_google_maps_script\";s:3:\"off\";s:16:\"use_google_fonts\";s:3:\"off\";}", "yes");
INSERT INTO `wp_options` VALUES("351", "mmb_stats_filter", "a:1:{s:7:\"plugins\";a:1:{s:7:\"cleanup\";a:1:{s:9:\"revisions\";a:1:{s:11:\"num_to_keep\";i:5;}}}}", "yes");
INSERT INTO `wp_options` VALUES("397", "kls_cookie_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("402", "kls_webshop_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("403", "kls_debug_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("404", "kls_toggle_font_awesome", "on", "yes");
INSERT INTO `wp_options` VALUES("408", "wpseo_sitemap_1_cache_validator", "3uLqC", "off");
INSERT INTO `wp_options` VALUES("409", "wpseo_sitemap_page_cache_validator", "3uLqJ", "off");
INSERT INTO `wp_options` VALUES("414", "kls_action_bar_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("415", "kls_action_bar_text", "Dit is de actie balk van [klant_naam] hier kun jij een mooie promotie neerzetten.", "yes");
INSERT INTO `wp_options` VALUES("416", "kls_action_bar_text_color", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("417", "kls_action_bar_button_text", "Contact", "yes");
INSERT INTO `wp_options` VALUES("418", "kls_action_bar_button_styling", "primary", "yes");
INSERT INTO `wp_options` VALUES("419", "kls_action_bar_url", "#", "yes");
INSERT INTO `wp_options` VALUES("420", "kls_action_bar_background_color", "#eeeeee", "yes");
INSERT INTO `wp_options` VALUES("436", "rocket_analytics_notice_displayed", "1", "yes");
INSERT INTO `wp_options` VALUES("438", "kls_maintenance_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("439", "kls_maintenance_background_select", "Image", "yes");
INSERT INTO `wp_options` VALUES("440", "kls_maintenance_background_image", "", "yes");
INSERT INTO `wp_options` VALUES("441", "kls_maintenance_background_color", "", "yes");
INSERT INTO `wp_options` VALUES("442", "kls_maintenance_background_gradient", "", "yes");
INSERT INTO `wp_options` VALUES("443", "kls_maintenance_customer_data_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("448", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("449", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("459", "wpseo_sitemap_cache_validator_global", "3uJxL", "off");
INSERT INTO `wp_options` VALUES("522", "capsman_version", "2.13.0", "yes");
INSERT INTO `wp_options` VALUES("523", "capsman_backup", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:76:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("524", "capsman_backup_datestamp", "1641981849", "no");
INSERT INTO `wp_options` VALUES("530", "capability-manager-enhanced_wp_reviews_installed_on", "2022-01-12 10:04:13", "yes");
INSERT INTO `wp_options` VALUES("535", "capsman_last_role_1", "author", "yes");
INSERT INTO `wp_options` VALUES("537", "presspermit_enabled_post_types", "a:4:{s:4:\"post\";s:1:\"1\";s:4:\"page\";s:1:\"1\";s:13:\"wp_navigation\";s:1:\"1\";s:6:\"nf_sub\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("538", "cme_enabled_post_types", "a:4:{s:4:\"post\";s:1:\"1\";s:4:\"page\";s:1:\"1\";s:13:\"wp_navigation\";s:1:\"1\";s:6:\"nf_sub\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("539", "presspermit_enabled_taxonomies", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("540", "cme_detailed_taxonomies", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("546", "wpseo_sitemap_author_cache_validator", "3hERs", "no");
INSERT INTO `wp_options` VALUES("548", "cme_backup_auto_2022-01-12_10-29-52_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:77:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:45:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("549", "cme_backup_auto_2022-01-12_10-30-04_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:77:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:46:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:4:\"read\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("551", "ninja_forms_optin_reported", "1", "yes");
INSERT INTO `wp_options` VALUES("556", "nf_active_promotions", "{\"dashboard\":[{\"id\":\"sendwp-banner\",\"location\":\"dashboard\",\"content\":\"<span aria-label=\\\"SendWP. Getting WordPress email into an inbox shouldn\'t be that hard! Never miss another receipt, form submission, or any WordPress email ever again.\\\" style=\\\"cursor:pointer;width:800px;height:83px;border-radius:4px;-moz-border-radius:4px;-webkit-border-radius:4px;background-image:url(\'https:\\/\\/opzetstan2.opzet-website.nl\\/wp-content\\/plugins\\/ninja-forms\\/assets\\/img\\/promotions\\/dashboard-banner-sendwp.png\');display:block;\\\"><\\/span>\",\"type\":\"sendwp\",\"script\":\"\\n\\t\\t\\t\\tsetTimeout(function(){ \\/* Wait for services to init. *\\/\\n\\t\\t\\t\\t\\tvar data = {\\n\\t\\t\\t\\t\\t\\twidth: 450,\\n\\t\\t\\t\\t\\t\\tcloseOnClick: \'body\',\\n\\t\\t\\t\\t\\t\\tcloseOnEsc: true,\\n\\t\\t\\t\\t\\t\\tcontent: \'<p><h2>Frustrated that WordPress email isn\\u2019t being received?<\\/h2><p>Form submission notifications not hitting your inbox? Some of your visitors getting form feedback via email, others not? By default, your WordPress site sends emails through your web host, which can be unreliable. Your host has spent lots of time and money optimizing to serve your pages, not send your emails.<\\/p><h3>Sign up for SendWP today, and never deal with WordPress email issues again!<\\/h3><p>SendWP is an email service that removes your web host from the email equation.<\\/p><ul style=&quot;list-style-type:initial;margin-left: 20px;&quot;><li>Sends email through dedicated email service, increasing email deliverability.<\\/li><li>Keeps form submission emails out of spam by using a trusted email provider.<\\/li><li>On a shared web host? Don\\u2019t worry about emails being rejected because of blocked IP addresses.<\\/li><li><strong>$1 for the first month. $9\\/month after. Cancel anytime!<\\/strong><\\/li><\\/ul><\\/p><br \\/>\',\\n\\t\\t\\t\\t\\t\\tbtnPrimary: {\\n\\t\\t\\t\\t\\t\\t\\ttext: \'Sign me up!\',\\n\\t\\t\\t\\t\\t\\t\\tcallback: function() {\\n\\t\\t\\t\\t\\t\\t\\t\\tvar spinner = document.createElement(\'span\');\\n\\t\\t\\t\\t\\t\\t\\t\\tspinner.classList.add(\'dashicons\', \'dashicons-update\', \'dashicons-update-spin\');\\n\\t\\t\\t\\t\\t\\t\\t\\tvar w = this.offsetWidth;\\n\\t\\t\\t\\t\\t\\t\\t\\tthis.innerHTML = spinner.outerHTML;\\n\\t\\t\\t\\t\\t\\t\\t\\tthis.style.width = w+\'px\';\\n\\t\\t\\t\\t\\t\\t\\t\\tninja_forms_sendwp_remote_install();\\n\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t},\\n\\t\\t\\t\\t\\t\\tbtnSecondary: {\\n\\t\\t\\t\\t\\t\\t\\ttext: \'Cancel\',\\n\\t\\t\\t\\t\\t\\t\\tcallback: function() {\\n\\t\\t\\t\\t\\t\\t\\t\\tsendwpModal.toggleModal(false);\\n\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\tvar sendwpModal = new NinjaModal(data);\\n\\t\\t\\t\\t}, 500);\\n\\t\\t\\t\"}]}", "no");
INSERT INTO `wp_options` VALUES("557", "cme_backup_auto_2022-01-12_10-37-29_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:77:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:47:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("593", "action_scheduler_hybrid_store_demarkation", "26", "yes");
INSERT INTO `wp_options` VALUES("594", "schema-ActionScheduler_StoreSchema", "7.0.1693451113", "yes");
INSERT INTO `wp_options` VALUES("595", "schema-ActionScheduler_LoggerSchema", "3.0.1645174818", "yes");
INSERT INTO `wp_options` VALUES("596", "wp_mail_smtp_initial_version", "3.2.1", "no");
INSERT INTO `wp_options` VALUES("597", "wp_mail_smtp_version", "3.2.1", "no");
INSERT INTO `wp_options` VALUES("598", "wp_mail_smtp", "a:12:{s:4:\"mail\";a:6:{s:10:\"from_email\";s:23:\"stanbouwman@klassebv.nl\";s:9:\"from_name\";s:4:\"Stan\";s:6:\"mailer\";s:4:\"mail\";s:11:\"return_path\";b:1;s:16:\"from_email_force\";b:1;s:15:\"from_name_force\";b:1;}s:4:\"smtp\";a:7:{s:7:\"autotls\";s:3:\"yes\";s:4:\"auth\";s:3:\"yes\";s:4:\"host\";s:0:\"\";s:10:\"encryption\";s:4:\"none\";s:4:\"port\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";}s:7:\"general\";a:7:{s:29:\"summary_report_email_disabled\";b:1;s:11:\"do_not_send\";b:0;s:23:\"am_notifications_hidden\";b:0;s:28:\"email_delivery_errors_hidden\";b:0;s:23:\"dashboard_widget_hidden\";b:0;s:9:\"uninstall\";b:0;s:22:\"usage-tracking-enabled\";b:0;}s:7:\"smtpcom\";a:2:{s:7:\"api_key\";s:0:\"\";s:7:\"channel\";s:0:\"\";}s:10:\"sendinblue\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:5:\"gmail\";a:2:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";}s:7:\"mailgun\";a:3:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:8:\"postmark\";a:2:{s:16:\"server_api_token\";s:0:\"\";s:14:\"message_stream\";s:0:\"\";}s:8:\"sendgrid\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:9:\"sparkpost\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:9:\"sendlayer\";a:1:{s:7:\"api_key\";s:0:\"\";}s:7:\"smtp2go\";a:1:{s:7:\"api_key\";s:0:\"\";}}", "off");
INSERT INTO `wp_options` VALUES("599", "wp_mail_smtp_activated_time", "1641985489", "no");
INSERT INTO `wp_options` VALUES("600", "wp_mail_smtp_activated", "a:1:{s:4:\"lite\";i:1641985489;}", "yes");
INSERT INTO `wp_options` VALUES("603", "action_scheduler_lock_async-request-runner", "66d6f25a109515.72703739|1725362838", "yes");
INSERT INTO `wp_options` VALUES("611", "wp_mail_smtp_migration_version", "5", "yes");
INSERT INTO `wp_options` VALUES("612", "wp_mail_smtp_debug_events_db_version", "1", "yes");
INSERT INTO `wp_options` VALUES("613", "wp_mail_smtp_activation_prevent_redirect", "1", "yes");
INSERT INTO `wp_options` VALUES("614", "wp_mail_smtp_review_notice", "a:2:{s:4:\"time\";i:1641985492;s:9:\"dismissed\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("750", "wp_mail_smtp_debug", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("751", "wp_mail_smtp_lite_sent_email_counter", "311", "on");
INSERT INTO `wp_options` VALUES("752", "wp_mail_smtp_lite_weekly_sent_email_counter", "a:12:{i:25;i:1;i:26;i:1;i:27;i:1;i:28;i:1;i:29;i:1;i:30;i:1;i:31;i:1;i:32;i:1;i:33;i:1;i:34;i:1;i:35;i:1;i:36;i:1;}", "on");
INSERT INTO `wp_options` VALUES("965", "wpseo_sitemap_post_cache_validator", "3cu5J", "off");
INSERT INTO `wp_options` VALUES("1181", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO `wp_options` VALUES("1182", "wordfence_syncingAttackData", "0", "no");
INSERT INTO `wp_options` VALUES("1183", "wordfence_lastSyncAttackData", "1709432177", "no");
INSERT INTO `wp_options` VALUES("1430", "wp_mail_smtp_notifications", "a:4:{s:6:\"update\";i:1725286991;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:1:{i:0;s:2:\"29\";}}", "yes");
INSERT INTO `wp_options` VALUES("1460", "wpseo_sitemap_attachment_cache_validator", "4Oath", "no");
INSERT INTO `wp_options` VALUES("1688", "_site_transient_mwp_sessions", "a:1:{i:1;a:120:{i:0;s:43:\"r2Efl4cE0NsOHNJxRuRHnqUoZy4paSki9rfwHOM6mso\";i:1;s:43:\"Jez0VOYAw5TlWUrG2LuStK1RzONo3R9bUF0ZAgHhSvk\";i:2;s:43:\"declnKuYSEdEAk4TalgwsQ0vOgJJ4t4ixB824RYM97e\";i:3;s:43:\"XxbhZpUtTz1LFTNb8BkrQ4lmMw25dpwT8bj8ej6QjdR\";i:4;s:43:\"FLX6hIzNBR3grb7cxZ40ptY3tgr2VcUezLBEajNtX9C\";i:5;s:43:\"RmRhsJ3FgRHRNiyNyMMD2xUU9AScaUQLIpKlNbSUFPT\";i:6;s:43:\"8MNLEsphiFb0nX8SNy37Gfg5IupqHcJZkKh0yKRh3pg\";i:7;s:43:\"5vk8RnE3J3U9f8GI5BiRZYOFY63IHYQNGlG6lF6hsc8\";i:8;s:43:\"A4aUXuQWBIeuKLQOJlfgkbtHAD2OFBToqyeZlRvU2BO\";i:9;s:43:\"svl7icjMpticveHHAfaBze8nNgv9FHBhupNc25zbt3J\";i:10;s:43:\"xDlLCN2KUN63xoXGOlNqZI7NGnLR4noCP62eCEJGMUS\";i:11;s:43:\"k1HaKMsYyZ2XOiqeqjjXv46PHyKYQlGLHXmqi8BV1WI\";i:12;s:43:\"aF9fGofpxGxOW8SrWk6DZDwBNdM99eXgCcyL4VG1u0m\";i:13;s:43:\"DGixd4F95l3tAvKf8l0x0oXNbya6fPjPhOA3hAwAQ0V\";i:14;s:43:\"NDN0XVY04mh688ghT50OkqIbByW0OxR4FaVt4AIXvxE\";i:15;s:43:\"GDgd03nAdoxYYBxbxWntVOI78l3zY18hYiV74MEekSy\";i:16;s:43:\"JDs9KDD9gu5xud8DZYWSeQalHE9QQWq7kgbnSnruNEO\";i:17;s:43:\"6JRTLOH2uTYgjTJ1zXhT1T6UDvxIn7juf4dcucIey2L\";i:18;s:43:\"4keTwDmeV93Dx56g36YcLzWWF7ukfCuWhxt82zh4xEv\";i:19;s:43:\"lAj6rM4uxMdAJbAmjhTsi53pJymlmDQ0pfwygjHasrV\";i:20;s:43:\"rgIJHgX3vwq0o2rYTYGJESOViCi1AvGTUrBFZli94cK\";i:21;s:43:\"GnJWXexGJv1WRLDkF4q3olEUom2hsiFsqumv2s5Zqhe\";i:22;s:43:\"9uY9xwBUXRVbkT198eHAvXTzgcCPqOeFehKEnK9il9r\";i:23;s:43:\"1rnEUPunqLP9vtzSj5fcphYxhEbTKXM5OSRELNUpal2\";i:24;s:43:\"5TO7o38raux2wrmS1kd95e3yCNvEptLJmEvaLLjF0Ts\";i:25;s:43:\"KyPX7d1nXCLurhQR2XsAmhnEJIHgLwIY8cx06PTmC6M\";i:26;s:43:\"aOfzcvRRVDmZ5CYM12cVIJGRBJ3VWQP1pqgxObFxRny\";i:27;s:43:\"QUbhBJNqubempp4pTI9tjlM5soHznDGeogXFoa7mDca\";i:28;s:43:\"lSHuRd5NEcjFQ5jy6wZ7WJEDJ3Wjo7JfQB25xBgNVmI\";i:29;s:43:\"8IFTuMhx3yq8CurlPR4ao8ggUhBuSjbWBEiDHEgd2Jv\";i:30;s:43:\"9WFiyhVpyBL8KfCJANrhn48kFejlrLyktrq7pAxqlDR\";i:31;s:43:\"C93LO0itm94vjtCtFqSuz7Ylq7fhpC6lPf6354SeBpI\";i:32;s:43:\"zzv9Tls7l1t3AOi8mhzPCFsM0mSmlS6sUY1mCtBCRrB\";i:33;s:43:\"UPzNhSRiubrvpkErOBwj8dxLjIO4N1PS03Az6Ohsrpk\";i:34;s:43:\"ppwE6Z33JEV0iPn1nH6m2ozHLusQagcZiaCwCIn5ag7\";i:35;s:43:\"ZuXV9w6GXBDCcQD6oXk0N9WJv0fXeqfMwWeHSoxV505\";i:36;s:43:\"nguaZV4ZVXFl2eK9RUTq6vxDcnVoGAzpcdKDMt2GUGq\";i:37;s:43:\"fJrecwzT2wceVAe6wDsnByYa7i5jSoVQhRFAwzFh9JM\";i:38;s:43:\"8wFNgKkqBdB076Za0RdtDzzEhYRtaukTg4KJWa7OtlG\";i:39;s:43:\"AvoehQTl8W8J78xJCPn75fbJC8lOGE8EXyzN5jj6k7A\";i:40;s:43:\"WVgtz4kphkG1iuzVGTisMBN74NchlV6YOTdogwD8ngn\";i:41;s:43:\"zyPvfDtRFTggXxj5I5a5mYP5T385omIq3Y7Hygk2ThM\";i:42;s:43:\"nQ1MiQyfuoIRuEjgyaQ1EiKA7oij7R6HkQUxhECaRgn\";i:43;s:43:\"bRLuo103yjaJ2PbHfob1AVptDI8QFqtmvFC5YcuybLi\";i:44;s:43:\"QvWPq6uYY7of3hYDyrYR0LZN03VeI9aXqGnDgWBi2iM\";i:45;s:43:\"z64unhNtMbQKTYZE8HxRwkrWm1ex3EExuc8mT3Q84ea\";i:46;s:43:\"zeUkHyLdKRv7WwDLBLoZKzeMSSSvPkU9WLx88VtJHuR\";i:47;s:43:\"DZHqwqAR46aUy3GjgJda64pwaU696wtaP7epqRRgBth\";i:48;s:43:\"MF2HfaIuEK7BvRLp6przqv4cWgBR1lmGiScq9NFfRIb\";i:49;s:43:\"k62S8iB4s1fXT7nZ82gWliPIWeNW36I4JNfCunU16yZ\";i:50;s:43:\"bekukH39ggWBBDV96dQTFIRtzqmXJfeT6DfGDK57DRe\";i:51;s:43:\"OJZe2Eyo18lznPbA8o00FjRwZeEeSL6vuIMD7a1mJyR\";i:52;s:43:\"q8KqTIFJeKWW98qlKlwYiH3pWhZHo9fowTlOfWH3so4\";i:53;s:43:\"Ic8uKnyYzaY7dIRwlYG9pDjQs5mafAvGNHYgRuDNUoH\";i:54;s:43:\"1NN1Qx59S4Cgcsepw0mExDjTddiE2SNjrjahyyLfzts\";i:55;s:43:\"uB8p2Y9eiXXaTMrJWEmxGROIo53mdqblOV3QYlN88hf\";i:56;s:43:\"VOrFEwS4ve2nHvstZRahAbVYmyao1HdNLHFA0Jky7YT\";i:57;s:43:\"9fmMOtI8vF67G5z4sGWj5BL9C9FlyKGXeKJkwNJ09J4\";i:58;s:43:\"z0laU9DtzJ1vgn7Ys5NxcVg9vTOyMAjRtTTPDdHvQJa\";i:59;s:43:\"GL4lcNuZFP4k50yKi7V8xL7sU5VlU9BJ8EapZXvesgf\";i:60;s:43:\"UOhp9OkGAGj9vaDXxB0peJDIqAF91E79V0ZMcnqnc5q\";i:61;s:43:\"H9LoUI5qrjWddxkBpxeOmmsdUAg2Ildg2unxkbOcALb\";i:62;s:43:\"JquYVSy1kVxjNGEWFNQglf7LfWmfBFoY3xZvHy9uDrC\";i:63;s:43:\"zipFKoUlsN1VJLTEz8EK17JwZ3xsJhQrkvIw9pVBaol\";i:64;s:43:\"NVu6NO1QKcLQhrroDQ8EO48UpKIVWJUdMrPxXgpWQFr\";i:65;s:43:\"YzbQVCQxIJzMFxGGwPZQr5yyOSRPw0dMMj9ks7la8BK\";i:66;s:43:\"ueQRizuCufaNHzEHwzh3aqpdYtSY3shbMaiCTuVNt9s\";i:67;s:43:\"HPxoSxBglt85WLTuKsp1SF3uLmIhi5ifQlPb0wlS3eK\";i:68;s:43:\"ffjM7Zs3LqGYS6oJp9MnAdecCmro9re9X45hCWUMfm3\";i:69;s:43:\"Fh1f8AzSv4u2TNxUQ0Ir4iXKiHSBOMlBTEwbhxgMgsj\";i:70;s:43:\"xEqzwyDRfzMZzkzagkn0n86llmJmcNT7N2hUxkGLTUY\";i:71;s:43:\"zlmf23nqK9TrWZxRpXr3i1eNOoAB3JWdi6h75OSoVSM\";i:72;s:43:\"aZ9GZh1WUfr8KEwpmzZZeCO4r47WFhEpCTIbeBxYr8c\";i:73;s:43:\"GBOMfGdc96BeYGb65ppkzPchFWScHaSJ18cNSEwmoMa\";i:74;s:43:\"WOe3fURXsE8ZcAB5BlnPSRU2lNNG8F3RVkdBE2IG3WX\";i:75;s:43:\"TYf6HCkcyc0d2eKpPeyjx1kSQXMjZONPxB6I1Up6ETd\";i:76;s:43:\"r1PQcQYMEyI0bQdHSrmcq68hu6OOmQKEouLib6JokEt\";i:77;s:43:\"fzxuKajoTa6RL47J32Tn8475l9bSfzhH3ImOyOkZOYD\";i:78;s:43:\"RkeRmcu49Kgsjg7gcnLvG1ULDYLwDTwomRKzVQT3FuC\";i:79;s:43:\"GdL3sHwUMWt4bdyVCwIm43l93lvDnTemjLORoh8cZBg\";i:80;s:43:\"a7u72Ad9wCtryu0htSV0pdDbHEewEgwVmSWmR47v8W2\";i:81;s:43:\"pNKLlb7VRR7Q3HNXOQOwhjrslvFpTsSg9dgeygHFWdR\";i:82;s:43:\"92XcMCFERBsIxY7xH29THyNKiSaUoosOt1lbjl8HX4o\";i:83;s:43:\"LkzJ158NDelscpacUurIGpoYf0f4CBCW3YrinfMs9nm\";i:84;s:43:\"XYkXgdYWiLaWn2xAWKe7o4lAXx6LMZGOM2IKijk0hdV\";i:85;s:43:\"wUqo5LQ7vVSY1Q54aHnRmyrb62ksDpvjN8NEYhorHwU\";i:86;s:43:\"qQ3IIOr8BWsXovxQ0WHfvINXs0Ews8z0N6yi6jTBHON\";i:87;s:43:\"WjkNrqhUv4G7Gpvgv5q345XEbXVASz9UShxcTy8KzLC\";i:88;s:43:\"5pLz9vZwKqAthFAcHq0rVzYAhtZixNlYPB9GBHDttJm\";i:89;s:43:\"JxKdrYpKL1LtBioqmM8nHaEnn4zWKzPQ5byUiHPnD0a\";i:90;s:43:\"j4PCKop5KRnpWO3fyTVvrcpPsrnrUcHlzsKYP56VEJ0\";i:91;s:43:\"ENqd71V93YYFzxi8E2RFZP1qhQvcwLGU8k72O0zEDvs\";i:92;s:43:\"6W10khMJWDdJT5pmy2DcP9WUdZz8PXvJJHRefyV7iv8\";i:93;s:43:\"QJ9xC5aYMIq6qzK7zDuLfIGXMUbab0os90moh78HmCM\";i:94;s:43:\"NG5BuTPzKiM88WM4F0zBtMCiZQR5fHowAaNSNJuu3DN\";i:95;s:43:\"D7rMpkm1USYzWTVHU5K37Y4w9uETsQeFmZoi84x29bC\";i:96;s:43:\"SnY2Ym4xYcTvJpcTaFbjeHGletdSai2gJZ84KmlAfGA\";i:97;s:43:\"zX1wLPN2o7ANiAUWsNA2WHK1sNO88M0iR8m7b1iUr6g\";i:98;s:43:\"kHwNmrjeSsGihPlLJd1P6T3uyMg9MsHCriyJTu5ibhe\";i:99;s:43:\"MB8d9sWe2MBy4zgvwMmWVlTpJvMdSDe44qtGkz2wOr8\";i:100;s:43:\"vavu31FXBH716nrquadZSkS691msQTTYlHi3002JQwv\";i:101;s:43:\"A9mtr91K0jqVamwe5UOn0khINYgmurTAQ2wOBR4t5L4\";i:102;s:43:\"D8QdmRqOUguW88jwUCb4uHD4spZIgGgXqLBknvwQ7cV\";i:103;s:43:\"70Bvvwxj3U2VFevPN2IaBMRluz2xzWNUdmNKZ33u1qk\";i:104;s:43:\"1R0qS7bp4eKAP6BibarqayOMIyEAEhi7H7cGNiDtJkf\";i:105;s:43:\"XWvt2UPp213Lyi4j4f5wJxFXjVpLTzTQsWNOK3xQV5m\";i:106;s:43:\"l5WA6rle3nhCHmp606E8jh57iQzoobd7GVDLheJhrwO\";i:107;s:43:\"nBBxBv9uVimVUKPOHlYInOv7NzjM1gVqxk4ipWK1eOV\";i:108;s:43:\"2cNUJZfnsNedz3HuTenU9fKpKVwUqxgVo42eRXSNTG8\";i:109;s:43:\"3ZVNdkKsHVqeknZoyxQGFaGm7V7llT3acogG0QdI4Sr\";i:110;s:43:\"GbykN3KiHwbctst0jD9Idu0xiqCE5HA7FxJTIrpxmNM\";i:111;s:43:\"KpKCAAWVj8r4VlyNsDdjCL5ieBlB3qEKsqpR5GAIcw4\";i:112;s:43:\"3drbeH032wGUfVGTWxiVSb5sr5xIwpVeLzPyEKply1L\";i:113;s:43:\"KrQjcKKvxHyvHGSSeaFgiYHAyEqzacEhIg8zp3kJge0\";i:114;s:43:\"fZlaYitKaWX8co21jptUt7Fe71quGTtmIHjsapyuCH8\";i:115;s:43:\"HZLiBdYKzbNe7GXfBRDJPTJou0voToJFTOc5RSLEZMs\";i:116;s:43:\"5dcyNNLTOik32AK9VysPeihqKvOfQh9MUzqw1yg9nU1\";i:117;s:43:\"JYoppsjXPIEvzUUbQE4zqjGzpBR7zAe6vwYdlxXqhmL\";i:118;s:43:\"K4jVk6zzvFA9fa2TeWP9hDqxVgtUqhQKzEyKkRBgWbn\";i:119;s:43:\"Ly06bGDdQK4jHBRa3PfCdJDzyc15YjLyOmFaLzzLNqq\";}}", "no");
INSERT INTO `wp_options` VALUES("1715", "kls_api_last_change", "03/02/2022 - 02:19:50", "yes");
INSERT INTO `wp_options` VALUES("1949", "kls_security_trusted_ips", "146.59.192.120,109.234.160.58,51.83.15.135,51.210.39.196,135.125.83.227,146.59.251.59,62.194.142.10,83.82.19.56,163.158.32.181,44.239.130.172,44.238.191.15,35.155.126.231,54.68.32.247,44.235.211.232,54.71.203.174,34.211.180.66,54.70.65.107,34.210.224.7,52.41.5.108,52.35.72.129,54.191.137.17,35.162.254.253,52.11.12.231,52.11.29.70,52.11.54.161,52.24.142.159,52.25.191.255,52.34.126.117,52.34.254.47,52.35.82.99,52.36.28.80,52.39.177.152,52.41.237.12,52.43.13.71,52.43.76.224,52.88.96.110,52.89.155.51,54.187.92.57,54.191.32.65,54.191.67.23,54.191.80.119,54.191.135.209,54.191.136.176,54.191.148.85,54.191.149.8,52.26.122.21,52.24.187.29,52.89.85.107,54.186.128.167,54.191.40.136,52.88.119.122,52.89.94.121,52.25.116.116,52.88.215.225,54.186.143.184,52.88.197.180,52.27.171.126,34.211.178.241,52.24.232.158,52.26.187.210,52.42.189.119,54.186.244.128,54.71.54.102,34.210.35.214,34.213.77.188,34.218.121.176,52.10.190.191,52.10.225.96,52.11.187.168,52.25.139.76,52.43.127.200,54.191.108.9,54.70.201.228,44.224.174.169,52.32.57.81,44.225.177.160,34.223.186.249,44.224.135.238,44.226.111.14,44.225.203.104,44.226.100.122,44.224.250.144,44.225.118.211,54.189.93.69,44.231.184.112,44.238.10.27,54.185.116.30,44.238.58.95,52.13.23.154,54.149.16.35,44.226.97.20,54.244.242.144,44.238.67.135,44.235.15.76,54.214.47.164,34.214.48.135,54.184.234.227", "yes");
INSERT INTO `wp_options` VALUES("2856", "disabled_hit_count", "0", "yes");
INSERT INTO `wp_options` VALUES("3461", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("3493", "kls_wp_rocket_preload_interval", "500", "yes");
INSERT INTO `wp_options` VALUES("3521", "kls_theme_admin_link_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("3522", "kls_action_bar_button_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("3562", "nf_form_tel_data", "1", "no");
INSERT INTO `wp_options` VALUES("3563", "ninja_forms_do_not_allow_tracking", "1", "yes");
INSERT INTO `wp_options` VALUES("3564", "nf_sub_expiration", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3565", "nf_form_tel_sent", "true", "no");
INSERT INTO `wp_options` VALUES("3572", "kls_customer_logo", "252", "yes");
INSERT INTO `wp_options` VALUES("3573", "kls_customer_favicon", "252", "yes");
INSERT INTO `wp_options` VALUES("3574", "kls_customer_name", "Boxing Company", "yes");
INSERT INTO `wp_options` VALUES("3575", "kls_customer_email", "klantemail@opzet-website.nl", "yes");
INSERT INTO `wp_options` VALUES("3576", "kls_customer_phone", "06 11223344", "yes");
INSERT INTO `wp_options` VALUES("3577", "kls_customer_street", "Straatnaam 12", "yes");
INSERT INTO `wp_options` VALUES("3578", "kls_customer_postcode", "1111 AA", "yes");
INSERT INTO `wp_options` VALUES("3579", "kls_customer_city", "Stad", "yes");
INSERT INTO `wp_options` VALUES("3580", "kls_customer_country", "Nederland", "yes");
INSERT INTO `wp_options` VALUES("3581", "kls_customer_kvk", "", "yes");
INSERT INTO `wp_options` VALUES("3582", "kls_customer_btw", "", "yes");
INSERT INTO `wp_options` VALUES("3586", "kls_customer_usp_1", "Lorem Ipsum", "yes");
INSERT INTO `wp_options` VALUES("3587", "kls_customer_usp_1_description", "", "yes");
INSERT INTO `wp_options` VALUES("3588", "kls_customer_usp_1_icon", "", "yes");
INSERT INTO `wp_options` VALUES("3589", "kls_customer_usp_2", "Lorem Ipsum", "yes");
INSERT INTO `wp_options` VALUES("3590", "kls_customer_usp_2_description", "", "yes");
INSERT INTO `wp_options` VALUES("3591", "kls_customer_usp_2_icon", "", "yes");
INSERT INTO `wp_options` VALUES("3592", "kls_customer_usp_3", "Lorem Ipsum", "yes");
INSERT INTO `wp_options` VALUES("3593", "kls_customer_usp_3_description", "", "yes");
INSERT INTO `wp_options` VALUES("3594", "kls_customer_usp_3_icon", "", "yes");
INSERT INTO `wp_options` VALUES("3595", "kls_customer_usp_4", "Lorem Ipsum", "yes");
INSERT INTO `wp_options` VALUES("3596", "kls_customer_usp_4_description", "", "yes");
INSERT INTO `wp_options` VALUES("3597", "kls_customer_usp_4_icon", "", "yes");
INSERT INTO `wp_options` VALUES("3598", "kls_customer_usp_5", "Lorem Ipsum", "yes");
INSERT INTO `wp_options` VALUES("3599", "kls_customer_usp_5_description", "", "yes");
INSERT INTO `wp_options` VALUES("3600", "kls_customer_usp_5_icon", "", "yes");
INSERT INTO `wp_options` VALUES("3601", "kls_customer_usp_6", "Lorem Ipsum", "yes");
INSERT INTO `wp_options` VALUES("3602", "kls_customer_usp_6_description", "", "yes");
INSERT INTO `wp_options` VALUES("3603", "kls_customer_usp_6_icon", "", "yes");
INSERT INTO `wp_options` VALUES("3604", "kls_customer_usp_icon_size", "", "yes");
INSERT INTO `wp_options` VALUES("3605", "kls_customer_main_color", "", "yes");
INSERT INTO `wp_options` VALUES("3608", "kls_opening_hours_monday", "08:30-17:00", "yes");
INSERT INTO `wp_options` VALUES("3609", "kls_opening_hours_tuesday", "08:30-17:00", "yes");
INSERT INTO `wp_options` VALUES("3610", "kls_opening_hours_wednesday", "08:30-17:00", "yes");
INSERT INTO `wp_options` VALUES("3611", "kls_opening_hours_thursday", "08:30-17:00", "yes");
INSERT INTO `wp_options` VALUES("3612", "kls_opening_hours_friday", "08:30-17:00", "yes");
INSERT INTO `wp_options` VALUES("3613", "kls_opening_hours_saterday", "Gesloten", "yes");
INSERT INTO `wp_options` VALUES("3614", "kls_opening_hours_sunday", "Gesloten", "yes");
INSERT INTO `wp_options` VALUES("3618", "kls_customer_facebook", "#", "yes");
INSERT INTO `wp_options` VALUES("3619", "kls_customer_instagram", "#", "yes");
INSERT INTO `wp_options` VALUES("3620", "kls_customer_linkedin", "", "yes");
INSERT INTO `wp_options` VALUES("3621", "kls_customer_youtube", "", "yes");
INSERT INTO `wp_options` VALUES("3622", "kls_customer_pinterest", "", "yes");
INSERT INTO `wp_options` VALUES("3623", "kls_customer_whatsapp", "", "yes");
INSERT INTO `wp_options` VALUES("3626", "kls_customer_form_email", "", "yes");
INSERT INTO `wp_options` VALUES("3627", "kls_customer_form_cc_email", "", "yes");
INSERT INTO `wp_options` VALUES("3628", "kls_customer_form_bcc_email", "", "yes");
INSERT INTO `wp_options` VALUES("3629", "kls_customer_zapier_email", "", "yes");
INSERT INTO `wp_options` VALUES("3630", "kls_customer_zapier_webhook", "", "yes");
INSERT INTO `wp_options` VALUES("3688", "kls_action_bar_close_button_location", "Left", "yes");
INSERT INTO `wp_options` VALUES("3751", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("3975", "duplicator_settings", "a:23:{s:7:\"version\";s:8:\"1.5.10.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:23;s:14:\"usage_tracking\";b:0;s:23:\"duparchive_create_state\";O:27:\"DUP_DupArchive_Create_State\":21:{s:8:\"basePath\";s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";s:11:\"archivePath\";s:149:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp/opzetopzet_migration_files_766f68c7175af55b7263_20240903093452_archive.daf\";s:12:\"isCompressed\";b:1;s:17:\"currentFileOffset\";i:0;s:13:\"archiveOffset\";i:142686473;s:15:\"timeSliceInSecs\";i:10;s:7:\"working\";b:0;s:8:\"failures\";a:0:{}s:12:\"failureCount\";i:0;s:14:\"startTimestamp\";i:1725356126;s:17:\"throttleDelayInUs\";i:0;s:16:\"timeoutTimestamp\";i:1725356136;s:12:\"timerEnabled\";b:1;s:8:\"isRobust\";b:0;s:14:\"basepathLength\";i:0;s:21:\"currentDirectoryIndex\";i:2633;s:16:\"currentFileIndex\";i:14529;s:8:\"globSize\";i:1048576;s:11:\"newBasePath\";N;s:16:\"skippedFileCount\";i:0;s:21:\"skippedDirectoryCount\";i:1;}s:23:\"duparchive_expand_state\";O:8:\"stdClass\":33:{s:23:\"currentFileHeaderString\";N;s:19:\"archiveHeaderString\";s:21:\"{\"isCompressed\":true}\";s:14:\"failuresString\";s:2:\"[]\";s:8:\"basePath\";s:83:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp/validate\";s:11:\"archivePath\";s:149:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp/opzetopzet_migration_files_766f68c7175af55b7263_20240903093452_archive.daf\";s:12:\"isCompressed\";b:1;s:17:\"currentFileOffset\";i:0;s:13:\"archiveOffset\";i:145086301;s:15:\"timeSliceInSecs\";i:10;s:7:\"working\";b:0;s:8:\"failures\";a:0:{}s:12:\"failureCount\";i:0;s:14:\"startTimestamp\";i:1725356131;s:17:\"throttleDelayInUs\";i:0;s:16:\"timeoutTimestamp\";i:1725356142;s:12:\"timerEnabled\";b:1;s:8:\"isRobust\";b:0;s:17:\"currentFileHeader\";N;s:12:\"validateOnly\";b:1;s:14:\"validationType\";i:0;s:14:\"fileWriteCount\";i:15138;s:19:\"directoryWriteCount\";i:2764;s:17:\"expectedFileCount\";i:15138;s:22:\"expectedDirectoryCount\";i:2764;s:19:\"filteredDirectories\";a:0:{}s:24:\"excludedDirWithoutChilds\";a:0:{}s:13:\"filteredFiles\";a:0:{}s:13:\"includedFiles\";a:0:{}s:11:\"fileRenames\";a:0:{}s:21:\"directoryModeOverride\";i:-1;s:16:\"fileModeOverride\";i:-1;s:16:\"lastHeaderOffset\";i:-1;s:12:\"keepFileTime\";b:0;}s:12:\"last_updated\";s:19:\"2024-09-03-11-26-40\";s:18:\"package_ui_created\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("3976", "duplicator_version_plugin", "1.5.10.2", "yes");
INSERT INTO `wp_options` VALUES("3982", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-03 11:27:04\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.1.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:27:\"opzetopzet_migration_files2\";s:4:\"Hash\";s:35:\"f8f9c1cacc7704fc8669_20240903112704\";s:8:\"NameHash\";s:63:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:73:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2634;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14532;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-03 11:27:04\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.1.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:27:\"opzetopzet_migration_files2\";s:4:\"Hash\";s:35:\"f8f9c1cacc7704fc8669_20240903112704\";s:8:\"NameHash\";s:63:\"opzetopzet_migration_files2_f8f9c1cacc7704fc8669_20240903112704\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:56:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:51:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-admin\";i:1;s:54:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-includes\";i:2;s:63:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";i:1;s:42:\"/home/opzetweb/opzetstan2.opzet-website.nl\";i:2;s:53:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content\";i:3;s:61:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/uploads\";i:4;s:61:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/plugins\";i:5;s:64:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/mu-plugins\";i:6;s:60:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:74:\"/home/opzetweb/opzetstan2.opzet-website.nl/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("3993", "cme_backup_auto_2022-03-23_9-46-58_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:85:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:46:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("4715", "kls_scripts_fbpixel_optimization", "on", "yes");
INSERT INTO `wp_options` VALUES("5015", "et_server_domain_token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvd3d3LmVsZWdhbnR0aGVtZXMuY29tIiwiaWF0IjoxNjQ5NzYyODQyLCJ1c2VybmFtZSI6IkZpdExlYWRzIiwic3RhdHVzIjoiYWN0aXZlIiwibWF4X2l0ZW1zIjoiNTAiLCJtYXhfdHJhc2hfaXRlbXMiOiI1MCIsImRvbWFpbiI6Im9wemV0Lm9wemV0LXdlYnNpdGUubmwiLCJuYW1lIjoiRnJhbmsgQmx1eXNzZW4iLCJlbWFpbCI6ImluZm9Ad2Vic2l0ZXhwZXJ0cy5ubCIsIm1heF9ieXRlcyI6MH0.jCaQpcaeKGC80k23zEu-6UkvzqUlPdZ-_JI3V9uHzQL7K50O8qWK1b5xLuk1fCdBPanY_Lh0m6fN_8_3hhFHheXBiAgvsb98X7leQpoK-AyFVT_QoNj5Kj5Ui_lTzxfbdZ2sr65cAj8ZZ3v8K6PFO9ArwpOMwHaAR_QuHPbzQzr2nNmh3TqjfWhy5Luyxniewa_QjTyakQkhMlNc4vLLp1tpL7YfJ3rvLt3mp_a9UncGl7gzegkNT_Ae35Ea-fvvuSAhmmhHxI-aQM3njguhF3hx3lVoOJuwdVsjDTRgqYkLJBZa9QwOw94_LtCAMjAKToUNn-HfBdG0Rtr-SZ6EfZYWJAsqyUv5dx3kRSrYUkzY83NcO61FK9ewIUromQhZiVGIfhr15-TSBvf4-eZHkO-YYcUhTnDWKEnd5I11by6S9DNczmBJEi7IJK2DAAFQGXCULCw8zp57pMHKFb5ANEB0wHA5guqQySrf0VCIi6PyO5ZgrO1D3H6Ok46C466FstQ54PTwscphqRtBr8tFbwBH5-h_zNsrc0IiE4Prpj-KdoODgwGYztCsB-1t_XszDlttsIGr9zIDahF8O-mVcOENhyAj6PwuibjzrBKzk6CJpKF7nkTJ1igXBmCulhOm1aqv8uozWIQh4i4S4XwToZ4cY6N25TDWsImCtw6FrYI", "yes");
INSERT INTO `wp_options` VALUES("5016", "et_cloud_refresh_token", "a:1:{i:1;a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("5296", "wpseo_sitemap_category_cache_validator", "3cu5M", "off");
INSERT INTO `wp_options` VALUES("5623", "kls_toggle_anytime_integration", "", "yes");
INSERT INTO `wp_options` VALUES("5624", "kls_toggle_anytime_presale_integration", "", "yes");
INSERT INTO `wp_options` VALUES("5649", "kls_syncsilo_compatibility_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("5650", "kls_theme_deinstallation_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("5651", "kls_ratings_select", "Manually", "yes");
INSERT INTO `wp_options` VALUES("5652", "kls_rating", "", "yes");
INSERT INTO `wp_options` VALUES("5653", "kls_rating_url", "", "yes");
INSERT INTO `wp_options` VALUES("5654", "kls_rating_text", "", "yes");
INSERT INTO `wp_options` VALUES("5655", "kls_rating_image", "", "yes");
INSERT INTO `wp_options` VALUES("5656", "kls_kiyoh_url", "https://www.kiyoh.com/v1/review/feed.xml?hash=1dtegvcmiuu4ptg", "yes");
INSERT INTO `wp_options` VALUES("6144", "rewrite_rules", "a:267:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:16:\"kls-website-api$\";s:27:\"index.php?kls-website-api=1\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:56:\"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?layout_category=$matches[1]&feed=$matches[2]\";s:51:\"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?layout_category=$matches[1]&feed=$matches[2]\";s:32:\"layout_category/([^/]+)/embed/?$\";s:48:\"index.php?layout_category=$matches[1]&embed=true\";s:44:\"layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?layout_category=$matches[1]&paged=$matches[2]\";s:26:\"layout_category/([^/]+)/?$\";s:37:\"index.php?layout_category=$matches[1]\";s:51:\"layout_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?layout_tag=$matches[1]&feed=$matches[2]\";s:46:\"layout_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?layout_tag=$matches[1]&feed=$matches[2]\";s:27:\"layout_tag/([^/]+)/embed/?$\";s:43:\"index.php?layout_tag=$matches[1]&embed=true\";s:39:\"layout_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?layout_tag=$matches[1]&paged=$matches[2]\";s:21:\"layout_tag/([^/]+)/?$\";s:32:\"index.php?layout_tag=$matches[1]\";s:56:\"et_tb_item_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?et_tb_item_type=$matches[1]&feed=$matches[2]\";s:51:\"et_tb_item_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?et_tb_item_type=$matches[1]&feed=$matches[2]\";s:32:\"et_tb_item_type/([^/]+)/embed/?$\";s:48:\"index.php?et_tb_item_type=$matches[1]&embed=true\";s:44:\"et_tb_item_type/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?et_tb_item_type=$matches[1]&paged=$matches[2]\";s:26:\"et_tb_item_type/([^/]+)/?$\";s:37:\"index.php?et_tb_item_type=$matches[1]\";s:38:\"et_tb_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"et_tb_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"et_tb_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"et_tb_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"et_tb_item/([^/]+)/embed/?$\";s:58:\"index.php?post_type=et_tb_item&name=$matches[1]&embed=true\";s:31:\"et_tb_item/([^/]+)/trackback/?$\";s:52:\"index.php?post_type=et_tb_item&name=$matches[1]&tb=1\";s:39:\"et_tb_item/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&paged=$matches[2]\";s:46:\"et_tb_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&cpage=$matches[2]\";s:35:\"et_tb_item/([^/]+)(?:/([0-9]+))?/?$\";s:64:\"index.php?post_type=et_tb_item&name=$matches[1]&page=$matches[2]\";s:27:\"et_tb_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"et_tb_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"et_tb_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"et_tb_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:61:\"et_code_snippet_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:56:\"et_code_snippet_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:37:\"et_code_snippet_type/([^/]+)/embed/?$\";s:53:\"index.php?et_code_snippet_type=$matches[1]&embed=true\";s:49:\"et_code_snippet_type/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?et_code_snippet_type=$matches[1]&paged=$matches[2]\";s:31:\"et_code_snippet_type/([^/]+)/?$\";s:42:\"index.php?et_code_snippet_type=$matches[1]\";s:43:\"et_code_snippet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"et_code_snippet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"et_code_snippet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"et_code_snippet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"et_code_snippet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"et_code_snippet/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"et_code_snippet/([^/]+)/embed/?$\";s:63:\"index.php?post_type=et_code_snippet&name=$matches[1]&embed=true\";s:36:\"et_code_snippet/([^/]+)/trackback/?$\";s:57:\"index.php?post_type=et_code_snippet&name=$matches[1]&tb=1\";s:44:\"et_code_snippet/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&paged=$matches[2]\";s:51:\"et_code_snippet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&cpage=$matches[2]\";s:40:\"et_code_snippet/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?post_type=et_code_snippet&name=$matches[1]&page=$matches[2]\";s:32:\"et_code_snippet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"et_code_snippet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"et_code_snippet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"et_code_snippet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"et_code_snippet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"et_code_snippet/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:37:\"et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:45:\"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:32:\"et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:40:\"et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:47:\"et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:36:\"et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:28:\"et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:37:\"et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:45:\"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:35:\"et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:43:\"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:50:\"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:39:\"et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:31:\"et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:37:\"et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:45:\"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=15&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("6751", "wpseo_sitemap_57_cache_validator", "l6d", "no");
INSERT INTO `wp_options` VALUES("7198", "_transient_rocket_preload_errors", "a:1:{s:6:\"errors\";a:3:{i:0;s:330:\"Preload encountered an error. Could not gather links on https://opzetstan2.opzet-website.nl because it returned the following response code: 503. <a href=\"https://docs.wp-rocket.me/article/1065-sitemap-preload-is-slow-or-some-pages-are-not-preloaded-at-all#failed-preload\" rel=\"noopener noreferrer\" target=_\"blank\">Learn more</a>.\";i:1;s:391:\"Preload encountered an error. Could not gather links on https://opzetstan2.opzet-website.nl because of the following error: cURL error 28: Operation timed out after 10001 milliseconds with 0 bytes received. <a href=\"https://docs.wp-rocket.me/article/1065-sitemap-preload-is-slow-or-some-pages-are-not-preloaded-at-all#failed-preload\" rel=\"noopener noreferrer\" target=_\"blank\">Learn more</a>.\";i:2;s:391:\"Preload encountered an error. Could not gather links on https://opzetstan2.opzet-website.nl because of the following error: cURL error 28: Operation timed out after 10001 milliseconds with 0 bytes received. <a href=\"https://docs.wp-rocket.me/article/1065-sitemap-preload-is-slow-or-some-pages-are-not-preloaded-at-all#failed-preload\" rel=\"noopener noreferrer\" target=_\"blank\">Learn more</a>.\";}}", "yes");
INSERT INTO `wp_options` VALUES("8641", "widget_simple_job_board_widgets_recent_jobs", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("8650", "wpseo_sitemap_jobpost_cache_validator", "li5U", "no");
INSERT INTO `wp_options` VALUES("8655", "jobpost_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("8656", "jobpost_job_type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("8657", "jobpost_location_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("8682", "code_snippets_version", "3.1.1", "yes");
INSERT INTO `wp_options` VALUES("8687", "code_snippets_settings", "a:3:{s:7:\"general\";a:6:{s:19:\"activate_by_default\";b:1;s:11:\"enable_tags\";b:1;s:18:\"enable_description\";b:1;s:10:\"list_order\";s:8:\"priority\";s:13:\"disable_prism\";b:0;s:18:\"complete_uninstall\";b:0;}s:18:\"description_editor\";a:3:{s:4:\"rows\";i:5;s:12:\"use_full_mce\";b:0;s:13:\"media_buttons\";b:0;}s:6:\"editor\";a:9:{s:5:\"theme\";s:7:\"default\";s:16:\"indent_with_tabs\";b:1;s:8:\"tab_size\";i:4;s:11:\"indent_unit\";i:4;s:10:\"wrap_lines\";b:1;s:12:\"line_numbers\";b:1;s:19:\"auto_close_brackets\";b:1;s:27:\"highlight_selection_matches\";b:1;s:21:\"highlight_active_line\";b:1;}}", "yes");
INSERT INTO `wp_options` VALUES("8691", "recently_activated_snippets", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("9224", "user_count", "2", "no");
INSERT INTO `wp_options` VALUES("9306", "_transient_rocket_preload_complete", "8", "yes");
INSERT INTO `wp_options` VALUES("9307", "_transient_rocket_preload_complete_time", "13/07/2022 @ 12:35", "yes");
INSERT INTO `wp_options` VALUES("10397", "forminator_free_install_date", "1660030730", "no");
INSERT INTO `wp_options` VALUES("10402", "wpmudev_recommended_plugins_registered", "a:2:{s:25:\"forminator/forminator.php\";a:1:{s:13:\"registered_at\";i:1660027130;}s:27:\"wordpress-popup/popover.php\";a:1:{s:13:\"registered_at\";i:1725350093;}}", "off");
INSERT INTO `wp_options` VALUES("10403", "forminator_version", "1.17.2", "yes");
INSERT INTO `wp_options` VALUES("10404", "widget_forminator_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("10406", "forminator_appearance_presets", "a:1:{s:7:\"default\";s:14:\"Default Preset\";}", "yes");
INSERT INTO `wp_options` VALUES("10407", "wpmudev_notices", "a:3:{s:7:\"plugins\";a:2:{s:10:\"forminator\";i:1660027139;s:6:\"hustle\";i:1725350094;}s:5:\"queue\";a:2:{s:10:\"forminator\";a:3:{s:5:\"email\";i:1660027139;s:4:\"rate\";i:1660631939;s:8:\"giveaway\";i:1660199939;}s:6:\"hustle\";a:3:{s:5:\"email\";i:1725350094;s:4:\"rate\";i:1725350094;s:8:\"giveaway\";i:1725350094;}}s:4:\"done\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("11784", "wpr_rocket_cache_version", "20220927", "yes");
INSERT INTO `wp_options` VALUES("11814", "wpseo_sitemap_project_cache_validator", "43KGK", "no");
INSERT INTO `wp_options` VALUES("12454", "duplicator_ui_view_state", "a:6:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";s:29:\"dup-package-dtl-install-panel\";s:1:\"1\";s:29:\"dup-package-dtl-storage-panel\";s:1:\"1\";s:29:\"dup-package-dtl-general-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("12899", "kls_customer_slogan", "Hier komt jouw slogan", "yes");
INSERT INTO `wp_options` VALUES("13613", "rocket_cache_dir_size_check", "1", "yes");
INSERT INTO `wp_options` VALUES("18963", "et_divi_builder_plugin_builder_global_presets_ng", "O:8:\"stdClass\":3:{s:9:\"et_pb_row\";O:8:\"stdClass\":2:{s:7:\"presets\";O:8:\"stdClass\":2:{s:8:\"_initial\";O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"Rij Voorinstelling 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.27.0\";s:7:\"is_temp\";b:0;s:8:\"settings\";O:8:\"stdClass\":4:{s:14:\"custom_padding\";s:19:\"0px||0px||true|true\";s:13:\"custom_margin\";s:24:\"150px||150px||true|false\";s:5:\"width\";s:3:\"90%\";s:9:\"max_width\";s:6:\"1305px\";}}s:36:\"8486286b-839f-46c9-9ba3-19e32de0769b\";O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"test\";s:7:\"created\";i:1725007700549;s:7:\"updated\";i:1725007700549;s:7:\"version\";s:6:\"4.27.0\";s:8:\"settings\";O:8:\"stdClass\":0:{}}}s:7:\"default\";s:8:\"_initial\";}s:11:\"et_pb_image\";O:8:\"stdClass\":2:{s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"Afbeelding Voorinstelling 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.27.0\";s:7:\"is_temp\";b:0;s:8:\"settings\";O:8:\"stdClass\":2:{s:13:\"custom_margin\";s:14:\"||||true|false\";s:17:\"show_bottom_space\";s:3:\"off\";}}}s:7:\"default\";s:8:\"_initial\";}s:11:\"et_pb_blurb\";O:8:\"stdClass\":2:{s:7:\"presets\";O:8:\"stdClass\":1:{s:8:\"_initial\";O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"Blurb Voorinstelling 1\";s:7:\"created\";i:0;s:7:\"updated\";i:0;s:7:\"version\";s:6:\"4.27.0\";s:7:\"is_temp\";b:0;s:8:\"settings\";O:8:\"stdClass\":4:{s:10:\"icon_color\";s:7:\"#0a0a0a\";s:16:\"image_icon_width\";s:4:\"67px\";s:14:\"icon_alignment\";s:4:\"left\";s:25:\"image_icon_custom_padding\";s:19:\"50px||||false|false\";}}}s:7:\"default\";s:8:\"_initial\";}}", "off");
INSERT INTO `wp_options` VALUES("18964", "et_divi_builder_plugin_builder_global_presets_history_ng", "O:8:\"stdClass\":2:{s:7:\"history\";a:1:{i:0;O:8:\"stdClass\":3:{s:8:\"settings\";O:8:\"stdClass\":0:{}s:4:\"time\";i:1649762863978;s:5:\"label\";s:25:\"Geïmporteerd uit lay-out\";}}s:5:\"index\";s:1:\"0\";}", "no");
INSERT INTO `wp_options` VALUES("20126", "kls_cookie_button_styling", "theme", "yes");
INSERT INTO `wp_options` VALUES("20127", "kls_cookie_body_text_color", "#222222", "yes");
INSERT INTO `wp_options` VALUES("20128", "kls_cookie_background_color", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("20129", "kls_cookie_bar_styling", "box", "yes");
INSERT INTO `wp_options` VALUES("20130", "kls_cookie_bar_location_horizontal", "left", "yes");
INSERT INTO `wp_options` VALUES("20131", "kls_cookie_bar_location_vertical", "bottom", "yes");
INSERT INTO `wp_options` VALUES("20132", "kls_cookie_bar_transition", "zoom", "yes");
INSERT INTO `wp_options` VALUES("20133", "kls_cookie_expiration", "182", "yes");
INSERT INTO `wp_options` VALUES("20134", "kls_cookie_popup_title", "Cookievoorkeuren", "yes");
INSERT INTO `wp_options` VALUES("20135", "kls_cookie_popup_intro_title", "Cookiegebruik", "yes");
INSERT INTO `wp_options` VALUES("20136", "kls_cookie_popup_intro_text", "Wij gebruiken cookies om de basisfunctionaliteiten van de website te waarborgen en om jouw online ervaring te verbeteren. Je kunt voor elke categorie kiezen om je aan of af te melden wanneer je maar wilt. Lees het volledige <a href=\"/cookiebeleid/\" class=\"cc-link\">cookiebeleid</a> voor meer informatie over cookies en andere gevoelige gegevens.", "yes");
INSERT INTO `wp_options` VALUES("20137", "kls_cookie_popup_necessary_title", "Noodzakelijke cookies", "yes");
INSERT INTO `wp_options` VALUES("20138", "kls_cookie_popup_necessary_text", "Noodzakelijke cookies helpen een website gebruiksvriendelijker te maken door basisfuncties zoals paginanavigatie en toegang tot beveiligde delen van de website mogelijk te maken. Zonder deze cookies kan de website niet goed functioneren.", "yes");
INSERT INTO `wp_options` VALUES("20139", "kls_cookie_popup_analytics_title", "Analytische cookies", "yes");
INSERT INTO `wp_options` VALUES("20140", "kls_cookie_popup_analytics_text", "Met deze cookies kan de website onthouden welke keuzes je in het verleden hebt gemaakt.", "yes");
INSERT INTO `wp_options` VALUES("20141", "kls_cookie_popup_marketing_title", "Marketing cookies", "yes");
INSERT INTO `wp_options` VALUES("20142", "kls_cookie_popup_marketing_text", "Deze cookies verzamelen informatie over hoe je de website gebruikt, welke pagina\'s je hebt bezocht en op welke links je hebt geklikt. Alle gegevens zijn geanonimiseerd en kunnen niet worden gebruikt om u te identificeren.", "yes");
INSERT INTO `wp_options` VALUES("20143", "kls_cookie_popup_more_info_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("20144", "kls_cookie_popup_more_info_title", "Meer informatie", "yes");
INSERT INTO `wp_options` VALUES("20145", "kls_cookie_popup_more_info_text", "Voor vragen over ons cookiebeleid en jouw keuzes kun je <a href=\"/contact/\" class=\"cc-link\">contact</a> met ons opnemen.", "yes");
INSERT INTO `wp_options` VALUES("20146", "kls_cookie_popup_accept_all_text", "Alles accepteren", "yes");
INSERT INTO `wp_options` VALUES("20147", "kls_cookie_popup_reject_all_text", "Alles weigeren", "yes");
INSERT INTO `wp_options` VALUES("20148", "kls_cookie_popup_save_settings_text", "Instellingen opslaan", "yes");
INSERT INTO `wp_options` VALUES("20174", "kls_legacy_cookie_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("20693", "kls_cookie_consentlog_toggle", "on", "yes");
INSERT INTO `wp_options` VALUES("20843", "kls_plugin_version", "0.0.93", "yes");
INSERT INTO `wp_options` VALUES("21345", "kls_cookie_table_background_color", "", "yes");
INSERT INTO `wp_options` VALUES("21346", "kls_cookie_button_border_radius", "", "yes");
INSERT INTO `wp_options` VALUES("21347", "kls_cookie_primary_button_color", "", "yes");
INSERT INTO `wp_options` VALUES("21348", "kls_cookie_primary_button_background_color", "", "yes");
INSERT INTO `wp_options` VALUES("21349", "kls_cookie_primary_button_hover_color", "", "yes");
INSERT INTO `wp_options` VALUES("21350", "kls_cookie_primary_button_hover_background_color", "", "yes");
INSERT INTO `wp_options` VALUES("21351", "kls_cookie_secundary_button_color", "", "yes");
INSERT INTO `wp_options` VALUES("21352", "kls_cookie_secundary_button_background_color", "", "yes");
INSERT INTO `wp_options` VALUES("21353", "kls_cookie_secundary_button_hover_color", "", "yes");
INSERT INTO `wp_options` VALUES("21354", "kls_cookie_secundary_button_hover_background_color", "", "yes");
INSERT INTO `wp_options` VALUES("21890", "kls_legacy_scripts_toggle", "", "yes");
INSERT INTO `wp_options` VALUES("21891", "kls_script_selector", "a:1:{i:0;a:4:{s:5:\"title\";s:4:\"Test\";s:15:\"cookie_category\";s:9:\"necessary\";s:8:\"location\";s:9:\"shortcode\";s:6:\"script\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("22119", "kls_scripts_searchconsole", "", "yes");
INSERT INTO `wp_options` VALUES("22120", "kls_scripts_gtm_optimization", "", "yes");
INSERT INTO `wp_options` VALUES("22121", "kls_scripts_gtm", "", "yes");
INSERT INTO `wp_options` VALUES("22122", "kls_scripts_ua", "", "yes");
INSERT INTO `wp_options` VALUES("22123", "kls_scripts_fbpixel", "", "yes");
INSERT INTO `wp_options` VALUES("22124", "kls_scripts_chatbot", "", "yes");
INSERT INTO `wp_options` VALUES("22125", "kls_scripts_head", "", "yes");
INSERT INTO `wp_options` VALUES("22126", "kls_scripts_body", "", "yes");
INSERT INTO `wp_options` VALUES("22127", "kls_scripts_footer", "", "yes");
INSERT INTO `wp_options` VALUES("30426", "kls_anytime_openings_data", "always", "yes");
INSERT INTO `wp_options` VALUES("30447", "kls_popup_text", "", "yes");
INSERT INTO `wp_options` VALUES("30448", "kls_popup_cookie_name", "popupclosed", "yes");
INSERT INTO `wp_options` VALUES("37545", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("37546", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("39379", "WPLANG", "nl_NL", "yes");
INSERT INTO `wp_options` VALUES("39756", "PUBLISHPRESS_CAPS_VERSION", "2.13.0", "yes");
INSERT INTO `wp_options` VALUES("40484", "cme_backup_auto_2023-05-30_11-03-27_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:47:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:11:\"edit_themes\";b:0;}}}", "no");
INSERT INTO `wp_options` VALUES("40485", "cme_backup_auto_2023-05-30_11-03-30_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:47:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:11:\"edit_themes\";b:0;}}}", "no");
INSERT INTO `wp_options` VALUES("40487", "cme_backup_auto_2023-05-30_11-03-35_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:47:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:11:\"edit_themes\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("40491", "cme_backup_auto_2023-05-30_11-04-06_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:52:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:11:\"edit_themes\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("40492", "cme_backup_auto_2023-05-30_11-04-10_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:56:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:11:\"edit_themes\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("40493", "cme_backup_auto_2023-05-30_11-04-13_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:57:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:11:\"edit_themes\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("40496", "cme_backup_auto_2023-05-30_11-04-34_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:58:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:11:\"edit_themes\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;s:14:\"manage_options\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("40500", "cme_backup_auto_2023-05-30_11-05-25_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:58:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;s:14:\"manage_options\";b:1;s:18:\"edit_theme_options\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("40501", "cme_backup_auto_2023-05-30_11-05-34_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:57:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;s:18:\"edit_theme_options\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("40506", "wpseo_sitemap_92_cache_validator", "3DccY", "no");
INSERT INTO `wp_options` VALUES("42802", "et_pb_role_settings", "a:7:{s:13:\"administrator\";a:89:{s:13:\"theme_options\";s:2:\"on\";s:12:\"divi_library\";s:2:\"on\";s:13:\"theme_builder\";s:2:\"on\";s:10:\"ab_testing\";s:2:\"on\";s:11:\"portability\";s:2:\"on\";s:10:\"add_module\";s:2:\"on\";s:11:\"edit_module\";s:2:\"on\";s:11:\"move_module\";s:2:\"on\";s:14:\"disable_module\";s:2:\"on\";s:11:\"lock_module\";s:2:\"on\";s:20:\"divi_builder_control\";s:2:\"on\";s:11:\"load_layout\";s:2:\"on\";s:18:\"use_visual_builder\";s:2:\"on\";s:23:\"custom_fonts_management\";s:2:\"on\";s:34:\"read_dynamic_content_custom_fields\";s:2:\"on\";s:12:\"save_library\";s:2:\"on\";s:11:\"add_library\";s:2:\"on\";s:19:\"edit_global_library\";s:2:\"on\";s:16:\"general_settings\";s:2:\"on\";s:17:\"advanced_settings\";s:2:\"on\";s:19:\"custom_css_settings\";s:2:\"on\";s:11:\"edit_colors\";s:2:\"on\";s:12:\"edit_content\";s:2:\"on\";s:10:\"edit_fonts\";s:2:\"on\";s:12:\"edit_buttons\";s:2:\"on\";s:11:\"edit_layout\";s:2:\"on\";s:12:\"edit_borders\";s:2:\"on\";s:18:\"edit_configuration\";s:2:\"on\";s:17:\"et_pb_testimonial\";s:2:\"on\";s:15:\"et_pb_accordion\";s:2:\"on\";s:11:\"et_pb_image\";s:2:\"on\";s:21:\"et_pb_fullwidth_image\";s:2:\"on\";s:21:\"et_pb_countdown_timer\";s:2:\"on\";s:11:\"et_pb_audio\";s:2:\"on\";s:17:\"et_pb_post_slider\";s:2:\"on\";s:27:\"et_pb_fullwidth_post_slider\";s:2:\"on\";s:14:\"et_pb_post_nav\";s:2:\"on\";s:26:\"et_pb_fullwidth_post_title\";s:2:\"on\";s:10:\"et_pb_blog\";s:2:\"on\";s:11:\"et_pb_blurb\";s:2:\"on\";s:20:\"et_pb_circle_counter\";s:2:\"on\";s:10:\"et_pb_code\";s:2:\"on\";s:20:\"et_pb_fullwidth_code\";s:2:\"on\";s:18:\"et_pb_contact_form\";s:2:\"on\";s:12:\"et_pb_signup\";s:2:\"on\";s:26:\"et_pb_filterable_portfolio\";s:2:\"on\";s:13:\"et_pb_gallery\";s:2:\"on\";s:10:\"et_pb_icon\";s:2:\"on\";s:28:\"et_pb_fullwidth_post_content\";s:2:\"on\";s:18:\"et_pb_post_content\";s:2:\"on\";s:9:\"et_pb_map\";s:2:\"on\";s:12:\"et_pb_button\";s:2:\"on\";s:11:\"et_pb_login\";s:2:\"on\";s:10:\"et_pb_menu\";s:2:\"on\";s:20:\"et_pb_number_counter\";s:2:\"on\";s:9:\"et_pb_cta\";s:2:\"on\";s:17:\"et_pb_team_member\";s:2:\"on\";s:15:\"et_pb_portfolio\";s:2:\"on\";s:14:\"et_pb_comments\";s:2:\"on\";s:12:\"et_pb_toggle\";s:2:\"on\";s:12:\"et_pb_slider\";s:2:\"on\";s:25:\"et_pb_social_media_follow\";s:2:\"on\";s:10:\"et_pb_tabs\";s:2:\"on\";s:20:\"et_pb_pricing_tables\";s:2:\"on\";s:10:\"et_pb_text\";s:2:\"on\";s:10:\"kls_button\";s:2:\"on\";s:16:\"et_pb_post_title\";s:2:\"on\";s:13:\"et_pb_divider\";s:2:\"on\";s:11:\"et_pb_video\";s:2:\"on\";s:18:\"et_pb_video_slider\";s:2:\"on\";s:22:\"et_pb_fullwidth_header\";s:2:\"on\";s:19:\"et_pb_fullwidth_map\";s:2:\"on\";s:20:\"et_pb_fullwidth_menu\";s:2:\"on\";s:25:\"et_pb_fullwidth_portfolio\";s:2:\"on\";s:22:\"et_pb_fullwidth_slider\";s:2:\"on\";s:14:\"et_pb_counters\";s:2:\"on\";s:13:\"et_pb_sidebar\";s:2:\"on\";s:12:\"et_pb_search\";s:2:\"on\";s:17:\"et_support_center\";s:2:\"on\";s:24:\"et_support_center_system\";s:2:\"on\";s:31:\"et_support_center_remote_access\";s:2:\"on\";s:31:\"et_support_center_documentation\";s:2:\"on\";s:27:\"et_support_center_safe_mode\";s:2:\"on\";s:22:\"et_support_center_logs\";s:2:\"on\";s:28:\"et_code_snippets_portability\";s:2:\"on\";s:23:\"et_pb_roles_portability\";s:2:\"on\";s:22:\"et_builder_portability\";s:2:\"on\";s:30:\"et_builder_layouts_portability\";s:2:\"on\";s:28:\"et_theme_builder_portability\";s:2:\"on\";}s:6:\"editor\";a:88:{s:12:\"divi_library\";s:2:\"on\";s:13:\"theme_builder\";s:2:\"on\";s:10:\"ab_testing\";s:2:\"on\";s:11:\"portability\";s:2:\"on\";s:10:\"add_module\";s:2:\"on\";s:11:\"edit_module\";s:2:\"on\";s:11:\"move_module\";s:2:\"on\";s:14:\"disable_module\";s:2:\"on\";s:11:\"lock_module\";s:2:\"on\";s:20:\"divi_builder_control\";s:2:\"on\";s:11:\"load_layout\";s:2:\"on\";s:18:\"use_visual_builder\";s:2:\"on\";s:23:\"custom_fonts_management\";s:2:\"on\";s:34:\"read_dynamic_content_custom_fields\";s:3:\"off\";s:12:\"save_library\";s:2:\"on\";s:11:\"add_library\";s:2:\"on\";s:19:\"edit_global_library\";s:2:\"on\";s:16:\"general_settings\";s:2:\"on\";s:17:\"advanced_settings\";s:2:\"on\";s:19:\"custom_css_settings\";s:2:\"on\";s:11:\"edit_colors\";s:2:\"on\";s:12:\"edit_content\";s:2:\"on\";s:10:\"edit_fonts\";s:2:\"on\";s:12:\"edit_buttons\";s:2:\"on\";s:11:\"edit_layout\";s:2:\"on\";s:12:\"edit_borders\";s:2:\"on\";s:18:\"edit_configuration\";s:2:\"on\";s:17:\"et_pb_testimonial\";s:2:\"on\";s:15:\"et_pb_accordion\";s:2:\"on\";s:11:\"et_pb_image\";s:2:\"on\";s:21:\"et_pb_fullwidth_image\";s:2:\"on\";s:21:\"et_pb_countdown_timer\";s:2:\"on\";s:11:\"et_pb_audio\";s:2:\"on\";s:17:\"et_pb_post_slider\";s:2:\"on\";s:27:\"et_pb_fullwidth_post_slider\";s:2:\"on\";s:14:\"et_pb_post_nav\";s:2:\"on\";s:26:\"et_pb_fullwidth_post_title\";s:2:\"on\";s:10:\"et_pb_blog\";s:2:\"on\";s:11:\"et_pb_blurb\";s:2:\"on\";s:20:\"et_pb_circle_counter\";s:2:\"on\";s:10:\"et_pb_code\";s:2:\"on\";s:20:\"et_pb_fullwidth_code\";s:2:\"on\";s:18:\"et_pb_contact_form\";s:2:\"on\";s:12:\"et_pb_signup\";s:2:\"on\";s:26:\"et_pb_filterable_portfolio\";s:2:\"on\";s:13:\"et_pb_gallery\";s:2:\"on\";s:10:\"et_pb_icon\";s:2:\"on\";s:28:\"et_pb_fullwidth_post_content\";s:2:\"on\";s:18:\"et_pb_post_content\";s:2:\"on\";s:9:\"et_pb_map\";s:2:\"on\";s:12:\"et_pb_button\";s:2:\"on\";s:11:\"et_pb_login\";s:2:\"on\";s:10:\"et_pb_menu\";s:2:\"on\";s:20:\"et_pb_number_counter\";s:2:\"on\";s:9:\"et_pb_cta\";s:2:\"on\";s:17:\"et_pb_team_member\";s:2:\"on\";s:15:\"et_pb_portfolio\";s:2:\"on\";s:14:\"et_pb_comments\";s:2:\"on\";s:12:\"et_pb_toggle\";s:2:\"on\";s:12:\"et_pb_slider\";s:2:\"on\";s:25:\"et_pb_social_media_follow\";s:2:\"on\";s:10:\"et_pb_tabs\";s:2:\"on\";s:20:\"et_pb_pricing_tables\";s:2:\"on\";s:10:\"et_pb_text\";s:2:\"on\";s:10:\"kls_button\";s:2:\"on\";s:16:\"et_pb_post_title\";s:2:\"on\";s:13:\"et_pb_divider\";s:2:\"on\";s:11:\"et_pb_video\";s:2:\"on\";s:18:\"et_pb_video_slider\";s:2:\"on\";s:22:\"et_pb_fullwidth_header\";s:2:\"on\";s:19:\"et_pb_fullwidth_map\";s:2:\"on\";s:20:\"et_pb_fullwidth_menu\";s:2:\"on\";s:25:\"et_pb_fullwidth_portfolio\";s:2:\"on\";s:22:\"et_pb_fullwidth_slider\";s:2:\"on\";s:14:\"et_pb_counters\";s:2:\"on\";s:13:\"et_pb_sidebar\";s:2:\"on\";s:12:\"et_pb_search\";s:2:\"on\";s:17:\"et_support_center\";s:2:\"on\";s:24:\"et_support_center_system\";s:2:\"on\";s:31:\"et_support_center_remote_access\";s:2:\"on\";s:31:\"et_support_center_documentation\";s:2:\"on\";s:27:\"et_support_center_safe_mode\";s:2:\"on\";s:22:\"et_support_center_logs\";s:2:\"on\";s:28:\"et_code_snippets_portability\";s:2:\"on\";s:23:\"et_pb_roles_portability\";s:2:\"on\";s:22:\"et_builder_portability\";s:2:\"on\";s:30:\"et_builder_layouts_portability\";s:2:\"on\";s:28:\"et_theme_builder_portability\";s:2:\"on\";}s:6:\"author\";a:87:{s:12:\"divi_library\";s:2:\"on\";s:10:\"ab_testing\";s:2:\"on\";s:11:\"portability\";s:2:\"on\";s:10:\"add_module\";s:2:\"on\";s:11:\"edit_module\";s:2:\"on\";s:11:\"move_module\";s:2:\"on\";s:14:\"disable_module\";s:2:\"on\";s:11:\"lock_module\";s:2:\"on\";s:20:\"divi_builder_control\";s:2:\"on\";s:11:\"load_layout\";s:2:\"on\";s:18:\"use_visual_builder\";s:2:\"on\";s:23:\"custom_fonts_management\";s:2:\"on\";s:34:\"read_dynamic_content_custom_fields\";s:3:\"off\";s:12:\"save_library\";s:2:\"on\";s:11:\"add_library\";s:2:\"on\";s:19:\"edit_global_library\";s:2:\"on\";s:16:\"general_settings\";s:2:\"on\";s:17:\"advanced_settings\";s:2:\"on\";s:19:\"custom_css_settings\";s:2:\"on\";s:11:\"edit_colors\";s:2:\"on\";s:12:\"edit_content\";s:2:\"on\";s:10:\"edit_fonts\";s:2:\"on\";s:12:\"edit_buttons\";s:2:\"on\";s:11:\"edit_layout\";s:2:\"on\";s:12:\"edit_borders\";s:2:\"on\";s:18:\"edit_configuration\";s:2:\"on\";s:17:\"et_pb_testimonial\";s:2:\"on\";s:15:\"et_pb_accordion\";s:2:\"on\";s:11:\"et_pb_image\";s:2:\"on\";s:21:\"et_pb_fullwidth_image\";s:2:\"on\";s:21:\"et_pb_countdown_timer\";s:2:\"on\";s:11:\"et_pb_audio\";s:2:\"on\";s:17:\"et_pb_post_slider\";s:2:\"on\";s:27:\"et_pb_fullwidth_post_slider\";s:2:\"on\";s:14:\"et_pb_post_nav\";s:2:\"on\";s:26:\"et_pb_fullwidth_post_title\";s:2:\"on\";s:10:\"et_pb_blog\";s:2:\"on\";s:11:\"et_pb_blurb\";s:2:\"on\";s:20:\"et_pb_circle_counter\";s:2:\"on\";s:10:\"et_pb_code\";s:2:\"on\";s:20:\"et_pb_fullwidth_code\";s:2:\"on\";s:18:\"et_pb_contact_form\";s:2:\"on\";s:12:\"et_pb_signup\";s:2:\"on\";s:26:\"et_pb_filterable_portfolio\";s:2:\"on\";s:13:\"et_pb_gallery\";s:2:\"on\";s:10:\"et_pb_icon\";s:2:\"on\";s:28:\"et_pb_fullwidth_post_content\";s:2:\"on\";s:18:\"et_pb_post_content\";s:2:\"on\";s:9:\"et_pb_map\";s:2:\"on\";s:12:\"et_pb_button\";s:2:\"on\";s:11:\"et_pb_login\";s:2:\"on\";s:10:\"et_pb_menu\";s:2:\"on\";s:20:\"et_pb_number_counter\";s:2:\"on\";s:9:\"et_pb_cta\";s:2:\"on\";s:17:\"et_pb_team_member\";s:2:\"on\";s:15:\"et_pb_portfolio\";s:2:\"on\";s:14:\"et_pb_comments\";s:2:\"on\";s:12:\"et_pb_toggle\";s:2:\"on\";s:12:\"et_pb_slider\";s:2:\"on\";s:25:\"et_pb_social_media_follow\";s:2:\"on\";s:10:\"et_pb_tabs\";s:2:\"on\";s:20:\"et_pb_pricing_tables\";s:2:\"on\";s:10:\"et_pb_text\";s:2:\"on\";s:10:\"kls_button\";s:2:\"on\";s:16:\"et_pb_post_title\";s:2:\"on\";s:13:\"et_pb_divider\";s:2:\"on\";s:11:\"et_pb_video\";s:2:\"on\";s:18:\"et_pb_video_slider\";s:2:\"on\";s:22:\"et_pb_fullwidth_header\";s:2:\"on\";s:19:\"et_pb_fullwidth_map\";s:2:\"on\";s:20:\"et_pb_fullwidth_menu\";s:2:\"on\";s:25:\"et_pb_fullwidth_portfolio\";s:2:\"on\";s:22:\"et_pb_fullwidth_slider\";s:2:\"on\";s:14:\"et_pb_counters\";s:2:\"on\";s:13:\"et_pb_sidebar\";s:2:\"on\";s:12:\"et_pb_search\";s:2:\"on\";s:17:\"et_support_center\";s:2:\"on\";s:24:\"et_support_center_system\";s:2:\"on\";s:31:\"et_support_center_remote_access\";s:2:\"on\";s:31:\"et_support_center_documentation\";s:2:\"on\";s:27:\"et_support_center_safe_mode\";s:2:\"on\";s:22:\"et_support_center_logs\";s:2:\"on\";s:28:\"et_code_snippets_portability\";s:2:\"on\";s:23:\"et_pb_roles_portability\";s:2:\"on\";s:22:\"et_builder_portability\";s:2:\"on\";s:30:\"et_builder_layouts_portability\";s:2:\"on\";s:28:\"et_theme_builder_portability\";s:2:\"on\";}s:11:\"contributor\";a:87:{s:12:\"divi_library\";s:2:\"on\";s:10:\"ab_testing\";s:2:\"on\";s:11:\"portability\";s:2:\"on\";s:10:\"add_module\";s:2:\"on\";s:11:\"edit_module\";s:2:\"on\";s:11:\"move_module\";s:2:\"on\";s:14:\"disable_module\";s:2:\"on\";s:11:\"lock_module\";s:2:\"on\";s:20:\"divi_builder_control\";s:2:\"on\";s:11:\"load_layout\";s:2:\"on\";s:18:\"use_visual_builder\";s:2:\"on\";s:23:\"custom_fonts_management\";s:2:\"on\";s:34:\"read_dynamic_content_custom_fields\";s:3:\"off\";s:12:\"save_library\";s:2:\"on\";s:11:\"add_library\";s:2:\"on\";s:19:\"edit_global_library\";s:2:\"on\";s:16:\"general_settings\";s:2:\"on\";s:17:\"advanced_settings\";s:2:\"on\";s:19:\"custom_css_settings\";s:2:\"on\";s:11:\"edit_colors\";s:2:\"on\";s:12:\"edit_content\";s:2:\"on\";s:10:\"edit_fonts\";s:2:\"on\";s:12:\"edit_buttons\";s:2:\"on\";s:11:\"edit_layout\";s:2:\"on\";s:12:\"edit_borders\";s:2:\"on\";s:18:\"edit_configuration\";s:2:\"on\";s:17:\"et_pb_testimonial\";s:2:\"on\";s:15:\"et_pb_accordion\";s:2:\"on\";s:11:\"et_pb_image\";s:2:\"on\";s:21:\"et_pb_fullwidth_image\";s:2:\"on\";s:21:\"et_pb_countdown_timer\";s:2:\"on\";s:11:\"et_pb_audio\";s:2:\"on\";s:17:\"et_pb_post_slider\";s:2:\"on\";s:27:\"et_pb_fullwidth_post_slider\";s:2:\"on\";s:14:\"et_pb_post_nav\";s:2:\"on\";s:26:\"et_pb_fullwidth_post_title\";s:2:\"on\";s:10:\"et_pb_blog\";s:2:\"on\";s:11:\"et_pb_blurb\";s:2:\"on\";s:20:\"et_pb_circle_counter\";s:2:\"on\";s:10:\"et_pb_code\";s:2:\"on\";s:20:\"et_pb_fullwidth_code\";s:2:\"on\";s:18:\"et_pb_contact_form\";s:2:\"on\";s:12:\"et_pb_signup\";s:2:\"on\";s:26:\"et_pb_filterable_portfolio\";s:2:\"on\";s:13:\"et_pb_gallery\";s:2:\"on\";s:10:\"et_pb_icon\";s:2:\"on\";s:28:\"et_pb_fullwidth_post_content\";s:2:\"on\";s:18:\"et_pb_post_content\";s:2:\"on\";s:9:\"et_pb_map\";s:2:\"on\";s:12:\"et_pb_button\";s:2:\"on\";s:11:\"et_pb_login\";s:2:\"on\";s:10:\"et_pb_menu\";s:2:\"on\";s:20:\"et_pb_number_counter\";s:2:\"on\";s:9:\"et_pb_cta\";s:2:\"on\";s:17:\"et_pb_team_member\";s:2:\"on\";s:15:\"et_pb_portfolio\";s:2:\"on\";s:14:\"et_pb_comments\";s:2:\"on\";s:12:\"et_pb_toggle\";s:2:\"on\";s:12:\"et_pb_slider\";s:2:\"on\";s:25:\"et_pb_social_media_follow\";s:2:\"on\";s:10:\"et_pb_tabs\";s:2:\"on\";s:20:\"et_pb_pricing_tables\";s:2:\"on\";s:10:\"et_pb_text\";s:2:\"on\";s:10:\"kls_button\";s:2:\"on\";s:16:\"et_pb_post_title\";s:2:\"on\";s:13:\"et_pb_divider\";s:2:\"on\";s:11:\"et_pb_video\";s:2:\"on\";s:18:\"et_pb_video_slider\";s:2:\"on\";s:22:\"et_pb_fullwidth_header\";s:2:\"on\";s:19:\"et_pb_fullwidth_map\";s:2:\"on\";s:20:\"et_pb_fullwidth_menu\";s:2:\"on\";s:25:\"et_pb_fullwidth_portfolio\";s:2:\"on\";s:22:\"et_pb_fullwidth_slider\";s:2:\"on\";s:14:\"et_pb_counters\";s:2:\"on\";s:13:\"et_pb_sidebar\";s:2:\"on\";s:12:\"et_pb_search\";s:2:\"on\";s:17:\"et_support_center\";s:2:\"on\";s:24:\"et_support_center_system\";s:2:\"on\";s:31:\"et_support_center_remote_access\";s:2:\"on\";s:31:\"et_support_center_documentation\";s:2:\"on\";s:27:\"et_support_center_safe_mode\";s:2:\"on\";s:22:\"et_support_center_logs\";s:2:\"on\";s:28:\"et_code_snippets_portability\";s:2:\"on\";s:23:\"et_pb_roles_portability\";s:2:\"on\";s:22:\"et_builder_portability\";s:2:\"on\";s:30:\"et_builder_layouts_portability\";s:2:\"on\";s:28:\"et_theme_builder_portability\";s:2:\"on\";}s:13:\"wpseo_manager\";a:87:{s:12:\"divi_library\";s:2:\"on\";s:10:\"ab_testing\";s:2:\"on\";s:11:\"portability\";s:2:\"on\";s:10:\"add_module\";s:2:\"on\";s:11:\"edit_module\";s:2:\"on\";s:11:\"move_module\";s:2:\"on\";s:14:\"disable_module\";s:2:\"on\";s:11:\"lock_module\";s:2:\"on\";s:20:\"divi_builder_control\";s:2:\"on\";s:11:\"load_layout\";s:2:\"on\";s:18:\"use_visual_builder\";s:2:\"on\";s:23:\"custom_fonts_management\";s:2:\"on\";s:34:\"read_dynamic_content_custom_fields\";s:3:\"off\";s:12:\"save_library\";s:2:\"on\";s:11:\"add_library\";s:2:\"on\";s:19:\"edit_global_library\";s:2:\"on\";s:16:\"general_settings\";s:2:\"on\";s:17:\"advanced_settings\";s:2:\"on\";s:19:\"custom_css_settings\";s:2:\"on\";s:11:\"edit_colors\";s:2:\"on\";s:12:\"edit_content\";s:2:\"on\";s:10:\"edit_fonts\";s:2:\"on\";s:12:\"edit_buttons\";s:2:\"on\";s:11:\"edit_layout\";s:2:\"on\";s:12:\"edit_borders\";s:2:\"on\";s:18:\"edit_configuration\";s:2:\"on\";s:17:\"et_pb_testimonial\";s:2:\"on\";s:15:\"et_pb_accordion\";s:2:\"on\";s:11:\"et_pb_image\";s:2:\"on\";s:21:\"et_pb_fullwidth_image\";s:2:\"on\";s:21:\"et_pb_countdown_timer\";s:2:\"on\";s:11:\"et_pb_audio\";s:2:\"on\";s:17:\"et_pb_post_slider\";s:2:\"on\";s:27:\"et_pb_fullwidth_post_slider\";s:2:\"on\";s:14:\"et_pb_post_nav\";s:2:\"on\";s:26:\"et_pb_fullwidth_post_title\";s:2:\"on\";s:10:\"et_pb_blog\";s:2:\"on\";s:11:\"et_pb_blurb\";s:2:\"on\";s:20:\"et_pb_circle_counter\";s:2:\"on\";s:10:\"et_pb_code\";s:2:\"on\";s:20:\"et_pb_fullwidth_code\";s:2:\"on\";s:18:\"et_pb_contact_form\";s:2:\"on\";s:12:\"et_pb_signup\";s:2:\"on\";s:26:\"et_pb_filterable_portfolio\";s:2:\"on\";s:13:\"et_pb_gallery\";s:2:\"on\";s:10:\"et_pb_icon\";s:2:\"on\";s:28:\"et_pb_fullwidth_post_content\";s:2:\"on\";s:18:\"et_pb_post_content\";s:2:\"on\";s:9:\"et_pb_map\";s:2:\"on\";s:12:\"et_pb_button\";s:2:\"on\";s:11:\"et_pb_login\";s:2:\"on\";s:10:\"et_pb_menu\";s:2:\"on\";s:20:\"et_pb_number_counter\";s:2:\"on\";s:9:\"et_pb_cta\";s:2:\"on\";s:17:\"et_pb_team_member\";s:2:\"on\";s:15:\"et_pb_portfolio\";s:2:\"on\";s:14:\"et_pb_comments\";s:2:\"on\";s:12:\"et_pb_toggle\";s:2:\"on\";s:12:\"et_pb_slider\";s:2:\"on\";s:25:\"et_pb_social_media_follow\";s:2:\"on\";s:10:\"et_pb_tabs\";s:2:\"on\";s:20:\"et_pb_pricing_tables\";s:2:\"on\";s:10:\"et_pb_text\";s:2:\"on\";s:10:\"kls_button\";s:2:\"on\";s:16:\"et_pb_post_title\";s:2:\"on\";s:13:\"et_pb_divider\";s:2:\"on\";s:11:\"et_pb_video\";s:2:\"on\";s:18:\"et_pb_video_slider\";s:2:\"on\";s:22:\"et_pb_fullwidth_header\";s:2:\"on\";s:19:\"et_pb_fullwidth_map\";s:2:\"on\";s:20:\"et_pb_fullwidth_menu\";s:2:\"on\";s:25:\"et_pb_fullwidth_portfolio\";s:2:\"on\";s:22:\"et_pb_fullwidth_slider\";s:2:\"on\";s:14:\"et_pb_counters\";s:2:\"on\";s:13:\"et_pb_sidebar\";s:2:\"on\";s:12:\"et_pb_search\";s:2:\"on\";s:17:\"et_support_center\";s:2:\"on\";s:24:\"et_support_center_system\";s:2:\"on\";s:31:\"et_support_center_remote_access\";s:2:\"on\";s:31:\"et_support_center_documentation\";s:2:\"on\";s:27:\"et_support_center_safe_mode\";s:2:\"on\";s:22:\"et_support_center_logs\";s:2:\"on\";s:28:\"et_code_snippets_portability\";s:2:\"on\";s:23:\"et_pb_roles_portability\";s:2:\"on\";s:22:\"et_builder_portability\";s:2:\"on\";s:30:\"et_builder_layouts_portability\";s:2:\"on\";s:28:\"et_theme_builder_portability\";s:2:\"on\";}s:12:\"wpseo_editor\";a:87:{s:12:\"divi_library\";s:2:\"on\";s:10:\"ab_testing\";s:2:\"on\";s:11:\"portability\";s:2:\"on\";s:10:\"add_module\";s:2:\"on\";s:11:\"edit_module\";s:2:\"on\";s:11:\"move_module\";s:2:\"on\";s:14:\"disable_module\";s:2:\"on\";s:11:\"lock_module\";s:2:\"on\";s:20:\"divi_builder_control\";s:2:\"on\";s:11:\"load_layout\";s:2:\"on\";s:18:\"use_visual_builder\";s:2:\"on\";s:23:\"custom_fonts_management\";s:2:\"on\";s:34:\"read_dynamic_content_custom_fields\";s:3:\"off\";s:12:\"save_library\";s:2:\"on\";s:11:\"add_library\";s:2:\"on\";s:19:\"edit_global_library\";s:2:\"on\";s:16:\"general_settings\";s:2:\"on\";s:17:\"advanced_settings\";s:2:\"on\";s:19:\"custom_css_settings\";s:2:\"on\";s:11:\"edit_colors\";s:2:\"on\";s:12:\"edit_content\";s:2:\"on\";s:10:\"edit_fonts\";s:2:\"on\";s:12:\"edit_buttons\";s:2:\"on\";s:11:\"edit_layout\";s:2:\"on\";s:12:\"edit_borders\";s:2:\"on\";s:18:\"edit_configuration\";s:2:\"on\";s:17:\"et_pb_testimonial\";s:2:\"on\";s:15:\"et_pb_accordion\";s:2:\"on\";s:11:\"et_pb_image\";s:2:\"on\";s:21:\"et_pb_fullwidth_image\";s:2:\"on\";s:21:\"et_pb_countdown_timer\";s:2:\"on\";s:11:\"et_pb_audio\";s:2:\"on\";s:17:\"et_pb_post_slider\";s:2:\"on\";s:27:\"et_pb_fullwidth_post_slider\";s:2:\"on\";s:14:\"et_pb_post_nav\";s:2:\"on\";s:26:\"et_pb_fullwidth_post_title\";s:2:\"on\";s:10:\"et_pb_blog\";s:2:\"on\";s:11:\"et_pb_blurb\";s:2:\"on\";s:20:\"et_pb_circle_counter\";s:2:\"on\";s:10:\"et_pb_code\";s:2:\"on\";s:20:\"et_pb_fullwidth_code\";s:2:\"on\";s:18:\"et_pb_contact_form\";s:2:\"on\";s:12:\"et_pb_signup\";s:2:\"on\";s:26:\"et_pb_filterable_portfolio\";s:2:\"on\";s:13:\"et_pb_gallery\";s:2:\"on\";s:10:\"et_pb_icon\";s:2:\"on\";s:28:\"et_pb_fullwidth_post_content\";s:2:\"on\";s:18:\"et_pb_post_content\";s:2:\"on\";s:9:\"et_pb_map\";s:2:\"on\";s:12:\"et_pb_button\";s:2:\"on\";s:11:\"et_pb_login\";s:2:\"on\";s:10:\"et_pb_menu\";s:2:\"on\";s:20:\"et_pb_number_counter\";s:2:\"on\";s:9:\"et_pb_cta\";s:2:\"on\";s:17:\"et_pb_team_member\";s:2:\"on\";s:15:\"et_pb_portfolio\";s:2:\"on\";s:14:\"et_pb_comments\";s:2:\"on\";s:12:\"et_pb_toggle\";s:2:\"on\";s:12:\"et_pb_slider\";s:2:\"on\";s:25:\"et_pb_social_media_follow\";s:2:\"on\";s:10:\"et_pb_tabs\";s:2:\"on\";s:20:\"et_pb_pricing_tables\";s:2:\"on\";s:10:\"et_pb_text\";s:2:\"on\";s:10:\"kls_button\";s:2:\"on\";s:16:\"et_pb_post_title\";s:2:\"on\";s:13:\"et_pb_divider\";s:2:\"on\";s:11:\"et_pb_video\";s:2:\"on\";s:18:\"et_pb_video_slider\";s:2:\"on\";s:22:\"et_pb_fullwidth_header\";s:2:\"on\";s:19:\"et_pb_fullwidth_map\";s:2:\"on\";s:20:\"et_pb_fullwidth_menu\";s:2:\"on\";s:25:\"et_pb_fullwidth_portfolio\";s:2:\"on\";s:22:\"et_pb_fullwidth_slider\";s:2:\"on\";s:14:\"et_pb_counters\";s:2:\"on\";s:13:\"et_pb_sidebar\";s:2:\"on\";s:12:\"et_pb_search\";s:2:\"on\";s:17:\"et_support_center\";s:2:\"on\";s:24:\"et_support_center_system\";s:2:\"on\";s:31:\"et_support_center_remote_access\";s:2:\"on\";s:31:\"et_support_center_documentation\";s:2:\"on\";s:27:\"et_support_center_safe_mode\";s:2:\"on\";s:22:\"et_support_center_logs\";s:2:\"on\";s:28:\"et_code_snippets_portability\";s:2:\"on\";s:23:\"et_pb_roles_portability\";s:2:\"on\";s:22:\"et_builder_portability\";s:2:\"on\";s:30:\"et_builder_layouts_portability\";s:2:\"on\";s:28:\"et_theme_builder_portability\";s:2:\"on\";}s:5:\"admin\";a:87:{s:12:\"divi_library\";s:2:\"on\";s:10:\"ab_testing\";s:2:\"on\";s:11:\"portability\";s:2:\"on\";s:10:\"add_module\";s:2:\"on\";s:11:\"edit_module\";s:2:\"on\";s:11:\"move_module\";s:2:\"on\";s:14:\"disable_module\";s:2:\"on\";s:11:\"lock_module\";s:2:\"on\";s:20:\"divi_builder_control\";s:2:\"on\";s:11:\"load_layout\";s:2:\"on\";s:18:\"use_visual_builder\";s:2:\"on\";s:23:\"custom_fonts_management\";s:2:\"on\";s:34:\"read_dynamic_content_custom_fields\";s:3:\"off\";s:12:\"save_library\";s:2:\"on\";s:11:\"add_library\";s:2:\"on\";s:19:\"edit_global_library\";s:2:\"on\";s:16:\"general_settings\";s:2:\"on\";s:17:\"advanced_settings\";s:2:\"on\";s:19:\"custom_css_settings\";s:2:\"on\";s:11:\"edit_colors\";s:2:\"on\";s:12:\"edit_content\";s:2:\"on\";s:10:\"edit_fonts\";s:2:\"on\";s:12:\"edit_buttons\";s:2:\"on\";s:11:\"edit_layout\";s:2:\"on\";s:12:\"edit_borders\";s:2:\"on\";s:18:\"edit_configuration\";s:2:\"on\";s:17:\"et_pb_testimonial\";s:2:\"on\";s:15:\"et_pb_accordion\";s:2:\"on\";s:11:\"et_pb_image\";s:2:\"on\";s:21:\"et_pb_fullwidth_image\";s:2:\"on\";s:21:\"et_pb_countdown_timer\";s:2:\"on\";s:11:\"et_pb_audio\";s:2:\"on\";s:17:\"et_pb_post_slider\";s:2:\"on\";s:27:\"et_pb_fullwidth_post_slider\";s:2:\"on\";s:14:\"et_pb_post_nav\";s:2:\"on\";s:26:\"et_pb_fullwidth_post_title\";s:2:\"on\";s:10:\"et_pb_blog\";s:2:\"on\";s:11:\"et_pb_blurb\";s:2:\"on\";s:20:\"et_pb_circle_counter\";s:2:\"on\";s:10:\"et_pb_code\";s:2:\"on\";s:20:\"et_pb_fullwidth_code\";s:2:\"on\";s:18:\"et_pb_contact_form\";s:2:\"on\";s:12:\"et_pb_signup\";s:2:\"on\";s:26:\"et_pb_filterable_portfolio\";s:2:\"on\";s:13:\"et_pb_gallery\";s:2:\"on\";s:10:\"et_pb_icon\";s:2:\"on\";s:28:\"et_pb_fullwidth_post_content\";s:2:\"on\";s:18:\"et_pb_post_content\";s:2:\"on\";s:9:\"et_pb_map\";s:2:\"on\";s:12:\"et_pb_button\";s:2:\"on\";s:11:\"et_pb_login\";s:2:\"on\";s:10:\"et_pb_menu\";s:2:\"on\";s:20:\"et_pb_number_counter\";s:2:\"on\";s:9:\"et_pb_cta\";s:2:\"on\";s:17:\"et_pb_team_member\";s:2:\"on\";s:15:\"et_pb_portfolio\";s:2:\"on\";s:14:\"et_pb_comments\";s:2:\"on\";s:12:\"et_pb_toggle\";s:2:\"on\";s:12:\"et_pb_slider\";s:2:\"on\";s:25:\"et_pb_social_media_follow\";s:2:\"on\";s:10:\"et_pb_tabs\";s:2:\"on\";s:20:\"et_pb_pricing_tables\";s:2:\"on\";s:10:\"et_pb_text\";s:2:\"on\";s:10:\"kls_button\";s:2:\"on\";s:16:\"et_pb_post_title\";s:2:\"on\";s:13:\"et_pb_divider\";s:2:\"on\";s:11:\"et_pb_video\";s:2:\"on\";s:18:\"et_pb_video_slider\";s:2:\"on\";s:22:\"et_pb_fullwidth_header\";s:2:\"on\";s:19:\"et_pb_fullwidth_map\";s:2:\"on\";s:20:\"et_pb_fullwidth_menu\";s:2:\"on\";s:25:\"et_pb_fullwidth_portfolio\";s:2:\"on\";s:22:\"et_pb_fullwidth_slider\";s:2:\"on\";s:14:\"et_pb_counters\";s:2:\"on\";s:13:\"et_pb_sidebar\";s:2:\"on\";s:12:\"et_pb_search\";s:2:\"on\";s:17:\"et_support_center\";s:2:\"on\";s:24:\"et_support_center_system\";s:2:\"on\";s:31:\"et_support_center_remote_access\";s:2:\"on\";s:31:\"et_support_center_documentation\";s:2:\"on\";s:27:\"et_support_center_safe_mode\";s:2:\"on\";s:22:\"et_support_center_logs\";s:2:\"on\";s:28:\"et_code_snippets_portability\";s:2:\"on\";s:23:\"et_pb_roles_portability\";s:2:\"on\";s:22:\"et_builder_portability\";s:2:\"on\";s:30:\"et_builder_layouts_portability\";s:2:\"on\";s:28:\"et_theme_builder_portability\";s:2:\"on\";}}", "yes");
INSERT INTO `wp_options` VALUES("42803", "cme_editor_features_private_post_type", "", "yes");
INSERT INTO `wp_options` VALUES("42804", "cme_capabilities_show_private_taxonomies", "", "yes");
INSERT INTO `wp_options` VALUES("42805", "cme_capabilities_add_user_multi_roles", "1", "yes");
INSERT INTO `wp_options` VALUES("42806", "cme_capabilities_edit_user_multi_roles", "1", "yes");
INSERT INTO `wp_options` VALUES("42807", "cme_editor_features_classic_editor_tab", "", "yes");
INSERT INTO `wp_options` VALUES("42808", "cme_test_user_admin_bar", "1", "yes");
INSERT INTO `wp_options` VALUES("42809", "cme_test_user_footer_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("42810", "cme_test_user_excluded_roles", "", "yes");
INSERT INTO `wp_options` VALUES("42811", "cme_profile_features_auto_redirect", "", "yes");
INSERT INTO `wp_options` VALUES("42825", "pp_customized_roles", "a:1:{s:5:\"admin\";O:8:\"stdClass\":2:{s:4:\"caps\";a:63:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"nf_admin_menu\";b:1;s:10:\"nf_add_new\";b:1;s:14:\"nf_submissions\";b:1;s:39:\"ninja_forms_menu_ninja-forms_capability\";b:1;s:40:\"ninja_forms_admin_all_forms_capabilities\";b:1;s:40:\"inja_forms_admin_submissions_capabilitie\";i:1;}s:7:\"plugins\";a:0:{}}}", "no");
INSERT INTO `wp_options` VALUES("42836", "cme_backup_auto_2023-06-20_9-49-47_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:58:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;s:18:\"edit_theme_options\";b:1;s:40:\"inja_forms_admin_submissions_capabilitie\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("42837", "cme_backup_auto_2023-06-20_9-49-49_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:57:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;s:18:\"edit_theme_options\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("42840", "cme_backup_auto_2023-06-20_9-49-59_am", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_admin_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"wpseo_manage_options\";b:1;s:19:\"manage_capabilities\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;s:20:\"manage_installer_kls\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"manage_forminator\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:24:\"manage_customer_data_kls\";b:1;s:23:\"manage_scripts_data_kls\";b:1;s:27:\"manage_maintenance_data_kls\";b:1;s:22:\"manage_cookie_data_kls\";b:1;s:21:\"manage_speed_data_kls\";b:1;s:27:\"manage_woocommerce_data_kls\";b:1;s:24:\"manage_settings_data_kls\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:24:\"manage_customer_data_kls\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"manage_kls\";b:0;s:16:\"manage_kls_theme\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:5:\"admin\";a:2:{s:4:\"name\";s:5:\"Admin\";s:12:\"capabilities\";a:57:{s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:13:\"publish_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:10:\"edit_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:12:\"upload_files\";b:1;s:6:\"nf_sub\";b:1;s:17:\"manage_categories\";b:1;s:16:\"manage_post_tags\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"edit_dashboard\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:10:\"manage_kls\";b:1;s:16:\"manage_kls_theme\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:4:\"read\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:15:\"edit_navigation\";b:1;s:22:\"edit_others_navigation\";b:1;s:18:\"publish_navigation\";b:1;s:25:\"edit_published_navigation\";b:1;s:23:\"edit_private_navigation\";b:1;s:17:\"delete_navigation\";b:1;s:24:\"delete_others_navigation\";b:1;s:27:\"delete_published_navigation\";b:1;s:25:\"delete_private_navigation\";b:1;s:23:\"read_private_navigation\";b:1;s:18:\"edit_theme_options\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("44642", "duplicator_notifications", "a:4:{s:6:\"update\";i:1725345050;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("62283", "wp_rocket_no_licence", "0", "yes");
INSERT INTO `wp_options` VALUES("63076", "wp_rocket_last_base_url", "aHR0cHM6Ly9vcHpldHN0YW4yLm9wemV0LXdlYnNpdGUubmwv", "on");
INSERT INTO `wp_options` VALUES("65099", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"jk,;tPdVVP0;,3C4WnOIlXKvV,VVhATFzL8A0Frd_.xP\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 3,\n    \"buildLastDate\": 1725356132,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 316.81000000000000227373675443232059478759765625,\n    \"siteNumFiles\": 17166,\n    \"siteDbSizeMB\": 16.8299999999999982946974341757595539093017578125,\n    \"siteDbNumTables\": 75\n}", "yes");
INSERT INTO `wp_options` VALUES("67563", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("68269", "wsal_plugin_version", "4.6.4", "no");
INSERT INTO `wp_options` VALUES("68270", "wsal_disabled-alerts", ",5010,5011,5012,5013,5014,5015,5016,5017,5018,5022,5023,5024", "no");
INSERT INTO `wp_options` VALUES("68271", "fs_wsalp", "no", "no");
INSERT INTO `wp_options` VALUES("68274", "wsal_redirect_on_activate", "1", "no");
INSERT INTO `wp_options` VALUES("72100", "wsal_setup-modal-dismissed", "yes", "yes");
INSERT INTO `wp_options` VALUES("72287", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1704983691;}}", "yes");
INSERT INTO `wp_options` VALUES("72341", "gf_db_version", "2.8.17", "off");
INSERT INTO `wp_options` VALUES("72342", "rg_form_version", "2.8.17", "no");
INSERT INTO `wp_options` VALUES("72343", "gform_enable_background_updates", "1", "yes");
INSERT INTO `wp_options` VALUES("72344", "auto_update_plugins", "a:12:{i:0;s:29:\"gravityforms/gravityforms.php\";i:1;s:47:\"better-search-replace/better-search-replace.php\";i:2;s:29:\"divi-builder/divi-builder.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:31:\"klasse-plugin/klasse-plugin.php\";i:5;s:15:\"worker/init.php\";i:6;s:48:\"capability-manager-enhanced/capsman-enhanced.php\";i:7;s:23:\"wordfence/wordfence.php\";i:8;s:47:\"wp-security-audit-log/wp-security-audit-log.php\";i:9;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:10;s:23:\"wp-rocket/wp-rocket.php\";i:11;s:24:\"wordpress-seo/wp-seo.php\";}", "no");
INSERT INTO `wp_options` VALUES("72345", "rg_gforms_default_theme", "orbital", "no");
INSERT INTO `wp_options` VALUES("72346", "rg_form_original_version", "2.8.0", "no");
INSERT INTO `wp_options` VALUES("72347", "_site_transient_t15s-registry-gforms", "O:8:\"stdClass\":2:{s:8:\"projects\";a:58:{s:26:\"gravityformsactivecampaign\";a:1:{s:12:\"translations\";a:31:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2024-03-20T12:45:10+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:17+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:17+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:31+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-15T08:11:04+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:32:09+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:19+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:49+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:50+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:54+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:05+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:56+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:48+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:27+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:58+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-03-27T13:41:07+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:16+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-03-25T15:23:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-03-14T17:35:58+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:11+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:32:10+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-03-24T15:29:26+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:32:12+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:50+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:32:14+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:56+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-03-31T16:22:35+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:32:16+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-03-21T10:42:11+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.1.0\";s:7:\"updated\";s:25:\"2022-06-27T08:32:33+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsaweber\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2024-03-20T12:44:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-20T07:18:01+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-10-30T15:13:06+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:50+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:50+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-10-30T12:14:04+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-10-30T16:20:49+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-14T09:02:25+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-07T11:36:51+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-16T18:15:15+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-28T21:16:06+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-02T21:50:14+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-01T13:16:12+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-01T14:16:16+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-14T16:42:10+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-03T18:33:28+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2024-03-18T20:48:50+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:25:\"2023-11-09T01:23:53+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformsagilecrm\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-20T12:49:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-20T07:16:01+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T08:00:35+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:09+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:11+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:16+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-09-13T08:58:31+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T16:56:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T16:56:35+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T16:56:37+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T16:56:43+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-03-14T17:37:39+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T08:00:37+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T08:00:40+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-09-27T21:55:07+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T08:00:45+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T16:56:26+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T08:00:49+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T08:00:51+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T08:00:54+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:24:\"gravityformsauthorizenet\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2024-03-20T12:51:36+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-12-28T11:16:35+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:40+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-29T15:48:18+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-19T11:05:17+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-19T11:04:01+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-03-02T20:29:58+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-21T11:50:09+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:37+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:39+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:45+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-03-14T17:38:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2021-09-13T20:54:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-12-17T15:01:32+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-12-17T15:53:58+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:49+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:53+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-11-05T09:28:49+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-11-09T01:30:51+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsbatchbook\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2024-03-20T12:53:19+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2022-06-27T09:51:40+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:14:25+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:20+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:36+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:39+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:48+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:24+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:41+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-01-22T16:00:21+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:48+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-03-14T17:40:37+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:41+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:47+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:30:05+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:30:11+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:32+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-10-21T18:08:50+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:59+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-09T01:26:27+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsbreeze\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2024-03-20T12:53:50+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-11-20T07:19:36+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-01-06T08:03:49+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2020-10-21T11:51:14+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-01-06T16:59:26+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-01-06T16:59:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2020-10-27T15:24:22+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2020-11-04T15:55:14+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-03-14T17:41:59+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-01-06T08:03:51+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-01-06T08:03:53+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2020-12-17T15:54:19+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2020-11-04T15:53:05+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-01-06T16:59:34+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2020-10-21T18:01:43+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2020-11-05T09:41:54+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.1\";s:7:\"updated\";s:25:\"2023-11-09T01:32:48+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:27:\"gravityformscampaignmonitor\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2024-03-20T12:55:02+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-11-20T07:21:00+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2020-10-27T15:32:30+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:00:49+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2020-10-21T13:33:21+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:00:34+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2020-10-27T15:32:58+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:00:57+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:01:03+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-03-14T17:42:45+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:01:15+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:01:17+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2020-12-17T15:54:37+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2020-11-04T16:34:37+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:00:45+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:01:27+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-01-06T17:01:29+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.0.0\";s:7:\"updated\";s:25:\"2023-11-09T01:34:51+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformscampfire\";a:1:{s:12:\"translations\";a:24:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2024-03-20T12:55:41+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:21+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:39+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:01:41+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:51+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:30+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:34+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2022-06-27T09:53:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:01:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-02-18T11:26:09+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-01-22T16:22:19+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:47+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-14T17:44:01+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:59+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:55+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:58+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:44:01+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-02-13T09:15:04+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-11-09T01:41:12+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformscapsulecrm\";a:1:{s:12:\"translations\";a:25:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2024-03-20T12:57:44+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:26+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-11-20T07:22:07+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:32+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-06-27T08:52:42+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-06-27T08:52:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:07+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2021-05-25T20:59:21+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:02:54+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:14+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:16+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2024-03-02T12:48:47+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:34+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:37+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-06-15T19:59:52+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:46+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:42+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:52+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:03+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2021-06-05T06:33:09+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:49+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-11-09T01:46:15+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:26:\"gravityformschainedselects\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2024-03-26T11:38:44+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2023-04-14T18:06:58+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2023-11-20T07:22:44+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2023-01-06T17:04:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-10-27T15:57:33+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-11-04T16:39:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-11-04T16:39:05+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-10-27T15:56:33+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-11-04T16:40:25+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-12-17T14:50:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2021-09-13T21:00:54+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-12-17T15:03:03+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-12-17T15:55:04+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-11-04T16:40:51+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2023-01-06T17:04:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-10-21T17:43:40+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2020-10-27T15:55:51+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:25:\"2023-11-10T01:29:52+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformscleverreach\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-03-20T13:19:05+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-20T07:23:40+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-10-27T16:14:47+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-06-27T08:54:38+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-06-27T08:54:39+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:05:28+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:05:32+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:05:14+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:05:34+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:05:36+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:05:43+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-03-14T17:45:38+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:05:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-12-17T15:03:13+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-12-17T15:55:14+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:06:04+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:05:23+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-10-21T17:59:57+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:06:10+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-09T01:49:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformscoupons\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-22T19:48:26+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-23T19:14:14+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-20T07:24:55+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-10-30T15:15:59+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-03-02T20:27:34+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-10-30T12:52:51+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-10-30T16:21:20+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:06:49+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-14T09:00:05+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-07T11:37:29+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-16T18:13:27+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-03T10:13:14+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-28T21:10:00+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-02T21:49:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-01T13:13:39+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-01T14:24:02+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-14T16:43:52+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-03T18:33:15+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-01T14:27:03+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-10T01:18:18+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsdropbox\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2024-03-20T13:21:40+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-23T14:29:18+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-10-30T15:16:21+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:56:15+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:07:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-10-30T12:54:26+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-10-30T16:21:42+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:56:26+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-14T09:01:08+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-07T11:37:53+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-16T18:06:23+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:15+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-28T21:04:03+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2024-03-21T23:01:31+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-01T13:16:30+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-01T14:24:24+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-14T16:46:22+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-03T18:33:39+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-01T14:27:30+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.2.0\";s:7:\"updated\";s:25:\"2023-11-28T01:11:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsemma\";a:1:{s:12:\"translations\";a:30:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2024-03-20T13:23:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-04-14T12:05:12+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:09:41+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-03-02T20:39:07+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-20T07:25:43+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:09:22+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:08:58+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-03-02T20:38:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:57:24+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:08:46+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-26T16:08:20+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-09-25T12:09:30+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-10-17T13:24:31+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:09:05+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:09:07+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:13+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-04-11T09:52:51+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-03-14T17:48:37+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:14+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-28T21:11:55+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:09:26+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:57:38+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:09:31+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:08:54+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:09:35+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T17:09:37+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-25T20:37:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformsfreshbooks\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2024-03-20T13:24:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:49+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:29+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-02-20T14:36:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2020-10-21T11:51:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:52+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:11+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:13+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:19+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-03-14T17:49:01+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2021-09-14T09:32:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2020-12-17T15:53:03+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:39+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:59+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2021-02-08T11:26:17+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:44+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-11-29T02:21:29+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformsgetresponse\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2024-03-20T13:25:36+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-11-23T14:30:46+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2020-11-04T17:36:04+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2022-06-27T08:58:09+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2022-06-27T08:58:11+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:13+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:16+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2020-11-04T17:34:56+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:18+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2020-11-04T17:34:11+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:25+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-03-14T17:49:50+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:39+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:41+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:42+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2020-11-04T17:35:18+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:09+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2021-02-08T11:28:42+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:52+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-11-25T20:48:13+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformshelpscout\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2024-03-20T13:26:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-24T07:42:04+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-11T17:38:30+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2022-06-27T09:58:40+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2022-06-27T09:58:42+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:19+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-25T16:20:17+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:08+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2020-11-05T09:45:35+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:27+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:32+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-03-14T17:50:31+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-28T21:10:33+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:48+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-25T23:03:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-20T06:44:18+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:15+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-11-04T18:39:39+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:13:00+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-29T02:37:34+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformshighrise\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2024-03-20T13:28:49+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2022-06-27T09:59:10+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:14:26+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:12+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:45+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:21+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:25+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:27+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-07-17T13:47:39+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:18+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:33+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:35+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-03-14T17:51:12+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:52+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:54+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:52+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:56+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:23+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2021-08-02T17:30:03+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:14:05+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-19T23:28:15+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformshipchat\";a:1:{s:12:\"translations\";a:25:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2024-03-20T13:29:15+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:44+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2022-06-27T10:00:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:50+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:25+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:00+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:04+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:11+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-10-21T13:28:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:57+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:55+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-02-21T12:24:57+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-01-25T07:46:44+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:18+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-03-14T17:51:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:23+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-01-06T17:14:57+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-01-06T17:14:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:32+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:06+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2021-08-02T17:31:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-02-13T09:22:17+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-11-19T23:25:08+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsmadmimi\";a:1:{s:12:\"translations\";a:34:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-20T13:31:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:17+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:32+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:07+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:06+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2020-10-21T11:52:31+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:26+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-09-25T12:09:30+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:110:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:27+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:49+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:52+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:13+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:30+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-03-14T17:52:56+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:15+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-10-02T10:46:06+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:11+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2020-12-17T15:55:55+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:47+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sr\";a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:16+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:53+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-08-02T17:35:32+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:24+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-09T01:39:35+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsmailchimp\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2024-03-20T13:32:12+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-11-24T12:41:33+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:15+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2022-06-27T08:43:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:28:02+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2021-10-25T16:35:54+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:39+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:57+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2021-10-17T13:48:34+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:05+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-02-04T16:58:16+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-11-03T10:13:13+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-11-28T21:13:27+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:19+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2021-10-25T23:02:38+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:25+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:47+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:29+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.2.2\";s:7:\"updated\";s:25:\"2023-11-25T20:33:22+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:26:\"gravityformspartialentries\";a:1:{s:12:\"translations\";a:26:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-11-23T11:07:56+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-04-14T17:10:56+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2022-06-27T10:03:45+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-11-26T19:03:02+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-01-06T17:18:21+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2022-06-29T15:47:04+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2020-10-21T13:19:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-01-06T17:17:46+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-09-25T12:09:31+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-10-17T13:38:00+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-01-06T17:18:03+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-01-06T17:18:05+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-01-06T17:18:12+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2020-12-17T14:50:15+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2021-09-14T09:48:18+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-01-06T17:18:24+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2020-12-17T15:55:24+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-01-06T17:18:31+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-01-06T17:17:54+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2021-08-02T17:40:09+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2020-11-05T09:27:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.7\";s:7:\"updated\";s:25:\"2023-11-25T20:27:12+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:29:\"gravityformspaypalpaymentspro\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2024-03-20T13:33:43+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-12-28T11:16:35+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-11-26T19:04:21+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:08:48+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-03-02T20:27:35+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-03-24T14:22:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:07:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:09:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:10+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:08:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-03-14T17:54:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-09-14T09:52:47+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:29+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-12-17T14:13:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:10:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:09:09+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-09-29T18:02:03+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-11-25T20:24:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformspaypal\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2024-03-20T15:01:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:51+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-23T19:13:23+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-27T10:05:05+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-03-02T20:27:35+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2020-10-21T11:52:44+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:19:55+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:13+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:15+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-03-14T17:54:51+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2021-09-14T09:52:14+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2020-12-17T15:54:54+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:40+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:03+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2021-09-29T18:06:04+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:46+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-12-01T23:37:46+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformspaypalpro\";a:1:{s:12:\"translations\";a:30:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2024-03-23T14:15:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-04-15T14:48:04+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-28T11:11:03+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-28T11:16:36+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-02T20:50:54+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:59:29+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:46+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:30+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:02+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:18+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-03-24T11:58:48+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:56:58+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-30T13:48:05+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-09-25T12:58:34+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-10-17T13:40:59+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-04-29T16:41:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-01-27T16:56:20+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-02T20:50:29+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-14T17:55:20+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2019-12-10T13:19:22+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-09-14T09:53:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:53:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:40+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:57:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:56:26+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-11-04T18:47:08+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-04-29T16:42:28+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-01T23:55:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformspolls\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2024-03-20T15:15:58+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-11-27T04:51:47+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2020-11-05T15:15:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:10+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:12+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:20+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-03-02T20:51:24+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2020-10-21T13:43:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2020-11-05T15:13:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:24+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2020-11-05T15:17:13+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:32+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-03-14T17:55:58+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2021-09-14T09:55:19+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2020-12-17T14:20:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2020-12-17T14:19:33+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2020-11-05T15:18:45+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2021-11-04T18:52:05+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2020-06-29T08:29:29+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-12-02T00:08:37+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformspostmark\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-24T12:00:03+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-27T04:54:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-24T11:44:53+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T09:11:37+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-25T21:03:26+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-31T19:40:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-03-29T18:54:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-22T09:30:48+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-26T12:48:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-04T08:26:03+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-09-14T09:55:49+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-31T04:01:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-04-11T21:20:33+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-20T16:53:54+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-01T17:59:01+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-05T06:35:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-26T23:45:38+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-25T20:16:29+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsquiz\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:22+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:23+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:14+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:15+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:15+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:12+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:24+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:23+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:13+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:23+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.0\";s:7:\"updated\";s:25:\"2024-07-10T08:01:23+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2