<?php

function kls_admin_notice( $notice = '', $type = 'warning', $dismissible = true ) {
	 // Here we return the notices saved on our option, if there are not notices, then an empty array is returned
	$notices = get_option( 'kls_admin_notices', array() );

	$dismissible_text = ( $dismissible ) ? 'is-dismissible' : '';

	// We add our new notice.
	array_push(
		$notices,
		array(
			'notice'      => $notice,
			'type'        => $type,
			'dismissible' => $dismissible_text,
		)
	);

	// Then we update the option with our notices array
	update_option( 'kls_admin_notices', $notices );
}

/**
 * Function executed when the 'admin_notices' action is called, here we check if there are notices on
 * our database and display them, after that, we remove the option to prevent notices being displayed forever.
 *
 * @return void
 */

function kls_display_admin_notices() {
	$notices = get_option( 'kls_admin_notices', array() );

	// Iterate through our notices to be displayed and print them.
	foreach ( $notices as $notice ) {
		printf(
			'<div class="notice notice-%1$s %2$s"><p>%3$s</p></div>',
			$notice['type'],
			$notice['dismissible'],
			$notice['notice']
		);
	}

	// Now we reset our options to prevent notices being displayed forever.
	if ( ! empty( $notices ) ) {
		delete_option( 'kls_admin_notices', array() );
	}
}

// We add our display_flash_notices function to the admin_notices
add_action( 'admin_notices', 'kls_display_admin_notices', 12 );

/**
 * Add Noindex notification
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.86
 */
function kls_noindex_notification() {
	$user = wp_get_current_user();
	if ( get_option( 'blog_public' ) == 0 && in_array( 'administrator', (array) $user->roles ) ) :
		echo '<div class="notice notice-warning">
                <p><strong>Let op!</strong> De website staat nog op noindex. Hoort dit dan kun je deze melding negeren.</p>
            </div>';
	endif;
}
add_action( 'admin_notices', 'kls_noindex_notification', 1 );

/**
 * Add email fields notification
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.86
 */
function kls_email_fields_notification() {
	$user = wp_get_current_user();
	if ( empty( get_option( 'kls_customer_form_email' ) ) && in_array( 'administrator', (array) $user->roles ) ) :
		echo '<div class="notice notice-warning">
                <p><strong>Let op!</strong> De standaard klant email is niet ingevuld. Als dit klopt kun je deze melding negeren.</p>
            </div>';
	endif;
}
add_action( 'admin_notices', 'kls_email_fields_notification', 1 );
