<?php

/**
 *
 *
 * @package KlassePlugin
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.77
 */


/**
 * Export json generation
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.77
 *
 * @return All options and theme mods in JSON format
 */
function klsExportJson() {
	$kls_options = array();

	// Options
	$all_options     = wp_load_alloptions();
	$exclude_options = array(
		'kls_customer_logo',
		'kls_customer_favicon',
		'kls_plugin_api_key',
		'kls_api_key',
		'kls_api_last_connection',
		'kls_api_last_change',
		'kls_maintenance_background_image',
		'kls_security_trusted_ips',
		'kls_user_interactions',
	);

	foreach ( $all_options as $name => $value ) {
		if ( ! in_array( $name, $exclude_options, true ) && stristr( $name, 'kls' ) ) {
			$kls_options[ 'kls_option_data-' . $name ] = 'kls_option_data|' . $name . '|' . $value;
		}
	}

	// Theme mods
	$all_theme_mods = get_theme_mods();
	$excluded_mods  = array(
		'nav_menu_locations',
		'custom_css_post_id',
		'google_fonts_toggle',
		'kls_headings_font',
		'kls_body_font',
		'archive_add_divi_shortcode_id',
		'product_add_divi_shortcode_id',
		'custom_logo',
		'bottom_footer_link_one',
		'bottom_footer_link_two',
		'bottom_footer_link_three',
		'bottom_footer_link_four',
		'bottom_footer_image',
	);

	foreach ( $all_theme_mods as $name => $value ) {
		if ( ! in_array( $name, $excluded_mods, true ) ) {
			$kls_options[ 'kls_mod_data-' . $name ] = 'kls_mod_data|' . $name . '|' . $value;
		}
	}

	echo json_encode( $kls_options );
}
add_action( 'kls_export_json', 'klsExportJson' );
