<?php // phpcs:ignore
/**
 * Anytime options class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/includes/options
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if ( ! defined('ABSPATH') ) {
	exit;
}

if (!class_exists('KP_Options_Anytime')) {
	/**
	 * Anytime options class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/includes/options
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Options_Anytime
	{
		/**
		 * Construct the Anytime options.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_init', array($this, 'createAnytimeSettingFields'));
			add_action('admin_init', array($this, 'registerAnytimeSettingFields'));
		}

		/**
		 * Create the settings fields.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.03
		 */
		public function createAnytimeSettingFields()
		{
			if (get_option('kls_toggle_anytime_integration') == 'on') {
				add_settings_field(
					'kls_anytime_language',
					__('Location language', KP_TXT_DOMAIN),
					'kls_select_field',
					'kls_anytime_fitness',
					'kls_anytime_fitness_section',
					array(
						'label_for' => 'kls_anytime_language',
						'class' => 'select-choice',
						'selects' => array(
							'Maak een keuze',
							'Nederlands',
							'Vlaams',
						),
					)
				);

				add_settings_field(
					'kls_anytime_openings_data',
					__('Is the location 24/7 open?', KP_TXT_DOMAIN),
					'kls_select_field',
					'kls_anytime_fitness',
					'kls_anytime_fitness_section',
					array(
						'label_for' => 'kls_anytime_openings_data',
						'class' => 'select-choice',
						'selects' => array(
							'always',
							'other',
						),
					)
				);

				add_settings_field(
					'kls_anytime_grouplesson',
					__('Group lessons', KP_TXT_DOMAIN),
					'kls_simple_file_upload',
					'kls_anytime_fitness',
					'kls_anytime_fitness_section',
					array(
						'label_for' => 'kls_anytime_grouplesson',
						'button_text' => __(
							'Select document',
							KP_TXT_DOMAIN
						),
					)
				);

				add_settings_field('kls_anytime_registration', __('Registration url', KP_TXT_DOMAIN), 'kls_text_field', 'kls_anytime_fitness', 'kls_anytime_fitness_section', array('label_for' => 'kls_anytime_registration'));
				add_settings_field('kls_anytime_appointment_url', __('Appointment module url', KP_TXT_DOMAIN), 'kls_text_field', 'kls_anytime_fitness', 'kls_anytime_fitness_section', array('label_for' => 'kls_anytime_appointment_url'));

				add_settings_field(
					'kls_anytime_clubimpression_images',
					__('Club photos', KP_TXT_DOMAIN),
					'kls_multiple_image_field',
					'kls_anytime_fitness',
					'kls_anytime_fitness_section',
					array(
						'label_for' => 'kls_anytime_clubimpression_images',
						'button_text' => __(
							'Upload images',
							KP_TXT_DOMAIN
						),
					)
				);
				add_settings_field('kls_anytime_clubimpression_video', __('Club video Youtube embed url', KP_TXT_DOMAIN), 'kls_text_field', 'kls_anytime_fitness', 'kls_anytime_fitness_section', array('label_for' => 'kls_anytime_clubimpression_video'));

				add_settings_field(
					'kls_anytime_grouplessons',
					__('Grouplessons', KP_TXT_DOMAIN),
					'klsAnytimeGrouplessonSelector',
					'kls_anytime_fitness',
					'kls_anytime_fitness_section',
					array(
						'label_for' => 'kls_anytime_grouplessons',
						'button_text' => __(
							'Upload images',
							KP_TXT_DOMAIN
						),
					)
				);
			}

			if (get_option('kls_toggle_anytime_presale_integration') == 'on') {
				add_settings_field('kls_anytime_presale_opening', __('Knalopening date', KP_TXT_DOMAIN), 'kls_text_field', 'kls_anytime_fitness_presale', 'kls_anytime_fitness_presale_section', array('label_for' => 'kls_anytime_presale_opening'));
				add_settings_field('kls_anytime_vip_weekend', __('VIP weekend date', KP_TXT_DOMAIN), 'kls_text_field', 'kls_anytime_fitness_presale', 'kls_anytime_fitness_presale_section', array('label_for' => 'kls_anytime_vip_weekend'));
				add_settings_field('kls_anytime_presale_date', __('Presale date', KP_TXT_DOMAIN), 'kls_text_field', 'kls_anytime_fitness_presale', 'kls_anytime_fitness_presale_section', array('label_for' => 'kls_anytime_presale_date'));
				add_settings_field('kls_anytime_presale_discount', __('Presale discount', KP_TXT_DOMAIN), 'kls_text_field', 'kls_anytime_fitness_presale', 'kls_anytime_fitness_presale_section', array('label_for' => 'kls_anytime_presale_discount'));
			}
		}

		/**
		 * Register the settings fields.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.03
		 */
		public function registerAnytimeSettingFields()
		{
			if (get_option('kls_toggle_anytime_integration') == 'on'){
				register_setting('kls_anytime_fitness', 'kls_anytime_language');
				register_setting('kls_anytime_fitness', 'kls_anytime_openings_data');
				register_setting('kls_anytime_fitness', 'kls_anytime_grouplesson');
				register_setting('kls_anytime_fitness', 'kls_anytime_registration');
				register_setting('kls_anytime_fitness', 'kls_anytime_appointment_url');
				register_setting('kls_anytime_fitness', 'kls_anytime_clubimpression_images');
				register_setting('kls_anytime_fitness', 'kls_anytime_clubimpression_video');
				register_setting('kls_anytime_fitness', 'kls_anytime_grouplessons');
			}

			if (get_option('kls_toggle_anytime_presale_integration') == 'on'){
				register_setting('kls_anytime_fitness_presale', 'kls_anytime_presale_opening');
				register_setting('kls_anytime_fitness_presale', 'kls_anytime_vip_weekend');
				register_setting('kls_anytime_fitness_presale', 'kls_anytime_presale_discount');
				register_setting('kls_anytime_fitness_presale', 'kls_anytime_presale_date');
			}
		}
	}

	new KP_Options_Anytime();
}
