<?php // phpcs:ignore
/**
 * Admin page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Admin_Page')) {
	/**
	 * Admin page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Admin_Page
	{
		/**
		 * Construct the admin page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Admin settings', KP_TXT_DOMAIN), __('Admin settings', KP_TXT_DOMAIN), 'manage_admin_kls', 'kls_admin_settings_page', array($this, 'adminPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Admin settings', KP_TXT_DOMAIN),
				'description' => __('Whitelabel, beta updates', KP_TXT_DOMAIN),
				'url' => 'kls_admin_settings_page',
				'capability' => 'manage_admin_kls',
				'order' => '110',
			);

			return $pages;
		}

		/**
		 * Admin page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function adminPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_admin_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Admin settings', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('If you can you can read this you have access to the admin settings. This adds options to create a whitelabel of the plugin/theme or switch between. Also you can enable beta updates and toggle the removal of options on deinstallation of the plugin.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<form method="post" action="options.php">
									<?php
									settings_fields('kls_admin_settings_section');

									do_settings_sections('kls_admin_settings');

									// Output save settings button.
									submit_button(__('Save settings', KP_TXT_DOMAIN));

									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Admin_Page();
}