<?php // phpcs:ignore
/**
 * Header class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages/components
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if ( ! defined('ABSPATH') ) {
	exit;
}

if (!class_exists('KP_Header')) {
	/**
	 * Header class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages/components
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Header
	{
		/**
		 * Construct the header.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('kp_header', array($this, 'headerOutput'));
		}

		/**
		 * Header output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function headerOutput()
		{
			require 'topbar.class.php';
			require 'sidebar.class.php';

			if (isset($_GET['settings-updated'])) {
				add_settings_error('kls_messages', 'kls_message', __('Save settings', KP_TXT_DOMAIN), 'updated');
			}

			settings_errors('kls_messages');

			do_action('kp_topbar');
		}
	}

	new KP_Header();
}
