<?php // phpcs:ignore
/**
 * Sidebar class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages/components
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Sidebar')) {
	/**
	 * Sidebar class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages/components
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Sidebar
	{
		/**
		 * Construct the sidebar.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('kp_sidebar', array($this, 'sidebarOutput'));
		}

		/**
		 * sidebar output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarOutput()
		{
			// Generate pages array
			$pages = [];
			$pages = apply_filters('kp_sidebar_links', $pages);

			usort($pages, function ($a, $b) {
				$aOrder = isset($a['order']) ? $a['order'] : PHP_INT_MAX;
				$bOrder = isset($b['order']) ? $b['order'] : PHP_INT_MAX;

				if ($aOrder > $bOrder) {
					return 1;
				} elseif ($aOrder < $bOrder) {
					return -1;
				}

				return 0;
			});

			$current_url = $_SERVER['REQUEST_URI'];
			?>

			<div class="sidebar-container">
				<div class="sidebar-menu">
					<ul>
						<?php foreach ($pages as $page):
							if (!isset($page['show_if']) || isset($page['show_if']) && $page['show_if']):
								if (current_user_can($page['capability'])): ?>
									<li class="<?php echo (strpos($current_url, $page['url']) !== false ? 'active' : ''); ?>">
										<a href="<?php echo admin_url('admin.php?page=' . $page['url']); ?>" class="">
											<span class="sidebar-menu-content">
												<span class="sidebar-menu-title">
													<?php echo $page['name']; ?>
												</span><br>
												<span class="sidebar-menu-description">
													<?php echo $page['description']; ?>
												</span>
											</span>
											<span class="sidebar-menu-icon">
												<span class="dashicons dashicons-arrow-right-alt2"></span>
											</span>
										</a>
									</li>
								<?php endif;
							endif;
						endforeach; ?>
					</ul>
					<div class="sidebar-info">
						<p>
							<strong>
								<?php _e('Technical information', KP_TXT_DOMAIN); ?>
							</strong>
						</p>
						<p>
							<?php _e('Plugin version', KP_TXT_DOMAIN); ?>:
							<?php echo KP_VERSION; ?>
							<br>
							<?php _e('Plugin db version', KP_TXT_DOMAIN); ?>:
							<?php echo get_option('kls_plugin_version');
							do_action('kp_sidebar_info'); ?>
						</p>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Sidebar();
}