<?php // phpcs:ignore
/**
 * Topbar class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages/components
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if ( ! defined('ABSPATH') ) {
	exit;
}

if (!class_exists('KP_Topbar')) {
	/**
	 * Topbar class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages/components
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Topbar
	{
		/**
		 * Construct the topbar.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('kp_topbar', array($this, 'topbarOutput'));
		}

		/**
		 * Topbar output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function topbarOutput()
		{
			?>
			<style>
				#wpcontent {
					padding-left: 0 !important;
				}
			</style>

			<div class="topbar-container">
				<div class="topbar-row">
					<div class="topbar-logo">
						<img src="<?php echo $GLOBALS['adminLogo']; ?>" alt="Admin logo">
					</div>
					<div class="kls-setup-button-container">
						<?php if (current_user_can('manage_installer_kls')): ?>
							<a href="#" class="kls-setup-button" disabled>
								<span class="dashicons dashicons-admin-settings"></span>
								<span>
									<?php _e('Plugin setup', KP_TXT_DOMAIN); ?>
								</span>
							</a>
							
							<?php
							do_action('kp_topbar_installer_links');
						endif; ?>

						<a href="#" class="mobile-sidebar-toggle">
							<span class="dashicons dashicons-admin-settings"></span>
						</a>
					</div>
				</div>
			</div>
			<?php
		}
	}
	new KP_Topbar();
}
