<?php // phpcs:ignore
/**
 * Cookie page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Cookie_Page')) {
	/**
	 * Cookie page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Cookie_Page
	{
		/**
		 * Construct the cookie page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Cookie', KP_TXT_DOMAIN), __('Cookie notice', KP_TXT_DOMAIN), 'manage_cookie_data_kls', 'kls_cookie_page', array($this, 'cookiePageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Cookie notice', KP_TXT_DOMAIN),
				'description' => __('Add & edit the cookie notice', KP_TXT_DOMAIN),
				'url' => 'kls_cookie_page',
				'capability' => 'manage_cookie_data_kls',
				'order' => '40',
			);

			return $pages;
		}

		/**
		 * Cookie page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function cookiePageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_cookie_data_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');

			if (isset($_GET['tab'])) {
				$active_tab = $_GET['tab'];
			} else {
				$active_tab = 'kls_cookie_text';
			}
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Cookie notice', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('This function adds the required Cookie notice to the footer of the page with customizable settings.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<h2 class="nav-tab-wrapper">
									<a href="?page=kls_cookie_page&tab=kls_cookie_text" class="nav-tab <?php echo $active_tab == 'kls_cookie_text' ? 'nav-tab-active' : ''; ?>"><?php _e('Cookie bar text', KP_TXT_DOMAIN); ?></a>
									<?php if (!'on' == get_option('kls_legacy_cookie_toggle')): ?>
										<a href="?page=kls_cookie_page&tab=kls_cookie_popup_text" class="nav-tab <?php echo $active_tab == 'kls_cookie_popup_text' ? 'nav-tab-active' : ''; ?>"><?php _e('Cookie popup text', KP_TXT_DOMAIN); ?></a>
									<?php endif; ?>
									<a href="?page=kls_cookie_page&tab=kls_cookie_styling" class="nav-tab <?php echo $active_tab == 'kls_cookie_styling' ? 'nav-tab-active' : ''; ?>"><?php _e('Styling', KP_TXT_DOMAIN); ?></a>
									<a href="?page=kls_cookie_page&tab=kls_cookie_settings" class="nav-tab <?php echo $active_tab == 'kls_cookie_settings' ? 'nav-tab-active' : ''; ?>"><?php _e('Settings', KP_TXT_DOMAIN); ?></a>
								</h2>

								<form method="post" action="options.php">
									<?php

									if ($active_tab == 'kls_cookie_text') {
										settings_fields('kls_cookie_section');

										do_settings_sections('kls_cookie');
									} elseif ($active_tab == 'kls_cookie_popup_text' && !'on' == get_option('kls_legacy_cookie_toggle')) {
										settings_fields('kls_cookie_popup_text_section');

										do_settings_sections('kls_cookie_popup_text');
									} elseif ($active_tab == 'kls_cookie_styling') {
										settings_fields('kls_cookie_styling_section');

										do_settings_sections('kls_cookie_styling');
									} elseif ($active_tab == 'kls_cookie_settings') {
										settings_fields('kls_cookie_settings_section');

										do_settings_sections('kls_cookie_settings');
									}

									// Output save settings button..
									submit_button(__('Save', KP_TXT_DOMAIN));

									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Cookie_Page();
}