<?php // phpcs:ignore
/**
 * Dashboard page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Dashboard_Page')) {
	/**
	 * Dashboard page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Dashboard_Page
	{
		/**
		 * Construct the dashboard page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPages'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPages()
		{
			add_menu_page('Klasse dashboard', $GLOBALS['adminName'], 'manage_options', 'kls_dashboard', array($this, 'dashboardPageOutput'), 'dashicons-paperclip', 3);
			add_submenu_page('kls_dashboard', __('Dashboard', KP_TXT_DOMAIN), __('Dashboard', KP_TXT_DOMAIN), 'manage_kls', 'kls_dashboard', array($this, 'dashboardPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Dashboard', KP_TXT_DOMAIN),
				'description' => __('Information and clear cache', KP_TXT_DOMAIN),
				'url' => 'kls_dashboard',
				'capability' => 'manage_kls',
				'order' => '10',
			);

			return $pages;
		}

		/**
		 * Header output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function dashboardPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php echo $GLOBALS['adminName']; ?> plugin
								</h1>
								<p>
									<?php
									// Translators: First variable is the admin name. Second variable is the admin email.
									echo sprintf(__('Welcome in the %1$s plugin. This plugin gives the website more features like a cookie notice, maintenance page, shortcodes etc. If there are any bugs feel free to report them to: %2$s', KP_TXT_DOMAIN), $GLOBALS['adminName'], $GLOBALS['adminEmail']);
									?>
								</p>
								<hr>

								<h2>
									<?php _e('Clear all caches', KP_TXT_DOMAIN); ?>
								</h2>
								<form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
									<input type="hidden" name="action" value="kls_clear_caches">
									<button class="kls-button button button-secundary">
										<?php _e('Clear all caches', KP_TXT_DOMAIN); ?>
									</button>
								</form>

								<hr>

								<h2>
									<?php _e('Check the website for lorem ipsum', KP_TXT_DOMAIN); ?>
								</h2>
								<form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
									<input type="hidden" name="action" value="kls_check_loremipsum">
									<button class="kls-button button button-secundary">
										<?php _e('Check all posts for lorem ipsum', KP_TXT_DOMAIN); ?>
									</button>
								</form>

								<hr>

								<h2>
									<?php _e('Check the website for incorrectly spelled words', KP_TXT_DOMAIN); ?>
								</h2>
								<form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
									<input type="hidden" name="action" value="kls_check_words">
									<button class="kls-button button button-secundary">
										<?php _e('Check all posts for incorrectly spelled words', KP_TXT_DOMAIN); ?>
									</button>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Dashboard_Page();
}