<?php // phpcs:ignore
/**
 * Security page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Security_Page')) {
	/**
	 * Security page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Security_Page
	{
		/**
		 * Construct the security page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Security', KP_TXT_DOMAIN), __('Security', KP_TXT_DOMAIN), 'manage_admin_kls', 'kls_security', array($this, 'securityPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Security', KP_TXT_DOMAIN),
				'description' => __('Secure the website', KP_TXT_DOMAIN),
				'url' => 'kls_security',
				'capability' => 'manage_admin_kls',
				'order' => '80',
			);

			return $pages;
		}

		/**
		 * Security page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function securityPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_admin_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');
			?>
			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Security settings', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('The security settings add functionalities to make the enviroment more secure. It is an advanced setting so proceed with caution.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<form method="post" action="options.php">
									<?php
									settings_fields('kls_security_section');

									do_settings_sections('kls_security');

									// Output save settings button.
									submit_button(__('Save', KP_TXT_DOMAIN));

									?>
								</form>

								<h2>
									<?php _e('Update trusted IPs to the htaccess', KP_TXT_DOMAIN); ?>
								</h2>
								<form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
									<input type="hidden" name="action" value="kls_add_trusted_ips">
									<label for="kls_trusted_ips">
										<?php _e('Trusted IPs', KP_TXT_DOMAIN); ?>
									</label>
									<input type="text" name="kls_trusted_ips" id="kls_trusted_ips" value="<?php echo get_option('kls_security_trusted_ips'); ?>" class="kls_input kls_text_field">
									<button class="kls-button button button-secundary">
										<?php _e("Update trusted IP's", KP_TXT_DOMAIN); ?>
									</button>
								</form>

								<h2>
									<?php _e('Remove all the trusted IPs from the htaccess', KP_TXT_DOMAIN); ?>
								</h2>
								<form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
									<input type="hidden" name="action" value="kls_flush_trusted_ips">
									<button class="kls-button button button-secundary">
										<?php _e("Remove trusted IP's", KP_TXT_DOMAIN); ?>
									</button>
								</form>

								<h2>
									<?php _e('Add http redirect to htaccess', KP_TXT_DOMAIN); ?>
								</h2>
								<form action="<?php echo admin_url('admin-post.php'); ?>" method="post">
									<input type="hidden" name="action" value="kls_add_http_redirect">
									<button class="kls-button button button-secundary">
										<?php _e('Add http redirect', KP_TXT_DOMAIN); ?>
									</button>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_Security_Page();
}