<?php // phpcs:ignore
/**
 * Tools page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_Tools_Page')) {
	/**
	 * Tools page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_Tools_Page
	{
		/**
		 * Construct the tools page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			add_submenu_page('kls_dashboard', __('Tools', KP_TXT_DOMAIN), __('Tools', KP_TXT_DOMAIN), 'manage_admin_kls', 'kls_tools_page', array($this, 'toolsPageOutput'));
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Tools', KP_TXT_DOMAIN),
				'description' => __('Standard pages, import/export', KP_TXT_DOMAIN),
				'url' => 'kls_tools_page',
				'capability' => 'manage_admin_kls',
				'order' => '100',
			);

			return $pages;
		}

		/**
		 * Tools page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function toolsPageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_admin_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');

			if (isset($_GET['tab'])) {
				$active_tab = wp_unslash($_GET['tab']);
			} else {
				$active_tab = 'kls_tools_page';
			}

			// Log file location.
			$file = KP_LOG_FILE;
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php esc_html_e('Tools', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php esc_html_e('With this page you can generate the standard pages, import and export the settings.', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<h2 class="nav-tab-wrapper">
									<a href="?page=kls_tools_page&tab=kls_tools_page" class="nav-tab <?php echo 'kls_tools_page' == $active_tab ? 'nav-tab-active' : ''; ?>">
										<?php esc_html_e('Tools', KP_TXT_DOMAIN); ?>
									</a>
									<a href="?page=kls_tools_page&tab=kls_tools_import_export" class="nav-tab <?php echo 'kls_tools_import_export' == $active_tab ? 'nav-tab-active' : ''; ?>">
										<?php esc_html_e('Import/export', KP_TXT_DOMAIN); ?>
									</a>
									<?php if ('on' == get_option('kls_cookie_consentlog_toggle')): ?>
										<a href="?page=kls_tools_page&tab=kls_tools_logs_cookie_consent" class="nav-tab <?php echo 'kls_tools_logs_cookie_consent' == $active_tab ? 'nav-tab-active' : ''; ?>">
											<?php esc_html_e('Cookie consent log', KP_TXT_DOMAIN); ?>
										</a>
									<?php endif; ?>
									<?php if ('on' == get_option('kls_user_tracking_toggle')): ?>
										<a href="?page=kls_tools_page&tab=kls_tools_usage_tracking" class="nav-tab <?php echo 'kls_tools_usage_tracking' == $active_tab ? 'nav-tab-active' : ''; ?>">
											<?php esc_html_e('Usage tracking log', KP_TXT_DOMAIN); ?>
										</a>
									<?php endif; ?>
									<a href="?page=kls_tools_page&tab=kls_tools_logs" class="nav-tab <?php echo 'kls_tools_logs' == $active_tab ? 'nav-tab-active' : ''; ?>">
										<?php esc_html_e('Plugin log', KP_TXT_DOMAIN); ?>
									</a>
								</h2>

								<?php
								if ('kls_tools_page' == $active_tab) {
									?>
									<h2>
										<?php esc_html_e('Create ReCaptcha form action', KP_TXT_DOMAIN); ?>
									</h2>
									<form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
										<input type="hidden" name="action" value="kls_create_recaptcha_action">
										<button class="kls-button button button-secundary">
											<?php esc_html_e('Create recaptcha action (Ninja Forms)', KP_TXT_DOMAIN); ?>
										</button>
									</form>

									<hr>

									<h2>
										<?php esc_html_e('Generate standard pages', KP_TXT_DOMAIN); ?>
									</h2>
									<form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
										<input type="hidden" name="action" value="kls_create_pages">
										<button class="kls-button button button-secundary">
											<?php esc_html_e('Generate standard pages', KP_TXT_DOMAIN); ?>
										</button>
									</form>
									<?php
								} elseif ('kls_tools_import_export' == $active_tab) {
									?>
									<h2>
										<?php esc_html_e('Export plugin and theme settings', KP_TXT_DOMAIN); ?>
									</h2>
									<textarea class="kls_textarea"><?php do_action('kls_export_json'); ?></textarea>

									<h2>
										<?php esc_html_e('Import plugin and theme settings', KP_TXT_DOMAIN); ?>
									</h2>
									<p style="color:red;"><strong>
											<?php esc_html_e('Warning, by running this import you will override all plugin settings! So pay attention to what you want to be updated!', KP_TXT_DOMAIN); ?>
										</strong></p>
									<form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
										<input type="hidden" name="action" value="kls_import_settings">
										<textarea class="kls_textarea" name="kls_import_json" id="kls_import_json"></textarea>
										<div style="margin-bottom: 10px;">
											<input type="checkbox" id="kls_plugin_options" name="kls_plugin_options" value="on" checked>
											<label for="kls_plugin_options">
												<?php esc_html_e('Import plugin settings', KP_TXT_DOMAIN); ?>
											</label>
										</div>
										<div style="margin-bottom: 10px;">
											<input type="checkbox" id="kls_theme_mods" name="kls_theme_mods" value="on" checked>
											<label for="kls_theme_mods">
												<?php esc_html_e('Import theme mods', KP_TXT_DOMAIN); ?>
											</label>
										</div>
										<button class="kls-button button button-secundary">
											<?php esc_html_e('Import settings', KP_TXT_DOMAIN); ?>
										</button>
									</form>
									<?php
								} elseif ('kls_tools_logs_cookie_consent' == $active_tab && 'on' == get_option('kls_cookie_consentlog_toggle')) {
									?>
									<h2>
										<?php esc_html_e('Cookie consent log', KP_TXT_DOMAIN); ?>
									</h2>
									<div class="kls_log_container">
										<div class="kls_log_head">
											<div>
												<?php echo esc_html_e('IP Address', 'klasse-theme'); ?>
											</div>
											<div>
												<?php echo esc_html_e('Consent status', 'klasse-theme'); ?>
											</div>
											<div>
												<?php echo esc_html_e('Date/Time', 'klasse-theme'); ?>
											</div>
										</div>
										<?php

										global $wpdb;

										$table_name = $wpdb->prefix . 'kls_consentlog';

										$retrieve_data = $wpdb->get_results("SELECT * FROM $table_name ORDER BY time DESC");

										// [Dev] Todo, if empty show empty text.
										foreach ($retrieve_data as $data) {
											?>
											<div class="kls_cookie_consentlog_item">
												<div>
													<?php echo esc_html($data->ip_address); ?>
												</div>
												<div>
													<?php echo esc_html($data->consent_status); ?>
													<span>
														<?php echo esc_html($data->accepted_categories); ?>
													</span>
													<span>
														<?php echo esc_html($data->rejected_categories); ?>
													</span>
												</div>

												<div>
													<?php echo esc_html($data->time); ?>
												</div>
											</div>
											<?php
										}
										?>
									</div>
									<?php
									// [Dev] Todo, add a button to clear all the logs.
								} elseif ('kls_tools_logs' == $active_tab) {
									?>
									<h2>
										<?php esc_html_e('Plugin log', KP_TXT_DOMAIN); ?>
									</h2>
									<div class="kls_log_container">
										<?php
										echo nl2br(esc_html(file_get_contents($file)));
										?>
									</div>
									<?php
									// [Dev] Todo, add a button to clear all the logs.
								} elseif ('kls_tools_usage_tracking' == $active_tab) {
									?>
									<h2>
										<?php esc_html_e('Usage tracking log', KP_TXT_DOMAIN); ?>
									</h2>
									<div class="kls_log_container">
										<?php
										foreach (get_option('kls_user_interactions') as $key => $value) {
											?>
											<h5>Gebruiker:
												<?php echo $key ?>
											</h5>
											<?php
											foreach ($value as $item) {
												foreach ($item as $key2 => $value2) {
													?>
													<ul>
														<?php
														if (isset($value2['type'])) {
															echo '<li>Type: ' . $value2['type'] . '</li>';
														}

														if (isset($value2['timestamp'])) {
															echo '<li>Timestamp: ' . date('H:m:s m/d/Y', $value2['timestamp'] / 1000) . '</li>';
														}

														if (isset($value2['url'])) {
															echo '<li>Page: ' . $value2['url'] . '</li>';
														}

														if (isset($value2['leavingPage'])) {
															echo '<li>Leaving page: ' . $value2['leavingPage'] . '</li>';
														}
														?>
													</ul>
													<?php
												}
												echo '<hr>';
											}
										}
										?>
									</div>
									<?php
									// [Dev] Todo, add a button to clear all the logs.
								}
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}
	new KP_Tools_Page();
}