<?php // phpcs:ignore
/**
 * WooCommerce page class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/admin/pages
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.01
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KP_WooCommerce_Page')) {
	/**
	 * WooCommerce page class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/admin/pages
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.01
	 */
	class KP_WooCommerce_Page
	{
		/**
		 * Construct the WooCommerce page.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.01
		 */
		public function __construct()
		{
			add_action('admin_menu', array($this, 'menuPage'));
			add_filter('kp_sidebar_links', array($this, 'sidebarLink'));
		}

		/**
		 * Add page to admin menu.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function menuPage()
		{
			if (get_option('kls_webshop_toggle') == 'on') {
				add_submenu_page('kls_dashboard', __('Woocommerce', KP_TXT_DOMAIN), __('Woocommerce settings', KP_TXT_DOMAIN), 'manage_woocommerce_data_kls', 'kls_woocommerce_page', array($this, 'woocommercePageOutput'));
			}
		}

		/**
		 * Add page to the sidebar.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function sidebarLink($pages)
		{
			$pages[] = array(
				'name' => __('Woocommerce settings', KP_TXT_DOMAIN),
				'description' => __('Change standard options', KP_TXT_DOMAIN),
				'url' => 'kls_woocommerce_page',
				'capability' => 'manage_woocommerce_data_kls',
				'show_if' => get_option('kls_webshop_toggle') == 'on',
				'order' => '70',
			);

			return $pages;
		}

		/**
		 * WooCommerce page output.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.01
		 */
		public function woocommercePageOutput()
		{
			// Check user capabilities.
			if (!current_user_can('manage_woocommerce_data_kls')) {
				return;
			}

			require 'components/header.class.php';
			do_action('kp_header');
			?>

			<div class="wrap kls-page-wrapper py-4">
				<div class="container">
					<div class="row">
						<div class="col col-md-12 col-xl-2">
							<?php do_action('kp_sidebar'); ?>
						</div>
						<div class="col col-md-12 col-xl-10">
							<div class="content-container">
								<h1>
									<?php _e('Woocommerce settings', KP_TXT_DOMAIN); ?>
								</h1>
								<p>
									<?php _e('Woocommerce settings adds a additional settings for improving the Woocommerce plugin. It adds a "From:" infront of variable prices, gives the posibility to globalize the couponcode text and much more!', KP_TXT_DOMAIN); ?>
								</p>
								<hr>

								<form method="post" action="options.php">
									<?php
									settings_fields('kls_woocommerce_settings_section');

									do_settings_sections('kls_woocommerce');

									// Output save settings button.
									submit_button(__('Save', KP_TXT_DOMAIN));

									?>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KP_WooCommerce_Page();
}
