jQuery(document).ready(function ($) {
	// Buffer to store data temporarily before sending it to the server
	var dataBuffer = [];

	// Capture Session Start
	var sessionData = {
		type: 'session start',
		url: window.location.href,
		timestamp: new Date().getTime(),
	};
	dataBuffer.push(sessionData);
	sendDataToServer();

	// Function to save interaction data to the buffer
	function saveToBuffer(data) {
		dataBuffer.push(data);

		if (dataBuffer.length >= 10) {  // Adjust the limit based on your preference
			sendDataToServer();
		}
	}

	// Function to send data to the server
	// Function to send data to the server
	function sendDataToServer() {
		if (dataBuffer.length === 0) return;

		$.ajax({
			url: '/wp-admin/admin-ajax.php',  // Update with your WordPress admin AJAX URL
			type: 'POST',
			data: {
				action: 'save_user_interaction_data',
				interaction_data: JSON.stringify(dataBuffer),
				security: my_ajax_object.nonce  // Include the nonce in the AJAX request
			}
		})
			.done(function (response) {
				console.log('Data sent successfully', response);
			})
			.fail(function (error) {
				console.error('Failed to send data', error);
			});

		dataBuffer = [];  // Clear the buffer
	}


	// Capture Click Events
	$(document).click(function (event) {
		var clickData = {
			type: 'click',
			target: event.target.tagName,
			id: event.target.id,
			class: event.target.className,
			x: event.pageX,
			y: event.pageY,
			timestamp: new Date().getTime()
		};
		saveToBuffer(clickData);
	});

	// Capture Scroll Events (Throttled to improve performance)
	var scrollTimer;
	$(window).scroll(function () {
		clearTimeout(scrollTimer);
		scrollTimer = setTimeout(function () {
			var scrollData = {
				type: 'scroll',
				position: $(window).scrollTop(),
				timestamp: new Date().getTime()
			};
			saveToBuffer(scrollData);
		}, 200);  // Adjust the delay as needed
	});

	// Capture Form Submission Events
	$('form').submit(function (event) {
		var formData = {
			type: 'form submission',
			form: $(this).attr('name') || $(this).attr('id') || 'unnamed form',
			data: $(this).serialize(),
			timestamp: new Date().getTime()
		};
		saveToBuffer(formData);
	});

	// ... (include other event handlers here like the ones in the previous example)

	// Function to detect the user's navigation actions
	window.addEventListener('beforeunload', function (event) {
		var navigationData = {
			type: 'navigation',
			leavingPage: window.location.href,
			timestamp: new Date().getTime()
		};
		saveToBuffer(navigationData);

		// Send buffer data before user leaves the page
		sendDataToServer();
	});

	// Function to track errors
	window.onerror = function (message, source, lineno, colno, error) {
		var errorData = {
			type: 'error',
			message: message,
			source: source,
			line: lineno,
			column: colno,
			errorObject: JSON.stringify(error),
			timestamp: new Date().getTime()
		};
		saveToBuffer(errorData);
	};
});
