<?php // phpcs:ignore
/**
 * Logger class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/includes/logger
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.93
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_Logger' ) ) {
	/**
	 * Logger class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/includes/ipgrades
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.93
	 *
	 * [Dev] Todo, add function to log if plugin option is updated.
	 */
	class KP_Logger {

		/**
		 * Construct the logger.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.93
		 */
		public function __construct() {
		}

		/**
		 * Write to the log
		 *
		 * @param string $message Content to put in the log file.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.93
		 */
		public function writeLog( $message ) {
			$file = KP_LOG_FILE;
			if ( ! empty( $message ) ) {
				$file_message = $this->getCurrentDate() . ': ' . $message . "\r\n";
				file_put_contents( $file, $file_message, FILE_APPEND | LOCK_EX );
			}
		}

		/**
		 * Get the current date
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.93
		 */
		public function getCurrentDate() {
			$date = new DateTime( 'now', new DateTimeZone( 'Europe/Amsterdam' ) );

			return $date->format( 'd-m-y H:i:s' );
		}
	}

	new KP_Logger();
}
