<?php
/**
 * The plugin functions
 *
 * @category Klasse_Plugin
 * @package  KP
 * @author   Joeri van der Stek <joeri@klassebv.nl>
 * @license  GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link     https://github.com/Klasse-Software-Development-B-V/klasse-website-sync
 * @since    0.0.1
 *
 * Plugin Name:       Klasse Plugin
 * Plugin URI:        https://github.com/joerivanderstek/klasse-plugin
 * Description:       Plugin for all the Klasse Software & Development B.V. Trademarks. Delete with caution.
 * Version:           0.1.20
 * Requires at least: 5.4
 * Requires PHP:      7.4
 * Author:            Klasse Software & Development B.V.
 * Author URI:        https://klassebv.nl/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 */

// namespace KP;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Define all the constants
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.93
 */
// Plugin basics.
$kls_plugin = get_file_data( __FILE__, array( 'Version' => 'Version' ), false );
define( 'KP_NAME', 'Klasse_Plugin' );
define( 'KP_VERSION', $kls_plugin['Version'] );
define( 'KP_DB_VERSION', '0.0.91' );

// Define text domain.
define( 'KP_TXT_DOMAIN', 'klasse-plugin' );

// Define includes paths.
define( 'KP_PLUGIN_FILE_URL', __FILE__ );
define( 'KP_DIR_PATH', plugin_dir_path( KP_PLUGIN_FILE_URL ) );

define( 'KP_PLUGIN', '/klasse-plugin/' );
define( 'KP_PLUGIN_PATH', WP_PLUGIN_DIR . KP_PLUGIN );
define( 'KP_INCLUDES_PATH', WP_PLUGIN_URL . KP_PLUGIN . 'includes/' );
define( 'KP_ASSETS_PATH', WP_PLUGIN_URL . KP_PLUGIN . 'assets/' );
define( 'KP_VENDORS_PATH', KP_PLUGIN_PATH . 'vendor/' );
define( 'KP_VENDORS_PATH_ASSETS', WP_PLUGIN_URL . KP_PLUGIN . 'vendor/' );

define( 'KP_LOG_FILE', WP_CONTENT_DIR . '/uploads/klasse_plugin_log.txt' );
define( 'KP_API_LOG_FILE', WP_CONTENT_DIR . '/uploads/klasse_api_log.txt' );

/**
 * Load the text domain
 *
 * @since 0.0.06
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kpPluginInit() {
	load_plugin_textdomain( KP_TXT_DOMAIN, false, 'klasse-plugin/languages' );

	include_once __DIR__ . '/includes/logger.class.php';

	$logger = new KP_Logger();
	$logger;
}
kpPluginInit();

/**
 * Require admin functions
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( is_admin() ) {
	include_once __DIR__ . '/includes/upgrades.class.php';
	include_once __DIR__ . '/includes/installation.php';
	include_once __DIR__ . '/admin/klasse-plugin-admin.php';
}

// Admin settings.
require_once __DIR__ . '/admin/includes/admin/admin.php';

/**
 * Require public functions
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/public/public-manager.class.php';

/**
 * Include styling & scripts
 *
 * @since 0.0.04
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kpGlobalStyle() {
	if ( get_option( 'kls_toggle_font_awesome' ) == 'on' ) {
		wp_enqueue_style( 'kls_font_awesome_css', KP_VENDORS_PATH_ASSETS . 'components/font-awesome/css/all.min.css', false, KP_VERSION );
	}
}
add_action( 'wp_enqueue_scripts', 'kpGlobalStyle' );
add_action( 'admin_enqueue_scripts', 'kpGlobalStyle' );

require_once KP_VENDORS_PATH . 'yahnis-elsts/plugin-update-checker/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;
/**
 * Add the plugin update checker function
 *
 * @since 0.0.01
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function checkKlassePluginUpdates() {
	if ( is_admin() && 'on' == get_option( 'kls_updates_toggle' ) ) {
		$kp_update_checker = PucFactory::buildUpdateChecker(
			'https://github.com/Klasse-Software-Development-B-V/klasse-plugin',
			__FILE__,
			'klasse-plugin'
		);

		$kp_update_checker->setAuthentication( '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' );

		if ( get_option( 'kls_beta_updates_toggle' ) == 'on' ) {
			$kp_update_checker->setBranch( 'development' );
		} else {
			$kp_update_checker->setBranch( 'main' );
		}

		$kp_update_checker->getVcsApi()->enableReleaseAssets();
	}
}
checkKlassePluginUpdates();
