<?php

/**
 * Create clear caches api
 *
 * @since 0.0.35
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * [Dev] Todo, refactor this to be more useable and future proof. This needs to be based on the sync plugin. Split it up in 3 files. Api.class.php, api-get.class.php, api-post.class.php. Post will be used to offload form data (Emailadres, site, category, date) to external database.
 * [Dev] Todo, also deprecate this version.
 */

add_action( 'wp_loaded', 'kls_internal_rewrites' );
function kls_internal_rewrites() {
	add_rewrite_rule( 'kls-website-api$', 'index.php?kls-website-api=1', 'top' );
}

add_filter( 'query_vars', 'kls_internal_query_vars' );
function kls_internal_query_vars( $query_vars ) {
	$query_vars[] = 'kls-website-api';
	return $query_vars;
}

add_action( 'parse_request', 'kls_internal_rewrites_parse_request' );
function kls_internal_rewrites_parse_request( &$wp ) {
	if ( ! array_key_exists( 'kls-website-api', $wp->query_vars ) ) {
		return;
	}

	if ( $wp->query_vars['kls-website-api'] == get_option( 'kls_api_key' ) ) :
		// Update last connection date
		date_default_timezone_set( 'Europe/Amsterdam' );
		update_option( 'kls_api_last_connection', date( 'd/m/Y - H:i:s' ) );

		print_r( get_site_url() . ' ' );

		// Clear caches
		if ( $_REQUEST['kls_clear_cache'] == 1 ) :
			// Clear Divi cache
			$theme = wp_get_theme();
			if ( in_array( 'divi-builder/divi-builder.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) || 'Divi' == $theme->name || 'Divi' == $theme->parent_theme ) {
				ET_Core_PageResource::do_remove_static_resources( 'all', 'all', true );
			}

			// Clear WP Rocket cache
			// Clear cache
			if ( function_exists( 'rocket_clean_domain' ) ) {
				rocket_clean_domain();
			}

			// Clear minified CSS and JavaScript files
			if ( function_exists( 'rocket_clean_minify' ) ) {
				rocket_clean_minify();
			}

			// Create preload
			if ( function_exists( 'run_rocket_bot' ) ) {
				run_rocket_bot();
			}

			// Clear Litespeed caches
			// Clear all caches
			do_action( 'litespeed_purge_all' );

			print_r( 'Cache cleared' );
			endif;

		// Update htaccess trusted IP's
		if ( $_REQUEST['kls_insert_ips'] == 1 ) {
			$trusted_ips = $_REQUEST['kls_trusted_ips'];
			$combined    = $_REQUEST['kls_combined'];
			kls_update_trusted_ips( $trusted_ips, $combined );
			print_r( ' | Trusted ips updated' );
		}

		// Update options
		if ( $_REQUEST['kls_update_options'] == 1 ) {
			foreach ( $_REQUEST as $test ) :
				if ( substr_compare( $test, 'kls_option_data', 0, strlen( 'kls_option_data' ) ) === 0 ) :
					$test = explode( '|', $test );
					if ( substr_compare( $test[1], 'kls_', 0, strlen( 'kls_' ) ) === 0 || substr_compare( $test[1], 'blogname', 0, strlen( 'blogname' ) ) === 0 ) :
						update_option( $test[1], $test[2] );
						else :
							print_r( 'Warning, you cant update ' . $test[1] );
							die();
						endif;
					endif;
				endforeach;

			print_r( 'Updated options' );
		}

		if ( get_option( 'kls_api_key' ) == 'XlidNb7b3ys4smyjVG3LTnnhlpzJJFlIihnjdL5H7LZ8NGbLrleSE1pjJmPod3ZJ' ) :
			update_option( 'kls_api_key', kls_api_random_str( '64' ) );

			date_default_timezone_set( 'Europe/Amsterdam' );
			update_option( 'kls_api_last_change', date( 'd/m/Y - H:i:s' ) );

			print_r( get_site_url() . ',' . get_option( 'kls_api_key' ) );
			endif;

		die();
	else :
		print_r( get_site_url() );
		die();
	endif;
}

/**
 * Insert htaccess trusted ips remotely
 *
 * @since 0.0.51
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_update_trusted_ips( $trusted_ips, $combined ) {
	include_once 'wp-admin/includes/misc.php';
	$trusted = get_option( 'kls_security_trusted_ips' );
	if ( $combined == 1 ) :
		$trusted = $trusted . ',' . $trusted_ips;

		$trusted = implode( ',', array_unique( explode( ',', $trusted ) ) );
		$trusted = rtrim( $trusted, ',' );
		$trusted = ltrim( $trusted, ',' );
		print_r( ' | Combined with current ips' );
	else :
		$trusted = $trusted_ips;
	endif;

	update_option( 'kls_security_trusted_ips', $trusted );

	$htaccess_file = get_home_path() . '.htaccess';

	return insert_with_markers( $htaccess_file, 'Klasse B.V. HTaccess data', 'Trusted:' . $trusted );
}

/**
 * API generate 64 key
 *
 * @since 0.0.57
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_api_random_str(
	int $length = 64,
	string $keyspace = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'
): string {
	if ( $length < 1 ) {
		throw new \RangeException( 'Length must be a positive integer' );
	}
	$pieces = array();
	$max    = mb_strlen( $keyspace, '8bit' ) - 1;
	for ( $i = 0; $i < $length; ++$i ) {
		$pieces [] = $keyspace[ random_int( 0, $max ) ];
	}
	return implode( '', $pieces );
}
