<?php // phpcs:ignore
/**
 * Api class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/public/includes/api/post
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.94
 *
 * Todo, implement logger.
 * Todo, add maintenance page to exclude /wp-json/
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_Post' ) ) {
	/**
	 * Api class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/public/includes/api/post
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.94
	 */
	class KP_Post {

		/**
		 * Construct the api.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.94
		 */
		public function __construct() {
			 add_action( 'rest_api_init', array( $this, 'registerRoutes' ) );
		}

		/**
		 * Register the routes for the options API
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.93
		 */
		public function registerRoutes() {
			$api_v2 = 'klasse-api/v2';

			register_rest_route(
				$api_v2,
				'/update-options',
				array(
					'methods'             => 'POST',
					'callback'            => array( $this, 'postOptions' ),
					'permission_callback' => array( $this, 'callAuth' ),
				)
			);

			register_rest_route(
				$api_v2,
				'/update-theme-mods',
				array(
					'methods'             => 'POST',
					'callback'            => array( $this, 'postThemeMods' ),
					'permission_callback' => array( $this, 'callAuth' ),
				)
			);

			register_rest_route(
				$api_v2,
				'/update-trusted-ips',
				array(
					'methods'             => 'POST',
					'callback'            => array( $this, 'postTrustedIps' ),
					'permission_callback' => array( $this, 'callAuth' ),
				)
			);

			register_rest_route(
				$api_v2,
				'/clear-cache',
				array(
					'methods'             => 'POST',
					'callback'            => array( $this, 'postClearCache' ),
					'permission_callback' => array( $this, 'callAuth' ),
				)
			);
		}

		public function callAuth($request) {
			$api_controller = new KP_Api();

			return $api_controller->authenticate($request);
		}

		/**
		 * Update an option
		 *
		 * This function updates an option based on the option_name and new_value parameters passed in the request object.
		 *
		 * @param WP_REST_Request $request The request object.
		 * @return WP_REST_Response|WP_Error The response containing the success status and message or an error if the option_name or new_value are missing.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.94
		 *
		 * [Dev] Todo, find a better way for the exploding.
		 * [Dev] Todo, add error handling.
		 */
		public function postOptions( $request ) {
			foreach ( $request->get_params() as $key => $value ) :
				$key = explode( '|', $key );

				if ( ! str_contains( $key[0], 'kls_api_key' ) && str_contains( $key[0], 'kls_' ) || str_contains( $key[0], 'blogname' ) ) :

					if ( isset( $key[1] ) && 'combine' == $key[1] ) :
						$old_value = get_option( $key[0] );

						$seperator = isset( $key[2] ) ? $key[2] : '';

						update_option( $key[0], $old_value . $seperator . $value );
					else :
						update_option( $key[0], $value );
					endif;
				elseif (str_contains($key[1], 'rocket_option')) :
					if (function_exists('update_rocket_option')) :
						update_rocket_option($key[0], $value);
					endif;
				else :
					echo 'Warning, you may not update ' . $key[0];
				endif;
			endforeach;

			$api_controller = new KP_Api();
			$api_controller->clearCache();

			return new WP_REST_Response(
				array(
					'success' => true,
					'message' => 'Option(s) updated successfully!',
				)
			);

			// Todo, fix this.
			// return new WP_REST_Response(
			// array(
			// 'success' => false,
			// 'message' => 'Missing option_name or new_value',
			// ),
			// 400,
			// );
		}

		public function postThemeMods( $request ) {
			foreach ( $request->get_params() as $key => $value ) :
				set_theme_mod( $key, $value );
			endforeach;

			$api_controller = new KP_Api();
			$api_controller->clearCache();

			return new WP_REST_Response(
				array(
					'success' => true,
					'message' => 'Theme mod(s) updated successfully!',
				)
			);

			return new WP_REST_Response(
				array(
					'success' => false,
					'message' => 'Missing theme_mod_name or new_value',
				),
				400,
			);
		}

		public function postTrustedIps( $request ) {
			$trusted_ips = $request->get_param( 'trusted_ips' );
			$combine     = $request->get_param( 'combine' );
			$clear       = $request->get_param( 'clear' );
			// Update htaccess trusted IP's.
			if ( isset( $trusted_ips ) && ! empty( $trusted_ips ) ) {
				$this->updateTrustedIpsFunction( $trusted_ips, $combine, $clear );

				if ( 1 == $clear ) {
					$message = 'Trusted ip(s) cleared successfully!';
				} elseif ( 1 == $combine ) {
					$message = 'Trusted ip(s) updated and combined successfully!';
				} else {
					$message = 'Trusted ip(s) updated successfully!';
				}

				$api_controller = new KP_Api();
				$api_controller->clearCache();

				return new WP_REST_Response(
					array(
						'success' => true,
						'message' => $message,
					)
				);
			} else {
				return new WP_REST_Response(
					array(
						'success' => false,
						'message' => 'Missing ip(s).',
					),
					400,
				);
			}
		}

		public function updateTrustedIpsFunction( $trusted, $combine = null, $clear = null ) {
			include_once 'wp-admin/includes/misc.php';
			$htaccess_file = get_home_path() . '.htaccess';

			if ( 1 == $clear ) {
				update_option( 'kls_security_trusted_ips', '' );
				return insert_with_markers( $htaccess_file, 'Klasse B.V. HTaccess data', '' );
			}

			if ( 1 == $combine ) :
				$currentTrustedIps = get_option( 'kls_security_trusted_ips' );

				$trusted = $currentTrustedIps . ',' . $trusted;

				$trusted = implode( ',', array_unique( explode( ',', $trusted ) ) );
				$trusted = rtrim( $trusted, ',' );
				$trusted = ltrim( $trusted, ',' );
			endif;

			update_option( 'kls_security_trusted_ips', $trusted );

			return insert_with_markers(
				$htaccess_file,
				'Klasse B.V. HTaccess data',
				'<IfModule LiteSpeed>
Trusted:' . $trusted . '
</IfModule>'
			);
		}

		public function postClearCache() {
			$api_controller = new KP_Api();
			$api_controller->clearCache();

			return new WP_REST_Response(
				array(
					'success' => true,
					'message' => 'Cleared the cache.',
				)
			);
		}
	}

	new KP_Post();
}
