<?php

namespace KP\PublicManager\GravityForms;

require_once __DIR__ . '/merge-tags.class.php';
require_once __DIR__ . '/sessions.class.php';

if (!class_exists('GravityFormsController')) {
	class GravityFormsController
	{
		private $mergeTagManager;
		private $sessionManager;

		public function __construct()
		{
			add_filter('gform_notification_enable_cc', '__return_true');

			$options = [
				// Customer company name
				[
					'name' => 'kls_customer_name',
					'tag' => '{klant:bedrijfsnaam}',
					'label' => __('Customer company', KP_TXT_DOMAIN),
				],
				// Customer phone number
				[
					'name' => 'kls_customer_phone',
					'tag' => '{klant:telefoonnummer}',
					'label' => __('Customer phone', KP_TXT_DOMAIN),
				],
				// Customer address
				[
					'name' => 'kls_merge_customer_form_address',
					'custom_output' => get_option('kls_customer_street') . '<br>' . get_option('kls_customer_postcode') . ', ' . get_option('kls_customer_city') . '<br>' . get_option('kls_customer_country'),
					'tag' => '{klant:adres}',
					'label' => __('Customer address', KP_TXT_DOMAIN),
				],
				// Customer kvk
				[
					'name' => 'kls_customer_kvk',
					'tag' => '{klant:kvk}',
					'label' => __('Customer KVK', KP_TXT_DOMAIN),
				],
				// Customer mail
				[
					'name' => 'kls_customer_btw',
					'tag' => '{klant:btw}',
					'label' => __('Customer BTW', KP_TXT_DOMAIN),
				],
				// Mail
				[
					'name' => 'kls_customer_form_email',
					'tag' => '{klant:emailadres}',
					'label' => __('Customer email', KP_TXT_DOMAIN),
				],
				// CC
				[
					'name' => 'kls_customer_form_cc_email',
					'tag' => '{klant:cc_emailadres}',
					'label' => __('CC email', KP_TXT_DOMAIN),
				],
				// BCC
				[
					'name' => 'kls_customer_form_bcc_email',
					'tag' => '{klant:bcc_emailadres}',
					'label' => __('BCC email', KP_TXT_DOMAIN),
				],
				// Zapier email
				[
					'name' => 'kls_customer_zapier_email',
					'tag' => '{zapier:emailadres}',
					'label' => __('Zapier email', KP_TXT_DOMAIN),
				],
				// Zapier webhook
				[
					'name' => 'kls_customer_zapier_webhook',
					'tag' => '{zapier:webhook}',
					'label' => __('Zapier webhook', KP_TXT_DOMAIN),
				],
				// Admin name
				[
					'name' => 'kls_admin_name',
					'tag' => '{admin:name}',
					'label' => __('Admin name', KP_TXT_DOMAIN),
				],
				// Tacking campaign cookie
				[
					'name' => 'kls_campaign_cookie',
					'custom_output' => $this->campaginCookieOutput(),
					'tag' => '{website:cookie_tracking}',
					'label' => __('Admin name', KP_TXT_DOMAIN),
				],
				// Website url
				[
					'name' => 'kls_campaign_cookie',
					'custom_output' => get_home_url(),
					'tag' => '{website:url}',
					'label' => __('Admin name', KP_TXT_DOMAIN),
				],
			];

			$this->mergeTagManager = new MergeTagManager($options);

			$this->sessionManager = new SessionManager();
		}

		private function campaginCookieOutput()
		{
			$cookie_value = isset($_COOKIE['kp_campaigns']) ? $_COOKIE['kp_campaigns'] : '';

			return $cookie_value;
		}
	}
}