<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />

	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">

	<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=yes'/>

	<?php if ( wp_get_attachment_image_src( get_option( 'kls_customer_favicon' ), 'large' ) ) : ?>
		<link rel="icon" type="image" href="<?php echo wp_kses_post( wp_get_attachment_image_src( get_option( 'kls_customer_favicon' ), 'large' )[0] ); ?>">
	<?php endif; ?>

	<meta name="theme-color" content="<?php echo esc_html( get_option( 'kls_customer_main_color' ) ); ?>">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
	<style>
		main {
			min-height: 100vh;
			<?php

			if ( get_option( 'kls_maintenance_background_select' ) == 'Image' && ! empty( get_option( 'kls_maintenance_background_image' ) ) ) {
				$options = get_option( 'kls_maintenance_background_image' );

				echo 'background-image: url("' . wp_kses_post( wp_get_attachment_image_src( $options, 'full' )[0] ) . '");';
			} elseif ( get_option( 'kls_maintenance_background_select' ) == 'Color' && ! empty( get_option( 'kls_maintenance_background_color' ) ) ) {
				$options = get_option( 'kls_maintenance_background_color' );

				echo 'background-color:' . esc_html( $options ) . ';';
			} elseif ( get_option( 'kls_maintenance_background_select' ) == 'Gradient' && ! empty( get_option( 'kls_maintenance_background_gradient' ) ) ) {
				$options = get_option( 'kls_maintenance_background_gradient' );

				echo 'background: ' . esc_html( $options ) . '; ';
			} else {
				echo 'background: #212121;';
			}
			?>
			background-size: cover;
			background-repeat: no-repeat;
		}

		.row {
			min-height: 100vh;
			align-items: center;
		}

		.box-color {
			background: rgba(255, 255, 255, 0.8);
			border-radius: 10px;
		}

		h1 {
			margin-bottom: 40px;
			line-height: 1.4em;
		}

		h2 {
			font-size: 1.3em;
			color: #212121;
			font-weight: bold;
		}

		a{
			color: #212121;
			font-weight: bold;
			text-decoration: underline;
		}

		h2 img{
			width: 75% !important;
		}

		footer{
			display: none !important;
		}

		@media (max-width: 450px){
			h1{
				font-size: 1.6em;
			}

			h2 img{
				width: 100% !important;
			}
		}
	</style>
</head>

<body style="margin-top: 0 !important;">
<?php echo get_option( 'kls_scripts_body' ); ?>
	<main>
		<div class="container">
			<div class="row">
				<div class="col-md-6 offset-md-3 text-center py-5 box-color my-4">
					<h2><img src="
					<?php
					if ( get_option( 'kls_customer_logo' ) ) {
						echo wp_kses_post( wp_get_attachment_image_src( get_option( 'kls_customer_logo' ), 'large' )[0] );
					} else {
						echo esc_html( $GLOBALS['adminLogo'] );
					}
					?>
					" alt="Logo"></h2>

					<h1><?php echo esc_html( kls_plugin_translate_option( 'kls_maintenance_title', 'Maintenance page title', 'nl' ) ); ?></h1>
					<p><?php echo esc_html( kls_plugin_translate_option( 'kls_maintenance_text', 'Maintenance page text', 'nl' ) ); ?></p>
					<?php
					if ( get_option( 'kls_maintenance_customer_data_toggle' ) ) :
						if ( get_option( 'kls_customer_phone' ) && get_option( 'kls_customer_email' ) ) {
							?>
							<a href="tel:<?php echo esc_html( get_option( 'kls_customer_phone' ) ); ?>"><?php echo esc_html( get_option( 'kls_customer_phone' ) ); ?></a> | <a href="mailto:<?php echo esc_html( get_option( 'kls_customer_email' ) ); ?>"><?php echo esc_html( get_option( 'kls_customer_email' ) ); ?></a> 
						<?php } elseif ( get_option( 'kls_customer_email' ) ) { ?>
							<a href="mailto:<?php echo esc_html( get_option( 'kls_customer_email' ) ); ?>"><?php echo esc_html( get_option( 'kls_customer_email' ) ); ?></a> 
						<?php } elseif ( get_option( 'kls_customer_phone' ) ) { ?>
							<a href="tel:<?php echo esc_html( get_option( 'kls_customer_phone' ) ); ?>"><?php echo esc_html( get_option( 'kls_customer_phone' ) ); ?></a> 
							<?php
						};
					endif;
					?>
				</div>
			</div>
		</div>
	</main>
	<?php
		wp_footer();
	?>
</body>

</html>
