<?php // phpcs:ignore
/**
 * Ninja Forms actions class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/public/includes/ninjaforms
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.96
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_NF_Actions' ) ) {
	/**
	 * Ninja Forms actions class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/public/includes/ninjaforms
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.96
	 *
	 * Todo, add a button that let's you add the zapier email actions to all the forms.
	 */
	class KP_NF_Actions {

		/**
		 * Construct the actions.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.96
		 */
		public function __construct() {
			 add_action( 'admin_post_kls_create_recaptcha_action', array( $this, 'addRecaptchaActions' ) );
		}

		/**
		 *
		 * Adds reCAPTCHA v3 action to all Ninja Forms if reCAPTCHA keys are set in settings.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.96
		 *
		 * @return void
		 */
		public function addRecaptchaActions() {
			// Get the Ninja Forms settings and check for the recaptcha keys.
			$site_key   = Ninja_Forms()->get_setting( 'recaptcha_site_key_3' );
			$secret_key = Ninja_Forms()->get_setting( 'recaptcha_secret_key_3' );

			if ( ! isset( $site_key ) || empty( $site_key ) || ! isset( $secret_key ) || empty( $secret_key ) ) {
				if ( $_POST['action'] == 'kls_create_recaptcha_action' ) {
					// Redirect to the settings page.
					wp_redirect( admin_url( 'admin.php?page=kls_tools_page' ) );
					kls_admin_notice( __( 'No ReCaptcha V3 keys set. Add them to the Ninja Forms settings page.', KP_TXT_DOMAIN ), 'error', true );
					return;
				} else {
					return;
				}
			}

			// Get all the forms.
			$forms               = Ninja_Forms()->form()->get_forms();
			$form_captcha_amount = 0;

			foreach ( $forms as $form ) {
				// Get the current forms actions.
				$form_id                    = $form->get_id();
				$current_form               = Ninja_Forms()->form( $form_id );
				$actions                    = $current_form->get_actions();
				$recaptcha_v3_action_exists = false;

				foreach ( $actions as $action ) {
					$action_type = $action->get_settings( 'type' );

					if ( $action_type === 'recaptcha' ) {
						$recaptcha_v3_action_exists = true;
						break;
					}
				}

				// If the there isn't a recaptcha type in the form. Add it.
				if ( ! $recaptcha_v3_action_exists ) {
					$action = $current_form->action()->get();
					$action->update_setting( 'label', esc_html__( 'ReCaptcha (Automatisch gegenereerd)', 'ninja-forms' ) )
						->update_setting( 'type', 'recaptcha' )
						->update_setting( 'active', true )
						->save();
					$form_captcha_amount++;
				}
			}

			if ( $_POST['action'] == 'kls_create_recaptcha_action' ) {
				if ( $form_captcha_amount == 0 ) {
					wp_redirect( admin_url( 'admin.php?page=kls_tools_page' ) );
					kls_admin_notice( __( 'All the forms already have a Recaptcha action.', KP_TXT_DOMAIN ), 'warning', true );
				} else {
					// Todo, add clear cache function.

					wp_redirect( admin_url( 'admin.php?page=kls_tools_page' ) );
					kls_admin_notice( __( 'Added the ReCaptcha action to all the forms.', KP_TXT_DOMAIN ), 'success', true );
				}
			}
		}
	}

	new KP_NF_Actions();
}
