<?php

/**
 * Add security headers which don't need much configuration.
 *
 * @since 0.0.06
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_add_security_headers() {
	header( 'X-Frame-Options: SAMEORIGIN' );
	header( 'X-XSS-Protection: 1; mode=block' );
	header( 'X-Content-Type-Options: nosniff' );
	header( 'Strict-Transport-Security: max-age=31536000; includeSubDomains; preload' );
	// header('');
}
add_action( 'send_headers', 'kls_add_security_headers' );
