<?php

/**
 * Create all shortcodes
 *
 * @since 0.0.02
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

// Shortcode name
if ( get_option( 'kls_customer_name' ) ) {
	function kls_shortcode_customer_name() {
		return get_option( 'kls_customer_name' );
	}
	add_shortcode( 'klant_naam', 'kls_shortcode_customer_name' );
}

// Shortcode slogan
if ( get_option( 'kls_customer_slogan' ) ) {
	function kls_shortcode_customer_slogan() {
		return kls_plugin_translate_option( 'kls_customer_slogan', 'Customer slogan', 'nl' );
	}
	add_shortcode( 'klant_slogan', 'kls_shortcode_customer_slogan' );
}

// Shortcode email
if ( get_option( 'kls_customer_email' ) ) {
	function kls_shortcode_customer_email( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 0,
				),
				$atts
			)
		);

		return '<a href="mailto:' . get_option( 'kls_customer_email' ) . '">' . ( 1 == $show_icon ? '<i class="fas fa-envelope"></i> ' : '' ) . get_option( 'kls_customer_email' ) . '</a>';
	}
	add_shortcode( 'klant_email', 'kls_shortcode_customer_email' );
}

// Shortcode phone number
if ( get_option( 'kls_customer_phone' ) ) {
	function kls_shortcode_customer_phone( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 0,
				),
				$atts
			)
		);

		return '<a href="tel:' . get_option( 'kls_customer_phone' ) . '">' . ( 1 == $show_icon ? '<i class="fas fa-phone-alt"></i> ' : '' ) . get_option( 'kls_customer_phone' ) . '</a>';
	}
	add_shortcode( 'klant_telefoon', 'kls_shortcode_customer_phone' );
}

// Shortcode street
if ( get_option( 'kls_customer_street' ) ) {
	function kls_shortcode_customer_street() {
		return get_option( 'kls_customer_street' );
	}
	add_shortcode( 'klant_straat_huisnummer', 'kls_shortcode_customer_street' );
}

// Shortcode postcode
if ( get_option( 'kls_customer_postcode' ) ) {
	function kls_shortcode_customer_postcode() {
		return get_option( 'kls_customer_postcode' );
	}
	add_shortcode( 'klant_postcode', 'kls_shortcode_customer_postcode' );
}

// Shortcode city
if ( get_option( 'kls_customer_city' ) ) {
	function kls_shortcode_customer_city() {
		return get_option( 'kls_customer_city' );
	}
	add_shortcode( 'klant_stad', 'kls_shortcode_customer_city' );
}

// Shortcode country
if ( get_option( 'kls_customer_country' ) ) {
	function kls_shortcode_customer_country() {
		 return get_option( 'kls_customer_country' );
	}
	add_shortcode( 'klant_land', 'kls_shortcode_customer_country' );
}

// Shortcode adres combined
function kls_shortcode_customer_adres_combined() {
	return get_option( 'kls_customer_street' ) . '<br>' . get_option( 'kls_customer_postcode' ) . ', ' . get_option( 'kls_customer_city' ) . '<br>' . get_option( 'kls_customer_country' );
}
add_shortcode( 'klant_adres', 'kls_shortcode_customer_adres_combined' );

// Shortcode kvk
if ( get_option( 'kls_customer_kvk' ) ) {
	function kls_shortcode_customer_kvk() {
		 return get_option( 'kls_customer_kvk' );
	}
	add_shortcode( 'klant_kvk', 'kls_shortcode_customer_kvk' );
}

// Shortcode btw
if ( get_option( 'kls_customer_btw' ) ) {
	function kls_shortcode_customer_btw() {
		 return get_option( 'kls_customer_btw' );
	}
	add_shortcode( 'klant_btw', 'kls_shortcode_customer_btw' );
}

// Shortcode opening hours
function kls_shortcode_customer_opening_hours_combined( $atts ) {
	extract(
		shortcode_atts(
			array(
				'titel' => '',
				'type' => 'static',
			),
			$atts
		)
	);

	$title_html = '';

	if ( isset( $titel ) && ! empty( $titel ) ) {
		$title_html = '<h3>' . $titel . '</h3>';
	}

	$days_html  = '';
	$show_title = 0;

	$days = array(
		__( 'Monday', KP_TXT_DOMAIN )    => get_option( 'kls_opening_hours_monday' ),
		__( 'Tuesday', KP_TXT_DOMAIN )   => get_option( 'kls_opening_hours_tuesday' ),
		__( 'Wednesday', KP_TXT_DOMAIN ) => get_option( 'kls_opening_hours_wednesday' ),
		__( 'Thursday', KP_TXT_DOMAIN )  => get_option( 'kls_opening_hours_thursday' ),
		__( 'Friday', KP_TXT_DOMAIN )    => get_option( 'kls_opening_hours_friday' ),
		__( 'Saturday', KP_TXT_DOMAIN )  => get_option( 'kls_opening_hours_saterday' ),
		__( 'Sunday', KP_TXT_DOMAIN )    => get_option( 'kls_opening_hours_sunday' ),
	);

	$days_html .= $type == 'table' ? '<table>' : '<p>';

	foreach ( $days as $day => $opening_hours ) {
		if ( isset( $opening_hours ) && ! empty( $opening_hours ) ) {
			$show_title = 1;
			$day = __( $day, KP_TXT_DOMAIN );
			if ($type == 'table') {
				$days_html .= '<tr><td>' . $day . ':</td><td>' . $opening_hours . '</td></tr>';
			} else {
				$days_html .= $day . ': ' . $opening_hours . '<br>';
			}
		}
	}

	$days_html .= $type == 'table' ? '</table>' : '</p>';

	return ( $show_title !== 0 ? $title_html : '' ) . $days_html;

}
add_shortcode( 'klant_openingstijden', 'kls_shortcode_customer_opening_hours_combined' );
