<?php

/**
 * Social media shortcodes
 *
 * @since 0.0.41
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

// Facebook
if ( get_option( 'kls_customer_facebook' ) ) :
	function kls_shortcode_facebook_link( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 1,
				),
				$atts
			)
		);

		if ( $atts > 0 && $show_icon == 1 ) :
			return '<a href="' . get_option( 'kls_customer_facebook' ) . '" target="_blank" rel="noopener" class="facebook-icon"><i class="fab fa-facebook-f"></i></a>';
		else :
			return get_option( 'kls_customer_facebook' );
		endif;
	}
	add_shortcode( 'klant_facebook', 'kls_shortcode_facebook_link' );
endif;

// Twitter
// Todo, change this to X instead of twitter.
if ( get_option( 'kls_customer_twitter' ) ) :
	function kls_shortcode_twitter_link( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 1,
				),
				$atts
			)
		);

		if ( $atts > 0 && $show_icon == 1 ) :
			return '<a href="' . get_option( 'kls_customer_twitter' ) . '" target="_blank" rel="noopener" class="twitter-icon"><i class="fab fa-twitter"></i></a>';
		else :
			return get_option( 'kls_customer_twitter' );
		endif;
	}
	add_shortcode( 'klant_twitter', 'kls_shortcode_twitter_link' );
endif;

// Instagram
if ( get_option( 'kls_customer_instagram' ) ) :
	function kls_shortcode_instagram_link( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 1,
				),
				$atts
			)
		);

		if ( $atts > 0 && $show_icon == 1 ) :
			return '<a href="' . get_option( 'kls_customer_instagram' ) . '" target="_blank" rel="noopener" class="instagram-icon"><i class="fab fa-instagram"></i></a>';
		else :
			return get_option( 'kls_customer_instagram' );
		endif;
	}
	add_shortcode( 'klant_instagram', 'kls_shortcode_instagram_link' );
endif;

// Linkedin
if ( get_option( 'kls_customer_linkedin' ) ) :
	function kls_shortcode_linkedin_link( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 1,
				),
				$atts
			)
		);

		if ( $atts > 0 && $show_icon == 1 ) :
			return '<a href="' . get_option( 'kls_customer_linkedin' ) . '" target="_blank" rel="noopener" class="linkedin-icon"><i class="fab fa-linkedin-in"></i></a>';
		else :
			return get_option( 'kls_customer_linkedin' );
		endif;
	}
	add_shortcode( 'klant_linkedin', 'kls_shortcode_linkedin_link' );
endif;

// Pinterest
if ( get_option( 'kls_customer_pinterest' ) ) :
	function kls_shortcode_pinterest_link( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 1,
				),
				$atts
			)
		);

		if ( $atts > 0 && $show_icon == 1 ) :
			return '<a href="' . get_option( 'kls_customer_pinterest' ) . '" target="_blank" rel="noopener" class="pinterest-icon"><i class="fab fa-linkedin-in"></i></a>';
		else :
			return get_option( 'kls_customer_pinterest' );
		endif;
	}
	add_shortcode( 'klant_pinterest', 'kls_shortcode_pinterest_link' );
endif;

// Youtube
if ( get_option( 'kls_customer_youtube' ) ) :
	function kls_shortcode_youtube_link( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 1,
				),
				$atts
			)
		);

		if ( $atts > 0 && $show_icon == 1 ) :
			return '<a href="' . get_option( 'kls_customer_youtube' ) . '" target="_blank" rel="noopener" class="youtube-icon"><i class="fab fa-youtube"></i></a>';
		else :
			return get_option( 'kls_customer_youtube' );
		endif;
	}
	add_shortcode( 'klant_youtube', 'kls_shortcode_youtube_link' );
endif;

// Whatsapp
if ( get_option( 'kls_customer_whatsapp' ) ) :
	function kls_shortcode_whatsapp_link( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 1,
				),
				$atts
			)
		);

		if ( $atts > 0 && $show_icon == 1 ) :
			return '<a href="' . get_option( 'kls_customer_whatsapp' ) . '" target="_blank" rel="noopener" class="whatsapp-icon"><i class="fab fa-whatsapp"></i></a>';
		else :
			return get_option( 'kls_customer_whatsapp' );
		endif;
	}
	add_shortcode( 'klant_whatsapp', 'kls_shortcode_whatsapp_link' );
endif;

// Linkedin
if ( get_option( 'kls_customer_tiktok' ) ) :
	function kls_shortcode_tiktok_link( $atts ) {
		extract(
			shortcode_atts(
				array(
					'show_icon' => 1,
				),
				$atts
			)
		);

		if ( $atts > 0 && $show_icon == 1 ) :
			return '<a href="' . get_option( 'kls_customer_tiktok' ) . '" target="_blank" rel="noopener" class="tiktok-icon"><i class="fab fa-tiktok"></i></a>';
		else :
			return get_option( 'kls_customer_tiktok' );
		endif;
	}
	add_shortcode( 'klant_tiktok', 'kls_shortcode_tiktok_link' );
endif;

/**
 * All socials
 *
 * @since 0.0.41
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_shortcode_social_media( $atts ) {
	extract(
		shortcode_atts(
			array(
				'color'     => 1,
				'font_size' => 1,
			),
			$atts
		)
	);

	if ( get_option( 'kls_customer_facebook' ) ) :
		$facebook = '<a href="' . get_option( 'kls_customer_facebook' ) . '" target="_blank" rel="noopener" style="margin-right: 10px!important;color:' . $color . '!important;font-size:' . $font_size . '!important" class="facebook-icon"><i class="fab fa-facebook-f"></i></a>';
	endif;

	if ( get_option( 'kls_customer_twitter' ) ) :
		$twitter = '<a href="' . get_option( 'kls_customer_twitter' ) . '" target="_blank" rel="noopener" style="margin-right: 10px!important;color:' . $color . '!important;font-size:' . $font_size . '!important" class="twitter-icon"><i class="fab fa-twitter"></i></a>';
	endif;

	if ( get_option( 'kls_customer_instagram' ) ) :
		$instagram = '<a href="' . get_option( 'kls_customer_instagram' ) . '" target="_blank" rel="noopener" style="margin-right: 10px!important;color:' . $color . '!important;font-size:' . $font_size . '!important" class="instagram-icon"><i class="fab fa-instagram"></i></a>';
	endif;

	if ( get_option( 'kls_customer_linkedin' ) ) :
		$linkedin = '<a href="' . get_option( 'kls_customer_linkedin' ) . '" target="_blank" rel="noopener" style="margin-right: 10px!important;color:' . $color . '!important;font-size:' . $font_size . '!important" class="linkedin-icon"><i class="fab fa-linkedin-in"></i></a>';
	endif;

	if ( get_option( 'kls_customer_pinterest' ) ) :
		$pinterest = '<a href="' . get_option( 'kls_customer_pinterest' ) . '" target="_blank" rel="noopener" style="margin-right: 10px!important;color:' . $color . '!important;font-size:' . $font_size . '!important" class="pinterest-icon"><i class="fab fa-pinterest-p"></i></a>';
	endif;

	if ( get_option( 'kls_customer_youtube' ) ) :
		$youtube = '<a href="' . get_option( 'kls_customer_youtube' ) . '" target="_blank" rel="noopener" style="margin-right: 10px!important;color:' . $color . '!important;font-size:' . $font_size . '!important" class="youtube-icon"><i class="fab fa-youtube"></i></a>';
	endif;

	if ( get_option( 'kls_customer_whatsapp' ) ) :
		$whatsapp = '<a href="' . get_option( 'kls_customer_whatsapp' ) . '" target="_blank" rel="noopener" style="margin-right: 10px!important;color:' . $color . '!important;font-size:' . $font_size . '!important" class="whatsapp-icon"><i class="fab fa-whatsapp"></i></a>';
	endif;

	if ( get_option( 'kls_customer_tiktok' ) ) :
		$tiktok = '<a href="' . get_option( 'kls_customer_tiktok' ) . '" target="_blank" rel="noopener" style="margin-right: 10px!important;color:' . $color . '!important;font-size:' . $font_size . '!important" class="tiktok-icon"><i class="fab fa-tiktok"></i></a>';
	endif;

	return '<div class="kls-social-icons">
        ' . ( isset( $facebook ) ? $facebook : '' ) . '
        ' . ( isset( $twitter ) ? $twitter : '' ) . '
        ' . ( isset( $instagram ) ? $instagram : '' ) . '
        ' . ( isset( $linkedin ) ? $linkedin : '' ) . '
        ' . ( isset( $pinterest ) ? $pinterest : '' ) . '
        ' . ( isset( $youtube ) ? $youtube : '' ) . '
        ' . ( isset( $whatsapp ) ? $whatsapp : '' ) . '
        ' . ( isset( $tiktok ) ? $tiktok : '' ) . '
    </div>';
}
add_shortcode( 'klant_social_media', 'kls_shortcode_social_media' );
