<?php

/**
 * Set a custom wp rocket preload interval
 *
 * @since 0.0.60
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

namespace WP_Rocket\Helpers\preload\sitemap;

defined( 'ABSPATH' ) or die();

define( 'WPROCKETHELPERS_PRELOAD_INTERVAL_IN_SECONDS', get_option( 'kls_wp_rocket_preload_interval', 500 ) );

function apply_preload_interval() {
	 return absint( WPROCKETHELPERS_PRELOAD_INTERVAL_IN_SECONDS ) * 1000; // microseconds
}
add_filter( 'pre_get_rocket_option_sitemap_preload_url_crawl', __NAMESPACE__ . '\apply_preload_interval' );
