<?php

/**
 * Add From to products with a price range
 *
 * @since 0.0.10
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

if ( get_option( 'kls_from_price_range' ) == 'on' ) {
	function kls_format_price_range( $price, $from, $to ) {
		 $price_range_text = get_option( 'kls_price_range_text' );
		$range_text        = $price_range_text ? $price_range_text : '';

		return sprintf( '%s %s', $range_text, strip_tags( wc_price( $from ) ) );
	}

	add_filter( 'woocommerce_format_price_range', 'kls_format_price_range', 10, 3 );
}

/**
 * Change couponcode text
 *
 * @since 0.0.10
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_couponcode_text' ) ) {
	$couponcodetext = get_option( 'kls_couponcode_text' );

	add_filter( 'gettext', 'kls_rename_coupon_field_on_cart', 10, 3 );
	add_filter( 'ngettext', 'kls_rename_coupon_field_on_cart', 10, 3 );

	add_filter( 'woocommerce_coupon_error', 'kls_rename_coupon_label', 10, 3 );

	add_filter( 'woocommerce_coupon_message', 'kls_rename_coupon_label', 10, 3 );

	add_filter( 'woocommerce_cart_totals_coupon_label', 'kls_rename_coupon_label', 10, 1 );

	add_filter( 'woocommerce_checkout_coupon_message', 'kls_rename_coupon_message_on_checkout' );

	function kls_rename_coupon_field_on_cart( $translated_text, $text, $text_domain ) {
		if ( is_admin() || 'woocommerce' !== $text_domain ) {
			return $translated_text;
		}

		if ( 'Coupon:' === $text ) {
			$translated_text = $GLOBALS['couponcodetext '] . ':';
		}

		if ( 'Coupon has been removed.' === $text ) {
			$translated_text = $GLOBALS['couponcodetext'] . ' is verwijderd.';
		}

		if ( 'Apply coupon' === $text ) {
			$translated_text = $GLOBALS['couponcodetext'] . ' toepassen';
		}

		if ( 'Coupon code' === $text ) {
			$translated_text = $GLOBALS['couponcodetext'];
		}

		if ( 'Have a coupon?' === $text ) {
			$translated_text = 'Heb je een ' . strtolower( $GLOBALS['couponcodetext'] ) . '?';
		}

		if ( 'If you have a coupon code, please apply it below.' === $text ) {
			$translated_text = 'Als je een ' . strtolower( $GLOBALS['couponcodetext'] ) . ' hebt, kun je deze hieronder gebruiken.';
		}

		return $translated_text;
	}

	function kls_rename_coupon_message_on_checkout() {
		return 'Heb je een ' . strtolower( $GLOBALS['couponcodetext'] ) . '?' . ' <a href="#" class="showcoupon">' . __( 'Click here to enter your code', 'woocommerce' ) . '</a>';
	}

	function kls_rename_coupon_label( $err, $err_code = null, $something = null ) {
		 $err = str_ireplace( 'Coupon', $GLOBALS['couponcodetext'] . ' ', $err );

		return $err;
	}
}

/**
 * Hide all shipping methods if Free shipping or local pickup is available
 *
 * @since 0.0.12
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_hide_shipping_when_free' ) ) {
	function kls_hide_shipping_when_free_is_available( $rates, $package ) {
		 $new_rates = array();
		foreach ( $rates as $rate_id => $rate ) {
			// Only modify rates if free_shipping is present.
			if ( 'free_shipping' === $rate->method_id ) {
				$new_rates[ $rate_id ] = $rate;
				break;
			}
		}

		if ( ! empty( $new_rates ) ) {
			// Save local pickup if it's present.
			foreach ( $rates as $rate_id => $rate ) {
				if ( 'local_pickup' === $rate->method_id ) {
					$new_rates[ $rate_id ] = $rate;
					break;
				}
			}
			return $new_rates;
		}

		return $rates;
	}

	add_filter( 'woocommerce_package_rates', 'kls_hide_shipping_when_free_is_available', 10, 2 );
}
