<?php

/**
 * On option update hook
 *
 * @param string $option_name  Name of the option
 * @param string $old_value    Old value of the option
 * @param string $option_value New value of the option
 *
 * @since 0.0.61
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @return string Updates all specific post meta options
 */
function kls_on_option_update( $option_name, $old_value, $option_value ) {
	if ( get_option( 'kls_toggle_anytime_integration' ) == 'on' && $option_name == 'kls_anytime_grouplesson' ) :
		$key   = 'groeples_url';
		$value = get_option( 'kls_anytime_grouplesson' );
		kls_update_post_meta_pages( $key, $value );
	elseif ( get_option( 'kls_toggle_anytime_integration' ) == 'on' && $option_name == 'kls_anytime_registration' ) :
		$key   = 'inschrijf_url';
		$value = get_option( 'kls_anytime_registration' );
		kls_update_post_meta_pages( $key, $value );
	endif;
}
add_action( 'updated_option', 'kls_on_option_update', 10, 3 );

/**
 * Add post meta to all pages
 *
 * @param string $key   Key to update the meta tag
 * @param string $value Value of the to be updatet meta tag
 *
 * @since 0.0.61
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @return int Updates specific post meta to all pages
 */
function kls_update_post_meta_pages( $key, $value ) {
	$args        = array(
		'posts_per_page'   => -1,
		'post_type'        => 'page',
		'suppress_filters' => true,
	);
	$posts_array = get_posts( $args );
	foreach ( $posts_array as $post_array ) {
		add_post_meta( $post_array->ID, $key, $value, true );
		update_post_meta( $post_array->ID, $key, $value );
	}
}

/**
 * Add Anytime links to all posts
 *
 * @since 0.0.76
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @return int Updates all post meta on one click
 *
 * [Dev] Todo, rename function, create new function for the if statement.
 */
function kls_add_anytime_links() {
	if ( get_option( 'kls_toggle_anytime_integration' ) == 'on' ) :
		$key   = 'groeples_url';
		$value = get_option( 'kls_anytime_grouplesson' );
		kls_update_post_meta_pages( $key, $value );

		$key   = 'inschrijf_url';
		$value = get_option( 'kls_anytime_registration' );
		kls_update_post_meta_pages( $key, $value );
	endif;

	// Redirect and admin notice
	wp_redirect( admin_url( 'admin.php?page=kls_customer&tab=kls_anytime_fitness' ) );
	kls_admin_notice( __( 'Added Anytime links to all posts', KP_TXT_DOMAIN ), 'success', true );
}
add_action( 'admin_post_kls_add_anytime_links', 'kls_add_anytime_links' );
