<?php

/**
 * Translate option by input.
 *
 * @param string $theme_mod Insert the name of the Option.
 * @param string $name Insert the name of the string.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 *
 * @return mixed
 */
function kls_plugin_translate_option( $option, $name, $default_lang ) {
	$content = get_option( $option );
	$local   = KP_TXT_DOMAIN;

	do_action( 'wpml_register_single_string', $local, $name, $content, false, $default_lang );
	return apply_filters( 'wpml_translate_single_string', $content, $local, $name );
}
