<?php // phpcs:ignore
/**
 * Yoast Variables class
 *
 * @category   Klasse_Plugin
 * @package    KP
 * @subpackage KP/public/includes/yoast
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.0.97
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KP_Yoast_Variables' ) ) {
	/**
	 * Yoast Variables class
	 *
	 * @category    Klasse_Plugin
	 * @package     KP
	 * @subpackage  KP/public/includes/yoast
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.0.97
	 */
	class KP_Yoast_Variables {

		/**
		 * Construct the variables.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.97
		 *
		 * Todo, do this for all the fillable settings.
		 */
		public function __construct() {
			 add_action( 'wpseo_register_extra_replacements', array( $this, 'customerVariables' ) );
		}

		/**
		 * Yoast variables for the customer settings.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.0.97
		 *
		 * Todo, do this for all the options in the customer settings.
		 */
		public function customerVariables() {
			// Customer name.
			wpseo_register_var_replacement(
				'%%klant_naam%%',
				function () {
					return get_option( 'kls_customer_name' );
				},
				'advanced',
				__( 'Customer name', KP_TXT_DOMAIN )
			);

			// Customer slogan.
			wpseo_register_var_replacement(
				'%%klant_slogan%%',
				function () {
					return get_option( 'kls_customer_slogan' );
				},
				'advanced',
				__( 'Customer slogan', KP_TXT_DOMAIN )
			);

			// Customer city.
			wpseo_register_var_replacement(
				'%%klant_stad%%',
				function () {
					return get_option( 'kls_customer_city' );
				},
				'advanced',
				__( 'Customer city', KP_TXT_DOMAIN )
			);
		}
	}

	new KP_Yoast_Variables();
}
