<?php

class KP_GetTest extends \Codeception\TestCase\WPTestCase
{
	private $admin_id;

	public function setUp(): void
	{
		// before
		parent::setUp();

		// your set up methods here
		$this->admin_id = $this->factory()->user->create([
			'role' => 'administrator',
		]);
	}

	public function tearDown(): void
	{
		// your tear down methods here

		// then
		parent::tearDown();
	}

	// tests
	public function testRegisterRoutes()
	{
		wp_set_current_user($this->admin_id);

		$kp_get = new KP_Get();
		do_action('rest_api_init');

		$routes = $GLOBALS['wp_rest_server']->get_routes();

		$this->assertArrayHasKey('/klasse-api/v2/get-options', $routes);
		$this->assertArrayHasKey('/klasse-api/v2/get-option/(?P<option>[a-zA-Z0-9-_]+)', $routes);
		$this->assertArrayHasKey('/klasse-api/v2/get-theme-mods', $routes);
		$this->assertArrayHasKey('/klasse-api/v2/get-theme-mod/(?P<thememod>[a-zA-Z0-9-_]+)', $routes);
	}

	public function testCallAuth()
	{
		// Mock KP_Api class and its methods as needed, as it's not defined in the given class code.
	}

	public function testGetOptions()
	{
		// Insert assertions here based on your expectation
	}

	public function testGetOption()
	{
		// Insert assertions here based on your expectation
	}

	public function testGetThemeMods()
	{
		// Insert assertions here based on your expectation
	}

	public function testGetThemeMod()
	{
		// Insert assertions here based on your expectation
	}
}