const defaultConfig = require('@wordpress/scripts/config/webpack.config');
const path = require('path');

const entry = {};
['admin/admin', 'admin/wp-color-picker-alpha', 'public/anytime-carousel', 'public/anytime-marquee', 'public/cookie', 'public/cookieconsent', 'public/nf-session', 'public/gf-session', 'public/sitemap', 'public/user-experience', 'public/anytime-joining'].forEach(
	(script) =>
	(entry[script] = path.resolve(
		process.cwd(),
		`assets/src/${script}.js`
	))
);

module.exports = {
	...defaultConfig,
	entry,
	output: {
		path: path.join(__dirname, './assets/build'),
	},
	externals: {
		react: 'React',
		'react-dom': 'ReactDOM',
	},
};
