<?php
/**
 * Register custom menus
 *
 * @since 0.0.04
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_register_menus() {
	register_nav_menus(
		array(
			'primary'   => __( 'Main menu', 'klasse-theme' ),
			'secundary' => __( 'Top menu', 'klasse-theme' ),
			'footer'    => __( 'Footer menu', 'klasse-theme' ),
			'404-menu'  => __( '404 page menu', 'klasse-theme' ),
		)
	);
}
add_action( 'init', 'kls_register_menus' );

/**
 * Add custom menu checkbox
 *
 * @since 0.0.64
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_add_menu_primary_button_checkbox( $item_id, $item ) {
	$show_as_button = get_post_meta( $item_id, '_kls-primary-button', true );
	?>
	<p class="">
		<label for="kls-menu-primary-button-<?php echo $item_id; ?>" >
			<input type="checkbox" 
				id="kls-menu-primary-button-<?php echo $item_id; ?>" 
				name="kls-menu-primary-button[<?php echo $item_id; ?>]" 
				<?php checked( $show_as_button, true ); ?> 
			/><?php _e( 'Show as primary button', 'klasse-theme' ); ?>
		</label>
	</p>
	<?php

	$show_as_button_secundary = get_post_meta( $item_id, '_kls-secundary-button', true );
	?>
	<p class="">
		<label for="kls-menu-secundary-button-<?php echo $item_id; ?>" >
			<input type="checkbox" 
				id="kls-menu-secundary-button-<?php echo $item_id; ?>" 
				name="kls-menu-secundary-button[<?php echo $item_id; ?>]" 
				<?php checked( $show_as_button_secundary, true ); ?> 
			/><?php _e( 'Show as secundary button', 'klasse-theme' ); ?>
		</label>
	</p>
	<?php

	$show_hot_label = get_post_meta( $item_id, '_kls-show-hot-label', true );
	?>
	<p class="">
		<label for="kls-show-hot-label-<?php echo $item_id; ?>" >
			<input type="checkbox" 
				id="kls-show-hot-label-<?php echo $item_id; ?>" 
				name="kls-show-hot-label[<?php echo $item_id; ?>]" 
				<?php checked( $show_hot_label, true ); ?> 
			/><?php _e( 'Show hot label', 'klasse-theme' ); ?>
		</label>
	</p>
	<?php

	$show_product_menu = get_post_meta( $item_id, '_kls-show-product-menu', true );
	?>
	<p class="">
		<label for="kls-show-product-menu-<?php echo $item_id; ?>" >
			<input type="checkbox" 
				id="kls-show-product-menu-<?php echo $item_id; ?>" 
				name="kls-show-product-menu[<?php echo $item_id; ?>]" 
				<?php checked( $show_product_menu, true ); ?> 
			/><?php _e( 'Show product menu', 'klasse-theme' ); ?>
		</label>
	</p>
	<?php

	if ( $show_product_menu ) {
		$only_show_category_products = get_post_meta( $item_id, '_kls-only-show-category-products', true );
		?>
		<p class="">
			<label for="kls-only-show-category-products-<?php echo $item_id; ?>" >
				<input type="checkbox" 
					id="kls-only-show-category-products-<?php echo $item_id; ?>" 
					name="kls-only-show-category-products[<?php echo $item_id; ?>]" 
					<?php checked( $only_show_category_products, true ); ?> 
				/><?php _e( 'Only show this categories products', 'klasse-theme' ); ?>
			</label>
		</p>
		<?php
	}
}
add_action( 'wp_nav_menu_item_custom_fields', 'kls_add_menu_primary_button_checkbox', 10, 2 );

// Update menu
function kls_update_menu( $menu_id, $menu_item_db_id ) {
	$button_value_primary        = ( isset( $_POST['kls-menu-primary-button'][ $menu_item_db_id ] ) && $_POST['kls-menu-primary-button'][ $menu_item_db_id ] == 'on' ) ? true : false;
	$button_value_secundary      = ( isset( $_POST['kls-menu-secundary-button'][ $menu_item_db_id ] ) && $_POST['kls-menu-secundary-button'][ $menu_item_db_id ] == 'on' ) ? true : false;
	$show_hot_label              = ( isset( $_POST['kls-show-hot-label'][ $menu_item_db_id ] ) && $_POST['kls-show-hot-label'][ $menu_item_db_id ] == 'on' ) ? true : false;
	$show_product_menu           = ( isset( $_POST['kls-show-product-menu'][ $menu_item_db_id ] ) && $_POST['kls-show-product-menu'][ $menu_item_db_id ] == 'on' ) ? true : false;
	$only_show_category_products = ( isset( $_POST['kls-only-show-category-products'][ $menu_item_db_id ] ) && $_POST['kls-only-show-category-products'][ $menu_item_db_id ] == 'on' ) ? true : false;
	update_post_meta( $menu_item_db_id, '_kls-primary-button', $button_value_primary );
	update_post_meta( $menu_item_db_id, '_kls-secundary-button', $button_value_secundary );
	update_post_meta( $menu_item_db_id, '_kls-show-hot-label', $show_hot_label );
	update_post_meta( $menu_item_db_id, '_kls-show-product-menu', $show_product_menu );
	update_post_meta( $menu_item_db_id, '_kls-only-show-category-products', $only_show_category_products );
}
add_action( 'wp_update_nav_menu_item', 'kls_update_menu', 10, 2 );
