import './faq.scss';

jQuery(document).ready(function ($) {
	$(document).on('click', '.faq-title', function () {
		var $this = $(this);
		var $parent = $this.parent().parent();
		var $active = $parent.hasClass('active');

		$parent.parent().find('.active').removeClass('active');

		if ($active) {
			$parent.removeClass('active');
		} else {
			$parent.addClass('active');
		}
	});

	var searchTimeout;

	$('#search-term').on('keyup', function () {
		var searchTerm = $(this).val();

		clearTimeout(searchTimeout); // Clear the timeout if it's already set.

		if (searchTerm.length > 2) {
			searchTimeout = setTimeout(function () {
				$.ajax({
					type: 'POST',
					url: custom_search.ajax_url,
					data: {
						action: 'search_custom_post_type',
						term: searchTerm
					},
					success: function (response) {
						$('#search-results').html(response);
						return false;
					}
				});
			}, 500);  // 500 milliseconds delay (0.5 seconds)
		} else {
			$('#search-results').empty();
		}
	});
});