jQuery(document).ready(
	function ($) {
		function setup_collapsible_submenus() {
			var $menu = $('.menu'),
				top_level_link = '.menu .menu-item-has-children > a';

			$menu.find('a').each(
				function () {
					$(this).off('click');

					if ($(this).is(top_level_link)) {
						$('<a class="hover-link"></a>')
							.attr('href', $(this).attr('href'))
							.on(
								'click',
								function (e) {
									e.stopPropagation();
								}
							)
							.appendTo($(this));

						$(this).attr('href', '#');
					}

					if (!$(this).siblings('.sub-menu').length) {
						$(this).on(
							'click',
							function (event) {
								$(this).parents('.mobile-nav').trigger('click');
							}
						);
					} else {
						$(this).on(
							'click',
							function (event) {
								if ($(this).parent('.active').length > 0) {
									$(this).parent().removeClass('active');
								} else {
									$(this).parent().parent().find('li.active').removeClass('active');
									$(this).parent().addClass('active');
								}
							}
						);
					}
				}
			);
		}

		setTimeout(
			function () {
				setup_collapsible_submenus();
			},
			700
		);
	}
);
