
import './standard_checkout_flow.scss';

jQuery(document).on('ready',
	function ($) {
		// Listen for checkout updates
		jQuery(document.body).on('updated_checkout', function () {
			// Assuming you have a function to fetch and refresh shipping info
			refreshShippingMethods();
			// refreshBillingMethods();
		});

		function refreshShippingMethods() {
			jQuery.ajax({
				type: 'POST',
				url: wc_checkout_params.ajax_url,
				data: {
					'action': 'refresh_shipping_methods'
				},
				success: function (response) {
					jQuery('.woocommerce-cart-shipping-methodes-container .woocommerce-cart-shipping-item').html(response);
				},
				error: function () {
					console.error('Failed to update shipping methods.');
				}
			});
		}

		// Todo, when refreshing this deselects the item.
		function refreshBillingMethods() {
			jQuery.ajax({
				type: 'POST',
				url: wc_checkout_params.ajax_url,
				data: {
					'action': 'refresh_billing_methods'
				},
				success: function (response) {
					jQuery('.woocommerce-cart-billing-methodes-container .woocommerce-cart-shipping-item').html(response);
				},
				error: function () {
					console.error('Failed to update billing methods.');
				}
			});
		}
	}
);
