import './standard_general-woocommerce.scss';

jQuery( document ).ready(
	function ($) {
		if ( ! String.prototype.getDecimals) {
			String.prototype.getDecimals = function () {
				var num = this,
				match = ('' + num).match( /(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/ );
				if ( ! match) {
					return 0;
				}
				return Math.max( 0, (match[1] ? match[1].length : 0) - (match[2] ? +match[2] : 0) );
			}
		}

		$( document.body ).on(
			'click',
			'.plus, .minus',
			function () {
				var $qty = $( this ).closest( '.quantity' ).find( '.qty' ),
				currentVal = parseFloat( $qty.val() ),
				max = parseFloat( $qty.attr( 'max' ) ),
				min = parseFloat( $qty.attr( 'min' ) ),
				step = $qty.attr( 'step' );

				if ( ! currentVal || currentVal === '' || currentVal === 'NaN') {
					currentVal = 0;
				}
				if (max === '' || max === 'NaN') {
					max = '';
				}
				if (min === '' || min === 'NaN') {
					min = 0;
				}
				if (step === 'any' || step === '' || step === undefined || parseFloat( step ) === 'NaN') {
					step = 1;
				}

				if ($( this ).is( '.plus' )) {
					if (max && (currentVal >= max)) {
						$qty.val( max );
					} else {
						$qty.val( (currentVal + parseFloat( step )).toFixed( step.getDecimals() ) );
					}
				} else {
					if (min && (currentVal <= min)) {
						$qty.val( min );
					} else if (currentVal > 0) {
						$qty.val( (currentVal - parseFloat( step )).toFixed( step.getDecimals() ) );
					}
				}

				$qty.trigger( 'change' );
			}
		);

		var categoryItem = $( '.product-categories .cat-parent' );

		$( "<div class='toggle'></div>" ).insertBefore( ".sidebar .product-categories > .cat-item.cat-parent > .children" );

		$( '.product-categories .cat-parent .toggle' ).on(
			'click',
			function () {
				$( this ).parent().toggleClass( 'active' );
			}
		);

		categoryItem.each(
			function () {
				var categoryChildren = $( this ).find( '.children' );
				var categoryChildrenHeight = $( this ).find( '.children' ).height();

				if ( ! $( this ).hasClass( 'current-cat-parent' )) {
					categoryChildren.height( 0 );
				} else {
					$( this ).addClass( 'active' );
					categoryChildren.height( categoryChildrenHeight );
				}

				$( this ).find( '.toggle' ).on(
					'click',
					function () {
						if (categoryChildren.height() == 0) {
							categoryChildren.height( categoryChildrenHeight );
						} else {
							categoryChildren.height( 0 );
						}
					}
				);
			}
		);

		$(".theme-order-button").on("click", function () {
			if (!$(".accordion-item.summary").hasClass("show")) {
				$(".accordion-item, .accordion-toggle, .accordion-content").removeClass("show");
				$(".accordion-item .accordion-content").slideUp(350);

				$(".accordion-item.summary, .accordion-item.summary .accordion-toggle, .accordion-item.summary .accordion-content").addClass("show");
				$(".accordion-item.summary .accordion-content").slideToggle(350);
			}
		});
	}
);

jQuery(document).on(
	'keyup blur',
	'[name="coupon_code_under"]',
	function () {
		var val = jQuery(this).val();
		jQuery('[name="coupon_code"]').val(val);
	}
);

jQuery(document).on(
	'click',
	'button[name="coupon_code_under"]',
	function () {
		jQuery('button[name="apply_coupon"]').trigger("click");
	}
);

jQuery(document).on(
	'change',
	'.woocommerce-cart input.qty',
	function () {
		jQuery('.update-cart-button').trigger("click");
	}
);

jQuery(document).on(
	'click',
	'.woocommerce-cart .qty_button',
	function () {
		jQuery('.update-cart-button').trigger("click");
	}
);
