<?php
/**
 * This file is for the configuration of multiple aspacts of the theme to easily add, for example, buttons, headers etc.
 *
 * @param string $type
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.19
 */
// function kls_get_($type) {

// }

/**
 * Set the theme global variations
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.19
 */
$theme_style_version         = get_theme_mod( 'general_theme_version' );
$kls_product_style_version   = ( null == get_theme_mod( 'kls_woocommerce_product_page_version' ) ? $theme_style_version : get_theme_mod( 'kls_woocommerce_product_page_version' ) );
$kls_mini_cart_style_version = ( null == get_theme_mod( 'kls_mini_cart_version' ) ? 'v1' : get_theme_mod( 'kls_mini_cart_version' ) );

// Checkout flow version.
if ( ! empty( get_theme_mod( 'kls_checkout_flow_version' ) ) && null !== get_theme_mod( 'kls_checkout_flow_version' ) ) {
	$kls_checkout_flow_style_version = get_theme_mod( 'kls_checkout_flow_version' );
} elseif ( null == get_theme_mod( 'kls_checkout_flow_version' ) && 'v1' == $theme_style_version ) {
	$kls_checkout_flow_style_version = 'v1';
} elseif ( null == get_theme_mod( 'kls_checkout_flow_version' ) && 'v2' == $theme_style_version ) {
	$kls_checkout_flow_style_version = 'v2';
} else {
	$kls_checkout_flow_style_version = 'v3';
}

// Product archive version.
if ( ! empty( get_theme_mod( 'kls_archive_version' ) ) && null !== get_theme_mod( 'kls_archive_version' ) ) {
	$kls_archive_style_version = get_theme_mod( 'kls_archive_version' );
} elseif ( null == get_theme_mod( 'kls_archive_version' ) && 'v1' == $theme_style_version ) {
	$kls_archive_style_version = 'v1';
} elseif ( null == get_theme_mod( 'kls_archive_version' ) && 'v4' == $theme_style_version ) {
	$kls_archive_style_version = 'v3';
} else {
	$kls_archive_style_version = 'v2';
}

$kls_main_navigation_version    = get_theme_mod( 'main_navigation_version' );
$kls_top_navigation_version     = get_theme_mod( 'top_navigation_version' );
$kls_sidebar_navigation_version = get_theme_mod( 'kls_sidebar_navigation_version' );
$kls_mobile_navigation_version  = get_theme_mod( 'mobile_navigation_version' );
$kls_mobile_menu_version        = get_theme_mod( 'mobile_menu_version' );
$kls_footer_version             = get_theme_mod( 'footer_version' );

// Theme breakpoints.
$kls_tablet_breakpoint = '980px';
$kls_phone_breakpoint  = '767px';

// Main navigation.
$kls_main_navigation = array(
	'default-v1'           => __( 'Default v1', 'klasse-theme' ),
	'default-v1-fullwidth' => __( 'Default v1 fullwidth', 'klasse-theme' ),
	'default-v2-fullwidth' => __( 'Default v2 fullwidth', 'klasse-theme' ),
	'center-v1'            => __( 'Center logo v1', 'klasse-theme' ),
	'shop-v1'              => __( 'Shop v1', 'klasse-theme' ),
	'shop-v1-search'       => __( 'Shop v1 search under icons', 'klasse-theme' ),
	'shop-v2'              => __( 'Shop v2', 'klasse-theme' ),
	'shop-v3'              => __( 'Shop v3', 'klasse-theme' ),
	'shop-v4'              => __( 'Shop v4', 'klasse-theme' ),
	'shop-v5'              => __( 'Shop v5', 'klasse-theme' ),
);

// Sidebar navigation.
$kls_sidebar_navigation = array(
	'shop-v5' => __( 'Shop v5', 'klasse-theme' ),
);

// Button options acros the theme.
$kls_buttons = array(
	'primary'    => __( 'Primary', 'klasse-theme' ),
	'secundary'  => __( 'Secundary', 'klasse-theme' ),
	'tertiary'   => __( 'Tertiary', 'klasse-theme' ),
	'quaternary' => __( 'Quaternary', 'klasse-theme' ),
);

// 404 page templates.
$kls_404 = array(
	'default-v1' => __( 'Default v1', 'klasse-theme' ),
	// 'shop-v1' => __('Shop v1', 'klasse-theme'),
	'shop-v2'    => __( 'Shop v2', 'klasse-theme' ),
	// 'bottom_bar-v1' => __('Bottom bar v1', 'klasse-theme'),
);

// WooCommerce product page styling.
$kls_product_pages = array(
	'v1' => __( 'Version 1', 'klasse-theme' ),
	'v2' => __( 'Version 2', 'klasse-theme' ),
	'v3' => __( 'Version 3', 'klasse-theme' ),
	'v4' => __( 'Version 4', 'klasse-theme' ),
	'v5' => __( 'Version 5', 'klasse-theme' ),
	'v6' => __( 'Version 6', 'klasse-theme' ),
	'v7' => __( 'Version 7', 'klasse-theme' ),
);

// WooCommerce mini cart styling.
$kls_mini_cart_styling_versions = array(
	'v1' => __( 'Version 1 (Dropdown)', 'klasse-theme' ),
	'v2' => __( 'Version 2 (Big popup)', 'klasse-theme' ),
);

// WooCommerce checkout flow styling.
$kls_checkout_flow_styling_versions = array(
	'v1' => __( 'Version 1 (Simple)', 'klasse-theme' ),
	'v2' => __( 'Version 2 (Big block)', 'klasse-theme' ),
	'v3' => __( 'Version 3 (Big block no background)', 'klasse-theme' ),
	'v4' => __( 'Version 4 (Advanced)', 'klasse-theme' ),
);

// WooCommerce checkout flow styling.
$kls_archive_styling_versions = array(
	'v1' => __( 'Version 1 (Basic/Description bottom)', 'klasse-theme' ),
	'v2' => __( 'Version 2 (Advanced/Description bottom)', 'klasse-theme' ),
	'v3' => __( 'Version 3 (Description top)', 'klasse-theme' ),
);
