<?php
/**
 * Create customizer panel
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.14
 */
function kls_create_button_customizer_panels( $wp_customize ) {
	// Add the general panel
	$wp_customize->add_panel(
		'button_theme_editor',
		array(
			'priority'    => 0,
			'title'       => __( 'Button theme editor', 'klasse-theme' ),
			'description' => __( 'Edit the main theme settings', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_button_customizer_panels' );

/**
 * Create all button sections
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.14
 */
function kls_button_customizer_sections( $wp_customize ) {
	foreach ( array_keys( $GLOBALS['kls_buttons'] ) as $button ) :
		$wp_customize->add_section(
			$button . '_button_theme_options',
			array(
				'title'    => __( $button . ' button settings', 'klasse-theme' ),
				'priority' => '10',
				'panel'    => 'button_theme_editor',
			)
		);
	endforeach;
}
add_action( 'customize_register', 'kls_button_customizer_sections' );

/**
 * Create link button section
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.14
 */
function kls_link_button_customizer_sections( $wp_customize ) {
	$wp_customize->add_section(
		'link_button_theme_options',
		array(
			'title'    => __( 'Link button settings', 'klasse-theme' ),
			'priority' => '10',
			'panel'    => 'button_theme_editor',
		)
	);
}
add_action( 'customize_register', 'kls_link_button_customizer_sections' );

require_once __DIR__ . '/button-template-settings.php';
require_once __DIR__ . '/link-button-settings.php';
