<?php

function kls_customizer_css_generator() {
	if ( get_template_directory() === get_stylesheet_directory() ) {
		// No child theme
		require_once get_stylesheet_directory() . '/public/includes/styling/css/style.php';
		$custom_css = implode( $css_combined );
	} else {
		// Child theme
		require_once get_template_directory() . '/public/includes/styling/css/style.php';
		$custom_css = implode( $GLOBALS['css_combined'] );
	}

	// Minify css
	$custom_css = preg_replace( '#/\*.*?\*/#s', '', $custom_css );
	$custom_css = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $custom_css );
	$custom_css = preg_replace( '/\s\s+(.*)/', '$1', $custom_css );
	$custom_css = preg_replace( '/;(?=\s*})/', '', $custom_css );
	$custom_css = preg_replace( '/ (,|;|\{|})/', '$1', $custom_css );
	$custom_css = preg_replace( '/(:| )0\.([0-9]+)(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}.${2}${3}', $custom_css );
	$custom_css = preg_replace( '/(:| )(\.?)0(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}0', $custom_css );
	if ( file_exists( get_stylesheet_directory() . '/theme.min.css' ) ) {
		$file = file_get_contents( get_stylesheet_directory() . '/theme.min.css' );
	}

	if ( strpos( $file, $custom_css ) == 0 ) {
		$file = $custom_css;
		file_put_contents( get_stylesheet_directory() . '/theme.min.css', $file );
	}

	wp_enqueue_style( 'kls_custom_css', get_stylesheet_directory_uri() . '/theme.min.css', false, rand() );
}
add_action( 'wp_enqueue_scripts', 'kls_customizer_css_generator' );
