<?php

if ( class_exists( 'WP_Customize_Control' ) ) :
	/**
	 * Add seperator
	 *
	 * @since 0.0.23
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	class kls_seperator extends WP_Customize_Control {

		public $type = 'separator';

		public function render_content() {
			echo '<h2>' . esc_html( $this->label ) . '</h2>';
			echo '<hr>';
		}
	}

	/**
	 * Add page dropdown
	 *
	 * @since 0.0.23
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	class kls_page_dropdown extends WP_Customize_Control {

		public $type = 'page_dropdown';

		// Render the control's content.
		public function render_content() {
			$page_dropdown = new WP_Query(
				array(
					'post_type'   => 'page',
					'post_status' => 'publish',
					'orderby'     => 'date',
					'order'       => 'DESC',
				)
			); ?>
		<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
		<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<select <?php $this->link(); ?>>
			<?php
			while ( $page_dropdown->have_posts() ) {
				$page_dropdown->the_post();
				echo '<option ' . selected( $this->value(), get_the_ID() ) . " value='" . get_the_ID() . "'>" . the_title( '', '', false ) . '</option>';
			}
			?>
		</select>             
			<?php
		}
	}

	/**
	 * Add multi image control
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 *
	 * @since 0.1.45
	 */
	class kls_multi_image_control extends WP_Customize_Control {

		public function enqueue() {
			 wp_enqueue_style( 'multi-image-style', get_template_directory_uri() . '/public/includes/customizer/css/multi-image-style.css' );
			wp_enqueue_script( 'multi-image-script', get_template_directory_uri() . '/public/includes/customizer/js/multi-image-script.js', array( 'jquery' ), rand(), true );
		}

		public function render_content() {
			?>
			<div class="multi-image-control">
				<label>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
					<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
					<a class="images-remove-all"><?php _e( 'Remove all', 'klasse-theme' ); ?></a>
				</label>
				<ul class='images'></ul>
				<div class='actions'>
					<a class="button-secondary upload"><?php _e( 'Select', 'klasse-theme' ); ?></a>
				</div>

				<input class="wp-editor-area images-input" type="hidden" <?php $this->link(); ?>>
			</div>
			<?php
		}
	}
endif;
