<?php

/**
 * Create settings & controls for the bottom footer
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_bottom_footer_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'bottom_footer_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'bottom_footer_general_title',
			array(
				'priority' => 0,
				'section'  => 'bottom_footer_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Toggle bottom footer
	$wp_customize->add_setting(
		'bottom_footer_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'bottom_footer_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'bottom_footer_options',
			'label'    => __( 'Toggle bottom footer', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'bottom_footer_font_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'bottom_footer_font_title',
			array(
				'priority' => 0,
				'section'  => 'bottom_footer_options',
				'label'    => __( 'Font settings', 'klasse-theme' ),
			)
		)
	);
	// bottom footer font size
	$wp_customize->add_setting(
		'bottom_footer_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'bottom_footer_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'bottom_footer_options',
			'label'    => __( 'Bottom footer font size', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'bottom_footer_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'bottom_footer_colors_title',
			array(
				'priority' => 0,
				'section'  => 'bottom_footer_options',
				'label'    => __( 'Colors', 'klasse-theme' ),
			)
		)
	);
	// Bottom footer background color
	$wp_customize->add_setting(
		'bottom_footer_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'bottom_footer_background_color',
			array(
				'label'        => __( 'Bottom footer background color', 'klasse-theme' ),
				'section'      => 'bottom_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Set bottom menu item color
	$wp_customize->add_setting(
		'bottom_footer_text_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'bottom_footer_text_color',
			array(
				'label'        => __( 'Bottom footer text color', 'klasse-theme' ),
				'section'      => 'bottom_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Set menu item active color
	$wp_customize->add_setting(
		'bottom_footer_link_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'bottom_footer_link_color',
			array(
				'label'        => __( 'Bottom footer link color', 'klasse-theme' ),
				'section'      => 'bottom_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Menu item hover color
	$wp_customize->add_setting(
		'bottom_footer_link_hover_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'bottom_footer_link_hover_color',
			array(
				'label'        => __( 'Bottom footer link hover color', 'klasse-theme' ),
				'section'      => 'bottom_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'bottom_footer_image_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'bottom_footer_image_title',
			array(
				'priority' => 0,
				'section'  => 'bottom_footer_options',
				'label'    => __( 'Image', 'klasse-theme' ),
			)
		)
	);
	// Bottom footer image
	$wp_customize->add_setting(
		'bottom_footer_image',
		array(
			'default'   => '',
			// 'sanitize_callback' => '',
			'transport' => 'refresh',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Media_Control(
			$wp_customize,
			'bottom_footer_image',
			array(
				'label'         => __( 'Bottom footer image', 'klasse-theme' ),
				'priority'      => 0,
				'section'       => 'bottom_footer_options',
				'button_labels' => array(
					'select'       => __( 'Select Image', 'klasse-theme' ),
					'change'       => __( 'Change Image', 'klasse-theme' ),
					'remove'       => __( 'Remove', 'klasse-theme' ),
					'default'      => __( 'Default', 'klasse-theme' ),
					'placeholder'  => __( 'No image selected', 'klasse-theme' ),
					'frame_title'  => __( 'Select Image', 'klasse-theme' ),
					'frame_button' => __( 'Choose Image', 'klasse-theme' ),
				),
			)
		)
	);

	// bottom footer font size
	$wp_customize->add_setting(
		'bottom_footer_image_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'bottom_footer_image_link',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'bottom_footer_options',
			'label'    => __( 'Bottom footer image link', 'klasse-theme' ),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'bottom_footer_links_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'bottom_footer_links_title',
			array(
				'priority' => 0,
				'section'  => 'bottom_footer_options',
				'label'    => __( 'Links', 'klasse-theme' ),
			)
		)
	);
	// Bottom footer link #1
	$wp_customize->add_setting(
		'bottom_footer_link_one',
		array(
			'default'           => '',
			'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'bottom_footer_link_one',
		array(
			'type'     => 'dropdown-pages',
			'priority' => 0,
			'section'  => 'bottom_footer_options',
			'label'    => __( 'Bottom footer link 1', 'klasse-theme' ),
		)
	);
	// Bottom footer link #2
	$wp_customize->add_setting(
		'bottom_footer_link_two',
		array(
			'default'           => '',
			'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'bottom_footer_link_two',
		array(
			'type'     => 'dropdown-pages',
			'priority' => 0,
			'section'  => 'bottom_footer_options',
			'label'    => __( 'Bottom footer link 2', 'klasse-theme' ),
		)
	);
	// Bottom footer link #3
	$wp_customize->add_setting(
		'bottom_footer_link_three',
		array(
			'default'           => '',
			'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'bottom_footer_link_three',
		array(
			'type'     => 'dropdown-pages',
			'priority' => 0,
			'section'  => 'bottom_footer_options',
			'label'    => __( 'Bottom footer link 3', 'klasse-theme' ),
		)
	);
	// Bottom footer link #4
	$wp_customize->add_setting(
		'bottom_footer_link_four',
		array(
			'default'           => '',
			'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'bottom_footer_link_four',
		array(
			'type'     => 'dropdown-pages',
			'priority' => 0,
			'section'  => 'bottom_footer_options',
			'label'    => __( 'Bottom footer link 4', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_bottom_footer_settings_controls' );
