<?php

/**
 * Create cart page settings & controls
 *
 * @since 0.1.79
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_form_input_settings_controls($wp_customize)
{
	// Seperator
	$wp_customize->add_setting(
		'form_input_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'form_input_general_title',
			array(
				'priority' => 0,
				'section'  => 'form_input_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Input padding
	$wp_customize->add_setting(
		'kls_form_input_padding',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_padding',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_input_options',
			'label' => __('Input padding', 'klasse-theme'),
		)
	);

	// Input padding
	$wp_customize->add_setting(
		'kls_form_input_margin_bottom',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_margin_bottom',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_input_options',
			'label' => __('Input bottom margin', 'klasse-theme'),
		)
	);

	// Input border radius
	$wp_customize->add_setting(
		'kls_form_input_border_radius',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_border_radius',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_input_options',
			'label' => __('Input border radius', 'klasse-theme'),
		)
	);

	// Input border size
	$wp_customize->add_setting(
		'kls_form_input_border_size',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_border_size',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_input_options',
			'label' => __('Input border size', 'klasse-theme'),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'form_input_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'form_input_colors_title',
			array(
				'priority' => 0,
				'section' => 'form_input_options',
				'label' => __('Colors', 'klasse-theme'),
			)
		)
	);

	// Form input text color
	$wp_customize->add_setting(
		'kls_form_input_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_form_input_color',
			array(
				'label' => __('Input text color', 'klasse-theme'),
				'section' => 'form_input_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);

	// Form input text color
	$wp_customize->add_setting(
		'kls_form_input_placeholder_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_form_input_placeholder_color',
			array(
				'label' => __('Input placeholder color', 'klasse-theme'),
				'section' => 'form_input_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);

	// Form input background color
	$wp_customize->add_setting(
		'kls_form_input_background_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_form_input_background_color',
			array(
				'label' => __('Input background color', 'klasse-theme'),
				'section' => 'form_input_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);

	// Form input border color
	$wp_customize->add_setting(
		'kls_form_input_border_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_form_input_border_color',
			array(
				'label' => __('Input border color', 'klasse-theme'),
				'section' => 'form_input_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'form_input_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'form_input_text_title',
			array(
				'priority' => 0,
				'section' => 'form_input_options',
				'label' => __('Input text settings', 'klasse-theme'),
			)
		)
	);

	// Input font weight
	$wp_customize->add_setting(
		'kls_form_input_font_weight',
		array(
			'default' => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type' => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_font_weight',
		array(
			'priority' => 0,
			'type' => 'select',
			'section' => 'form_input_options',
			'label' => __('Input font weight', 'klasse-theme'),
			'choices' => array(
				'normal' => __('Normal', 'klasse-theme'),
				'bold' => __('Bold', 'klasse-theme'),
				'bolder' => __('Bolder', 'klasse-theme'),
				'lighter' => __('Light', 'klasse-theme'),
			),
		)
	);

	// Input font size
	$wp_customize->add_setting(
		'kls_form_input_font_size',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_font_size',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_input_options',
			'label' => __('input font size', 'klasse-theme'),
		)
	);

	// Input line height
	$wp_customize->add_setting(
		'kls_form_input_line_height',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_line_height',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_input_options',
			'label' => __('Input line height', 'klasse-theme'),
		)
	);

	// Input letter spacing
	$wp_customize->add_setting(
		'kls_form_input_letter_spacing',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_letter_spacing',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_input_options',
			'label' => __('Input letter spacing', 'klasse-theme'),
		)
	);

	// Input text transform
	$wp_customize->add_setting(
		'kls_form_input_text_transform',
		array(
			'default' => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type' => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_form_input_text_transform',
		array(
			'priority' => 0,
			'type' => 'select',
			'section' => 'form_input_options',
			'label' => __('Input text transform', 'klasse-theme'),
			'choices' => array(
				'none' => __('None', 'klasse-theme'),
				'capitalize' => __('Capitalize', 'klasse-theme'),
				'uppercase' => __('Uppercase', 'klasse-theme'),
				'lowercase' => __('Lowercase', 'klasse-theme'),
				'initial' => __('Initial', 'klasse-theme'),
			),
		)
	);
}
add_action('customize_register', 'kls_create_form_input_settings_controls');
