<?php

/**
 * Create cart page settings & controls
 *
 * @since 0.1.79
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_form_label_settings_controls($wp_customize)
{
	// Seperator.
	$wp_customize->add_setting(
		'form_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'form_toggles_title',
			array(
				'priority' => 0,
				'section' => 'form_label_options',
				'label' => __('Toggleable items', 'klasse-theme'),
			)
		)
	);

	$wp_customize->add_setting(
		'kls_form_label_toggleable_label',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport' => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_form_label_toggleable_label',
		array(
			'type' => 'checkbox',
			'priority' => 0,
			'section' => 'form_label_options',
			'label' => __('Toggle the label viewed as placeholder', 'klasse-theme'),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'form_label_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'form_label_colors_title',
			array(
				'priority' => 0,
				'section' => 'form_label_options',
				'label' => __('Colors', 'klasse-theme'),
			)
		)
	);

	// Form label text color
	$wp_customize->add_setting(
		'kls_form_label_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_form_label_color',
			array(
				'label' => __('Label text color', 'klasse-theme'),
				'section' => 'form_label_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'form_label_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'form_label_text_title',
			array(
				'priority' => 0,
				'section' => 'form_label_options',
				'label' => __('Label text settings', 'klasse-theme'),
			)
		)
	);

	// Label font weight
	$wp_customize->add_setting(
		'kls_form_label_font_weight',
		array(
			'default' => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type' => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_form_label_font_weight',
		array(
			'priority' => 0,
			'type' => 'select',
			'section' => 'form_label_options',
			'label' => __('Label font weight', 'klasse-theme'),
			'choices' => array(
				'normal' => __('Normal', 'klasse-theme'),
				'bold' => __('Bold', 'klasse-theme'),
				'bolder' => __('Bolder', 'klasse-theme'),
				'lighter' => __('Light', 'klasse-theme'),
			),
		)
	);

	// Label font size
	$wp_customize->add_setting(
		'kls_form_label_font_size',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_label_font_size',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_label_options',
			'label' => __('Label font size', 'klasse-theme'),
		)
	);

	// Label line height
	$wp_customize->add_setting(
		'kls_form_label_line_height',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_label_line_height',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_label_options',
			'label' => __('Label line height', 'klasse-theme'),
		)
	);

	// Label letter spacing
	$wp_customize->add_setting(
		'kls_form_label_letter_spacing',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_form_label_letter_spacing',
		array(
			'priority' => 0,
			'type' => 'text',
			'section' => 'form_label_options',
			'label' => __('Label letter spacing', 'klasse-theme'),
		)
	);

	// Label text transform
	$wp_customize->add_setting(
		'kls_form_label_text_transform',
		array(
			'default' => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type' => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_form_label_text_transform',
		array(
			'priority' => 0,
			'type' => 'select',
			'section' => 'form_label_options',
			'label' => __('Label text transform', 'klasse-theme'),
			'choices' => array(
				'none' => __('None', 'klasse-theme'),
				'capitalize' => __('Capitalize', 'klasse-theme'),
				'uppercase' => __('Uppercase', 'klasse-theme'),
				'lowercase' => __('Lowercase', 'klasse-theme'),
				'initial' => __('Initial', 'klasse-theme'),
			),
		)
	);
}
add_action('customize_register', 'kls_create_form_label_settings_controls');
