<?php

/**
 * Create cart page settings & controls
 *
 * @since 0.1.79
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_form_settings_controls($wp_customize)
{
	// Seperator
	$wp_customize->add_setting(
		'form_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'form_general_title',
			array(
				'priority' => 0,
				'section'  => 'general_form_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Select navigation type
	$wp_customize->add_setting(
		'form_submit_button_style',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'form_submit_button_style',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'general_form_options',
			'label'    => __( 'Form submit button styling', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_buttons'],
		)
	);

	// Select navigation type
	$wp_customize->add_setting(
		'form_submit_button_location',
		array(
			'default' => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'form_submit_button_location',
		array(
			'priority' => 0,
			'type' => 'select',
			'section' => 'general_form_options',
			'label' => __('Form submit button position', 'klasse-theme'),
			'choices' => array(
				'left' => __('Left', 'klasse-theme'),
				'center' => __('Center', 'klasse-theme'),
				'Right' => __('Right', 'klasse-theme'),
			),
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'form_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'form_toggles_title',
			array(
				'priority' => 0,
				'section' => 'general_form_options',
				'label' => __('Toggleable items', 'klasse-theme'),
			)
		)
	);
}
add_action('customize_register', 'kls_create_form_settings_controls');
