<?php
/**
 * Create customizer panel
 *
 * @since 0.1.79
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_form_customizer_panels($wp_customize)
{
	// Add the form panel
	$wp_customize->add_panel(
		'form_editor',
		array(
			'priority' => 15,
			'title' => __('Form-editor', 'klasse-theme'),
			'description' => __('Edit the form settings', 'klasse-theme'),
		)
	);
}
add_action('customize_register', 'kls_create_form_customizer_panels');

/**
 * Create customizer sections
 *
 * @since 0.1.79
 * @author Joeri van der Stek <joeri@klassebv.nl>
 * 
 * Todo, add error options
 * 
 */
function kls_create_form_customizer_sections($wp_customize)
{
	// Add general form section
	$wp_customize->add_section(
		'general_form_options',
		array(
			'title' => __('General forms', 'klasse-theme'),
			'priority' => '0',
			'panel' => 'form_editor',
		)
	);

	// Add label form section
	$wp_customize->add_section(
		'form_label_options',
		array(
			'title' => __('Label settings', 'klasse-theme'),
			'priority' => '0',
			'panel' => 'form_editor',
		)
	);

	// Add input form section
	$wp_customize->add_section(
		'form_input_options',
		array(
			'title' => __('Input settings', 'klasse-theme'),
			'priority' => '0',
			'panel' => 'form_editor',
		)
	);
}
add_action('customize_register', 'kls_create_form_customizer_sections');

require_once __DIR__ . '/form-settings.php';
require_once __DIR__ . '/form-label-settings.php';
require_once __DIR__ . '/form-input-settings.php';
