<?php

/**
 * Create general color settings & controls
 *
 * @since 0.0.21
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_theme_color_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'colors_title',
			array(
				'priority' => 0,
				'section'  => 'color_theme_options',
				'label'    => __( 'Standard colors', 'klasse-theme' ),
			)
		)
	);
	// Primary color
	$wp_customize->add_setting(
		'primary_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'primary_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'color_theme_options',
				'label'        => __( 'Primary color', 'klasse-theme' ),
			)
		)
	);
	// Secundary color
	$wp_customize->add_setting(
		'secundary_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'secundary_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'color_theme_options',
				'label'        => __( 'Secundary color', 'klasse-theme' ),
			)
		)
	);
	// Tertiary color
	$wp_customize->add_setting(
		'tertiary_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'tertiary_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'color_theme_options',
				'label'        => __( 'Tertiary color', 'klasse-theme' ),
			)
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'text_title',
			array(
				'priority' => 0,
				'section'  => 'color_theme_options',
				'label'    => __( 'Text colors', 'klasse-theme' ),
			)
		)
	);
	// Heading color
	$wp_customize->add_setting(
		'heading_text_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'heading_text_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'color_theme_options',
				'label'        => __( 'Heading color', 'klasse-theme' ),
			)
		)
	);

	// Body color
	$wp_customize->add_setting(
		'body_text_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'body_text_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'color_theme_options',
				'label'        => __( 'Body color', 'klasse-theme' ),
			)
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'background_color_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'background_color_title',
			array(
				'priority' => 0,
				'section'  => 'color_theme_options',
				'label'    => __( 'Background colors', 'klasse-theme' ),
			)
		)
	);

	// Light background color
	$wp_customize->add_setting(
		'background_light_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'background_light_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'color_theme_options',
				'label'        => __( 'Light background color', 'klasse-theme' ),
			)
		)
	);
}
add_action( 'customize_register', 'kls_create_theme_color_settings_controls' );
