<?php

/**
 * Create fonts settings & controls
 *
 * @since 0.0.21
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_fonts_theme_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'google_fonts_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'google_fonts_title',
			array(
				'priority' => 0,
				'section'  => 'fonts_theme_options',
				'label'    => __( 'Google fonts settings', 'klasse-theme' ),
			)
		)
	);
	// Toggle Google Fonts
	$wp_customize->add_setting(
		'google_fonts_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'google_fonts_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'fonts_theme_options',
			'label'    => __( 'Toggle Google Fonts', 'klasse-theme' ),
		)
	);
	// Change the heading font
	$wp_customize->add_setting(
		'kls_headings_font',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'kls_sanitize_fonts',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_headings_font',
		array(
			'priority' => 0,
			'type'     => 'select',
			'label'    => __( 'Set the heading font', 'klasse-theme' ),
			'section'  => 'fonts_theme_options',
			'choices'  => $GLOBALS['fonts'],
		)
	);
	// Change the Body Font
	$wp_customize->add_setting(
		'kls_body_font',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'kls_sanitize_fonts',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_body_font',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'fonts_theme_options',
			'label'    => __( 'Set the body font', 'klasse-theme' ),
			'choices'  => $GLOBALS['fonts'],
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'custom_fonts_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'custom_fonts_title',
			array(
				'priority' => 0,
				'section'  => 'fonts_theme_options',
				'label'    => __( 'Custom fonts settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle custom font
	$wp_customize->add_setting(
		'custom_fonts_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'custom_fonts_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'fonts_theme_options',
			'label'    => __( 'Toggle custom Fonts', 'klasse-theme' ),
		)
	);

	// Upload custom font heading
	$wp_customize->add_setting(
		'kls_custom_fonts_heading',
		array(
			'default'   => '',
			// 'sanitize_callback' => '',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		new kls_multi_image_control(
			$wp_customize,
			'kls_custom_fonts_heading',
			array(
				'label'       => __( 'Upload headings font', 'klasse-theme' ),
				'description' => __( 'Use the following name structure for all the fonts:"fontname-WeightItalic". For example: "Poppins-SemiBoldItalic" or "RadioCanada_condensed-Light". Different formats should have the complete same structure.', 'klasse-theme' ),
				'priority'    => 0,
				'section'     => 'fonts_theme_options',
			)
		)
	);

	// Upload custom font body
	$wp_customize->add_setting(
		'kls_custom_fonts_body',
		array(
			'default'   => '',
			// 'sanitize_callback' => '',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		new kls_multi_image_control(
			$wp_customize,
			'kls_custom_fonts_body',
			array(
				'label'       => __( 'Upload body font', 'klasse-theme' ),
				'description' => __( 'Use the following name structure for all the fonts:"fontname-WeightItalic". For example: "Poppins-SemiBoldItalic" or "RadioCanada_condensed-Light". Different formats should have the complete same structure.', 'klasse-theme' ),
				'priority'    => 0,
				'section'     => 'fonts_theme_options',
			)
		)
	);
}
add_action( 'customize_register', 'kls_create_fonts_theme_settings_controls' );
