<?php

function kls_customizer_js_generator() {
	if ( get_template_directory() === get_stylesheet_directory() ) {
		// No child theme
		require_once get_stylesheet_directory() . '/public/includes/styling/js/script.php';
		$custom_js = implode( $js_combined );
	} else {
		// Child theme
		require_once get_template_directory() . '/public/includes/styling/js/script.php';
		$custom_js = implode( $GLOBALS['js_combined'] );
	}

	// Minify js
	$custom_js = preg_replace( '#/\*.*?\*/#s', '', $custom_js );
	$custom_js = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $custom_js );
	$custom_js = preg_replace( '/\s\s+(.*)/', '$1', $custom_js );
	$custom_js = preg_replace( '/;(?=\s*})/', '', $custom_js );
	$custom_js = preg_replace( '/ (,|;|\{|})/', '$1', $custom_js );
	$custom_js = preg_replace( '/(:| )0\.([0-9]+)(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}.${2}${3}', $custom_js );
	$custom_js = preg_replace( '/(:| )(\.?)0(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}0', $custom_js );
	if ( file_exists( get_stylesheet_directory() . '/theme.min.js' ) ) {
		$file = file_get_contents( get_stylesheet_directory() . '/theme.min.js' );
	}

	if ( strpos( $file, $custom_js ) == 0 ) {
		$file = $custom_js;
		file_put_contents( get_stylesheet_directory() . '/theme.min.js', $file );
	}

	wp_enqueue_script( 'kls_custom_js', get_stylesheet_directory_uri() . '/theme.min.js', array( 'jquery' ), rand() );

	wp_localize_script(
		'kls_custom_js',
		'theme_object',
		array(
			'read_less' => __( 'Read less...', 'klasse-theme' ),
			'read_more' => __( 'Read more...', 'klasse-theme' ),
		)
	);
}
add_action( 'wp_enqueue_scripts', 'kls_customizer_js_generator', 9999999 );
