<?php

/**
 * Create settings & controls for general mobile navigation
 *
 * @since 0.0.11
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_mobile_navigation_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'mobile_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_general_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_navigation_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Select navigation type
	$wp_customize->add_setting(
		'mobile_navigation_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'mobile_navigation_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Mobile navigation theme selection', 'klasse-theme' ),
			'choices'  => array(
				'default-v1'         => __( 'Default v1', 'klasse-theme' ),
				'anytime-v1' => __('Anytime Fitness v1', 'klasse-theme'),
				'bottom_bar-v1'      => __( 'Bottom bar v1', 'klasse-theme' ),
				'bottom_bar_shop-v2' => __( 'Shop bottom bar v2', 'klasse-theme' ),
			),
		)
	);
	// Logo max height
	$wp_customize->add_setting(
		'kls_mobile_logo_height',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_mobile_logo_height',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Mobile logo height in pixels', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'mobile_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_navigation_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);
	// Change navigation position
	$wp_customize->add_setting(
		'mobile_navigation_position',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_radio_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_navigation_position',
		array(
			'type'     => 'radio',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Mobile navigation top or bottom position', 'klasse-theme' ),
			'choices'  => array(
				'top'    => __( 'Top', 'klasse-theme' ),
				'bottom' => __( 'Bottom', 'klasse-theme' ),
			),
		)
	);
	// Toggle bottom bar menu navigation logo above the main content
	$wp_customize->add_setting(
		'mobile_bottom_bar_logo_above_content_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_bottom_bar_logo_above_content_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Toggle logo above the main content', 'klasse-theme' ),
		)
	);

	// Toggle bottom bar menu search.
	$wp_customize->add_setting(
		'kls_mobile_bottom_bar_search_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_mobile_bottom_bar_search_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Toggle search icon', 'klasse-theme' ),
		)
	);

	// Toggle mobile navigation phone number
	// $wp_customize->add_setting(
	// 'mobile_navigation_phone_toggle',
	// array(
	// 'default'           => '',
	// 'sanitize_callback' => 'sanitize_checkbox_field',
	// 'transport'         => 'refresh'
	// )
	// );

	// $wp_customize->add_control(
	// 'mobile_navigation_phone_toggle',
	// array(
	// 'type'              => 'checkbox',
	// 'priority'          => 0,
	// 'section'           => 'general_mobile_navigation_options',
	// 'label'             => __('Toggle phone number', 'klasse-theme'),
	// )
	// );

	// Toggle mobile navigation email address
	// $wp_customize->add_setting(
	// 'mobile_navigation_email_toggle',
	// array(
	// 'default'           => '',
	// 'sanitize_callback' => 'sanitize_checkbox_field',
	// 'transport'         => 'refresh'
	// )
	// );

	// $wp_customize->add_control(
	// 'mobile_navigation_email_toggle',
	// array(
	// 'type'              => 'checkbox',
	// 'priority'          => 0,
	// 'section'           => 'general_mobile_navigation_options',
	// 'label'             => __('Toggle e-mailadress', 'klasse-theme'),
	// )
	// );

	// Seperator
	$wp_customize->add_setting(
		'mobile_fonts_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_fonts_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_navigation_options',
				'label'    => __( 'Font settings', 'klasse-theme' ),
			)
		)
	);
	// Mobile navigation navigation font size
	$wp_customize->add_setting(
		'mobile_navigation_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_navigation_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Mobile navigation item font size', 'klasse-theme' ),
		)
	);
	// Mobile navigation font weight
	$wp_customize->add_setting(
		'mobile_navigation_font_weight',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'mobile_navigation_font_weight',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Mobile navigation font weight', 'klasse-theme' ),
			'choices'  => array(
				'normal'  => __( 'Normal', 'klasse-theme' ),
				'bold'    => __( 'Bold', 'klasse-theme' ),
				'bolder'  => __( 'Bolder', 'klasse-theme' ),
				'lighter' => __( 'Light', 'klasse-theme' ),
			),
		)
	);
	// Bottom bar icons font size
	$wp_customize->add_setting(
		'mobile_bottom_bar_icon_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_bottom_bar_icon_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Bottom bar icon font size', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'mobile_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_colors_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_navigation_options',
				'label'    => __( 'Colors', 'klasse-theme' ),
			)
		)
	);
	// Hamburger menu toggle color
	$wp_customize->add_setting(
		'mobile_navigation_menu_toggle_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'mobile_navigation_menu_toggle_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'general_mobile_navigation_options',
				'label'        => __( 'Mobile navigation hamburger toggle color', 'klasse-theme' ),
			)
		)
	);
	// Mobile menu background color
	$wp_customize->add_setting(
		'mobile_navigation_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'mobile_navigation_background_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'general_mobile_navigation_options',
				'label'        => __( 'Mobile navigation background color', 'klasse-theme' ),
			)
		)
	);
	// Bottom bar logo above content background color
	$wp_customize->add_setting(
		'mobile_bottom_bar_logo_above_content_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'mobile_bottom_bar_logo_above_content_background_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'general_mobile_navigation_options',
				'label'        => __( 'Logo above the main content background color', 'klasse-theme' ),
			)
		)
	);
	// Bottom bar icons color
	$wp_customize->add_setting(
		'mobile_bottom_bar_icons_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'mobile_bottom_bar_icons_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'general_mobile_navigation_options',
				'label'        => __( 'Bottom bar icons color', 'klasse-theme' ),
			)
		)
	);
	// Bottom bar icons active color
	$wp_customize->add_setting(
		'mobile_bottom_bar_icons_active_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'mobile_bottom_bar_icons_active_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'general_mobile_navigation_options',
				'label'        => __( 'Bottom bar active icons color', 'klasse-theme' ),
			)
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'bottom_bar_contact_link_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'bottom_bar_contact_link_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_navigation_options',
				'label'    => __( 'Contact button shop v2', 'klasse-theme' ),
			)
		)
	);
	// Bottom bar v2 contact link
	$wp_customize->add_setting(
		'mobile_bottom_bar_v2_contact_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_bottom_bar_v2_contact_link',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Bottom bar contact link', 'klasse-theme' ),
		)
	);
	// Bottom bar v2 contact link
	$wp_customize->add_setting(
		'mobile_bottom_bar_v2_contact_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_bottom_bar_v2_contact_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Bottom bar contact link text', 'klasse-theme' ),
		)
	);
	// Bottom bar v2 contact link
	$wp_customize->add_setting(
		'mobile_bottom_bar_v2_contact_icon',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_bottom_bar_v2_contact_icon',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_navigation_options',
			'label'    => __( 'Bottom bar contact link icon', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_general_mobile_navigation_settings_controls' );
