<?php

/**
 * Create general settings & controls
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_navigation_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'general_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'general_general_title',
			array(
				'priority' => 0,
				'section'  => 'general_navigation_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Toggle navigation
	$wp_customize->add_setting(
		'navigation_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'navigation_toggle',
		array(
			'type'        => 'checkbox',
			'priority'    => 0,
			'section'     => 'general_navigation_options',
			'description' => __( 'Toggle this to off if you want to use the Divi navigation.', 'klasse-theme' ),
			'label'       => __( 'Navigation toggle', 'klasse-theme' ),
		)
	);
	// Toggle fixed navigation
	$wp_customize->add_setting(
		'fixed_navigation_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'fixed_navigation_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_navigation_options',
			'label'    => __( 'Fixed navigation toggle', 'klasse-theme' ),
		)
	);
	// Set navigation breakpoint
	$wp_customize->add_setting(
		'navigation_breakpoint',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'navigation_breakpoint',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_navigation_options',
			'label'    => __( 'Mobile navigation breakpoint', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'general_main_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'general_main_title',
			array(
				'priority' => 0,
				'section'  => 'general_navigation_options',
				'label'    => __( 'Main menu colors', 'klasse-theme' ),
			)
		)
	);
	// Set menu item color
	$wp_customize->add_setting(
		'navigation_item_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_item_color',
			array(
				'label'        => __( 'Navigation item color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Set menu item active color
	$wp_customize->add_setting(
		'navigation_item_active_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_item_active_color',
			array(
				'label'        => __( 'Navigation item active color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Menu item hover color
	$wp_customize->add_setting(
		'navigation_item_hover_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_item_hover_color',
			array(
				'label'        => __( 'Navigation item hover color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Set menu item color
	$wp_customize->add_setting(
		'navigation_fixed_item_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_fixed_item_color',
			array(
				'label'        => __( 'Fixed navigation item color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'general_sub_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'general_sub_title',
			array(
				'priority' => 0,
				'section'  => 'general_navigation_options',
				'label'    => __( 'Sub menu colors', 'klasse-theme' ),
			)
		)
	);
	// Set sub menu item color
	$wp_customize->add_setting(
		'navigation_sub_item_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_sub_item_color',
			array(
				'label'        => __( 'Navigation sub menu item color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Set sub menu item active color
	$wp_customize->add_setting(
		'navigation_sub_item_active_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_sub_item_active_color',
			array(
				'label'        => __( 'Navigation sub menu item active color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Sub menu item hover color
	$wp_customize->add_setting(
		'navigation_sub_item_hover_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_sub_item_hover_color',
			array(
				'label'        => __( 'Navigation sub menu item hover color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Sub menu background color
	$wp_customize->add_setting(
		'navigation_sub_item_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_sub_item_background_color',
			array(
				'label'        => __( 'Navigation sub menu background color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Sub menu background color
	$wp_customize->add_setting(
		'navigation_sub_item_border_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'navigation_sub_item_border_color',
			array(
				'label'        => __( 'Navigation sub menu border color', 'klasse-theme' ),
				'section'      => 'general_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
}
add_action( 'customize_register', 'kls_create_general_navigation_settings_controls' );
